%------------------------------------------------------------------------------
% File     : GEO440+1 : TPTP v8.1.2. Released v7.0.0.
% Domain   : Mathematics
% Problem  : Flyspeck project step
% Version  : Especial.
% English  :

% Refs     : [Hal10] Hales (2010), A Revision of the Proof of the Kepler
%          : [Urb16] Urban (2016), Email to Geoff Sutcliffe
% Source   : [Urb16]
% Names    :

% Status   : Theorem
% Rating   : 0.81 v7.5.0, 0.88 v7.4.0, 0.83 v7.3.0, 0.90 v7.1.0, 0.87 v7.0.0
% Syntax   : Number of formulae    : 2852 (1087 unt;   0 def)
%            Number of atoms       : 8188 (3004 equ)
%            Maximal formula atoms :   25 (   2 avg)
%            Number of connectives : 5703 ( 367   ~; 208   |;1817   &)
%                                         (1101 <=>;2210  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   36 (   6 avg)
%            Maximal term depth    :   28 (   3 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :  337 ( 337 usr; 326 con; 0-2 aty)
%            Number of variables   : 11455 (10553   !; 902   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments :
%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(aTu_DEF,axiom,
    s(bool,t) = s(bool,t) ).

fof(aTacticsu_jordano_unifyu_existsu_tacu_example,axiom,
    s(bool,t) = s(bool,t) ).

fof(aTRUTH,axiom,
    p(s(bool,t)) ).

fof(aANDu_DEF,axiom,
    ! [X,XI_] :
      ( ( p(s(bool,X))
        & p(s(bool,XI_)) )
    <=> ! [X0] : s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),X0),s(bool,X))),s(bool,XI_))) = s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),X0),s(bool,t))),s(bool,t))) ) ).

fof(aIMPu_DEF,axiom,
    ! [X,XI_] :
      ( ( p(s(bool,X))
       => p(s(bool,XI_)) )
    <=> ( ( p(s(bool,X))
          & p(s(bool,XI_)) )
      <=> p(s(bool,X)) ) ) ).

fof(aFORALLu_DEF,axiom,
    ! [A,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),e_),s(fun(A,bool),X))))
    <=> ! [X0] : s(bool,i(s(fun(A,bool),X),s(A,X0))) = s(bool,t) ) ).

fof(aEXISTSu_DEF,axiom,
    ! [A,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),q_),s(fun(A,bool),X))))
    <=> ! [Q0] :
          ( ! [X0] :
              ( p(s(bool,i(s(fun(A,bool),X),s(A,X0))))
             => p(s(bool,Q0)) )
         => p(s(bool,Q0)) ) ) ).

fof(aORu_DEF,axiom,
    ! [X,XI_] :
      ( ( p(s(bool,X))
        | p(s(bool,XI_)) )
    <=> ! [R0] :
          ( ( p(s(bool,X))
           => p(s(bool,R0)) )
         => ( ( p(s(bool,XI_))
             => p(s(bool,R0)) )
           => p(s(bool,R0)) ) ) ) ).

fof(aFu_DEF,axiom,
    ( p(s(bool,f0))
  <=> ! [P0] : p(s(bool,P0)) ) ).

fof(aNOTu_DEF,axiom,
    ! [X] :
      ( ~ p(s(bool,X))
    <=> ( p(s(bool,X))
       => p(s(bool,f0)) ) ) ).

fof(aEXISTSu_UNIQUEu_DEF,axiom,
    p(s(bool,t)) ).

fof(au_FALSITYu_,axiom,
    s(bool,u_falsityu_) = s(bool,f0) ).

fof(aIMPu_IMP,axiom,
    ( ( p(s(bool,p1))
     => ( p(s(bool,q))
       => p(s(bool,r0)) ) )
  <=> ( ( p(s(bool,p1))
        & p(s(bool,q)) )
     => p(s(bool,r0)) ) ) ).

fof(aEQu_REFL,axiom,
    ! [A,X] : s(A,X) = s(A,X) ).

fof(aREFLu_CLAUSE,axiom,
    ! [A,X] :
      ( s(A,X) = s(A,X)
    <=> p(s(bool,t)) ) ).

fof(aEQu_SYM,axiom,
    ! [A,X,Y] :
      ( s(A,X) = s(A,Y)
     => s(A,Y) = s(A,X) ) ).

fof(aEQu_SYMu_EQ,axiom,
    ! [A,X,Y] :
      ( s(A,X) = s(A,Y)
    <=> s(A,Y) = s(A,X) ) ).

fof(aEQu_TRANS,axiom,
    ! [A,X,Y,Z0] :
      ( ( s(A,X) = s(A,Y)
        & s(A,Y) = s(A,Z0) )
     => s(A,X) = s(A,Z0) ) ).

fof(aBETAu_THM,axiom,
    ! [B,A,F0,Y] : s(B,i(s(fun(A,B),F0),s(A,Y))) = s(B,i(s(fun(A,B),F0),s(A,Y))) ).

fof(aABSu_SIMP,axiom,
    ! [B,A,T1,T2] : s(A,T1) = s(A,T1) ).

fof(aCONJu_ASSOC,axiom,
    ! [T1,T2,T3] :
      ( ( p(s(bool,T1))
        & p(s(bool,T2))
        & p(s(bool,T3)) )
    <=> ( p(s(bool,T1))
        & p(s(bool,T2))
        & p(s(bool,T3)) ) ) ).

fof(aCONJu_SYM,axiom,
    ! [T1,T2] :
      ( ( p(s(bool,T1))
        & p(s(bool,T2)) )
    <=> ( p(s(bool,T2))
        & p(s(bool,T1)) ) ) ).

fof(aCONJu_ACIu_conjunct0,axiom,
    ( ( p(s(bool,p1))
      & p(s(bool,q)) )
  <=> ( p(s(bool,q))
      & p(s(bool,p1)) ) ) ).

fof(aCONJu_ACIu_conjunct1,axiom,
    ( ( p(s(bool,p1))
      & p(s(bool,q))
      & p(s(bool,r0)) )
  <=> ( p(s(bool,p1))
      & p(s(bool,q))
      & p(s(bool,r0)) ) ) ).

fof(aCONJu_ACIu_conjunct2,axiom,
    ( ( p(s(bool,p1))
      & p(s(bool,q))
      & p(s(bool,r0)) )
  <=> ( p(s(bool,q))
      & p(s(bool,p1))
      & p(s(bool,r0)) ) ) ).

fof(aCONJu_ACIu_conjunct3,axiom,
    ( ( p(s(bool,p1))
      & p(s(bool,p1)) )
  <=> p(s(bool,p1)) ) ).

fof(aCONJu_ACIu_conjunct4,axiom,
    ( ( p(s(bool,p1))
      & p(s(bool,p1))
      & p(s(bool,q)) )
  <=> ( p(s(bool,p1))
      & p(s(bool,q)) ) ) ).

fof(aDISJu_ASSOC,axiom,
    ! [T1,T2,T3] :
      ( ( p(s(bool,T1))
        | p(s(bool,T2))
        | p(s(bool,T3)) )
    <=> ( p(s(bool,T1))
        | p(s(bool,T2))
        | p(s(bool,T3)) ) ) ).

fof(aDISJu_SYM,axiom,
    ! [T1,T2] :
      ( ( p(s(bool,T1))
        | p(s(bool,T2)) )
    <=> ( p(s(bool,T2))
        | p(s(bool,T1)) ) ) ).

fof(aDISJu_ACIu_conjunct0,axiom,
    ( ( p(s(bool,p1))
      | p(s(bool,q)) )
  <=> ( p(s(bool,q))
      | p(s(bool,p1)) ) ) ).

fof(aDISJu_ACIu_conjunct1,axiom,
    ( ( p(s(bool,p1))
      | p(s(bool,q))
      | p(s(bool,r0)) )
  <=> ( p(s(bool,p1))
      | p(s(bool,q))
      | p(s(bool,r0)) ) ) ).

fof(aDISJu_ACIu_conjunct2,axiom,
    ( ( p(s(bool,p1))
      | p(s(bool,q))
      | p(s(bool,r0)) )
  <=> ( p(s(bool,q))
      | p(s(bool,p1))
      | p(s(bool,r0)) ) ) ).

fof(aDISJu_ACIu_conjunct3,axiom,
    ( ( p(s(bool,p1))
      | p(s(bool,p1)) )
  <=> p(s(bool,p1)) ) ).

fof(aDISJu_ACIu_conjunct4,axiom,
    ( ( p(s(bool,p1))
      | p(s(bool,p1))
      | p(s(bool,q)) )
  <=> ( p(s(bool,p1))
      | p(s(bool,q)) ) ) ).

fof(aIMPu_CONJ,axiom,
    ( ( ( p(s(bool,p1))
        & p(s(bool,q)) )
     => p(s(bool,r0)) )
  <=> ( p(s(bool,p1))
     => ( p(s(bool,q))
       => p(s(bool,r0)) ) ) ) ).

fof(aIMPu_CONJu_ALT,axiom,
    ( ( ( p(s(bool,p1))
        & p(s(bool,q)) )
     => p(s(bool,r0)) )
  <=> ( p(s(bool,q))
     => ( p(s(bool,p1))
       => p(s(bool,r0)) ) ) ) ).

fof(aLEFTu_ORu_DISTRIB,axiom,
    ! [P0,Q0,R0] :
      ( ( p(s(bool,P0))
        & ( p(s(bool,Q0))
          | p(s(bool,R0)) ) )
    <=> ( ( p(s(bool,P0))
          & p(s(bool,Q0)) )
        | ( p(s(bool,P0))
          & p(s(bool,R0)) ) ) ) ).

fof(aRIGHTu_ORu_DISTRIB,axiom,
    ! [P0,Q0,R0] :
      ( ( ( p(s(bool,P0))
          | p(s(bool,Q0)) )
        & p(s(bool,R0)) )
    <=> ( ( p(s(bool,P0))
          & p(s(bool,R0)) )
        | ( p(s(bool,Q0))
          & p(s(bool,R0)) ) ) ) ).

fof(aFORALLu_SIMP,axiom,
    ! [A,T0] :
      ( ! [X] : p(s(bool,T0))
    <=> p(s(bool,T0)) ) ).

fof(aEXISTSu_SIMP,axiom,
    ! [A,T0] :
      ( ? [X] : p(s(bool,T0))
    <=> p(s(bool,T0)) ) ).

fof(aEQu_IMP,axiom,
    ( s(bool,a0) = s(bool,b0)
   => ( p(s(bool,a0))
     => p(s(bool,b0)) ) ) ).

fof(aEQu_CLAUSES,axiom,
    ! [T0] :
      ( ( s(bool,t) = s(bool,T0)
      <=> p(s(bool,T0)) )
      & ( s(bool,T0) = s(bool,t)
      <=> p(s(bool,T0)) )
      & ( s(bool,f0) = s(bool,T0)
      <=> ~ p(s(bool,T0)) )
      & ( s(bool,T0) = s(bool,f0)
      <=> ~ p(s(bool,T0)) ) ) ).

fof(aSsrboolo_notu_falseu_isu_true,axiom,
    ~ p(s(bool,f0)) ).

fof(aNOTu_CLAUSESu_WEAKu_conjunct1,axiom,
    ( ~ p(s(bool,f0))
  <=> p(s(bool,t)) ) ).

fof(aNOTu_CLAUSESu_WEAKu_conjunct0,axiom,
    ( ~ p(s(bool,t))
  <=> p(s(bool,f0)) ) ).

fof(aANDu_CLAUSES,axiom,
    ! [T0] :
      ( ( ( p(s(bool,t))
          & p(s(bool,T0)) )
      <=> p(s(bool,T0)) )
      & ( ( p(s(bool,T0))
          & p(s(bool,t)) )
      <=> p(s(bool,T0)) )
      & ( ( p(s(bool,f0))
          & p(s(bool,T0)) )
      <=> p(s(bool,f0)) )
      & ( ( p(s(bool,T0))
          & p(s(bool,f0)) )
      <=> p(s(bool,f0)) )
      & ( ( p(s(bool,T0))
          & p(s(bool,T0)) )
      <=> p(s(bool,T0)) ) ) ).

fof(aORu_CLAUSES,axiom,
    ! [T0] :
      ( ( ( p(s(bool,t))
          | p(s(bool,T0)) )
      <=> p(s(bool,t)) )
      & ( ( p(s(bool,T0))
          | p(s(bool,t)) )
      <=> p(s(bool,t)) )
      & ( ( p(s(bool,f0))
          | p(s(bool,T0)) )
      <=> p(s(bool,T0)) )
      & ( ( p(s(bool,T0))
          | p(s(bool,f0)) )
      <=> p(s(bool,T0)) )
      & ( ( p(s(bool,T0))
          | p(s(bool,T0)) )
      <=> p(s(bool,T0)) ) ) ).

fof(aIMPu_CLAUSES,axiom,
    ! [T0] :
      ( ( ( p(s(bool,t))
         => p(s(bool,T0)) )
      <=> p(s(bool,T0)) )
      & ( ( p(s(bool,T0))
         => p(s(bool,t)) )
      <=> p(s(bool,t)) )
      & ( ( p(s(bool,f0))
         => p(s(bool,T0)) )
      <=> p(s(bool,t)) )
      & ( ( p(s(bool,T0))
         => p(s(bool,T0)) )
      <=> p(s(bool,t)) )
      & ( ( p(s(bool,T0))
         => p(s(bool,f0)) )
      <=> ~ p(s(bool,T0)) ) ) ).

fof(aEXISTSu_UNIQUEu_THM,axiom,
    ! [A,P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X,XI_] :
            ( ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & p(s(bool,i(s(fun(A,bool),P0),s(A,XI_)))) )
           => s(A,X) = s(A,XI_) ) )
    <=> ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X,XI_] :
            ( ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & p(s(bool,i(s(fun(A,bool),P0),s(A,XI_)))) )
           => s(A,X) = s(A,XI_) ) ) ) ).

fof(aEXISTSu_REFL,axiom,
    ! [A,A5] :
    ? [X] : s(A,X) = s(A,A5) ).

fof(aEXISTSu_UNIQUEu_REFL,axiom,
    ! [A,A5] :
      ( ? [X] : s(A,X) = s(A,A5)
      & ! [X,XI_] :
          ( ( s(A,X) = s(A,A5)
            & s(A,XI_) = s(A,A5) )
         => s(A,X) = s(A,XI_) ) ) ).

fof(aUNWINDu_THM1,axiom,
    ! [A,P0,A5] :
      ( ? [X] :
          ( s(A,A5) = s(A,X)
          & p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) )
    <=> p(s(bool,i(s(fun(A,bool),P0),s(A,A5)))) ) ).

fof(aUNWINDu_THM2,axiom,
    ! [A,P0,A5] :
      ( ? [X] :
          ( s(A,X) = s(A,A5)
          & p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) )
    <=> p(s(bool,i(s(fun(A,bool),P0),s(A,A5)))) ) ).

fof(aFORALLu_UNWINDu_THM2,axiom,
    ! [A,P0,A5] :
      ( ! [X] :
          ( s(A,X) = s(A,A5)
         => p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) )
    <=> p(s(bool,i(s(fun(A,bool),P0),s(A,A5)))) ) ).

fof(aFORALLu_UNWINDu_THM1,axiom,
    ! [Q1020,P0,A5] :
      ( ! [X] :
          ( s(Q1020,A5) = s(Q1020,X)
         => p(s(bool,i(s(fun(Q1020,bool),P0),s(Q1020,X)))) )
    <=> p(s(bool,i(s(fun(Q1020,bool),P0),s(Q1020,A5)))) ) ).

fof(aSWAPu_FORALLu_THM,axiom,
    ! [A,B,P0] :
      ( ! [X,Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
    <=> ! [Y,X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y)))) ) ).

fof(aSWAPu_EXISTSu_THM,axiom,
    ! [A,B,P0] :
      ( ? [X,Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
    <=> ? [Y,X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y)))) ) ).

fof(aFORALLu_ANDu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aANDu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_ANDu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & p(s(bool,Q0)) )
    <=> ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_ANDu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
        & ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ! [X] :
          ( p(s(bool,P0))
          & p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aEXISTSu_ORu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          | p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        | ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aORu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        | ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          | p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_ORu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        | p(s(bool,Q0)) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          | p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_ORu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
        | ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ? [X] :
          ( p(s(bool,P0))
          | p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_EXISTSu_ANDu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & p(s(bool,Q0)) )
    <=> ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_EXISTSu_ANDu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,P0))
          & p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( p(s(bool,P0))
        & ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aTRIVu_EXISTSu_ANDu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,P0))
          & p(s(bool,Q0)) )
    <=> ( ? [X] : p(s(bool,P0))
        & ? [X] : p(s(bool,Q0)) ) ) ).

fof(aLEFTu_ANDu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & p(s(bool,Q0)) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_ANDu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
        & ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ? [X] :
          ( p(s(bool,P0))
          & p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aTRIVu_ANDu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ? [X] : p(s(bool,P0))
        & ? [X] : p(s(bool,Q0)) )
    <=> ? [X] :
          ( p(s(bool,P0))
          & p(s(bool,Q0)) ) ) ).

fof(aTRIVu_FORALLu_ORu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,P0))
          | p(s(bool,Q0)) )
    <=> ( ! [X] : p(s(bool,P0))
        | ! [X] : p(s(bool,Q0)) ) ) ).

fof(aTRIVu_ORu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ! [X] : p(s(bool,P0))
        | ! [X] : p(s(bool,Q0)) )
    <=> ! [X] :
          ( p(s(bool,P0))
          | p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_IMPu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
       => ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ! [X] :
          ( p(s(bool,P0))
         => p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aRIGHTu_FORALLu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,P0))
         => p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( p(s(bool,P0))
       => ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_IMPu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
       => p(s(bool,Q0)) )
    <=> ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
         => p(s(bool,Q0)) ) ) ).

fof(aLEFTu_FORALLu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
         => p(s(bool,Q0)) )
    <=> ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
       => p(s(bool,Q0)) ) ) ).

fof(aTRIVu_FORALLu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,P0))
         => p(s(bool,Q0)) )
    <=> ( ? [X] : p(s(bool,P0))
       => ! [X] : p(s(bool,Q0)) ) ) ).

fof(aTRIVu_EXISTSu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,P0))
         => p(s(bool,Q0)) )
    <=> ( ! [X] : p(s(bool,P0))
       => ? [X] : p(s(bool,Q0)) ) ) ).

fof(aEXISTSu_UNIQUEu_ALT,axiom,
    ! [A,P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X,XI_] :
            ( ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & p(s(bool,i(s(fun(A,bool),P0),s(A,XI_)))) )
           => s(A,X) = s(A,XI_) ) )
    <=> ? [X] :
        ! [Y] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,Y))))
        <=> s(A,X) = s(A,Y) ) ) ).

fof(aGeomdetailo_EQu_EXPAND,axiom,
    ( s(bool,a0) = s(bool,b0)
  <=> ( ( p(s(bool,a0))
       => p(s(bool,b0)) )
      & ( p(s(bool,b0))
       => p(s(bool,a0)) ) ) ) ).

fof(aEXISTSu_UNIQUE,axiom,
    ! [A,P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        & ! [X,XI_] :
            ( ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & p(s(bool,i(s(fun(A,bool),P0),s(A,XI_)))) )
           => s(A,X) = s(A,XI_) ) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          & ! [Y] :
              ( p(s(bool,i(s(fun(A,bool),P0),s(A,Y))))
             => s(A,Y) = s(A,X) ) ) ) ).

fof(aMONOu_AND,axiom,
    ( ( ( p(s(bool,a))
       => p(s(bool,b)) )
      & ( p(s(bool,c0))
       => p(s(bool,d0)) ) )
   => ( ( p(s(bool,a))
        & p(s(bool,c0)) )
     => ( p(s(bool,b))
        & p(s(bool,d0)) ) ) ) ).

fof(aMONOu_OR,axiom,
    ( ( ( p(s(bool,a))
       => p(s(bool,b)) )
      & ( p(s(bool,c0))
       => p(s(bool,d0)) ) )
   => ( ( p(s(bool,a))
        | p(s(bool,c0)) )
     => ( p(s(bool,b))
        | p(s(bool,d0)) ) ) ) ).

fof(aMONOu_IMP,axiom,
    ( ( ( p(s(bool,b))
       => p(s(bool,a)) )
      & ( p(s(bool,c0))
       => p(s(bool,d0)) ) )
   => ( ( p(s(bool,a))
       => p(s(bool,c0)) )
     => ( p(s(bool,b))
       => p(s(bool,d0)) ) ) ) ).

fof(aMONOu_NOT,axiom,
    ( ( p(s(bool,b))
     => p(s(bool,a)) )
   => ( ~ p(s(bool,a))
     => ~ p(s(bool,b)) ) ) ).

fof(aMONOu_FORALL,axiom,
    ! [A] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),p0),s(A,X))))
         => p(s(bool,i(s(fun(A,bool),q0),s(A,X)))) )
     => ( ! [X] : p(s(bool,i(s(fun(A,bool),p0),s(A,X))))
       => ! [X] : p(s(bool,i(s(fun(A,bool),q0),s(A,X)))) ) ) ).

fof(aMONOu_EXISTS,axiom,
    ! [A] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),p0),s(A,X))))
         => p(s(bool,i(s(fun(A,bool),q0),s(A,X)))) )
     => ( ? [X] : p(s(bool,i(s(fun(A,bool),p0),s(A,X))))
       => ? [X] : p(s(bool,i(s(fun(A,bool),q0),s(A,X)))) ) ) ).

fof(aETAu_AX,axiom,
    ! [B,A,T0,X] : s(B,i(s(fun(A,B),T0),s(A,X))) = s(B,i(s(fun(A,B),T0),s(A,X))) ).

fof(aEQu_EXT,axiom,
    ! [A,B,F0,G0] :
      ( ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),G0),s(A,X)))
     => s(fun(A,B),F0) = s(fun(A,B),G0) ) ).

fof(aFUNu_EQu_THM,axiom,
    ! [B,A,F0,G0] :
      ( s(fun(A,B),F0) = s(fun(A,B),G0)
    <=> ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),G0),s(A,X))) ) ).

fof(aSELECTu_AX,axiom,
    ! [A,P0,X] :
      ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
     => p(s(bool,i(s(fun(A,bool),P0),s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),P0)))))) ) ).

fof(aEXISTSu_THM,axiom,
    ! [A,X] : s(bool,i(s(fun(fun(A,bool),bool),q_),s(fun(A,bool),X))) = s(bool,i(s(fun(A,bool),X),s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),X))))) ).

fof(aSELECTu_REFL,axiom,
    ! [A,U_0] :
      ( ! [X,Y] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),U_0),s(A,X))),s(A,Y))))
        <=> s(A,Y) = s(A,X) )
     => ! [X] : s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),i(s(fun(A,fun(A,bool)),U_0),s(A,X))))) = s(A,X) ) ).

fof(aSELECTu_UNIQUE,axiom,
    ! [A,P0,X] :
      ( ! [Y] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,Y))))
        <=> s(A,Y) = s(A,X) )
     => s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),P0))) = s(A,X) ) ).

fof(aEXCLUDEDu_MIDDLE,axiom,
    ! [T0] :
      ( p(s(bool,T0))
      | ~ p(s(bool,T0)) ) ).

fof(aBOOLu_CASESu_AX,axiom,
    ! [T0] :
      ( s(bool,T0) = s(bool,t)
      | s(bool,T0) = s(bool,f0) ) ).

fof(aDEu_MORGANu_THM,axiom,
    ! [T1,T2] :
      ( ( ~ ( p(s(bool,T1))
            & p(s(bool,T2)) )
      <=> ( ~ p(s(bool,T1))
          | ~ p(s(bool,T2)) ) )
      & ( ~ ( p(s(bool,T1))
            | p(s(bool,T2)) )
      <=> ( ~ p(s(bool,T1))
          & ~ p(s(bool,T2)) ) ) ) ).

fof(aNOTu_CLAUSESu_conjunct0,axiom,
    ! [T0] :
      ( ~ ~ p(s(bool,T0))
    <=> p(s(bool,T0)) ) ).

fof(aNOTu_IMP,axiom,
    ! [T1,T2] :
      ( ~ ( p(s(bool,T1))
         => p(s(bool,T2)) )
    <=> ( p(s(bool,T1))
        & ~ p(s(bool,T2)) ) ) ).

fof(aCONTRAPOSu_THM,axiom,
    ! [T1,T2] :
      ( ( ~ p(s(bool,T1))
       => ~ p(s(bool,T2)) )
    <=> ( p(s(bool,T2))
       => p(s(bool,T1)) ) ) ).

fof(aNOTu_EXISTSu_THM,axiom,
    ! [A,P0] :
      ( ~ ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
    <=> ! [X] : ~ p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ).

fof(aEXISTSu_NOTu_THM,axiom,
    ! [A,P0] :
      ( ? [X] : ~ p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
    <=> ~ ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ).

fof(aNOTu_FORALLu_THM,axiom,
    ! [A,P0] :
      ( ~ ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
    <=> ? [X] : ~ p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ).

fof(aFORALLu_NOTu_THM,axiom,
    ! [A,P0] :
      ( ! [X] : ~ p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
    <=> ~ ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ).

fof(aFORALLu_BOOLu_THM,axiom,
    ( ! [B0] : p(s(bool,i(s(fun(bool,bool),p0),s(bool,B0))))
  <=> ( p(s(bool,i(s(fun(bool,bool),p0),s(bool,t))))
      & p(s(bool,i(s(fun(bool,bool),p0),s(bool,f0)))) ) ) ).

fof(aEXISTSu_BOOLu_THM,axiom,
    ( ? [B0] : p(s(bool,i(s(fun(bool,bool),p0),s(bool,B0))))
  <=> ( p(s(bool,i(s(fun(bool,bool),p0),s(bool,t))))
      | p(s(bool,i(s(fun(bool,bool),p0),s(bool,f0)))) ) ) ).

fof(aLEFTu_FORALLu_ORu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          | p(s(bool,Q0)) )
    <=> ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        | p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_FORALLu_ORu_THM,axiom,
    ! [A,P0,Q0] :
      ( ! [X] :
          ( p(s(bool,P0))
          | p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( p(s(bool,P0))
        | ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_ORu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        | p(s(bool,Q0)) )
    <=> ! [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
          | p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_ORu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
        | ! [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ! [X] :
          ( p(s(bool,P0))
          | p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aLEFTu_IMPu_FORALLu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
       => p(s(bool,Q0)) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
         => p(s(bool,Q0)) ) ) ).

fof(aLEFTu_EXISTSu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
         => p(s(bool,Q0)) )
    <=> ( ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
       => p(s(bool,Q0)) ) ) ).

fof(aRIGHTu_IMPu_EXISTSu_THM,axiom,
    ! [A,P0,Q0] :
      ( ( p(s(bool,P0))
       => ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ? [X] :
          ( p(s(bool,P0))
         => p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aRIGHTu_EXISTSu_IMPu_THM,axiom,
    ! [A,P0,Q0] :
      ( ? [X] :
          ( p(s(bool,P0))
         => p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) )
    <=> ( p(s(bool,P0))
       => ? [X] : p(s(bool,i(s(fun(A,bool),Q0),s(A,X)))) ) ) ).

fof(aCONDu_DEF,axiom,
    ! [A,U_0] :
      ( ! [X,X0,XI_,XI_I_] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(bool,fun(A,fun(A,bool))),i(s(fun(A,fun(bool,fun(A,fun(A,bool)))),U_0),s(A,X))),s(bool,X0))),s(A,XI_))),s(A,XI_I_))))
        <=> ( ( s(bool,X0) = s(bool,t)
             => s(A,XI_I_) = s(A,X) )
            & ( s(bool,X0) = s(bool,f0)
             => s(A,XI_I_) = s(A,XI_) ) ) )
     => ! [X,X0,XI_] : s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,X))),s(A,X0))),s(A,XI_))) = s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(bool,fun(A,fun(A,bool))),i(s(fun(A,fun(bool,fun(A,fun(A,bool)))),U_0),s(A,X0))),s(bool,X))),s(A,XI_))))) ) ).

fof(aCONDu_CLAUSES,axiom,
    ! [A,T1,T2] :
      ( s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,t))),s(A,T1))),s(A,T2))) = s(A,T1)
      & s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,f0))),s(A,T1))),s(A,T2))) = s(A,T2) ) ).

fof(aCONDu_EXPAND,axiom,
    ! [B0,T1,T2] :
      ( p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,B0))),s(bool,T1))),s(bool,T2))))
    <=> ( ( ~ p(s(bool,B0))
          | p(s(bool,T1)) )
        & ( p(s(bool,B0))
          | p(s(bool,T2)) ) ) ) ).

fof(aCONDu_ID,axiom,
    ! [A,B0,T0] : s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,B0))),s(A,T0))),s(A,T0))) = s(A,T0) ).

fof(aCONDu_RAND,axiom,
    ! [B,A,B0,F0,X,Y] : s(B,i(s(fun(A,B),F0),s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,B0))),s(A,X))),s(A,Y))))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,B0))),s(B,i(s(fun(A,B),F0),s(A,X))))),s(B,i(s(fun(A,B),F0),s(A,Y))))) ).

fof(aCONDu_RATOR,axiom,
    ! [B,A,B0,F0,G0,X] : s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),i(s(fun(fun(A,B),fun(fun(A,B),fun(A,B))),i(s(fun(bool,fun(fun(A,B),fun(fun(A,B),fun(A,B)))),cond),s(bool,B0))),s(fun(A,B),F0))),s(fun(A,B),G0))),s(A,X))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,B0))),s(B,i(s(fun(A,B),F0),s(A,X))))),s(B,i(s(fun(A,B),G0),s(A,X))))) ).

fof(aCONDu_ABS,axiom,
    ! [B,A,B0,F0,G0,X] : s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,B0))),s(B,i(s(fun(A,B),F0),s(A,X))))),s(B,i(s(fun(A,B),G0),s(A,X))))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),i(s(fun(fun(A,B),fun(fun(A,B),fun(A,B))),i(s(fun(bool,fun(fun(A,B),fun(fun(A,B),fun(A,B)))),cond),s(bool,B0))),s(fun(A,B),F0))),s(fun(A,B),G0))),s(A,X))) ).

fof(aMONOu_COND,axiom,
    ( ( ( p(s(bool,a))
       => p(s(bool,b)) )
      & ( p(s(bool,c0))
       => p(s(bool,d0)) ) )
   => ( p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,b0))),s(bool,a))),s(bool,c0))))
     => p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,b0))),s(bool,b))),s(bool,d0)))) ) ) ).

fof(aCONDu_ELIMu_THM,axiom,
    ! [A] :
      ( p(s(bool,i(s(fun(A,bool),p0),s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,c))),s(A,x))),s(A,y))))))
    <=> ( ( p(s(bool,c))
         => p(s(bool,i(s(fun(A,bool),p0),s(A,x)))) )
        & ( ~ p(s(bool,c))
         => p(s(bool,i(s(fun(A,bool),p0),s(A,y)))) ) ) ) ).

fof(aSKOLEMu_THM,axiom,
    ! [B,A,P0] :
      ( ! [X] :
        ? [Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
    <=> ? [Y] :
        ! [X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,i(s(fun(A,B),Y),s(A,X)))))) ) ).

fof(aUNIQUEu_SKOLEMu_ALT,axiom,
    ! [A,B,P0] :
      ( ! [X] :
          ( ? [Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
          & ! [Y,XI_] :
              ( ( p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
                & p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,XI_)))) )
             => s(B,Y) = s(B,XI_) ) )
    <=> ? [F0] :
        ! [X,Y] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
        <=> s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) ) ).

fof(aUNIQUEu_SKOLEMu_THM,axiom,
    ! [A,B,P0] :
      ( ! [X] :
          ( ? [Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
          & ! [Y,XI_] :
              ( ( p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y))))
                & p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,XI_)))) )
             => s(B,Y) = s(B,XI_) ) )
    <=> ( ? [F0] :
          ! [X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,i(s(fun(A,B),F0),s(A,X))))))
        & ! [F0,XI_] :
            ( ( ! [X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,i(s(fun(A,B),F0),s(A,X))))))
              & ! [X] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,i(s(fun(A,B),XI_),s(A,X)))))) )
           => s(fun(A,B),F0) = s(fun(A,B),XI_) ) ) ) ).

fof(aboolu_INDUCT,axiom,
    ! [P0] :
      ( ( p(s(bool,i(s(fun(bool,bool),P0),s(bool,f0))))
        & p(s(bool,i(s(fun(bool,bool),P0),s(bool,t)))) )
     => ! [X] : p(s(bool,i(s(fun(bool,bool),P0),s(bool,X)))) ) ).

fof(aboolu_RECURSION,axiom,
    ! [A,A5,B0] :
    ? [F0] :
      ( s(A,i(s(fun(bool,A),F0),s(bool,f0))) = s(A,A5)
      & s(A,i(s(fun(bool,A),F0),s(bool,t))) = s(A,B0) ) ).

fof(aou_DEF,axiom,
    ! [C,B,A,F0,G0,X] : s(C,i(s(fun(A,C),i(s(fun(fun(A,B),fun(A,C)),i(s(fun(fun(B,C),fun(fun(A,B),fun(A,C))),o),s(fun(B,C),F0))),s(fun(A,B),G0))),s(A,X))) = s(C,i(s(fun(B,C),F0),s(B,i(s(fun(A,B),G0),s(A,X))))) ).

fof(aIu_DEF,axiom,
    ! [A,X] : s(A,i(s(fun(A,A),i1),s(A,X))) = s(A,X) ).

fof(aou_THM,axiom,
    ! [C,B,A,F0,G0,X] : s(C,i(s(fun(A,C),i(s(fun(fun(A,B),fun(A,C)),i(s(fun(fun(B,C),fun(fun(A,B),fun(A,C))),o),s(fun(B,C),F0))),s(fun(A,B),G0))),s(A,X))) = s(C,i(s(fun(B,C),F0),s(B,i(s(fun(A,B),G0),s(A,X))))) ).

fof(aou_ASSOC,axiom,
    ! [D,C,A,B,F0,G0,H0] : s(fun(A,D),i(s(fun(fun(A,C),fun(A,D)),i(s(fun(fun(C,D),fun(fun(A,C),fun(A,D))),o),s(fun(C,D),F0))),s(fun(A,C),i(s(fun(fun(A,B),fun(A,C)),i(s(fun(fun(B,C),fun(fun(A,B),fun(A,C))),o),s(fun(B,C),G0))),s(fun(A,B),H0))))) = s(fun(A,D),i(s(fun(fun(A,B),fun(A,D)),i(s(fun(fun(B,D),fun(fun(A,B),fun(A,D))),o),s(fun(B,D),i(s(fun(fun(B,C),fun(B,D)),i(s(fun(fun(C,D),fun(fun(B,C),fun(B,D))),o),s(fun(C,D),F0))),s(fun(B,C),G0))))),s(fun(A,B),H0))) ).

fof(aIu_THM,axiom,
    ! [A,X] : s(A,i(s(fun(A,A),i1),s(A,X))) = s(A,X) ).

fof(aIu_Ou_ID,axiom,
    ! [A,B,F0] :
      ( s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),i(s(fun(fun(B,B),fun(fun(A,B),fun(A,B))),o),s(fun(B,B),i1))),s(fun(A,B),F0))) = s(fun(A,B),F0)
      & s(fun(A,B),i(s(fun(fun(A,A),fun(A,B)),i(s(fun(fun(A,B),fun(fun(A,A),fun(A,B))),o),s(fun(A,B),F0))),s(fun(A,A),i1))) = s(fun(A,B),F0) ) ).

fof(aEXISTSu_ONEu_REP,axiom,
    ? [B0] : p(s(bool,B0)) ).

fof(aoneu_tydefu_conjunct1,axiom,
    ! [R0] :
      ( p(s(bool,R0))
    <=> s(bool,i(s(fun(n10,bool),oneu_rep),s(n10,i(s(fun(bool,n10),oneu_abs),s(bool,R0))))) = s(bool,R0) ) ).

fof(aoneu_tydefu_conjunct0,axiom,
    ! [A5] : s(n10,i(s(fun(bool,n10),oneu_abs),s(bool,i(s(fun(n10,bool),oneu_rep),s(n10,A5))))) = s(n10,A5) ).

fof(aoneu_DEF,axiom,
    ! [U_0] :
      ( ! [X] : s(bool,i(s(fun(n10,bool),U_0),s(n10,X))) = s(bool,t)
     => s(n10,one) = s(n10,i(s(fun(fun(n10,bool),n10),h_),s(fun(n10,bool),U_0))) ) ).

fof(aone,axiom,
    ! [V] : s(n10,V) = s(n10,one) ).

fof(aoneu_axiom,axiom,
    ! [A,F0,G0] : s(fun(A,n10),F0) = s(fun(A,n10),G0) ).

fof(aoneu_INDUCT,axiom,
    ! [P0] :
      ( p(s(bool,i(s(fun(n10,bool),P0),s(n10,one))))
     => ! [X] : p(s(bool,i(s(fun(n10,bool),P0),s(n10,X)))) ) ).

fof(aoneu_RECURSION,axiom,
    ! [A,E0] :
    ? [FN] : s(A,i(s(fun(n10,A),FN),s(n10,one))) = s(A,E0) ).

fof(aoneu_Axiom,axiom,
    ! [A,E0] :
      ( ? [FN] : s(A,i(s(fun(n10,A),FN),s(n10,one))) = s(A,E0)
      & ! [FN,XI_] :
          ( ( s(A,i(s(fun(n10,A),FN),s(n10,one))) = s(A,E0)
            & s(A,i(s(fun(n10,A),XI_),s(n10,one))) = s(A,E0) )
         => s(fun(n10,A),FN) = s(fun(n10,A),XI_) ) ) ).

fof(aLETu_DEF,axiom,
    ! [B,A,F0,X] : s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),let),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,X))) ).

fof(aLETu_ENDu_DEF,axiom,
    ! [A,T0] : s(A,i(s(fun(A,A),letu_end),s(A,T0))) = s(A,T0) ).

fof(aGABSu_DEF,axiom,
    ! [A,P0] : s(A,i(s(fun(fun(A,bool),A),gabs),s(fun(A,bool),P0))) = s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),P0))) ).

fof(aGEQu_DEF,axiom,
    ! [A,A5,B0] :
      ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),geq),s(A,A5))),s(A,B0))))
    <=> s(A,A5) = s(A,B0) ) ).

fof(au_SEQPATTERN,axiom,
    ! [Q4002,Q4005,X,XI_,X0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> ? [Y] : p(s(bool,i(s(fun(Q4002,bool),i(s(fun(Q4005,fun(Q4002,bool)),X),s(Q4005,X0))),s(Q4002,Y)))) )
      & s(fun(Q4002,bool),i(s(fun(Q4005,fun(Q4002,bool)),i(s(fun(fun(Q4005,fun(Q4002,bool)),fun(Q4005,fun(Q4002,bool))),i(s(fun(fun(Q4005,fun(Q4002,bool)),fun(fun(Q4005,fun(Q4002,bool)),fun(Q4005,fun(Q4002,bool)))),u_seqpattern),s(fun(Q4005,fun(Q4002,bool)),X))),s(fun(Q4005,fun(Q4002,bool)),XI_))),s(Q4005,X0))) = s(fun(Q4002,bool),i(s(fun(fun(Q4002,bool),fun(Q4002,bool)),i(s(fun(fun(Q4002,bool),fun(fun(Q4002,bool),fun(Q4002,bool))),i(s(fun(bool,fun(fun(Q4002,bool),fun(fun(Q4002,bool),fun(Q4002,bool)))),cond),s(bool,V))),s(fun(Q4002,bool),i(s(fun(Q4005,fun(Q4002,bool)),X),s(Q4005,X0))))),s(fun(Q4002,bool),i(s(fun(Q4005,fun(Q4002,bool)),XI_),s(Q4005,X0))))) ) ).

fof(au_UNGUARDEDu_PATTERN,axiom,
    ! [X,XI_] :
      ( p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),u_unguardedu_pattern),s(bool,X))),s(bool,XI_))))
    <=> ( p(s(bool,X))
        & p(s(bool,XI_)) ) ) ).

fof(au_GUARDEDu_PATTERN,axiom,
    ! [X,XI_,XI_I_] :
      ( p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),u_guardedu_pattern),s(bool,X))),s(bool,XI_))),s(bool,XI_I_))))
    <=> ( p(s(bool,X))
        & p(s(bool,XI_))
        & p(s(bool,XI_I_)) ) ) ).

fof(au_MATCH,axiom,
    ! [Q4047,Q4051,U_0] :
      ( ! [Z0] : s(bool,i(s(fun(Q4051,bool),U_0),s(Q4051,Z0))) = s(bool,f0)
     => ! [X,X0] :
        ? [V] :
          ( ( p(s(bool,V))
          <=> ( p(s(bool,i(s(fun(fun(Q4051,bool),bool),q_),s(fun(Q4051,bool),i(s(fun(Q4047,fun(Q4051,bool)),X0),s(Q4047,X))))))
              & ! [X1,Y] :
                  ( ( p(s(bool,i(s(fun(Q4051,bool),i(s(fun(Q4047,fun(Q4051,bool)),X0),s(Q4047,X))),s(Q4051,X1))))
                    & p(s(bool,i(s(fun(Q4051,bool),i(s(fun(Q4047,fun(Q4051,bool)),X0),s(Q4047,X))),s(Q4051,Y)))) )
                 => s(Q4051,X1) = s(Q4051,Y) ) ) )
          & s(Q4051,i(s(fun(fun(Q4047,fun(Q4051,bool)),Q4051),i(s(fun(Q4047,fun(fun(Q4047,fun(Q4051,bool)),Q4051)),u_match),s(Q4047,X))),s(fun(Q4047,fun(Q4051,bool)),X0))) = s(Q4051,i(s(fun(Q4051,Q4051),i(s(fun(Q4051,fun(Q4051,Q4051)),i(s(fun(bool,fun(Q4051,fun(Q4051,Q4051))),cond),s(bool,V))),s(Q4051,i(s(fun(fun(Q4051,bool),Q4051),h_),s(fun(Q4051,bool),i(s(fun(Q4047,fun(Q4051,bool)),X0),s(Q4047,X))))))),s(Q4051,i(s(fun(fun(Q4051,bool),Q4051),h_),s(fun(Q4051,bool),U_0))))) ) ) ).

fof(au_FUNCTION,axiom,
    ! [Q4069,Q4073,U_0] :
      ( ! [Z0] : s(bool,i(s(fun(Q4073,bool),U_0),s(Q4073,Z0))) = s(bool,f0)
     => ! [X,X0] :
        ? [V] :
          ( ( p(s(bool,V))
          <=> ( p(s(bool,i(s(fun(fun(Q4073,bool),bool),q_),s(fun(Q4073,bool),i(s(fun(Q4069,fun(Q4073,bool)),X),s(Q4069,X0))))))
              & ! [X1,Y] :
                  ( ( p(s(bool,i(s(fun(Q4073,bool),i(s(fun(Q4069,fun(Q4073,bool)),X),s(Q4069,X0))),s(Q4073,X1))))
                    & p(s(bool,i(s(fun(Q4073,bool),i(s(fun(Q4069,fun(Q4073,bool)),X),s(Q4069,X0))),s(Q4073,Y)))) )
                 => s(Q4073,X1) = s(Q4073,Y) ) ) )
          & s(Q4073,i(s(fun(Q4069,Q4073),i(s(fun(fun(Q4069,fun(Q4073,bool)),fun(Q4069,Q4073)),u_function),s(fun(Q4069,fun(Q4073,bool)),X))),s(Q4069,X0))) = s(Q4073,i(s(fun(Q4073,Q4073),i(s(fun(Q4073,fun(Q4073,Q4073)),i(s(fun(bool,fun(Q4073,fun(Q4073,Q4073))),cond),s(bool,V))),s(Q4073,i(s(fun(fun(Q4073,bool),Q4073),h_),s(fun(Q4073,bool),i(s(fun(Q4069,fun(Q4073,bool)),X),s(Q4069,X0))))))),s(Q4073,i(s(fun(fun(Q4073,bool),Q4073),h_),s(fun(Q4073,bool),U_0))))) ) ) ).

fof(amku_pairu_def,axiom,
    ! [A,B,X,Y,XI_,X0] :
      ( p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,X))),s(B,Y))),s(A,XI_))),s(B,X0))))
    <=> ( s(A,XI_) = s(A,X)
        & s(B,X0) = s(B,Y) ) ) ).

fof(aPAIRu_EXISTSu_THM,axiom,
    ! [A,B] :
    ? [X,A5,B0] : s(fun(A,fun(B,bool)),X) = s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,A5))),s(B,B0))) ).

fof(aprodu_tybiju_conjunct1,axiom,
    ! [A,B,R0] :
      ( ? [A5,B0] : s(fun(A,fun(B,bool)),R0) = s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,A5))),s(B,B0)))
    <=> s(fun(A,fun(B,bool)),i(s(fun(prod(A,B),fun(A,fun(B,bool))),repu_prod),s(prod(A,B),i(s(fun(fun(A,fun(B,bool)),prod(A,B)),absu_prod),s(fun(A,fun(B,bool)),R0))))) = s(fun(A,fun(B,bool)),R0) ) ).

fof(aprodu_tybiju_conjunct0,axiom,
    ! [A,B,A5] : s(prod(A,B),i(s(fun(fun(A,fun(B,bool)),prod(A,B)),absu_prod),s(fun(A,fun(B,bool)),i(s(fun(prod(A,B),fun(A,fun(B,bool))),repu_prod),s(prod(A,B),A5))))) = s(prod(A,B),A5) ).

fof(aREPu_ABSu_PAIR,axiom,
    ! [A,B,X,Y] : s(fun(A,fun(B,bool)),i(s(fun(prod(A,B),fun(A,fun(B,bool))),repu_prod),s(prod(A,B),i(s(fun(fun(A,fun(B,bool)),prod(A,B)),absu_prod),s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,X))),s(B,Y))))))) = s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,X))),s(B,Y))) ).

fof(aCOMMAu_DEF,axiom,
    ! [A,B,X,Y] : s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))) = s(prod(A,B),i(s(fun(fun(A,fun(B,bool)),prod(A,B)),absu_prod),s(fun(A,fun(B,bool)),i(s(fun(B,fun(A,fun(B,bool))),i(s(fun(A,fun(B,fun(A,fun(B,bool)))),mku_pair),s(A,X))),s(B,Y))))) ).

fof(aFSTu_DEF,axiom,
    ! [A,B,U_0] :
      ( ! [P0,X] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(prod(A,B),fun(A,bool)),U_0),s(prod(A,B),P0))),s(A,X))))
        <=> ? [Y] : s(prod(A,B),P0) = s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))) )
     => ! [P0] : s(A,i(s(fun(prod(A,B),A),fst),s(prod(A,B),P0))) = s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),i(s(fun(prod(A,B),fun(A,bool)),U_0),s(prod(A,B),P0))))) ) ).

fof(aSNDu_DEF,axiom,
    ! [A,B,U_0] :
      ( ! [P0,Y] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(prod(A,B),fun(B,bool)),U_0),s(prod(A,B),P0))),s(B,Y))))
        <=> ? [X] : s(prod(A,B),P0) = s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))) )
     => ! [P0] : s(B,i(s(fun(prod(A,B),B),snd),s(prod(A,B),P0))) = s(B,i(s(fun(fun(B,bool),B),h_),s(fun(B,bool),i(s(fun(prod(A,B),fun(B,bool)),U_0),s(prod(A,B),P0))))) ) ).

fof(aPAIRu_EQ,axiom,
    ! [A,B,X,Y,A5,B0] :
      ( s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))) = s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,A5))),s(B,B0)))
    <=> ( s(A,X) = s(A,A5)
        & s(B,Y) = s(B,B0) ) ) ).

fof(aPAIRu_SURJECTIVE,axiom,
    ! [A,B,P0] :
    ? [X,Y] : s(prod(A,B),P0) = s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))) ).

fof(aFST,axiom,
    ! [B,A,X,Y] : s(A,i(s(fun(prod(A,B),A),fst),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))))) = s(A,X) ).

fof(aSND,axiom,
    ! [A,B,X,Y] : s(B,i(s(fun(prod(A,B),B),snd),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))))) = s(B,Y) ).

fof(aPAIR,axiom,
    ! [A,B,X] : s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,i(s(fun(prod(A,B),A),fst),s(prod(A,B),X))))),s(B,i(s(fun(prod(A,B),B),snd),s(prod(A,B),X))))) = s(prod(A,B),X) ).

fof(apairu_cases,axiom,
    ! [Q4341,Q4340,P0] :
      ( ! [X,Y] : p(s(bool,i(s(fun(prod(Q4341,Q4340),bool),P0),s(prod(Q4341,Q4340),i(s(fun(Q4340,prod(Q4341,Q4340)),i(s(fun(Q4341,fun(Q4340,prod(Q4341,Q4340))),c_),s(Q4341,X))),s(Q4340,Y))))))
     => ! [P1] : p(s(bool,i(s(fun(prod(Q4341,Q4340),bool),P0),s(prod(Q4341,Q4340),P1)))) ) ).

fof(apairu_RECURSION,axiom,
    ! [C,A,B,PAIRI_] :
    ? [FN] :
    ! [A01,A10] : s(C,i(s(fun(prod(A,B),C),FN),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,A01))),s(B,A10))))) = s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),PAIRI_),s(A,A01))),s(B,A10))) ).

fof(aCURRYu_DEF,axiom,
    ! [C,A,B,F0,X,Y] : s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),curry),s(fun(prod(A,B),C),F0))),s(A,X))),s(B,Y))) = s(C,i(s(fun(prod(A,B),C),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))))) ).

fof(aUNCURRYu_DEF,axiom,
    ! [C,A,B,F0,X,Y] : s(C,i(s(fun(prod(A,B),C),i(s(fun(fun(A,fun(B,C)),fun(prod(A,B),C)),uncurry),s(fun(A,fun(B,C)),F0))),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))))) = s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),F0),s(A,X))),s(B,Y))) ).

fof(aPASSOCu_DEF,axiom,
    ! [D,A,B,C,F0,X,Y,Z0] : s(D,i(s(fun(prod(A,prod(B,C)),D),i(s(fun(fun(prod(prod(A,B),C),D),fun(prod(A,prod(B,C)),D)),passoc),s(fun(prod(prod(A,B),C),D),F0))),s(prod(A,prod(B,C)),i(s(fun(prod(B,C),prod(A,prod(B,C))),i(s(fun(A,fun(prod(B,C),prod(A,prod(B,C)))),c_),s(A,X))),s(prod(B,C),i(s(fun(C,prod(B,C)),i(s(fun(B,fun(C,prod(B,C))),c_),s(B,Y))),s(C,Z0))))))) = s(D,i(s(fun(prod(prod(A,B),C),D),F0),s(prod(prod(A,B),C),i(s(fun(C,prod(prod(A,B),C)),i(s(fun(prod(A,B),fun(C,prod(prod(A,B),C))),c_),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y))))),s(C,Z0))))) ).

fof(aFORALLu_PAIRu_THM,axiom,
    ! [Q4498,Q4497,P0] :
      ( ! [P1] : p(s(bool,i(s(fun(prod(Q4498,Q4497),bool),P0),s(prod(Q4498,Q4497),P1))))
    <=> ! [P1,P2] : p(s(bool,i(s(fun(prod(Q4498,Q4497),bool),P0),s(prod(Q4498,Q4497),i(s(fun(Q4497,prod(Q4498,Q4497)),i(s(fun(Q4498,fun(Q4497,prod(Q4498,Q4497))),c_),s(Q4498,P1))),s(Q4497,P2)))))) ) ).

fof(aEXISTSu_PAIRu_THM,axiom,
    ! [Q4523,Q4522,P0] :
      ( ? [P1] : p(s(bool,i(s(fun(prod(Q4523,Q4522),bool),P0),s(prod(Q4523,Q4522),P1))))
    <=> ? [P1,P2] : p(s(bool,i(s(fun(prod(Q4523,Q4522),bool),P0),s(prod(Q4523,Q4522),i(s(fun(Q4522,prod(Q4523,Q4522)),i(s(fun(Q4523,fun(Q4522,prod(Q4523,Q4522))),c_),s(Q4523,P1))),s(Q4522,P2)))))) ) ).

fof(aLAMBDAu_PAIRu_THM,axiom,
    ! [Q4537,Q4545,Q4544,U_0] :
      ( ! [T0,F0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4545,Q4544),Q4537),bool),i(s(fun(fun(prod(Q4545,Q4544),Q4537),fun(fun(prod(Q4545,Q4544),Q4537),bool)),U_0),s(fun(prod(Q4545,Q4544),Q4537),T0))),s(fun(prod(Q4545,Q4544),Q4537),F0))))
        <=> ! [X,Y] : p(s(bool,i(s(fun(Q4537,bool),i(s(fun(Q4537,fun(Q4537,bool)),geq),s(Q4537,i(s(fun(prod(Q4545,Q4544),Q4537),F0),s(prod(Q4545,Q4544),i(s(fun(Q4544,prod(Q4545,Q4544)),i(s(fun(Q4545,fun(Q4544,prod(Q4545,Q4544))),c_),s(Q4545,X))),s(Q4544,Y))))))),s(Q4537,i(s(fun(prod(Q4545,Q4544),Q4537),T0),s(prod(Q4545,Q4544),i(s(fun(Q4544,prod(Q4545,Q4544)),i(s(fun(Q4545,fun(Q4544,prod(Q4545,Q4544))),c_),s(Q4545,X))),s(Q4544,Y)))))))) )
     => ! [T0,X] : s(Q4537,i(s(fun(prod(Q4545,Q4544),Q4537),T0),s(prod(Q4545,Q4544),X))) = s(Q4537,i(s(fun(prod(Q4545,Q4544),Q4537),i(s(fun(fun(fun(prod(Q4545,Q4544),Q4537),bool),fun(prod(Q4545,Q4544),Q4537)),gabs),s(fun(fun(prod(Q4545,Q4544),Q4537),bool),i(s(fun(fun(prod(Q4545,Q4544),Q4537),fun(fun(prod(Q4545,Q4544),Q4537),bool)),U_0),s(fun(prod(Q4545,Q4544),Q4537),T0))))),s(prod(Q4545,Q4544),X))) ) ).

fof(aPAIREDu_ETAu_THMu_conjunct2,axiom,
    ! [Q4620,Q4624,Q4628,Q4627,Q4604,U_0] :
      ( ! [F0,FI_] :
          ( p(s(bool,i(s(fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),bool),i(s(fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),bool)),U_0),s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),F0))),s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),FI_))))
        <=> ! [W,X,Y,Z0] : p(s(bool,i(s(fun(Q4604,bool),i(s(fun(Q4604,fun(Q4604,bool)),geq),s(Q4604,i(s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),FI_),s(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),i(s(fun(prod(Q4624,prod(Q4628,Q4627)),prod(Q4620,prod(Q4624,prod(Q4628,Q4627)))),i(s(fun(Q4620,fun(prod(Q4624,prod(Q4628,Q4627)),prod(Q4620,prod(Q4624,prod(Q4628,Q4627))))),c_),s(Q4620,W))),s(prod(Q4624,prod(Q4628,Q4627)),i(s(fun(prod(Q4628,Q4627),prod(Q4624,prod(Q4628,Q4627))),i(s(fun(Q4624,fun(prod(Q4628,Q4627),prod(Q4624,prod(Q4628,Q4627)))),c_),s(Q4624,X))),s(prod(Q4628,Q4627),i(s(fun(Q4627,prod(Q4628,Q4627)),i(s(fun(Q4628,fun(Q4627,prod(Q4628,Q4627))),c_),s(Q4628,Y))),s(Q4627,Z0))))))))))),s(Q4604,i(s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),F0),s(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),i(s(fun(prod(Q4624,prod(Q4628,Q4627)),prod(Q4620,prod(Q4624,prod(Q4628,Q4627)))),i(s(fun(Q4620,fun(prod(Q4624,prod(Q4628,Q4627)),prod(Q4620,prod(Q4624,prod(Q4628,Q4627))))),c_),s(Q4620,W))),s(prod(Q4624,prod(Q4628,Q4627)),i(s(fun(prod(Q4628,Q4627),prod(Q4624,prod(Q4628,Q4627))),i(s(fun(Q4624,fun(prod(Q4628,Q4627),prod(Q4624,prod(Q4628,Q4627)))),c_),s(Q4624,X))),s(prod(Q4628,Q4627),i(s(fun(Q4627,prod(Q4628,Q4627)),i(s(fun(Q4628,fun(Q4627,prod(Q4628,Q4627))),c_),s(Q4628,Y))),s(Q4627,Z0)))))))))))) )
     => ! [F0] : s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),i(s(fun(fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),bool),fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604)),gabs),s(fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),bool),i(s(fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),fun(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),bool)),U_0),s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),F0))))) = s(fun(prod(Q4620,prod(Q4624,prod(Q4628,Q4627))),Q4604),F0) ) ).

fof(aPAIREDu_ETAu_THMu_conjunct1,axiom,
    ! [Q4590,Q4594,Q4593,Q4578,U_0] :
      ( ! [F0,FI_] :
          ( p(s(bool,i(s(fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),bool),i(s(fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),bool)),U_0),s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),F0))),s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),FI_))))
        <=> ! [X,Y,Z0] : p(s(bool,i(s(fun(Q4578,bool),i(s(fun(Q4578,fun(Q4578,bool)),geq),s(Q4578,i(s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),FI_),s(prod(Q4590,prod(Q4594,Q4593)),i(s(fun(prod(Q4594,Q4593),prod(Q4590,prod(Q4594,Q4593))),i(s(fun(Q4590,fun(prod(Q4594,Q4593),prod(Q4590,prod(Q4594,Q4593)))),c_),s(Q4590,X))),s(prod(Q4594,Q4593),i(s(fun(Q4593,prod(Q4594,Q4593)),i(s(fun(Q4594,fun(Q4593,prod(Q4594,Q4593))),c_),s(Q4594,Y))),s(Q4593,Z0))))))))),s(Q4578,i(s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),F0),s(prod(Q4590,prod(Q4594,Q4593)),i(s(fun(prod(Q4594,Q4593),prod(Q4590,prod(Q4594,Q4593))),i(s(fun(Q4590,fun(prod(Q4594,Q4593),prod(Q4590,prod(Q4594,Q4593)))),c_),s(Q4590,X))),s(prod(Q4594,Q4593),i(s(fun(Q4593,prod(Q4594,Q4593)),i(s(fun(Q4594,fun(Q4593,prod(Q4594,Q4593))),c_),s(Q4594,Y))),s(Q4593,Z0)))))))))) )
     => ! [F0] : s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),i(s(fun(fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),bool),fun(prod(Q4590,prod(Q4594,Q4593)),Q4578)),gabs),s(fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),bool),i(s(fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),fun(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),bool)),U_0),s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),F0))))) = s(fun(prod(Q4590,prod(Q4594,Q4593)),Q4578),F0) ) ).

fof(aPAIREDu_ETAu_THMu_conjunct0,axiom,
    ! [Q4566,Q4565,Q4558,U_0] :
      ( ! [F0,FI_] :
          ( p(s(bool,i(s(fun(fun(prod(Q4566,Q4565),Q4558),bool),i(s(fun(fun(prod(Q4566,Q4565),Q4558),fun(fun(prod(Q4566,Q4565),Q4558),bool)),U_0),s(fun(prod(Q4566,Q4565),Q4558),F0))),s(fun(prod(Q4566,Q4565),Q4558),FI_))))
        <=> ! [X,Y] : p(s(bool,i(s(fun(Q4558,bool),i(s(fun(Q4558,fun(Q4558,bool)),geq),s(Q4558,i(s(fun(prod(Q4566,Q4565),Q4558),FI_),s(prod(Q4566,Q4565),i(s(fun(Q4565,prod(Q4566,Q4565)),i(s(fun(Q4566,fun(Q4565,prod(Q4566,Q4565))),c_),s(Q4566,X))),s(Q4565,Y))))))),s(Q4558,i(s(fun(prod(Q4566,Q4565),Q4558),F0),s(prod(Q4566,Q4565),i(s(fun(Q4565,prod(Q4566,Q4565)),i(s(fun(Q4566,fun(Q4565,prod(Q4566,Q4565))),c_),s(Q4566,X))),s(Q4565,Y)))))))) )
     => ! [F0] : s(fun(prod(Q4566,Q4565),Q4558),i(s(fun(fun(fun(prod(Q4566,Q4565),Q4558),bool),fun(prod(Q4566,Q4565),Q4558)),gabs),s(fun(fun(prod(Q4566,Q4565),Q4558),bool),i(s(fun(fun(prod(Q4566,Q4565),Q4558),fun(fun(prod(Q4566,Q4565),Q4558),bool)),U_0),s(fun(prod(Q4566,Q4565),Q4558),F0))))) = s(fun(prod(Q4566,Q4565),Q4558),F0) ) ).

fof(aFORALLu_UNCURRY,axiom,
    ! [A,B,C,U_1] :
      ( ! [F0,A5,B0] : s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_1),s(fun(prod(A,B),C),F0))),s(A,A5))),s(B,B0))) = s(C,i(s(fun(prod(A,B),C),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,A5))),s(B,B0)))))
     => ! [U_0] :
          ( ! [F0,A5] : s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_0),s(fun(prod(A,B),C),F0))),s(A,A5))) = s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_1),s(fun(prod(A,B),C),F0))),s(A,A5)))
         => ! [P0] :
              ( ! [F0] : p(s(bool,i(s(fun(fun(A,fun(B,C)),bool),P0),s(fun(A,fun(B,C)),F0))))
            <=> ! [F0] : p(s(bool,i(s(fun(fun(A,fun(B,C)),bool),P0),s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_0),s(fun(prod(A,B),C),F0)))))) ) ) ) ).

fof(aEXISTSu_UNCURRY,axiom,
    ! [A,B,C,U_1] :
      ( ! [F0,A5,B0] : s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_1),s(fun(prod(A,B),C),F0))),s(A,A5))),s(B,B0))) = s(C,i(s(fun(prod(A,B),C),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,A5))),s(B,B0)))))
     => ! [U_0] :
          ( ! [F0,A5] : s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_0),s(fun(prod(A,B),C),F0))),s(A,A5))) = s(fun(B,C),i(s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_1),s(fun(prod(A,B),C),F0))),s(A,A5)))
         => ! [P0] :
              ( ? [F0] : p(s(bool,i(s(fun(fun(A,fun(B,C)),bool),P0),s(fun(A,fun(B,C)),F0))))
            <=> ? [F0] : p(s(bool,i(s(fun(fun(A,fun(B,C)),bool),P0),s(fun(A,fun(B,C)),i(s(fun(fun(prod(A,B),C),fun(A,fun(B,C))),U_0),s(fun(prod(A,B),C),F0)))))) ) ) ) ).

fof(aEXISTSu_CURRY,axiom,
    ! [Q4732,Q4731,Q4725,U_0] :
      ( ! [F0,F1] :
          ( p(s(bool,i(s(fun(fun(prod(Q4732,Q4731),Q4725),bool),i(s(fun(fun(Q4732,fun(Q4731,Q4725)),fun(fun(prod(Q4732,Q4731),Q4725),bool)),U_0),s(fun(Q4732,fun(Q4731,Q4725)),F0))),s(fun(prod(Q4732,Q4731),Q4725),F1))))
        <=> ! [A5,B0] : p(s(bool,i(s(fun(Q4725,bool),i(s(fun(Q4725,fun(Q4725,bool)),geq),s(Q4725,i(s(fun(prod(Q4732,Q4731),Q4725),F1),s(prod(Q4732,Q4731),i(s(fun(Q4731,prod(Q4732,Q4731)),i(s(fun(Q4732,fun(Q4731,prod(Q4732,Q4731))),c_),s(Q4732,A5))),s(Q4731,B0))))))),s(Q4725,i(s(fun(Q4731,Q4725),i(s(fun(Q4732,fun(Q4731,Q4725)),F0),s(Q4732,A5))),s(Q4731,B0)))))) )
     => ! [P0] :
          ( ? [F0] : p(s(bool,i(s(fun(fun(prod(Q4732,Q4731),Q4725),bool),P0),s(fun(prod(Q4732,Q4731),Q4725),F0))))
        <=> ? [F0] : p(s(bool,i(s(fun(fun(prod(Q4732,Q4731),Q4725),bool),P0),s(fun(prod(Q4732,Q4731),Q4725),i(s(fun(fun(fun(prod(Q4732,Q4731),Q4725),bool),fun(prod(Q4732,Q4731),Q4725)),gabs),s(fun(fun(prod(Q4732,Q4731),Q4725),bool),i(s(fun(fun(Q4732,fun(Q4731,Q4725)),fun(fun(prod(Q4732,Q4731),Q4725),bool)),U_0),s(fun(Q4732,fun(Q4731,Q4725)),F0)))))))) ) ) ).

fof(aFORALLu_CURRY,axiom,
    ! [Q4757,Q4756,Q4750,U_0] :
      ( ! [F0,F1] :
          ( p(s(bool,i(s(fun(fun(prod(Q4757,Q4756),Q4750),bool),i(s(fun(fun(Q4757,fun(Q4756,Q4750)),fun(fun(prod(Q4757,Q4756),Q4750),bool)),U_0),s(fun(Q4757,fun(Q4756,Q4750)),F0))),s(fun(prod(Q4757,Q4756),Q4750),F1))))
        <=> ! [A5,B0] : p(s(bool,i(s(fun(Q4750,bool),i(s(fun(Q4750,fun(Q4750,bool)),geq),s(Q4750,i(s(fun(prod(Q4757,Q4756),Q4750),F1),s(prod(Q4757,Q4756),i(s(fun(Q4756,prod(Q4757,Q4756)),i(s(fun(Q4757,fun(Q4756,prod(Q4757,Q4756))),c_),s(Q4757,A5))),s(Q4756,B0))))))),s(Q4750,i(s(fun(Q4756,Q4750),i(s(fun(Q4757,fun(Q4756,Q4750)),F0),s(Q4757,A5))),s(Q4756,B0)))))) )
     => ! [P0] :
          ( ! [F0] : p(s(bool,i(s(fun(fun(prod(Q4757,Q4756),Q4750),bool),P0),s(fun(prod(Q4757,Q4756),Q4750),F0))))
        <=> ! [F0] : p(s(bool,i(s(fun(fun(prod(Q4757,Q4756),Q4750),bool),P0),s(fun(prod(Q4757,Q4756),Q4750),i(s(fun(fun(fun(prod(Q4757,Q4756),Q4750),bool),fun(prod(Q4757,Q4756),Q4750)),gabs),s(fun(fun(prod(Q4757,Q4756),Q4750),bool),i(s(fun(fun(Q4757,fun(Q4756,Q4750)),fun(fun(prod(Q4757,Q4756),Q4750),bool)),U_0),s(fun(Q4757,fun(Q4756,Q4750)),F0)))))))) ) ) ).

fof(aFORALLu_PAIREDu_THM,axiom,
    ! [Q4784,Q4783,U_0] :
      ( ! [P0,F0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4784,Q4783),bool),bool),i(s(fun(fun(Q4784,fun(Q4783,bool)),fun(fun(prod(Q4784,Q4783),bool),bool)),U_0),s(fun(Q4784,fun(Q4783,bool)),P0))),s(fun(prod(Q4784,Q4783),bool),F0))))
        <=> ! [X,Y] : p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(Q4784,Q4783),bool),F0),s(prod(Q4784,Q4783),i(s(fun(Q4783,prod(Q4784,Q4783)),i(s(fun(Q4784,fun(Q4783,prod(Q4784,Q4783))),c_),s(Q4784,X))),s(Q4783,Y))))))),s(bool,i(s(fun(Q4783,bool),i(s(fun(Q4784,fun(Q4783,bool)),P0),s(Q4784,X))),s(Q4783,Y)))))) )
     => ! [P0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4784,Q4783),bool),bool),e_),s(fun(prod(Q4784,Q4783),bool),i(s(fun(fun(fun(prod(Q4784,Q4783),bool),bool),fun(prod(Q4784,Q4783),bool)),gabs),s(fun(fun(prod(Q4784,Q4783),bool),bool),i(s(fun(fun(Q4784,fun(Q4783,bool)),fun(fun(prod(Q4784,Q4783),bool),bool)),U_0),s(fun(Q4784,fun(Q4783,bool)),P0))))))))
        <=> ! [X,Y] : p(s(bool,i(s(fun(Q4783,bool),i(s(fun(Q4784,fun(Q4783,bool)),P0),s(Q4784,X))),s(Q4783,Y)))) ) ) ).

fof(aEXISTSu_PAIREDu_THM,axiom,
    ! [Q4820,Q4819,U_0] :
      ( ! [P0,F0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4820,Q4819),bool),bool),i(s(fun(fun(Q4820,fun(Q4819,bool)),fun(fun(prod(Q4820,Q4819),bool),bool)),U_0),s(fun(Q4820,fun(Q4819,bool)),P0))),s(fun(prod(Q4820,Q4819),bool),F0))))
        <=> ! [X,Y] : p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(Q4820,Q4819),bool),F0),s(prod(Q4820,Q4819),i(s(fun(Q4819,prod(Q4820,Q4819)),i(s(fun(Q4820,fun(Q4819,prod(Q4820,Q4819))),c_),s(Q4820,X))),s(Q4819,Y))))))),s(bool,i(s(fun(Q4819,bool),i(s(fun(Q4820,fun(Q4819,bool)),P0),s(Q4820,X))),s(Q4819,Y)))))) )
     => ! [P0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4820,Q4819),bool),bool),q_),s(fun(prod(Q4820,Q4819),bool),i(s(fun(fun(fun(prod(Q4820,Q4819),bool),bool),fun(prod(Q4820,Q4819),bool)),gabs),s(fun(fun(prod(Q4820,Q4819),bool),bool),i(s(fun(fun(Q4820,fun(Q4819,bool)),fun(fun(prod(Q4820,Q4819),bool),bool)),U_0),s(fun(Q4820,fun(Q4819,bool)),P0))))))))
        <=> ? [X,Y] : p(s(bool,i(s(fun(Q4819,bool),i(s(fun(Q4820,fun(Q4819,bool)),P0),s(Q4820,X))),s(Q4819,Y)))) ) ) ).

fof(aFORALLu_TRIPLEDu_THM,axiom,
    ! [Q4857,Q4856,Q4855,U_0] :
      ( ! [P0,F0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool),i(s(fun(fun(Q4857,fun(Q4856,fun(Q4855,bool))),fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool)),U_0),s(fun(Q4857,fun(Q4856,fun(Q4855,bool))),P0))),s(fun(prod(Q4857,prod(Q4856,Q4855)),bool),F0))))
        <=> ! [X,Y,Z0] : p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(Q4857,prod(Q4856,Q4855)),bool),F0),s(prod(Q4857,prod(Q4856,Q4855)),i(s(fun(prod(Q4856,Q4855),prod(Q4857,prod(Q4856,Q4855))),i(s(fun(Q4857,fun(prod(Q4856,Q4855),prod(Q4857,prod(Q4856,Q4855)))),c_),s(Q4857,X))),s(prod(Q4856,Q4855),i(s(fun(Q4855,prod(Q4856,Q4855)),i(s(fun(Q4856,fun(Q4855,prod(Q4856,Q4855))),c_),s(Q4856,Y))),s(Q4855,Z0))))))))),s(bool,i(s(fun(Q4855,bool),i(s(fun(Q4856,fun(Q4855,bool)),i(s(fun(Q4857,fun(Q4856,fun(Q4855,bool))),P0),s(Q4857,X))),s(Q4856,Y))),s(Q4855,Z0)))))) )
     => ! [P0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool),e_),s(fun(prod(Q4857,prod(Q4856,Q4855)),bool),i(s(fun(fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool),fun(prod(Q4857,prod(Q4856,Q4855)),bool)),gabs),s(fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool),i(s(fun(fun(Q4857,fun(Q4856,fun(Q4855,bool))),fun(fun(prod(Q4857,prod(Q4856,Q4855)),bool),bool)),U_0),s(fun(Q4857,fun(Q4856,fun(Q4855,bool))),P0))))))))
        <=> ! [X,Y,Z0] : p(s(bool,i(s(fun(Q4855,bool),i(s(fun(Q4856,fun(Q4855,bool)),i(s(fun(Q4857,fun(Q4856,fun(Q4855,bool))),P0),s(Q4857,X))),s(Q4856,Y))),s(Q4855,Z0)))) ) ) ).

fof(aEXISTSu_TRIPLEDu_THM,axiom,
    ! [Q4903,Q4902,Q4901,U_0] :
      ( ! [P0,F0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool),i(s(fun(fun(Q4903,fun(Q4902,fun(Q4901,bool))),fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool)),U_0),s(fun(Q4903,fun(Q4902,fun(Q4901,bool))),P0))),s(fun(prod(Q4903,prod(Q4902,Q4901)),bool),F0))))
        <=> ! [X,Y,Z0] : p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(Q4903,prod(Q4902,Q4901)),bool),F0),s(prod(Q4903,prod(Q4902,Q4901)),i(s(fun(prod(Q4902,Q4901),prod(Q4903,prod(Q4902,Q4901))),i(s(fun(Q4903,fun(prod(Q4902,Q4901),prod(Q4903,prod(Q4902,Q4901)))),c_),s(Q4903,X))),s(prod(Q4902,Q4901),i(s(fun(Q4901,prod(Q4902,Q4901)),i(s(fun(Q4902,fun(Q4901,prod(Q4902,Q4901))),c_),s(Q4902,Y))),s(Q4901,Z0))))))))),s(bool,i(s(fun(Q4901,bool),i(s(fun(Q4902,fun(Q4901,bool)),i(s(fun(Q4903,fun(Q4902,fun(Q4901,bool))),P0),s(Q4903,X))),s(Q4902,Y))),s(Q4901,Z0)))))) )
     => ! [P0] :
          ( p(s(bool,i(s(fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool),q_),s(fun(prod(Q4903,prod(Q4902,Q4901)),bool),i(s(fun(fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool),fun(prod(Q4903,prod(Q4902,Q4901)),bool)),gabs),s(fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool),i(s(fun(fun(Q4903,fun(Q4902,fun(Q4901,bool))),fun(fun(prod(Q4903,prod(Q4902,Q4901)),bool),bool)),U_0),s(fun(Q4903,fun(Q4902,fun(Q4901,bool))),P0))))))))
        <=> ? [X,Y,Z0] : p(s(bool,i(s(fun(Q4901,bool),i(s(fun(Q4902,fun(Q4901,bool)),i(s(fun(Q4903,fun(Q4902,fun(Q4901,bool))),P0),s(Q4903,X))),s(Q4902,Y))),s(Q4901,Z0)))) ) ) ).

fof(aONEu_ONE,axiom,
    ! [B,A,F0] :
      ( p(s(bool,i(s(fun(fun(A,B),bool),oneu_one),s(fun(A,B),F0))))
    <=> ! [X1,X2] :
          ( s(B,i(s(fun(A,B),F0),s(A,X1))) = s(B,i(s(fun(A,B),F0),s(A,X2)))
         => s(A,X1) = s(A,X2) ) ) ).

fof(aONTO,axiom,
    ! [B,A,F0] :
      ( p(s(bool,i(s(fun(fun(A,B),bool),onto),s(fun(A,B),F0))))
    <=> ! [Y] :
        ? [X] : s(B,Y) = s(B,i(s(fun(A,B),F0),s(A,X))) ) ).

fof(aINFINITYu_AX,axiom,
    ? [F0] :
      ( p(s(bool,i(s(fun(fun(ind0,ind0),bool),oneu_one),s(fun(ind0,ind0),F0))))
      & ~ p(s(bool,i(s(fun(fun(ind0,ind0),bool),onto),s(fun(ind0,ind0),F0)))) ) ).

fof(aINDu_SUCu_0u_EXISTS,axiom,
    ? [F0,Z0] :
      ( ! [X1,X2] :
          ( s(ind0,i(s(fun(ind0,ind0),F0),s(ind0,X1))) = s(ind0,i(s(fun(ind0,ind0),F0),s(ind0,X2)))
        <=> s(ind0,X1) = s(ind0,X2) )
      & ! [X] : s(ind0,i(s(fun(ind0,ind0),F0),s(ind0,X))) != s(ind0,Z0) ) ).

fof(aINDu_SUCu_0,axiom,
    ! [X] : s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,X))) != s(ind0,indu_0) ).

fof(aINDu_SUCu_INJ,axiom,
    ! [X1,X2] :
      ( s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,X1))) = s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,X2)))
    <=> s(ind0,X1) = s(ind0,X2) ) ).

fof(aNUMu_REPu_RULESu_conjunct0,axiom,
    p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,indu_0)))) ).

fof(aNUMu_REPu_RULESu_conjunct1,axiom,
    ! [I0] :
      ( p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,I0))))
     => p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,I0)))))) ) ).

fof(aNUMu_REPu_CASES,axiom,
    ! [A5] :
      ( p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,A5))))
    <=> ( s(ind0,A5) = s(ind0,indu_0)
        | ? [I0] :
            ( s(ind0,A5) = s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,I0)))
            & p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,I0)))) ) ) ) ).

fof(aNUMu_REPu_INDUCT,axiom,
    ! [NUMU_REPI_] :
      ( ( p(s(bool,i(s(fun(ind0,bool),NUMU_REPI_),s(ind0,indu_0))))
        & ! [I0] :
            ( p(s(bool,i(s(fun(ind0,bool),NUMU_REPI_),s(ind0,I0))))
           => p(s(bool,i(s(fun(ind0,bool),NUMU_REPI_),s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,I0)))))) ) )
     => ! [A5] :
          ( p(s(bool,i(s(fun(ind0,bool),numu_rep),s(ind0,A5))))
         => p(s(bool,i(s(fun(ind0,bool),NUMU_REPI_),s(ind0,A5)))) ) ) ).

fof(aZEROu_DEF,axiom,
    s(num,u_0) = s(num,i(s(fun(ind0,num),mku_num),s(ind0,indu_0))) ).

fof(aSUCu_DEF,axiom,
    ! [N0] : s(num,i(s(fun(num,num),suc),s(num,N0))) = s(num,i(s(fun(ind0,num),mku_num),s(ind0,i(s(fun(ind0,ind0),indu_suc),s(ind0,i(s(fun(num,ind0),destu_num),s(num,N0))))))) ).

fof(aSUCu_INJ,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),suc),s(num,M0))) = s(num,i(s(fun(num,num),suc),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aARITHu_EQu_conjunct1,axiom,
    ( s(num,u_0) = s(num,u_0)
  <=> p(s(bool,t)) ) ).

fof(aNUMERAL,axiom,
    ! [N0] : s(num,i(s(fun(num,num),numeral),s(num,N0))) = s(num,N0) ).

fof(aNOTu_SUC,axiom,
    ! [N0] : s(num,i(s(fun(num,num),suc),s(num,N0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(anumu_INDUCTION,axiom,
    ! [P0] :
      ( ( p(s(bool,i(s(fun(num,bool),P0),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))
        & ! [N0] :
            ( p(s(bool,i(s(fun(num,bool),P0),s(num,N0))))
           => p(s(bool,i(s(fun(num,bool),P0),s(num,i(s(fun(num,num),suc),s(num,N0)))))) ) )
     => ! [N0] : p(s(bool,i(s(fun(num,bool),P0),s(num,N0)))) ) ).

fof(anumu_Axiom,axiom,
    ! [A,E0,F0] :
      ( ? [FN] :
          ( s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(A,E0)
          & ! [N0] : s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(A,i(s(fun(num,A),i(s(fun(A,fun(num,A)),F0),s(A,i(s(fun(num,A),FN),s(num,N0))))),s(num,N0))) )
      & ! [FN,XI_] :
          ( ( s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(A,E0)
            & ! [N0] : s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(A,i(s(fun(num,A),i(s(fun(A,fun(num,A)),F0),s(A,i(s(fun(num,A),FN),s(num,N0))))),s(num,N0)))
            & s(A,i(s(fun(num,A),XI_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(A,E0)
            & ! [N0] : s(A,i(s(fun(num,A),XI_),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(A,i(s(fun(num,A),i(s(fun(A,fun(num,A)),F0),s(A,i(s(fun(num,A),XI_),s(num,N0))))),s(num,N0))) )
         => s(fun(num,A),FN) = s(fun(num,A),XI_) ) ) ).

fof(anumu_RECURSION,axiom,
    ! [A,E0,F0] :
    ? [FN] :
      ( s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(A,E0)
      & ! [N0] : s(A,i(s(fun(num,A),FN),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(A,i(s(fun(num,A),i(s(fun(A,fun(num,A)),F0),s(A,i(s(fun(num,A),FN),s(num,N0))))),s(num,N0))) ) ).

fof(anumu_CASES,axiom,
    ! [M0] :
      ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
      | ? [N0] : s(num,M0) = s(num,i(s(fun(num,num),suc),s(num,N0))) ) ).

fof(anumu_RECURSIONu_STD,axiom,
    ! [Z,E0,F0] :
    ? [FN] :
      ( s(Z,i(s(fun(num,Z),FN),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(Z,E0)
      & ! [N0] : s(Z,i(s(fun(num,Z),FN),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(Z,i(s(fun(Z,Z),i(s(fun(num,fun(Z,Z)),F0),s(num,N0))),s(Z,i(s(fun(num,Z),FN),s(num,N0))))) ) ).

fof(aBIT0u_DEFu_conjunct0,axiom,
    s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aBIT0u_DEFu_conjunct1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),bit0),s(num,N0))))))) ).

fof(aBIT1u_DEF,axiom,
    ! [N0] : s(num,i(s(fun(num,num),bit1),s(num,N0))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),bit0),s(num,N0))))) ).

fof(aPREu_conjunct0,axiom,
    s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aPREu_conjunct1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,N0) ).

fof(aADDu_conjunct0,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) = s(num,N0) ).

fof(aADDu_conjunct1,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,N0))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aADDu_0,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,M0) ).

fof(aADDu_SUC,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aADDu_SYM,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,M0))) ).

fof(aADDu_ASSOC,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,P0))) ).

fof(aADDu_ACu_conjunct0,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,m))),s(num,n))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,n))),s(num,m))) ).

fof(aADDu_ACu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,m))),s(num,n))))),s(num,p1))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,m))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,n))),s(num,p1))))) ).

fof(aADDu_ACu_conjunct2,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,m))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,n))),s(num,p1))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,n))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,m))),s(num,p1))))) ).

fof(aADDu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEQu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0)))
    <=> s(num,N0) = s(num,P0) ) ).

fof(aEQu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aEQu_ADDu_LCANCELu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))) = s(num,M0)
    <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aEQu_ADDu_RCANCELu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))) = s(num,N0)
    <=> s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aBIT0,axiom,
    ! [N0] : s(num,i(s(fun(num,num),bit0),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,N0))) ).

fof(aBIT1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),bit1),s(num,N0))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,N0))))) ).

fof(aBIT0u_THM,axiom,
    ! [N0] : s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),numeral),s(num,N0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) ).

fof(aBIT1u_THM,axiom,
    ! [N0] : s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),numeral),s(num,N0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))))) ).

fof(aARITHu_ADDu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,u_0))),s(num,u_0))) = s(num,u_0) ).

fof(aONE,axiom,
    s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aTWO,axiom,
    s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aADD1,axiom,
    ! [M0] : s(num,i(s(fun(num,num),suc),s(num,M0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aMULTu_CLAUSESu_conjunct0,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aMULTu_CLAUSESu_conjunct4,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,N0))) ).

fof(aMULTu_0,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aMULTu_SUC,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aMULTu_CLAUSESu_conjunct2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0))) = s(num,N0) ).

fof(aMULTu_CLAUSESu_conjunct3,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,M0) ).

fof(aMULTu_SYM,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,M0))) ).

fof(aLEFTu_ADDu_DISTRIB,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))) ).

fof(aMULTu_ACu_conjunct0,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,m))),s(num,n))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,n))),s(num,m))) ).

fof(aRIGHTu_ADDu_DISTRIB,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))) ).

fof(aMULTu_ASSOC,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,P0))) ).

fof(aMULTu_ACu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,m))),s(num,n))))),s(num,p1))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,m))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,n))),s(num,p1))))) ).

fof(aMULTu_ACu_conjunct2,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,m))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,n))),s(num,p1))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,n))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,m))),s(num,p1))))) ).

fof(aMULTu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEQu_MULTu_LCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0)))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        | s(num,N0) = s(num,P0) ) ) ).

fof(aEQu_MULTu_RCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0)))
    <=> ( s(num,M0) = s(num,N0)
        | s(num,P0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aMULTu_2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,N0))) ).

fof(aMULTu_EQu_1,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
        & s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ) ) ).

fof(aEXPu_conjunct0,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ).

fof(aEXPu_conjunct1,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))) ).

fof(aEXPu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEXPu_EQu_1,axiom,
    ! [X,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
    <=> ( s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEXPu_ZERO,axiom,
    ! [N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
      & s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,V))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aEXPu_ADD,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,P0))))) ).

fof(aEXPu_ONE,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ).

fof(aEXPu_1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,N0) ).

fof(aEXPu_2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,N0))) ).

fof(aMULTu_EXP,axiom,
    ! [P0,M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,N0))),s(num,P0))))) ).

fof(aEXPu_MULT,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))),s(num,P0))) ).

fof(aLEu_conjunct0,axiom,
    ! [M0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))
    <=> s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aLEu_conjunct1,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),suc),s(num,N0)))
        | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) ) ) ).

fof(aLTu_conjunct0,axiom,
    ! [M0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(bool,f0) ).

fof(aLTu_conjunct1,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))))
    <=> ( s(num,M0) = s(num,N0)
        | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) ) ) ).

fof(aGE,axiom,
    ! [N0,M0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,M0))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))) ).

fof(aGT,axiom,
    ! [N0,M0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,M0))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0))) ).

fof(aMAX,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),max),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))),s(num,N0))),s(num,M0))) ).

fof(aMIN,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),min),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))),s(num,M0))),s(num,N0))) ).

fof(aLEu_SUCu_LT,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aLTu_SUCu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aLEu_SUC,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aLTu_SUC,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aLEu_0,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0)))) ).

fof(aLTu_0,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),suc),s(num,N0)))))) ).

fof(aLEu_REFL,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N0)))) ).

fof(aLTu_REFL,axiom,
    ! [N0] : ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,N0)))) ).

fof(aLEu_ANTISYM,axiom,
    ! [M0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) )
    <=> s(num,M0) = s(num,N0) ) ).

fof(aLTu_ANTISYM,axiom,
    ! [M0,N0] :
      ~ ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0)))) ) ).

fof(aLETu_ANTISYM,axiom,
    ! [M0,N0] :
      ~ ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0)))) ) ).

fof(aLTEu_ANTISYM,axiom,
    ! [M0,N0] :
      ~ ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) ) ).

fof(aLEu_TRANS,axiom,
    ! [M0,N0,P0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,P0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,P0)))) ) ).

fof(aLTu_TRANS,axiom,
    ! [M0,N0,P0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,P0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,P0)))) ) ).

fof(aLETu_TRANS,axiom,
    ! [M0,N0,P0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,P0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,P0)))) ) ).

fof(aLTEu_TRANS,axiom,
    ! [M0,N0,P0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,P0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,P0)))) ) ).

fof(aLEu_CASES,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
      | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) ) ).

fof(aLTu_CASES,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
      | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0))))
      | s(num,M0) = s(num,N0) ) ).

fof(aLETu_CASES,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
      | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0)))) ) ).

fof(aLTEu_CASES,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
      | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) ) ).

fof(aLEu_LT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        | s(num,M0) = s(num,N0) ) ) ).

fof(aLTu_LE,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & s(num,M0) != s(num,N0) ) ) ).

fof(aNOTu_LE,axiom,
    ! [M0,N0] :
      ( ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
    <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0)))) ) ).

fof(aNOTu_LT,axiom,
    ! [M0,N0] :
      ( ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
    <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) ) ).

fof(aLTu_IMPu_LE,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) ) ).

fof(aEQu_IMPu_LE,axiom,
    ! [M0,N0] :
      ( s(num,M0) = s(num,N0)
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) ) ).

fof(aLTu_NZ,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))))
    <=> s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aLEu_1u_conjunct0,axiom,
    ! [N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0)))) ) ).

fof(aLEu_1u_conjunct1,axiom,
    ! [N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0)))) ) ).

fof(aLEu_1u_conjunct2,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))))
     => s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aLEu_1u_conjunct3,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0)))) ) ).

fof(aLEu_1u_conjunct4,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0)))) ) ).

fof(aLEu_1u_conjunct5,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,N0))))
     => s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aLEu_EXISTS,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
    <=> ? [D0] : s(num,N0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,D0))) ) ).

fof(aLTu_EXISTS,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
    <=> ? [D0] : s(num,N0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,D0))))) ) ).

fof(aLEu_ADD,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))) ).

fof(aSsrnato_lequ_addr,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,M0)))))) ).

fof(aLEu_ADDR,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))) ).

fof(aLTu_ADD,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) ).

fof(aLTu_ADDR,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,M0))) ).

fof(aLEu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,P0))) ).

fof(aLEu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aLTu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,P0))) ).

fof(aLTu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aLEu_ADD2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,P0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0)))))) ) ).

fof(aLETu_ADD2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,P0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0)))))) ) ).

fof(aLTEu_ADD2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,P0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0)))))) ) ).

fof(aLTu_ADD2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,P0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0)))))) ) ).

fof(aLTu_MULT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0)))) ) ) ).

fof(aLEu_MULT2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,P0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,Q0)))))) ) ).

fof(aLTu_LMULT,axiom,
    ! [M0,N0,P0] :
      ( ( s(num,M0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,P0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0)))))) ) ).

fof(aLEu_MULTu_LCANCEL,axiom,
    ! [M0,N0,P0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))))
    <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,P0)))) ) ) ).

fof(aLEu_MULTu_RCANCEL,axiom,
    ! [M0,N0,P0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        | s(num,P0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aLTu_MULTu_LCANCEL,axiom,
    ! [M0,N0,P0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))))
    <=> ( s(num,M0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,P0)))) ) ) ).

fof(aLTu_MULTu_RCANCEL,axiom,
    ! [M0,N0,P0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aLTu_MULT2,axiom,
    ! [M0,N0,P0,Q0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,P0))),s(num,Q0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,Q0)))))) ) ).

fof(aLEu_SQUAREu_REFL,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,N0)))))) ).

fof(aWLOGu_LE,axiom,
    ( ( ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,N0))),s(num,M0)))
      & ! [M0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,N0)))) ) )
   => ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,N0)))) ) ).

fof(aWLOGu_LT,axiom,
    ( ( ! [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,M0))))
      & ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,N0))),s(num,M0)))
      & ! [M0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,N0)))) ) )
   => ! [M0,Y] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,M0))),s(num,Y)))) ) ).

fof(anumu_WF,axiom,
    ! [P0] :
      ( ! [N0] :
          ( ! [M0] :
              ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
             => p(s(bool,i(s(fun(num,bool),P0),s(num,M0)))) )
         => p(s(bool,i(s(fun(num,bool),P0),s(num,N0)))) )
     => ! [N0] : p(s(bool,i(s(fun(num,bool),P0),s(num,N0)))) ) ).

fof(anumu_WOP,axiom,
    ! [P0] :
      ( ? [N0] : p(s(bool,i(s(fun(num,bool),P0),s(num,N0))))
    <=> ? [N0] :
          ( p(s(bool,i(s(fun(num,bool),P0),s(num,N0))))
          & ! [M0] :
              ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
             => ~ p(s(bool,i(s(fun(num,bool),P0),s(num,M0)))) ) ) ) ).

fof(anumu_MAX,axiom,
    ! [P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(num,bool),P0),s(num,X))))
        & ? [M0] :
          ! [X] :
            ( p(s(bool,i(s(fun(num,bool),P0),s(num,X))))
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,M0)))) ) )
    <=> ? [M0] :
          ( p(s(bool,i(s(fun(num,bool),P0),s(num,M0))))
          & ! [X] :
              ( p(s(bool,i(s(fun(num,bool),P0),s(num,X))))
             => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,M0)))) ) ) ) ).

fof(aEVENu_conjunct0,axiom,
    s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(bool,t) ).

fof(aEVENu_conjunct1,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),suc),s(num,N0))))))
    <=> ~ p(s(bool,i(s(fun(num,bool),even),s(num,N0)))) ) ).

fof(aODDu_conjunct0,axiom,
    s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(bool,f0) ).

fof(aODDu_conjunct1,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),suc),s(num,N0))))))
    <=> ~ p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) ) ).

fof(aNOTu_EVEN,axiom,
    ! [N0] :
      ( ~ p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
    <=> p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) ) ).

fof(aNOTu_ODD,axiom,
    ! [N0] :
      ( ~ p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
    <=> p(s(bool,i(s(fun(num,bool),even),s(num,N0)))) ) ).

fof(aEVENu_ORu_ODD,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
      | p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) ) ).

fof(aEVENu_ANDu_ODD,axiom,
    ! [N0] :
      ~ ( p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) ) ).

fof(aEVENu_ADD,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))
    <=> s(bool,i(s(fun(num,bool),even),s(num,M0))) = s(bool,i(s(fun(num,bool),even),s(num,N0))) ) ).

fof(aEVENu_MULT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),even),s(num,M0))))
        | p(s(bool,i(s(fun(num,bool),even),s(num,N0)))) ) ) ).

fof(aEVENu_EXP,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),even),s(num,M0))))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aODDu_ADD,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))
    <=> s(bool,i(s(fun(num,bool),odd),s(num,M0))) != s(bool,i(s(fun(num,bool),odd),s(num,N0))) ) ).

fof(aODDu_MULT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),odd),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) ) ) ).

fof(aODDu_EXP,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),odd),s(num,M0))))
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEVENu_DOUBLE,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0)))))) ).

fof(aODDu_DOUBLE,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0)))))))) ).

fof(aEVENu_EXISTSu_LEMMA,axiom,
    ! [N0] :
      ( ( p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
       => ? [M0] : s(num,N0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,M0))) )
      & ( ~ p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
       => ? [M0] : s(num,N0) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,M0))))) ) ) ).

fof(aEVENu_EXISTS,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
    <=> ? [M0] : s(num,N0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,M0))) ) ).

fof(aODDu_EXISTS,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
    <=> ? [M0] : s(num,N0) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,M0))))) ) ).

fof(aEVENu_ODDu_DECOMPOSITION,axiom,
    ! [N0] :
      ( ? [K0,M0] :
          ( p(s(bool,i(s(fun(num,bool),odd),s(num,M0))))
          & s(num,N0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,K0))))),s(num,M0))) )
    <=> s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aSUBu_conjunct0,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,M0) ).

fof(aSUBu_conjunct1,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))) ).

fof(aSUBu_0,axiom,
    ! [M0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,M0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
      & s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,M0) ) ).

fof(aSUBu_PRESUC,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))) ).

fof(aSUBu_SUC,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),suc),s(num,M0))))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))) ).

fof(aSUBu_REFL,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aADDu_SUB,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,N0))) = s(num,M0) ).

fof(aADDu_SUB2,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,M0))) = s(num,N0) ).

fof(aSUBu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
    <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) ) ).

fof(aADDu_SUBR2,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aADDu_SUBR,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aSUBu_ADD,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))),s(num,N0))) = s(num,M0) ) ).

fof(aSUBu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,P0))) ).

fof(aSUBu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))) ).

fof(aSsrnato_leqE,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
    <=> s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aLEFTu_SUBu_DISTRIB,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))) ).

fof(aRIGHTu_SUBu_DISTRIB,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))) ).

fof(aSUCu_SUB1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),suc),s(num,N0))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,N0) ).

fof(aEVENu_SUB,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        | s(bool,i(s(fun(num,bool),even),s(num,M0))) = s(bool,i(s(fun(num,bool),even),s(num,N0))) ) ) ).

fof(aODDu_SUB,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0))))
        & s(bool,i(s(fun(num,bool),odd),s(num,M0))) != s(bool,i(s(fun(num,bool),odd),s(num,N0))) ) ) ).

fof(aFACTu_conjunct0,axiom,
    s(num,i(s(fun(num,num),fact),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ).

fof(aFACTu_conjunct1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),fact),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),suc),s(num,N0))))),s(num,i(s(fun(num,num),fact),s(num,N0))))) ).

fof(aHypermapo_ZRu_LTu_1,axiom,
    p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))) ).

fof(aFACTu_LT,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),fact),s(num,N0)))))) ).

fof(aFACTu_LE,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))),s(num,i(s(fun(num,num),fact),s(num,N0)))))) ).

fof(aFACTu_NZ,axiom,
    ! [N0] : s(num,i(s(fun(num,num),fact),s(num,N0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aFACTu_MONO,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),fact),s(num,M0))))),s(num,i(s(fun(num,num),fact),s(num,N0)))))) ) ).

fof(aEXPu_LTu_0,axiom,
    ! [N0,X] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))))
    <=> ( s(num,X) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aLTu_EXP,axiom,
    ! [X,M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))))
    <=> ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,X))))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) )
        | ( s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
          & s(num,M0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
          & s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ) ).

fof(aLEu_EXP,axiom,
    ! [X,M0,N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> ( s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
          | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
             => s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
          & ? [VI_I_] :
              ( ( p(s(bool,VI_I_))
              <=> s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
              & s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))) = s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_I_))),s(bool,VI_))),s(bool,V))) ) ) ) ).

fof(aSsrnato_eqnu_leq,axiom,
    ! [M0,N0] :
      ( s(num,M0) = s(num,N0)
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) ) ) ).

fof(aEQu_EXP,axiom,
    ! [X,M0,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,M0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0)))
    <=> ? [V] :
          ( ( p(s(bool,V))
          <=> ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
          & ? [VI_] :
              ( ( p(s(bool,VI_))
              <=> s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
              & ? [VI_I_] :
                  ( ( p(s(bool,VI_I_))
                  <=> ( s(num,X) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))
                      | s(num,M0) = s(num,N0) ) )
                  & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ) ).

fof(aEXPu_MONOu_LEu_IMP,axiom,
    ! [X,Y,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,Y))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,Y))),s(num,N0)))))) ) ).

fof(aEXPu_MONOu_LTu_IMP,axiom,
    ! [X,Y,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,X))),s(num,Y))))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,Y))),s(num,N0)))))) ) ).

fof(aEXPu_MONOu_LE,axiom,
    ! [X,Y,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,Y))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,Y))))
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEXPu_MONOu_LT,axiom,
    ! [X,Y,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,Y))),s(num,N0))))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,X))),s(num,Y))))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aEXPu_MONOu_EQ,axiom,
    ! [X,Y,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,Y))),s(num,N0)))
    <=> ( s(num,X) = s(num,Y)
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aDIVMODu_EXIST,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ? [Q0,R0] :
          ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))))),s(num,R0)))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,N0)))) ) ) ).

fof(aDIVMODu_EXISTu_0,axiom,
    ! [M0,N0] :
    ? [Q0,R0,V] :
      ( ( p(s(bool,V))
      <=> ( s(num,Q0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
          & s(num,R0) = s(num,M0) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
          & ? [VI_I_] :
              ( ( p(s(bool,VI_I_))
              <=> ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))))),s(num,R0)))
                  & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,N0)))) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ).

fof(aDIVISIONu_0,axiom,
    ! [M0,N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
          & s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,M0) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
          & ? [VI_I_] :
              ( ( p(s(bool,VI_I_))
              <=> ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0)))))
                  & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,N0)))) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ).

fof(aDIVISION,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0)))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,N0)))) ) ) ).

fof(aDIVISIONu_SIMPu_conjunct0,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))) = s(num,M0) ) ).

fof(aDIVISIONu_SIMPu_conjunct1,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))) = s(num,M0) ) ).

fof(aDIVMODu_UNIQu_LEMMA,axiom,
    ! [M0,N0,Q1,R1,Q2,R2] :
      ( ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q1))),s(num,N0))))),s(num,R1)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R1))),s(num,N0))))
        & s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q2))),s(num,N0))))),s(num,R2)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R2))),s(num,N0)))) )
     => ( s(num,Q1) = s(num,Q2)
        & s(num,R1) = s(num,R2) ) ) ).

fof(aDIVMODu_UNIQ,axiom,
    ! [M0,N0,Q0,R0] :
      ( ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))))),s(num,R0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,N0)))) )
     => ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))) = s(num,Q0)
        & s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,R0) ) ) ).

fof(aMODu_UNIQ,axiom,
    ! [M0,N0,Q0,R0] :
      ( ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))))),s(num,R0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,N0)))) )
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,R0) ) ).

fof(aDIVu_UNIQ,axiom,
    ! [M0,N0,Q0,R0] :
      ( ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))))),s(num,R0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,N0)))) )
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))) = s(num,Q0) ) ).

fof(aMODu_MULT,axiom,
    ! [M0,N0] :
      ( s(num,M0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,M0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aDIVu_MULT,axiom,
    ! [M0,N0] :
      ( s(num,M0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,M0))) = s(num,N0) ) ).

fof(aMODu_LT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,M0) ) ).

fof(aMODu_EQ,axiom,
    ! [M0,N0,P0,Q0] :
      ( s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,P0)))))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,N0))),s(num,P0))) ) ).

fof(aDIVu_LE,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,M0)))) ) ).

fof(aDIVu_MULu_LE,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))))),s(num,M0)))) ).

fof(aMODu_0,axiom,
    ! [N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aDIVu_0,axiom,
    ! [N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aMODu_1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aDIVu_1,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(num,N0) ).

fof(aDIVu_LT,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aMODu_MOD,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) ) ).

fof(aMODu_MODu_REFL,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) ) ).

fof(aDIVu_MULT2,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,P0))) ) ).

fof(aMODu_MULT2,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,N0))),s(num,P0))))) ) ).

fof(aMODu_EXISTS,axiom,
    ! [M0,N0] :
      ( ? [Q0] : s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,Q0)))
    <=> ? [V] :
          ( ( p(s(bool,V))
          <=> s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
          & ? [VI_] :
              ( ( p(s(bool,VI_))
              <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
              & ? [VI_I_] :
                  ( ( p(s(bool,VI_I_))
                  <=> s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
                  & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ) ).

fof(aLEu_RDIVu_EQ,axiom,
    ! [A5,B0,N0] :
      ( s(num,A5) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,B0))),s(num,A5))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0))) ) ).

fof(aLEu_LDIVu_EQ,axiom,
    ! [A5,B0,N0] :
      ( s(num,A5) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,B0))),s(num,A5))))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ) ).

fof(aLEu_LDIV,axiom,
    ! [A5,B0,N0] :
      ( ( s(num,A5) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0)))))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,B0))),s(num,A5))))),s(num,N0)))) ) ).

fof(aDIVu_MONO,axiom,
    ! [M0,N0,P0] :
      ( ( s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,P0)))))) ) ).

fof(aDIVu_MONOu_LT,axiom,
    ! [M0,N0,P0] :
      ( ( s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))),s(num,N0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,P0)))))) ) ).

fof(aDIVu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
      <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) ) ) ).

fof(aMODu_EQu_0,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
      <=> ? [Q0] : s(num,M0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,N0))) ) ) ).

fof(aEVENu_MOD,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),even),s(num,N0))))
    <=> s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aODDu_MOD,axiom,
    ! [N0] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
    <=> s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ) ).

fof(aMODu_MULTu_RMOD,axiom,
    ! [M0,N0,P0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,P0))),s(num,N0))))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,N0))) ) ).

fof(aMODu_MULTu_LMOD,axiom,
    ! [M0,N0,P0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,P0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,N0))) ) ).

fof(aMODu_MULTu_MOD2,axiom,
    ! [M0,N0,P0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,P0))),s(num,N0))))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,N0))) ) ).

fof(aMODu_EXPu_MOD,axiom,
    ! [M0,N0,P0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,P0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,P0))))),s(num,N0))) ) ).

fof(aMODu_MULTu_ADD,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,P0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,P0))),s(num,N0))) ).

fof(aDIVu_MULTu_ADD,axiom,
    ! [A5,B0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,A5))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,B0))),s(num,N0))))) ) ).

fof(aMODu_ADDu_MOD,axiom,
    ! [A5,B0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,A5))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,B0))),s(num,N0))))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,A5))),s(num,B0))))),s(num,N0))) ) ).

fof(aDIVu_ADDu_MOD,axiom,
    ! [A5,B0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,A5))),s(num,B0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,A5))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,B0))),s(num,N0)))))
      <=> s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,A5))),s(num,B0))))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,A5))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,B0))),s(num,N0))))) ) ) ).

fof(aDIVu_REFL,axiom,
    ! [N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))) ) ).

fof(aMODu_LE,axiom,
    ! [M0,N0] :
      ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,N0))))),s(num,M0)))) ) ).

fof(aDIVu_MONO2,axiom,
    ! [M0,N0,P0] :
      ( ( s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,P0))),s(num,M0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,P0)))))) ) ).

fof(aDIVu_LEu_EXCLUSION,axiom,
    ! [A5,B0,C0,D0] :
      ( ( s(num,B0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,C0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,A5))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,D0)))))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,C0))),s(num,D0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,A5))),s(num,B0)))))) ) ).

fof(aDIVu_EQu_EXCLUSION,axiom,
    ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,b0))),s(num,c))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,a0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,d))))))
      & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,a0))),s(num,d))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,c))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,b0)))))) )
   => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,a0))),s(num,b0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,c))),s(num,d))) ) ).

fof(aMULTu_DIVu_LE,axiom,
    ! [M0,N0,P0] :
      ( s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,N0))),s(num,P0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,P0)))))) ) ).

fof(aDIVu_DIV,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))) ) ).

fof(aDIVu_MOD,axiom,
    ! [M0,N0,P0] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,M0))),s(num,N0))))),s(num,P0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))))),s(num,N0))) ) ).

fof(aMODu_MODu_EXPu_MIN,axiom,
    ! [X,P0,M0,N0] :
      ( s(num,P0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,P0))),s(num,M0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,P0))),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,P0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),min),s(num,M0))),s(num,N0))))))) ) ).

fof(aPREu_ELIMu_THM,axiom,
    ( p(s(bool,i(s(fun(num,bool),p0),s(num,i(s(fun(num,num),pre),s(num,n))))))
  <=> ! [M0] :
        ( ( s(num,n) = s(num,i(s(fun(num,num),suc),s(num,M0)))
          | ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,n) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
       => p(s(bool,i(s(fun(num,bool),p0),s(num,M0)))) ) ) ).

fof(aPREu_ELIMu_THMi_,axiom,
    ( p(s(bool,i(s(fun(num,bool),p0),s(num,i(s(fun(num,num),pre),s(num,n))))))
  <=> ? [M0] :
        ( ( s(num,n) = s(num,i(s(fun(num,num),suc),s(num,M0)))
          | ( s(num,M0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,n) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
        & p(s(bool,i(s(fun(num,bool),p0),s(num,M0)))) ) ) ).

fof(aSUBu_ELIMu_THM,axiom,
    ( p(s(bool,i(s(fun(num,bool),p0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,a0))),s(num,b0))))))
  <=> ! [D0] :
        ( ( s(num,a0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,b0))),s(num,D0)))
          | ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,a0))),s(num,b0))))
            & s(num,D0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
       => p(s(bool,i(s(fun(num,bool),p0),s(num,D0)))) ) ) ).

fof(aSUBu_ELIMu_THMi_,axiom,
    ( p(s(bool,i(s(fun(num,bool),p0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,a0))),s(num,b0))))))
  <=> ? [D0] :
        ( ( s(num,a0) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,b0))),s(num,D0)))
          | ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,a0))),s(num,b0))))
            & s(num,D0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) )
        & p(s(bool,i(s(fun(num,bool),p0),s(num,D0)))) ) ) ).

fof(aDIVMODu_ELIMu_THM,axiom,
    ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,m))),s(num,n))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,m))),s(num,n))))))
  <=> ! [Q0,R0] :
        ( ( ( s(num,n) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,Q0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,R0) = s(num,m) )
          | ( s(num,m) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,n))))),s(num,R0)))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,n)))) ) )
       => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,Q0))),s(num,R0)))) ) ) ).

fof(aDIVMODu_ELIMu_THMi_,axiom,
    ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,m))),s(num,n))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),mod),s(num,m))),s(num,n))))))
  <=> ? [Q0,R0] :
        ( ( ( s(num,n) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,Q0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
            & s(num,R0) = s(num,m) )
          | ( s(num,m) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,Q0))),s(num,n))))),s(num,R0)))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,R0))),s(num,n)))) ) )
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),p0),s(num,Q0))),s(num,R0)))) ) ) ).

fof(aminimal,axiom,
    ! [U_0] :
      ( ! [P0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),U_0),s(fun(num,bool),P0))),s(num,N0))))
        <=> ( p(s(bool,i(s(fun(num,bool),P0),s(num,N0))))
            & ! [M0] :
                ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
               => ~ p(s(bool,i(s(fun(num,bool),P0),s(num,M0)))) ) ) )
     => ! [P0] : s(num,i(s(fun(fun(num,bool),num),minimal),s(fun(num,bool),P0))) = s(num,i(s(fun(fun(num,bool),num),h_),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),U_0),s(fun(num,bool),P0))))) ) ).

fof(aMINIMAL,axiom,
    ! [P0] :
      ( ? [N0] : p(s(bool,i(s(fun(num,bool),P0),s(num,N0))))
    <=> ( p(s(bool,i(s(fun(num,bool),P0),s(num,i(s(fun(fun(num,bool),num),minimal),s(fun(num,bool),P0))))))
        & ! [M0] :
            ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,i(s(fun(fun(num,bool),num),minimal),s(fun(num,bool),P0))))))
           => ~ p(s(bool,i(s(fun(num,bool),P0),s(num,M0)))) ) ) ) ).

fof(aTRANSITIVEu_STEPWISEu_LTu_EQ,axiom,
    ! [R0] :
      ( ! [X,Y,Z0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Y))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,Y))),s(num,Z0)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Z0)))) )
     => ( ! [M0,N0] :
            ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,M0))),s(num,N0)))) )
      <=> ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,N0))),s(num,i(s(fun(num,num),suc),s(num,N0)))))) ) ) ).

fof(aTRANSITIVEu_STEPWISEu_LT,axiom,
    ! [R0] :
      ( ( ! [X,Y,Z0] :
            ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Y))))
              & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,Y))),s(num,Z0)))) )
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Z0)))) )
        & ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,N0))),s(num,i(s(fun(num,num),suc),s(num,N0)))))) )
     => ! [M0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,M0))),s(num,N0)))) ) ) ).

fof(aTRANSITIVEu_STEPWISEu_LEu_EQ,axiom,
    ! [R0] :
      ( ( ! [X] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,X))))
        & ! [X,Y,Z0] :
            ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Y))))
              & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,Y))),s(num,Z0)))) )
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Z0)))) ) )
     => ( ! [M0,N0] :
            ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,M0))),s(num,N0)))) )
      <=> ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,N0))),s(num,i(s(fun(num,num),suc),s(num,N0)))))) ) ) ).

fof(aTRANSITIVEu_STEPWISEu_LE,axiom,
    ! [R0] :
      ( ( ! [X] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,X))))
        & ! [X,Y,Z0] :
            ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Y))))
              & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,Y))),s(num,Z0)))) )
           => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,X))),s(num,Z0)))) )
        & ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,N0))),s(num,i(s(fun(num,num),suc),s(num,N0)))))) )
     => ! [M0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),R0),s(num,M0))),s(num,N0)))) ) ) ).

fof(aWF,axiom,
    ! [A,L_L_] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),L_L_))))
    <=> ! [P0] :
          ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
         => ? [X] :
              ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & ! [Y] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,Y))),s(A,X))))
                 => ~ p(s(bool,i(s(fun(A,bool),P0),s(A,Y)))) ) ) ) ) ).

fof(aWFu_EQ,axiom,
    ! [A] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
    <=> ! [P0] :
          ( ? [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
        <=> ? [X] :
              ( p(s(bool,i(s(fun(A,bool),P0),s(A,X))))
              & ! [Y] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Y))),s(A,X))))
                 => ~ p(s(bool,i(s(fun(A,bool),P0),s(A,Y)))) ) ) ) ) ).

fof(aWFu_IND,axiom,
    ! [A] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
    <=> ! [P0] :
          ( ! [X] :
              ( ! [Y] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Y))),s(A,X))))
                 => p(s(bool,i(s(fun(A,bool),P0),s(A,Y)))) )
             => p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) )
         => ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ) ).

fof(aWFu_DCHAIN,axiom,
    ! [A] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
    <=> ~ ? [S0] :
          ! [N0] : p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,i(s(fun(num,A),S0),s(num,i(s(fun(num,num),suc),s(num,N0))))))),s(A,i(s(fun(num,A),S0),s(num,N0)))))) ) ).

fof(aWFu_UREC,axiom,
    ! [A,B] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
     => ! [H0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G0),s(A,Z0))) )
             => s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G0))),s(A,X))) )
         => ! [F0,G0] :
              ( ( ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X)))
                & ! [X] : s(B,i(s(fun(A,B),G0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G0))),s(A,X))) )
             => s(fun(A,B),F0) = s(fun(A,B),G0) ) ) ) ).

fof(aWFu_URECu_WF,axiom,
    ! [A] :
      ( ! [H0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => s(bool,i(s(fun(A,bool),F0),s(A,Z0))) = s(bool,i(s(fun(A,bool),G0),s(A,Z0))) )
             => s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),H0),s(fun(A,bool),F0))),s(A,X))) = s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),H0),s(fun(A,bool),G0))),s(A,X))) )
         => ! [F0,G0] :
              ( ( ! [X] : s(bool,i(s(fun(A,bool),F0),s(A,X))) = s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),H0),s(fun(A,bool),F0))),s(A,X)))
                & ! [X] : s(bool,i(s(fun(A,bool),G0),s(A,X))) = s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),H0),s(fun(A,bool),G0))),s(A,X))) )
             => s(fun(A,bool),F0) = s(fun(A,bool),G0) ) )
     => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_)))) ) ).

fof(aWFu_RECu_INVARIANT,axiom,
    ! [B,A] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
     => ! [H0,S0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => ( s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G0),s(A,Z0)))
                    & p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),S0),s(A,Z0))),s(B,i(s(fun(A,B),F0),s(A,Z0)))))) ) )
             => ( s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G0))),s(A,X)))
                & p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),S0),s(A,X))),s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X)))))) ) )
         => ? [F0] :
            ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) ) ) ).

fof(aWFu_REC,axiom,
    ! [B,A] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
     => ! [H0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G0),s(A,Z0))) )
             => s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G0))),s(A,X))) )
         => ? [F0] :
            ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) ) ) ).

fof(aWFu_RECu_WF,axiom,
    ! [A] :
      ( ! [H0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => s(num,i(s(fun(A,num),F0),s(A,Z0))) = s(num,i(s(fun(A,num),G0),s(A,Z0))) )
             => s(num,i(s(fun(A,num),i(s(fun(fun(A,num),fun(A,num)),H0),s(fun(A,num),F0))),s(A,X))) = s(num,i(s(fun(A,num),i(s(fun(fun(A,num),fun(A,num)),H0),s(fun(A,num),G0))),s(A,X))) )
         => ? [F0] :
            ! [X] : s(num,i(s(fun(A,num),F0),s(A,X))) = s(num,i(s(fun(A,num),i(s(fun(fun(A,num),fun(A,num)),H0),s(fun(A,num),F0))),s(A,X))) )
     => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_)))) ) ).

fof(aWFu_EREC,axiom,
    ! [A,B] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
     => ! [H0] :
          ( ! [F0,G0,X] :
              ( ! [Z0] :
                  ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
                 => s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G0),s(A,Z0))) )
             => s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G0))),s(A,X))) )
         => ( ? [F0] :
              ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X)))
            & ! [F0,XI_] :
                ( ( ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X)))
                  & ! [X] : s(B,i(s(fun(A,B),XI_),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),XI_))),s(A,X))) )
               => s(fun(A,B),F0) = s(fun(A,B),XI_) ) ) ) ) ).

fof(aWFu_SUBSET,axiom,
    ! [A] :
      ( ( ! [X,Y] :
            ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,X))),s(A,Y))))
           => p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_l_),s(A,X))),s(A,Y)))) )
        & p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_l_)))) )
     => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_)))) ) ).

fof(aWFu_MEASUREu_GEN,axiom,
    ! [A,B,U_1] :
      ( ! [X,M0,XI_] : s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),i(s(fun(A,fun(fun(A,B),fun(A,bool))),U_1),s(A,X))),s(fun(A,B),M0))),s(A,XI_))) = s(bool,i(s(fun(B,bool),i(s(fun(B,fun(B,bool)),l_l_),s(B,i(s(fun(A,B),M0),s(A,X))))),s(B,i(s(fun(A,B),M0),s(A,XI_)))))
     => ! [U_0] :
          ( ! [M0,X] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,B),fun(A,fun(A,bool))),U_0),s(fun(A,B),M0))),s(A,X))) = s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),i(s(fun(A,fun(fun(A,B),fun(A,bool))),U_1),s(A,X))),s(fun(A,B),M0)))
         => ! [M0] :
              ( p(s(bool,i(s(fun(fun(B,fun(B,bool)),bool),wf),s(fun(B,fun(B,bool)),l_l_))))
             => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),i(s(fun(fun(A,B),fun(A,fun(A,bool))),U_0),s(fun(A,B),M0)))))) ) ) ) ).

fof(aWFu_LEXu_DEPENDENT,axiom,
    ! [A,B,U_1] :
      ( ! [R0,S0,R1,S1,F0] :
          ( p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(A,fun(B,fun(fun(prod(A,B),bool),bool))),i(s(fun(fun(A,fun(B,fun(B,bool))),fun(A,fun(B,fun(fun(prod(A,B),bool),bool)))),i(s(fun(fun(A,fun(A,bool)),fun(fun(A,fun(B,fun(B,bool))),fun(A,fun(B,fun(fun(prod(A,B),bool),bool))))),U_1),s(fun(A,fun(A,bool)),R0))),s(fun(A,fun(B,fun(B,bool))),S0))),s(A,R1))),s(B,S1))),s(fun(prod(A,B),bool),F0))))
        <=> ! [R2,S2] :
            ? [V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),R0),s(A,R1))),s(A,R2))))
                  | ( s(A,R1) = s(A,R2)
                    & p(s(bool,i(s(fun(B,bool),i(s(fun(B,fun(B,bool)),i(s(fun(A,fun(B,fun(B,bool))),S0),s(A,R1))),s(B,S1))),s(B,S2)))) ) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(A,B),bool),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,R2))),s(B,S2))))))),s(bool,V)))) ) )
     => ! [U_0] :
          ( ! [R0,S0,F0] :
              ( p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),i(s(fun(fun(A,fun(B,fun(B,bool))),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool)),i(s(fun(fun(A,fun(A,bool)),fun(fun(A,fun(B,fun(B,bool))),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool))),U_0),s(fun(A,fun(A,bool)),R0))),s(fun(A,fun(B,fun(B,bool))),S0))),s(fun(prod(A,B),fun(prod(A,B),bool)),F0))))
            <=> ! [R1,S1] : p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(fun(prod(A,B),bool),fun(fun(prod(A,B),bool),bool)),geq),s(fun(prod(A,B),bool),i(s(fun(prod(A,B),fun(prod(A,B),bool)),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,R1))),s(B,S1))))))),s(fun(prod(A,B),bool),i(s(fun(fun(fun(prod(A,B),bool),bool),fun(prod(A,B),bool)),gabs),s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(A,fun(B,fun(fun(prod(A,B),bool),bool))),i(s(fun(fun(A,fun(B,fun(B,bool))),fun(A,fun(B,fun(fun(prod(A,B),bool),bool)))),i(s(fun(fun(A,fun(A,bool)),fun(fun(A,fun(B,fun(B,bool))),fun(A,fun(B,fun(fun(prod(A,B),bool),bool))))),U_1),s(fun(A,fun(A,bool)),R0))),s(fun(A,fun(B,fun(B,bool))),S0))),s(A,R1))),s(B,S1)))))))) )
         => ! [R0,S0] :
              ( ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),R0))))
                & ! [A5] : p(s(bool,i(s(fun(fun(B,fun(B,bool)),bool),wf),s(fun(B,fun(B,bool)),i(s(fun(A,fun(B,fun(B,bool))),S0),s(A,A5)))))) )
             => p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),wf),s(fun(prod(A,B),fun(prod(A,B),bool)),i(s(fun(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),fun(prod(A,B),fun(prod(A,B),bool))),gabs),s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),i(s(fun(fun(A,fun(B,fun(B,bool))),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool)),i(s(fun(fun(A,fun(A,bool)),fun(fun(A,fun(B,fun(B,bool))),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool))),U_0),s(fun(A,fun(A,bool)),R0))),s(fun(A,fun(B,fun(B,bool))),S0)))))))) ) ) ) ).

fof(aWFu_LEX,axiom,
    ! [A,B,U_1] :
      ( ! [R0,R1,S0,S1,F0] :
          ( p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool))),i(s(fun(A,fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool)))),i(s(fun(fun(A,fun(A,bool)),fun(A,fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool))))),U_1),s(fun(A,fun(A,bool)),R0))),s(A,R1))),s(fun(B,fun(B,bool)),S0))),s(B,S1))),s(fun(prod(A,B),bool),F0))))
        <=> ! [R2,S2] :
            ? [V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),R0),s(A,R1))),s(A,R2))))
                  | ( s(A,R1) = s(A,R2)
                    & p(s(bool,i(s(fun(B,bool),i(s(fun(B,fun(B,bool)),S0),s(B,S1))),s(B,S2)))) ) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(A,B),bool),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,R2))),s(B,S2))))))),s(bool,V)))) ) )
     => ! [U_0] :
          ( ! [R0,S0,F0] :
              ( p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),i(s(fun(fun(B,fun(B,bool)),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool)),i(s(fun(fun(A,fun(A,bool)),fun(fun(B,fun(B,bool)),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool))),U_0),s(fun(A,fun(A,bool)),R0))),s(fun(B,fun(B,bool)),S0))),s(fun(prod(A,B),fun(prod(A,B),bool)),F0))))
            <=> ! [R1,S1] : p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(fun(prod(A,B),bool),fun(fun(prod(A,B),bool),bool)),geq),s(fun(prod(A,B),bool),i(s(fun(prod(A,B),fun(prod(A,B),bool)),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,R1))),s(B,S1))))))),s(fun(prod(A,B),bool),i(s(fun(fun(fun(prod(A,B),bool),bool),fun(prod(A,B),bool)),gabs),s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool))),i(s(fun(A,fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool)))),i(s(fun(fun(A,fun(A,bool)),fun(A,fun(fun(B,fun(B,bool)),fun(B,fun(fun(prod(A,B),bool),bool))))),U_1),s(fun(A,fun(A,bool)),R0))),s(A,R1))),s(fun(B,fun(B,bool)),S0))),s(B,S1)))))))) )
         => ! [R0,S0] :
              ( ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),R0))))
                & p(s(bool,i(s(fun(fun(B,fun(B,bool)),bool),wf),s(fun(B,fun(B,bool)),S0)))) )
             => p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),wf),s(fun(prod(A,B),fun(prod(A,B),bool)),i(s(fun(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),fun(prod(A,B),fun(prod(A,B),bool))),gabs),s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),i(s(fun(fun(B,fun(B,bool)),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool)),i(s(fun(fun(A,fun(A,bool)),fun(fun(B,fun(B,bool)),fun(fun(prod(A,B),fun(prod(A,B),bool)),bool))),U_0),s(fun(A,fun(A,bool)),R0))),s(fun(B,fun(B,bool)),S0)))))))) ) ) ) ).

fof(aWFu_POINTWISE,axiom,
    ! [A,B,U_1] :
      ( ! [X1,Y1,F0] :
          ( p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(A,fun(B,fun(fun(prod(A,B),bool),bool))),U_1),s(A,X1))),s(B,Y1))),s(fun(prod(A,B),bool),F0))))
        <=> ! [X2,Y2] :
            ? [V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,X1))),s(A,X2))))
                  & p(s(bool,i(s(fun(B,bool),i(s(fun(B,fun(B,bool)),l_l_l_),s(B,Y1))),s(B,Y2)))) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),geq),s(bool,i(s(fun(prod(A,B),bool),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X2))),s(B,Y2))))))),s(bool,V)))) ) )
     => ! [U_0] :
          ( ! [F0] :
              ( p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),U_0),s(fun(prod(A,B),fun(prod(A,B),bool)),F0))))
            <=> ! [X1,Y1] : p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),i(s(fun(fun(prod(A,B),bool),fun(fun(prod(A,B),bool),bool)),geq),s(fun(prod(A,B),bool),i(s(fun(prod(A,B),fun(prod(A,B),bool)),F0),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X1))),s(B,Y1))))))),s(fun(prod(A,B),bool),i(s(fun(fun(fun(prod(A,B),bool),bool),fun(prod(A,B),bool)),gabs),s(fun(fun(prod(A,B),bool),bool),i(s(fun(B,fun(fun(prod(A,B),bool),bool)),i(s(fun(A,fun(B,fun(fun(prod(A,B),bool),bool))),U_1),s(A,X1))),s(B,Y1)))))))) )
         => ( ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
              & p(s(bool,i(s(fun(fun(B,fun(B,bool)),bool),wf),s(fun(B,fun(B,bool)),l_l_l_)))) )
           => p(s(bool,i(s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),wf),s(fun(prod(A,B),fun(prod(A,B),bool)),i(s(fun(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),fun(prod(A,B),fun(prod(A,B),bool))),gabs),s(fun(fun(prod(A,B),fun(prod(A,B),bool)),bool),U_0)))))) ) ) ) ).

fof(aWFu_num,axiom,
    p(s(bool,i(s(fun(fun(num,fun(num,bool)),bool),wf),s(fun(num,fun(num,bool)),l_)))) ).

fof(aWFu_RECu_num,axiom,
    ! [A,H0] :
      ( ! [F0,G0,N0] :
          ( ! [M0] :
              ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
             => s(A,i(s(fun(num,A),F0),s(num,M0))) = s(A,i(s(fun(num,A),G0),s(num,M0))) )
         => s(A,i(s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),H0),s(fun(num,A),F0))),s(num,N0))) = s(A,i(s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),H0),s(fun(num,A),G0))),s(num,N0))) )
     => ? [F0] :
        ! [N0] : s(A,i(s(fun(num,A),F0),s(num,N0))) = s(A,i(s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),H0),s(fun(num,A),F0))),s(num,N0))) ) ).

fof(aMEASURE,axiom,
    ! [Q12515,M0,X,XI_] : s(bool,i(s(fun(Q12515,bool),i(s(fun(Q12515,fun(Q12515,bool)),i(s(fun(fun(Q12515,num),fun(Q12515,fun(Q12515,bool))),measure0),s(fun(Q12515,num),M0))),s(Q12515,X))),s(Q12515,XI_))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(Q12515,num),M0),s(Q12515,X))))),s(num,i(s(fun(Q12515,num),M0),s(Q12515,XI_))))) ).

fof(aWFu_MEASURE,axiom,
    ! [A,M0] : p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),i(s(fun(fun(A,num),fun(A,fun(A,bool))),measure0),s(fun(A,num),M0)))))) ).

fof(aMEASUREu_LE,axiom,
    ! [Q12545] :
      ( ! [Y] :
          ( p(s(bool,i(s(fun(Q12545,bool),i(s(fun(Q12545,fun(Q12545,bool)),i(s(fun(fun(Q12545,num),fun(Q12545,fun(Q12545,bool))),measure0),s(fun(Q12545,num),m))),s(Q12545,Y))),s(Q12545,a0))))
         => p(s(bool,i(s(fun(Q12545,bool),i(s(fun(Q12545,fun(Q12545,bool)),i(s(fun(fun(Q12545,num),fun(Q12545,fun(Q12545,bool))),measure0),s(fun(Q12545,num),m))),s(Q12545,Y))),s(Q12545,b0)))) )
    <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(Q12545,num),m),s(Q12545,a0))))),s(num,i(s(fun(Q12545,num),m),s(Q12545,b0)))))) ) ).

fof(aWFu_REFL,axiom,
    ! [A,X] :
      ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
     => ~ p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,X))),s(A,X)))) ) ).

fof(aWFu_FALSE,axiom,
    ! [A,U_1] :
      ( ! [Y] : s(bool,i(s(fun(A,bool),U_1),s(A,Y))) = s(bool,f0)
     => ! [U_0] :
          ( ! [X] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),U_0),s(A,X))) = s(fun(A,bool),U_1)
         => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),U_0)))) ) ) ).

fof(aWFu_RECu_TAIL,axiom,
    ! [B,A,P0,G0,H0] :
    ? [F0] :
    ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,i(s(fun(A,bool),P0),s(A,X))))),s(B,i(s(fun(A,B),F0),s(A,i(s(fun(A,A),G0),s(A,X))))))),s(B,i(s(fun(A,B),H0),s(A,X))))) ).

fof(aWFu_RECu_TAILu_GENERAL,axiom,
    ! [B,A,P0,G0,H0] :
      ( ( p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),l_l_))))
        & ! [F0,G1,X] :
            ( ! [Z0] :
                ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
               => s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G1),s(A,Z0))) )
           => ( s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),P0),s(fun(A,B),F0))),s(A,X))) = s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),P0),s(fun(A,B),G1))),s(A,X)))
              & s(A,i(s(fun(A,A),i(s(fun(fun(A,B),fun(A,A)),G0),s(fun(A,B),F0))),s(A,X))) = s(A,i(s(fun(A,A),i(s(fun(fun(A,B),fun(A,A)),G0),s(fun(A,B),G1))),s(A,X)))
              & s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G1))),s(A,X))) ) )
        & ! [F0,G1,X] :
            ( ! [Z0] :
                ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Z0))),s(A,X))))
               => s(B,i(s(fun(A,B),F0),s(A,Z0))) = s(B,i(s(fun(A,B),G1),s(A,Z0))) )
           => s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))) = s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),G1))),s(A,X))) )
        & ! [F0,X,Y] :
            ( ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),P0),s(fun(A,B),F0))),s(A,X))))
              & p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Y))),s(A,i(s(fun(A,A),i(s(fun(fun(A,B),fun(A,A)),G0),s(fun(A,B),F0))),s(A,X)))))) )
           => p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),l_l_),s(A,Y))),s(A,X)))) ) )
     => ? [F0] :
        ! [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),P0),s(fun(A,B),F0))),s(A,X))))),s(B,i(s(fun(A,B),F0),s(A,i(s(fun(A,A),i(s(fun(fun(A,B),fun(A,A)),G0),s(fun(A,B),F0))),s(A,X))))))),s(B,i(s(fun(A,B),i(s(fun(fun(A,B),fun(A,B)),H0),s(fun(A,B),F0))),s(A,X))))) ) ).

fof(aARITHu_ZEROu_conjunct0,axiom,
    s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aARITHu_ZEROu_conjunct1,axiom,
    s(num,i(s(fun(num,num),bit0),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_SUCu_conjunct0,axiom,
    ! [N0] : s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),suc),s(num,N0))))) ).

fof(aARITHu_SUCu_conjunct1,axiom,
    s(num,i(s(fun(num,num),suc),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,u_0))) ).

fof(aARITHu_SUCu_conjunct2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit1),s(num,N0))) ).

fof(aARITHu_SUCu_conjunct3,axiom,
    ! [N0] : s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),suc),s(num,N0))))) ).

fof(aARITHu_PREu_conjunct1,axiom,
    s(num,i(s(fun(num,num),pre),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_PREu_conjunct0,axiom,
    ! [N0] : s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),pre),s(num,N0))))) ).

fof(aARITHu_PREu_conjunct2,axiom,
    ! [N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(num,N0) = s(num,u_0) )
      & s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,V))),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,i(s(fun(num,num),pre),s(num,N0))))))) ) ).

fof(aARITHu_PREu_conjunct3,axiom,
    ! [N0] : s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,N0))) ).

fof(aARITHu_ADDu_conjunct0,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_ADDu_conjunct2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,N0))) ).

fof(aARITHu_ADDu_conjunct3,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit1),s(num,N0))) ).

fof(aARITHu_ADDu_conjunct4,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit0),s(num,N0))) ).

fof(aARITHu_ADDu_conjunct5,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,N0))) ).

fof(aARITHu_ADDu_conjunct6,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_ADDu_conjunct7,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit1),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_ADDu_conjunct8,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit1),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_ADDu_conjunct9,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))) ).

fof(aARITHu_MULTu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,u_0))),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_MULTu_conjunct0,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_MULTu_conjunct2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,u_0) ).

fof(aARITHu_MULTu_conjunct3,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,u_0) ).

fof(aARITHu_MULTu_conjunct4,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_MULTu_conjunct5,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_MULTu_conjunct6,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))) ).

fof(aARITHu_MULTu_conjunct7,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))))) ).

fof(aARITHu_MULTu_conjunct8,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))))) ).

fof(aARITHu_MULTu_conjunct9,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))))))) ).

fof(aARITHu_EXPu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,u_0))),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,u_0))) ).

fof(aARITHu_EXPu_conjunct9,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,N0))))))) ).

fof(aARITHu_EXPu_conjunct8,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,N0))))))) ).

fof(aARITHu_EXPu_conjunct7,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,u_0) ).

fof(aARITHu_EXPu_conjunct6,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,N0))))) ).

fof(aARITHu_EXPu_conjunct5,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,N0))))) ).

fof(aARITHu_EXPu_conjunct4,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,u_0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,u_0))),s(num,N0))))) ).

fof(aARITHu_EXPu_conjunct3,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,u_0))) ).

fof(aARITHu_EXPu_conjunct2,axiom,
    ! [M0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,u_0))) ).

fof(aARITHu_EXPu_conjunct0,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_EVENu_conjunct1,axiom,
    s(bool,i(s(fun(num,bool),even),s(num,u_0))) = s(bool,t) ).

fof(aARITHu_EVENu_conjunct0,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(bool,i(s(fun(num,bool),even),s(num,N0))) ).

fof(aARITHu_EVENu_conjunct2,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,t) ).

fof(aARITHu_EVENu_conjunct3,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),even),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,f0) ).

fof(aARITHu_ODDu_conjunct1,axiom,
    s(bool,i(s(fun(num,bool),odd),s(num,u_0))) = s(bool,f0) ).

fof(aARITHu_ODDu_conjunct0,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(bool,i(s(fun(num,bool),odd),s(num,N0))) ).

fof(aARITHu_ODDu_conjunct2,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,f0) ).

fof(aARITHu_ODDu_conjunct3,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),odd),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,t) ).

fof(aSsrnato_lequ_eqVlt,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
    <=> ( s(num,M0) = s(num,N0)
        | p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) ) ) ).

fof(aARITHu_LEu_conjunct1,axiom,
    s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,u_0))),s(num,u_0))) = s(bool,t) ).

fof(aARITHu_LEu_conjunct0,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LEu_conjunct2,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,u_0))) ).

fof(aARITHu_LEu_conjunct3,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0))) = s(bool,f0) ).

fof(aARITHu_LEu_conjunct4,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,t) ).

fof(aARITHu_LEu_conjunct5,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,t) ).

fof(aARITHu_LEu_conjunct6,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LEu_conjunct7,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LEu_conjunct8,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LEu_conjunct9,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct1,axiom,
    s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,u_0))),s(num,u_0))) = s(bool,f0) ).

fof(aARITHu_LTu_conjunct0,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct2,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(bool,f0) ).

fof(aARITHu_LTu_conjunct3,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0))) = s(bool,f0) ).

fof(aARITHu_LTu_conjunct4,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,u_0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct5,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,t) ).

fof(aARITHu_LTu_conjunct6,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct7,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct8,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_LTu_conjunct9,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aARITHu_GEu_conjunct0,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),numeral),s(num,N0))))),s(num,i(s(fun(num,num),numeral),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GEu_conjunct1,axiom,
    p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,u_0))),s(num,u_0)))) ).

fof(aARITHu_GEu_conjunct2,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,u_0))),s(num,N0))) ).

fof(aARITHu_GEu_conjunct3,axiom,
    ! [N0] : ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0)))))) ).

fof(aARITHu_GEu_conjunct4,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0)))) ).

fof(aARITHu_GEu_conjunct5,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0)))) ).

fof(aARITHu_GEu_conjunct6,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GEu_conjunct7,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GEu_conjunct8,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit1),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GEu_conjunct9,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,i(s(fun(num,num),bit1),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GTu_conjunct0,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),numeral),s(num,N0))))),s(num,i(s(fun(num,num),numeral),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GTu_conjunct1,axiom,
    ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,u_0))),s(num,u_0)))) ).

fof(aARITHu_GTu_conjunct2,axiom,
    ! [N0] : ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0)))))) ).

fof(aARITHu_GTu_conjunct3,axiom,
    ! [N0] : ~ p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0)))))) ).

fof(aARITHu_GTu_conjunct4,axiom,
    ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,u_0))) ).

fof(aARITHu_GTu_conjunct5,axiom,
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0)))) ).

fof(aARITHu_GTu_conjunct6,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GTu_conjunct7,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,i(s(fun(num,num),bit0),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GTu_conjunct8,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,i(s(fun(num,num),bit1),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_GTu_conjunct9,axiom,
    ! [M0,N0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,i(s(fun(num,num),bit1),s(num,M0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,N0))),s(num,M0))) ).

fof(aARITHu_EQu_conjunct0,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),numeral),s(num,M0))) = s(num,i(s(fun(num,num),numeral),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aARITHu_EQu_conjunct2,axiom,
    ! [N0] :
      ( s(num,i(s(fun(num,num),bit0),s(num,N0))) = s(num,u_0)
    <=> s(num,N0) = s(num,u_0) ) ).

fof(aARITHu_EQu_conjunct3,axiom,
    ! [N0] :
      ( s(num,i(s(fun(num,num),bit1),s(num,N0))) = s(num,u_0)
    <=> p(s(bool,f0)) ) ).

fof(aARITHu_EQu_conjunct4,axiom,
    ! [N0] :
      ( s(num,u_0) = s(num,i(s(fun(num,num),bit0),s(num,N0)))
    <=> s(num,u_0) = s(num,N0) ) ).

fof(aARITHu_EQu_conjunct5,axiom,
    ! [N0] :
      ( s(num,u_0) = s(num,i(s(fun(num,num),bit1),s(num,N0)))
    <=> p(s(bool,f0)) ) ).

fof(aARITHu_EQu_conjunct6,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),bit0),s(num,M0))) = s(num,i(s(fun(num,num),bit0),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aARITHu_EQu_conjunct7,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),bit0),s(num,M0))) = s(num,i(s(fun(num,num),bit1),s(num,N0)))
    <=> p(s(bool,f0)) ) ).

fof(aARITHu_EQu_conjunct8,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),bit1),s(num,M0))) = s(num,i(s(fun(num,num),bit0),s(num,N0)))
    <=> p(s(bool,f0)) ) ).

fof(aARITHu_EQu_conjunct9,axiom,
    ! [M0,N0] :
      ( s(num,i(s(fun(num,num),bit1),s(num,M0))) = s(num,i(s(fun(num,num),bit1),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aARITHu_SUBu_conjunct1,axiom,
    s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,u_0))),s(num,u_0))) = s(num,u_0) ).

fof(aARITHu_SUBu_conjunct0,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),numeral),s(num,M0))))),s(num,i(s(fun(num,num),numeral),s(num,N0))))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_SUBu_conjunct2,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,u_0))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,u_0) ).

fof(aARITHu_SUBu_conjunct3,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,u_0))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,u_0) ).

fof(aARITHu_SUBu_conjunct4,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit0),s(num,N0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit0),s(num,N0))) ).

fof(aARITHu_SUBu_conjunct5,axiom,
    ! [N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit1),s(num,N0))))),s(num,u_0))) = s(num,i(s(fun(num,num),bit1),s(num,N0))) ).

fof(aARITHu_SUBu_conjunct6,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))) ).

fof(aARITHu_SUBu_conjunct7,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit0),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),pre),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))) ).

fof(aARITHu_SUBu_conjunct8,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit0),s(num,N0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))),s(num,u_0))) ).

fof(aARITHu_SUBu_conjunct9,axiom,
    ! [M0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),bit1),s(num,M0))))),s(num,i(s(fun(num,num),bit1),s(num,N0))))) = s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))) ).

fof(aINJu_INVERSE2,axiom,
    ! [C,A,B,P0] :
      ( ! [X1,Y1,X2,Y2] :
          ( s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),P0),s(A,X1))),s(B,Y1))) = s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),P0),s(A,X2))),s(B,Y2)))
        <=> ( s(A,X1) = s(A,X2)
            & s(B,Y1) = s(B,Y2) ) )
     => ? [X,Y] :
        ! [X0,Y0] :
          ( s(A,i(s(fun(C,A),X),s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),P0),s(A,X0))),s(B,Y0))))) = s(A,X0)
          & s(B,i(s(fun(C,B),Y),s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),P0),s(A,X0))),s(B,Y0))))) = s(B,Y0) ) ) ).

fof(aNUMPAIR,axiom,
    ! [X,Y] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X))),s(num,Y))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,X))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,Y))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ).

fof(aNUMPAIRu_INJu_LEMMA,axiom,
    ! [X1,Y1,X2,Y2] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X1))),s(num,Y1))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X2))),s(num,Y2)))
     => s(num,X1) = s(num,X2) ) ).

fof(aNUMPAIRu_INJ,axiom,
    ! [X1,Y1,X2,Y2] :
      ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X1))),s(num,Y1))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X2))),s(num,Y2)))
    <=> ( s(num,X1) = s(num,X2)
        & s(num,Y1) = s(num,Y2) ) ) ).

fof(aNUMPAIRu_DEST,axiom,
    ! [X,Y] :
      ( s(num,i(s(fun(num,num),numfst),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X))),s(num,Y))))) = s(num,X)
      & s(num,i(s(fun(num,num),numsnd),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),numpair),s(num,X))),s(num,Y))))) = s(num,Y) ) ).

fof(aNUMSUM,axiom,
    ! [B0,X] : s(num,i(s(fun(num,num),i(s(fun(bool,fun(num,num)),numsum),s(bool,B0))),s(num,X))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,B0))),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,X))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,X))))) ).

fof(aNUMSUMu_INJ,axiom,
    ! [B1,X1,B2,X2] :
      ( s(num,i(s(fun(num,num),i(s(fun(bool,fun(num,num)),numsum),s(bool,B1))),s(num,X1))) = s(num,i(s(fun(num,num),i(s(fun(bool,fun(num,num)),numsum),s(bool,B2))),s(num,X2)))
    <=> ( s(bool,B1) = s(bool,B2)
        & s(num,X1) = s(num,X2) ) ) ).

fof(aNUMSUMu_DEST,axiom,
    ! [X,Y] :
      ( s(bool,i(s(fun(num,bool),numleft),s(num,i(s(fun(num,num),i(s(fun(bool,fun(num,num)),numsum),s(bool,X))),s(num,Y))))) = s(bool,X)
      & s(num,i(s(fun(num,num),numright),s(num,i(s(fun(num,num),i(s(fun(bool,fun(num,num)),numsum),s(bool,X))),s(num,Y))))) = s(num,Y) ) ).

fof(aINJN,axiom,
    ! [A,M0,X,X0] :
      ( p(s(bool,i(s(fun(A,bool),i(s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),injn),s(num,M0))),s(num,X))),s(A,X0))))
    <=> s(num,X) = s(num,M0) ) ).

fof(aINJNu_INJ,axiom,
    ! [A,N1,N2] :
      ( s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),injn),s(num,N1))) = s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),injn),s(num,N2)))
    <=> s(num,N1) = s(num,N2) ) ).

fof(aINJA,axiom,
    ! [A,A5,X,X0] :
      ( p(s(bool,i(s(fun(A,bool),i(s(fun(num,fun(A,bool)),i(s(fun(A,fun(num,fun(A,bool))),inja),s(A,A5))),s(num,X))),s(A,X0))))
    <=> s(A,X0) = s(A,A5) ) ).

fof(aINJAu_INJ,axiom,
    ! [A,A10,A20] :
      ( s(fun(num,fun(A,bool)),i(s(fun(A,fun(num,fun(A,bool))),inja),s(A,A10))) = s(fun(num,fun(A,bool)),i(s(fun(A,fun(num,fun(A,bool))),inja),s(A,A20)))
    <=> s(A,A10) = s(A,A20) ) ).

fof(aINJF,axiom,
    ! [A,F0,X] : s(fun(A,bool),i(s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),injf),s(fun(num,fun(num,fun(A,bool))),F0))),s(num,X))) = s(fun(A,bool),i(s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),F0),s(num,i(s(fun(num,num),numfst),s(num,X))))),s(num,i(s(fun(num,num),numsnd),s(num,X))))) ).

fof(aINJFu_INJ,axiom,
    ! [A,F1,F2] :
      ( s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),injf),s(fun(num,fun(num,fun(A,bool))),F1))) = s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),injf),s(fun(num,fun(num,fun(A,bool))),F2)))
    <=> s(fun(num,fun(num,fun(A,bool))),F1) = s(fun(num,fun(num,fun(A,bool))),F2) ) ).

fof(aINJP,axiom,
    ! [A,F1,F2,X,X0] : s(bool,i(s(fun(A,bool),i(s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),F1))),s(fun(num,fun(A,bool)),F2))),s(num,X))),s(A,X0))) = s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,i(s(fun(num,bool),numleft),s(num,X))))),s(bool,i(s(fun(A,bool),i(s(fun(num,fun(A,bool)),F1),s(num,i(s(fun(num,num),numright),s(num,X))))),s(A,X0))))),s(bool,i(s(fun(A,bool),i(s(fun(num,fun(A,bool)),F2),s(num,i(s(fun(num,num),numright),s(num,X))))),s(A,X0))))) ).

fof(aINJPu_INJ,axiom,
    ! [A,F1,F1I_,F2,F2I_] :
      ( s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),F1))),s(fun(num,fun(A,bool)),F2))) = s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),F1I_))),s(fun(num,fun(A,bool)),F2I_)))
    <=> ( s(fun(num,fun(A,bool)),F1) = s(fun(num,fun(A,bool)),F1I_)
        & s(fun(num,fun(A,bool)),F2) = s(fun(num,fun(A,bool)),F2I_) ) ) ).

fof(aZCONSTR,axiom,
    ! [A,C0,I0,R0] : s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),R0))) = s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),injn),s(num,i(s(fun(num,num),suc),s(num,C0))))))),s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),i(s(fun(A,fun(num,fun(A,bool))),inja),s(A,I0))))),s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),injf),s(fun(num,fun(num,fun(A,bool))),R0))))))) ).

fof(aZBOT,axiom,
    ! [A,U_0] :
      ( ! [Z0] : s(bool,i(s(fun(fun(num,fun(A,bool)),bool),U_0),s(fun(num,fun(A,bool)),Z0))) = s(bool,t)
     => s(fun(num,fun(A,bool)),zbot) = s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(A,bool)),fun(num,fun(A,bool))),i(s(fun(fun(num,fun(A,bool)),fun(fun(num,fun(A,bool)),fun(num,fun(A,bool)))),injp),s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),injn),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(fun(num,fun(A,bool)),i(s(fun(fun(fun(num,fun(A,bool)),bool),fun(num,fun(A,bool))),h_),s(fun(fun(num,fun(A,bool)),bool),U_0))))) ) ).

fof(aZCONSTRu_ZBOT,axiom,
    ! [A,C0,I0,R0] : s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),R0))) != s(fun(num,fun(A,bool)),zbot) ).

fof(aZRECSPACEu_RULESu_conjunct0,axiom,
    ! [A] : p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),zbot)))) ).

fof(aZRECSPACEu_RULESu_conjunct1,axiom,
    ! [A,C0,I0,R0] :
      ( ! [N0] : p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),R0),s(num,N0))))))
     => p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),R0)))))) ) ).

fof(aZRECSPACEu_CASES,axiom,
    ! [A,A5] :
      ( p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),A5))))
    <=> ( s(fun(num,fun(A,bool)),A5) = s(fun(num,fun(A,bool)),zbot)
        | ? [C0,I0,R0] :
            ( s(fun(num,fun(A,bool)),A5) = s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),R0)))
            & ! [N0] : p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),R0),s(num,N0)))))) ) ) ) ).

fof(aZRECSPACEu_INDUCT,axiom,
    ! [A,ZRECSPACEI_] :
      ( ( p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),ZRECSPACEI_),s(fun(num,fun(A,bool)),zbot))))
        & ! [C0,I0,R0] :
            ( ! [N0] : p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),ZRECSPACEI_),s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),R0),s(num,N0))))))
           => p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),ZRECSPACEI_),s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),R0)))))) ) )
     => ! [A5] :
          ( p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),A5))))
         => p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),ZRECSPACEI_),s(fun(num,fun(A,bool)),A5)))) ) ) ).

fof(aBOTTOM,axiom,
    ! [A] : s(recspace(A),bottom) = s(recspace(A),i(s(fun(fun(num,fun(A,bool)),recspace(A)),u_mku_rec),s(fun(num,fun(A,bool)),zbot))) ).

fof(aCONSTR,axiom,
    ! [A,U_0] :
      ( ! [R0,N0] : s(fun(num,fun(A,bool)),i(s(fun(num,fun(num,fun(A,bool))),i(s(fun(fun(num,recspace(A)),fun(num,fun(num,fun(A,bool)))),U_0),s(fun(num,recspace(A)),R0))),s(num,N0))) = s(fun(num,fun(A,bool)),i(s(fun(recspace(A),fun(num,fun(A,bool))),u_destu_rec),s(recspace(A),i(s(fun(num,recspace(A)),R0),s(num,N0)))))
     => ! [C0,I0,R0] : s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C0))),s(A,I0))),s(fun(num,recspace(A)),R0))) = s(recspace(A),i(s(fun(fun(num,fun(A,bool)),recspace(A)),u_mku_rec),s(fun(num,fun(A,bool)),i(s(fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))),i(s(fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool)))),i(s(fun(num,fun(A,fun(fun(num,fun(num,fun(A,bool))),fun(num,fun(A,bool))))),zconstr),s(num,C0))),s(A,I0))),s(fun(num,fun(num,fun(A,bool))),i(s(fun(fun(num,recspace(A)),fun(num,fun(num,fun(A,bool)))),U_0),s(fun(num,recspace(A)),R0))))))) ) ).

fof(aMKu_RECu_INJ,axiom,
    ! [A,X,Y] :
      ( s(recspace(A),i(s(fun(fun(num,fun(A,bool)),recspace(A)),u_mku_rec),s(fun(num,fun(A,bool)),X))) = s(recspace(A),i(s(fun(fun(num,fun(A,bool)),recspace(A)),u_mku_rec),s(fun(num,fun(A,bool)),Y)))
     => ( ( p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),X))))
          & p(s(bool,i(s(fun(fun(num,fun(A,bool)),bool),zrecspace),s(fun(num,fun(A,bool)),Y)))) )
       => s(fun(num,fun(A,bool)),X) = s(fun(num,fun(A,bool)),Y) ) ) ).

fof(aDESTu_RECu_INJ,axiom,
    ! [A,X,Y] :
      ( s(fun(num,fun(A,bool)),i(s(fun(recspace(A),fun(num,fun(A,bool))),u_destu_rec),s(recspace(A),X))) = s(fun(num,fun(A,bool)),i(s(fun(recspace(A),fun(num,fun(A,bool))),u_destu_rec),s(recspace(A),Y)))
    <=> s(recspace(A),X) = s(recspace(A),Y) ) ).

fof(aCONSTRu_BOT,axiom,
    ! [A,C0,I0,R0] : s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C0))),s(A,I0))),s(fun(num,recspace(A)),R0))) != s(recspace(A),bottom) ).

fof(aCONSTRu_INJ,axiom,
    ! [A,C1,I1,R1,C2,I2,R2] :
      ( s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C1))),s(A,I1))),s(fun(num,recspace(A)),R1))) = s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C2))),s(A,I2))),s(fun(num,recspace(A)),R2)))
    <=> ( s(num,C1) = s(num,C2)
        & s(A,I1) = s(A,I2)
        & s(fun(num,recspace(A)),R1) = s(fun(num,recspace(A)),R2) ) ) ).

fof(aCONSTRu_IND,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(recspace(A),bool),P0),s(recspace(A),bottom))))
        & ! [C0,I0,R0] :
            ( ! [N0] : p(s(bool,i(s(fun(recspace(A),bool),P0),s(recspace(A),i(s(fun(num,recspace(A)),R0),s(num,N0))))))
           => p(s(bool,i(s(fun(recspace(A),bool),P0),s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C0))),s(A,I0))),s(fun(num,recspace(A)),R0)))))) ) )
     => ! [X] : p(s(bool,i(s(fun(recspace(A),bool),P0),s(recspace(A),X)))) ) ).

fof(aCONSTRu_REC,axiom,
    ! [B,A,U_0] :
      ( ! [F0,R0,N0] : s(B,i(s(fun(num,B),i(s(fun(fun(num,recspace(A)),fun(num,B)),i(s(fun(fun(recspace(A),B),fun(fun(num,recspace(A)),fun(num,B))),U_0),s(fun(recspace(A),B),F0))),s(fun(num,recspace(A)),R0))),s(num,N0))) = s(B,i(s(fun(recspace(A),B),F0),s(recspace(A),i(s(fun(num,recspace(A)),R0),s(num,N0)))))
     => ! [FN] :
        ? [F0] :
        ! [C0,I0,R0] : s(B,i(s(fun(recspace(A),B),F0),s(recspace(A),i(s(fun(fun(num,recspace(A)),recspace(A)),i(s(fun(A,fun(fun(num,recspace(A)),recspace(A))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),recspace(A)))),constr),s(num,C0))),s(A,I0))),s(fun(num,recspace(A)),R0))))) = s(B,i(s(fun(fun(num,B),B),i(s(fun(fun(num,recspace(A)),fun(fun(num,B),B)),i(s(fun(A,fun(fun(num,recspace(A)),fun(fun(num,B),B))),i(s(fun(num,fun(A,fun(fun(num,recspace(A)),fun(fun(num,B),B)))),FN),s(num,C0))),s(A,I0))),s(fun(num,recspace(A)),R0))),s(fun(num,B),i(s(fun(fun(num,recspace(A)),fun(num,B)),i(s(fun(fun(recspace(A),B),fun(fun(num,recspace(A)),fun(num,B))),U_0),s(fun(recspace(A),B),F0))),s(fun(num,recspace(A)),R0))))) ) ).

fof(aFCONSu_conjunct0,axiom,
    ! [A,A5,F0] : s(A,i(s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),i(s(fun(A,fun(fun(num,A),fun(num,A))),fcons),s(A,A5))),s(fun(num,A),F0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(A,A5) ).

fof(aFCONSu_conjunct1,axiom,
    ! [A,A5,F0,N0] : s(A,i(s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),i(s(fun(A,fun(fun(num,A),fun(num,A))),fcons),s(A,A5))),s(fun(num,A),F0))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(A,i(s(fun(num,A),F0),s(num,N0))) ).

fof(aFCONSu_UNDO,axiom,
    ! [A,F0] : s(fun(num,A),F0) = s(fun(num,A),i(s(fun(fun(num,A),fun(num,A)),i(s(fun(A,fun(fun(num,A),fun(num,A))),fcons),s(A,i(s(fun(num,A),F0),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(fun(num,A),i(s(fun(fun(num,num),fun(num,A)),i(s(fun(fun(num,A),fun(fun(num,num),fun(num,A))),o),s(fun(num,A),F0))),s(fun(num,num),suc))))) ).

fof(aFNIL,axiom,
    ! [A,U_0] :
      ( ! [X] : s(bool,i(s(fun(A,bool),U_0),s(A,X))) = s(bool,t)
     => ! [N0] : s(A,i(s(fun(num,A),fnil),s(num,N0))) = s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),U_0))) ) ).

fof(asumu_INDUCT,axiom,
    ! [A,B,P0] :
      ( ( ! [A5] : p(s(bool,i(s(fun(sum0(A,B),bool),P0),s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,A5))))))
        & ! [A5] : p(s(bool,i(s(fun(sum0(A,B),bool),P0),s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,A5)))))) )
     => ! [X] : p(s(bool,i(s(fun(sum0(A,B),bool),P0),s(sum0(A,B),X)))) ) ).

fof(asumu_RECURSION,axiom,
    ! [A,Z,B,INLI_,INRI_] :
    ? [FN] :
      ( ! [A5] : s(Z,i(s(fun(sum0(A,B),Z),FN),s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,A5))))) = s(Z,i(s(fun(A,Z),INLI_),s(A,A5)))
      & ! [A5] : s(Z,i(s(fun(sum0(A,B),Z),FN),s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,A5))))) = s(Z,i(s(fun(B,Z),INRI_),s(B,A5))) ) ).

fof(aOUTL,axiom,
    ! [B,A] : s(A,i(s(fun(sum0(A,B),A),outl),s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,x))))) = s(A,x) ).

fof(aOUTR,axiom,
    ! [A,B] : s(B,i(s(fun(sum0(A,B),B),outr),s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,y))))) = s(B,y) ).

fof(aoptionu_elim,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(option(A),bool),P0),s(option(A),none))))
        & ! [A5] : p(s(bool,i(s(fun(option(A),bool),P0),s(option(A),i(s(fun(A,option(A)),some),s(A,A5)))))) )
     => ! [X] : p(s(bool,i(s(fun(option(A),bool),P0),s(option(A),X)))) ) ).

fof(aoptionu_RECURSION,axiom,
    ! [Z,A,NONEI_,SOMEI_] :
    ? [FN] :
      ( s(Z,i(s(fun(option(A),Z),FN),s(option(A),none))) = s(Z,NONEI_)
      & ! [A5] : s(Z,i(s(fun(option(A),Z),FN),s(option(A),i(s(fun(A,option(A)),some),s(A,A5))))) = s(Z,i(s(fun(A,Z),SOMEI_),s(A,A5))) ) ).

fof(alistu_INDUCT,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(list(A),bool),P0),s(list(A),nil))))
        & ! [A01,A10] :
            ( p(s(bool,i(s(fun(list(A),bool),P0),s(list(A),A10))))
           => p(s(bool,i(s(fun(list(A),bool),P0),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,A01))),s(list(A),A10)))))) ) )
     => ! [X] : p(s(bool,i(s(fun(list(A),bool),P0),s(list(A),X)))) ) ).

fof(alistu_RECURSION,axiom,
    ! [Z,A,NILI_,CONSI_] :
    ? [FN] :
      ( s(Z,i(s(fun(list(A),Z),FN),s(list(A),nil))) = s(Z,NILI_)
      & ! [A01,A10] : s(Z,i(s(fun(list(A),Z),FN),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,A01))),s(list(A),A10))))) = s(Z,i(s(fun(Z,Z),i(s(fun(list(A),fun(Z,Z)),i(s(fun(A,fun(list(A),fun(Z,Z))),CONSI_),s(A,A01))),s(list(A),A10))),s(Z,i(s(fun(list(A),Z),FN),s(list(A),A10))))) ) ).

fof(asumu_DISTINCT,axiom,
    ! [A,B,A5,AI_] : s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,A5))) != s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,AI_))) ).

fof(asumu_INJECTIVEu_conjunct1,axiom,
    ! [A,B,A5,AI_] :
      ( s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,A5))) = s(sum0(A,B),i(s(fun(B,sum0(A,B)),inr),s(B,AI_)))
    <=> s(B,A5) = s(B,AI_) ) ).

fof(asumu_INJECTIVEu_conjunct0,axiom,
    ! [B,A,A5,AI_] :
      ( s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,A5))) = s(sum0(A,B),i(s(fun(A,sum0(A,B)),inl),s(A,AI_)))
    <=> s(A,A5) = s(A,AI_) ) ).

fof(aISO,axiom,
    ! [B,A,G0,F0] :
      ( p(s(bool,i(s(fun(fun(B,A),bool),i(s(fun(fun(A,B),fun(fun(B,A),bool)),iso0),s(fun(A,B),F0))),s(fun(B,A),G0))))
    <=> ( ! [X] : s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,X))))) = s(B,X)
        & ! [Y] : s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,Y))))) = s(A,Y) ) ) ).

fof(aISOu_REFL,axiom,
    ! [A,U_0] :
      ( ! [X] : s(A,i(s(fun(A,A),U_0),s(A,X))) = s(A,X)
     => p(s(bool,i(s(fun(fun(A,A),bool),i(s(fun(fun(A,A),fun(fun(A,A),bool)),iso0),s(fun(A,A),U_0))),s(fun(A,A),U_0)))) ) ).

fof(aISOu_FUN,axiom,
    ! [AP,BP,A,B,U_3] :
      ( ! [H0,A5] : s(B,i(s(fun(A,B),i(s(fun(fun(AP,BP),fun(A,B)),U_3),s(fun(AP,BP),H0))),s(A,A5))) = s(B,i(s(fun(BP,B),gi_),s(BP,i(s(fun(AP,BP),H0),s(AP,i(s(fun(A,AP),f),s(A,A5)))))))
     => ! [U_2] :
          ( ! [H0] : s(fun(A,B),i(s(fun(fun(AP,BP),fun(A,B)),U_2),s(fun(AP,BP),H0))) = s(fun(A,B),i(s(fun(fun(AP,BP),fun(A,B)),U_3),s(fun(AP,BP),H0)))
         => ! [U_1] :
              ( ! [H0,AI_] : s(BP,i(s(fun(AP,BP),i(s(fun(fun(A,B),fun(AP,BP)),U_1),s(fun(A,B),H0))),s(AP,AI_))) = s(BP,i(s(fun(B,BP),g),s(B,i(s(fun(A,B),H0),s(A,i(s(fun(AP,A),fi_),s(AP,AI_)))))))
             => ! [U_0] :
                  ( ! [H0] : s(fun(AP,BP),i(s(fun(fun(A,B),fun(AP,BP)),U_0),s(fun(A,B),H0))) = s(fun(AP,BP),i(s(fun(fun(A,B),fun(AP,BP)),U_1),s(fun(A,B),H0)))
                 => ( ( p(s(bool,i(s(fun(fun(AP,A),bool),i(s(fun(fun(A,AP),fun(fun(AP,A),bool)),iso0),s(fun(A,AP),f))),s(fun(AP,A),fi_))))
                      & p(s(bool,i(s(fun(fun(BP,B),bool),i(s(fun(fun(B,BP),fun(fun(BP,B),bool)),iso0),s(fun(B,BP),g))),s(fun(BP,B),gi_)))) )
                   => p(s(bool,i(s(fun(fun(fun(AP,BP),fun(A,B)),bool),i(s(fun(fun(fun(A,B),fun(AP,BP)),fun(fun(fun(AP,BP),fun(A,B)),bool)),iso0),s(fun(fun(A,B),fun(AP,BP)),U_0))),s(fun(fun(AP,BP),fun(A,B)),U_2)))) ) ) ) ) ) ).

fof(aISOu_USAGE,axiom,
    ! [Q17931,Q17928] :
      ( p(s(bool,i(s(fun(fun(Q17928,Q17931),bool),i(s(fun(fun(Q17931,Q17928),fun(fun(Q17928,Q17931),bool)),iso0),s(fun(Q17931,Q17928),f))),s(fun(Q17928,Q17931),g))))
     => ( ! [P0] :
            ( ! [X] : p(s(bool,i(s(fun(Q17931,bool),P0),s(Q17931,X))))
          <=> ! [X] : p(s(bool,i(s(fun(Q17931,bool),P0),s(Q17931,i(s(fun(Q17928,Q17931),g),s(Q17928,X)))))) )
        & ! [P0] :
            ( ? [X] : p(s(bool,i(s(fun(Q17931,bool),P0),s(Q17931,X))))
          <=> ? [X] : p(s(bool,i(s(fun(Q17931,bool),P0),s(Q17931,i(s(fun(Q17928,Q17931),g),s(Q17928,X)))))) )
        & ! [A5,B0] :
            ( s(Q17931,A5) = s(Q17931,i(s(fun(Q17928,Q17931),g),s(Q17928,B0)))
          <=> s(Q17928,i(s(fun(Q17931,Q17928),f),s(Q17931,A5))) = s(Q17928,B0) ) ) ) ).

fof(aSeq2o_HD,axiom,
    ! [A,T0,H0] : s(A,i(s(fun(list(A),A),hd),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))))) = s(A,H0) ).

fof(aHD,axiom,
    ! [A] : s(A,i(s(fun(list(A),A),hd),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),t0))))) = s(A,h0) ).

fof(aSeq2o_TL,axiom,
    ! [A,H0,T0] : s(list(A),i(s(fun(list(A),list(A)),tl),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))))) = s(list(A),T0) ).

fof(aTL,axiom,
    ! [A] : s(list(A),i(s(fun(list(A),list(A)),tl),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),t0))))) = s(list(A),t0) ).

fof(aAPPENDu_conjunct0,axiom,
    ! [A,L] : s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),nil))),s(list(A),L))) = s(list(A),L) ).

fof(aAPPENDu_conjunct1,axiom,
    ! [A,H0,T0,L] : s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))))),s(list(A),L))) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),T0))),s(list(A),L))))) ).

fof(aREVERSEu_conjunct0,axiom,
    ! [A] : s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),nil))) = s(list(A),nil) ).

fof(aREVERSEu_conjunct1,axiom,
    ! [A] : s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,x))),s(list(A),l0))))) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),l0))))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,x))),s(list(A),nil))))) ).

fof(aLENGTHu_conjunct0,axiom,
    ! [A] : s(num,i(s(fun(list(A),num),length),s(list(A),nil))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aLENGTHu_conjunct1,axiom,
    ! [A,H0,T0] : s(num,i(s(fun(list(A),num),length),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))))) = s(num,i(s(fun(num,num),suc),s(num,i(s(fun(list(A),num),length),s(list(A),T0))))) ).

fof(aMAPu_conjunct0,axiom,
    ! [A,B,F0] : s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),nil))) = s(list(B),nil) ).

fof(aMAPu_conjunct1,axiom,
    ! [B,A,F0,H0,T0] : s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))))) = s(list(B),i(s(fun(list(B),list(B)),i(s(fun(B,fun(list(B),list(B))),cons),s(B,i(s(fun(A,B),F0),s(A,H0))))),s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),T0))))) ).

fof(aLAST,axiom,
    ! [A] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(list(A),t0) = s(list(A),nil) )
      & s(A,i(s(fun(list(A),A),last0),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),t0))))) = s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,V))),s(A,h0))),s(A,i(s(fun(list(A),A),last0),s(list(A),t0))))) ) ).

fof(aBUTLASTu_conjunct0,axiom,
    ! [Q18547] : s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),butlast),s(list(Q18547),nil))) = s(list(Q18547),nil) ).

fof(aBUTLASTu_conjunct1,axiom,
    ! [Q18547] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(list(Q18547),t0) = s(list(Q18547),nil) )
      & s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),butlast),s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),i(s(fun(Q18547,fun(list(Q18547),list(Q18547))),cons),s(Q18547,h0))),s(list(Q18547),t0))))) = s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),i(s(fun(list(Q18547),fun(list(Q18547),list(Q18547))),i(s(fun(bool,fun(list(Q18547),fun(list(Q18547),list(Q18547)))),cond),s(bool,V))),s(list(Q18547),nil))),s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),i(s(fun(Q18547,fun(list(Q18547),list(Q18547))),cons),s(Q18547,h0))),s(list(Q18547),i(s(fun(list(Q18547),list(Q18547)),butlast),s(list(Q18547),t0))))))) ) ).

fof(aREPLICATEu_conjunct0,axiom,
    ! [Q18568] : s(list(Q18568),i(s(fun(Q18568,list(Q18568)),i(s(fun(num,fun(Q18568,list(Q18568))),replicate),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(Q18568,x))) = s(list(Q18568),nil) ).

fof(aREPLICATEu_conjunct1,axiom,
    ! [Q18568] : s(list(Q18568),i(s(fun(Q18568,list(Q18568)),i(s(fun(num,fun(Q18568,list(Q18568))),replicate),s(num,i(s(fun(num,num),suc),s(num,n))))),s(Q18568,x))) = s(list(Q18568),i(s(fun(list(Q18568),list(Q18568)),i(s(fun(Q18568,fun(list(Q18568),list(Q18568))),cons),s(Q18568,x))),s(list(Q18568),i(s(fun(Q18568,list(Q18568)),i(s(fun(num,fun(Q18568,list(Q18568))),replicate),s(num,n))),s(Q18568,x))))) ).

fof(aNULLu_conjunct0,axiom,
    ! [Q18583] : s(bool,i(s(fun(list(Q18583),bool),null),s(list(Q18583),nil))) = s(bool,t) ).

fof(aNULLu_conjunct1,axiom,
    ! [Q18583] : s(bool,i(s(fun(list(Q18583),bool),null),s(list(Q18583),i(s(fun(list(Q18583),list(Q18583)),i(s(fun(Q18583,fun(list(Q18583),list(Q18583))),cons),s(Q18583,h0))),s(list(Q18583),t0))))) = s(bool,f0) ).

fof(aALLu_conjunct0,axiom,
    ! [Q18603] : s(bool,i(s(fun(list(Q18603),bool),i(s(fun(fun(Q18603,bool),fun(list(Q18603),bool)),all0),s(fun(Q18603,bool),p0))),s(list(Q18603),nil))) = s(bool,t) ).

fof(aALLu_conjunct1,axiom,
    ! [Q18603] :
      ( p(s(bool,i(s(fun(list(Q18603),bool),i(s(fun(fun(Q18603,bool),fun(list(Q18603),bool)),all0),s(fun(Q18603,bool),p0))),s(list(Q18603),i(s(fun(list(Q18603),list(Q18603)),i(s(fun(Q18603,fun(list(Q18603),list(Q18603))),cons),s(Q18603,h0))),s(list(Q18603),t0))))))
    <=> ( p(s(bool,i(s(fun(Q18603,bool),p0),s(Q18603,h0))))
        & p(s(bool,i(s(fun(list(Q18603),bool),i(s(fun(fun(Q18603,bool),fun(list(Q18603),bool)),all0),s(fun(Q18603,bool),p0))),s(list(Q18603),t0)))) ) ) ).

fof(aEXu_conjunct0,axiom,
    ! [Q18624] : s(bool,i(s(fun(list(Q18624),bool),i(s(fun(fun(Q18624,bool),fun(list(Q18624),bool)),ex0),s(fun(Q18624,bool),p0))),s(list(Q18624),nil))) = s(bool,f0) ).

fof(aEXu_conjunct1,axiom,
    ! [Q18624] :
      ( p(s(bool,i(s(fun(list(Q18624),bool),i(s(fun(fun(Q18624,bool),fun(list(Q18624),bool)),ex0),s(fun(Q18624,bool),p0))),s(list(Q18624),i(s(fun(list(Q18624),list(Q18624)),i(s(fun(Q18624,fun(list(Q18624),list(Q18624))),cons),s(Q18624,h0))),s(list(Q18624),t0))))))
    <=> ( p(s(bool,i(s(fun(Q18624,bool),p0),s(Q18624,h0))))
        | p(s(bool,i(s(fun(list(Q18624),bool),i(s(fun(fun(Q18624,bool),fun(list(Q18624),bool)),ex0),s(fun(Q18624,bool),p0))),s(list(Q18624),t0)))) ) ) ).

fof(aITLISTu_conjunct0,axiom,
    ! [Q18647,Q18646] : s(Q18646,i(s(fun(Q18646,Q18646),i(s(fun(list(Q18647),fun(Q18646,Q18646)),i(s(fun(fun(Q18647,fun(Q18646,Q18646)),fun(list(Q18647),fun(Q18646,Q18646))),itlist),s(fun(Q18647,fun(Q18646,Q18646)),f))),s(list(Q18647),nil))),s(Q18646,b0))) = s(Q18646,b0) ).

fof(aITLISTu_conjunct1,axiom,
    ! [Q18647,Q18646] : s(Q18646,i(s(fun(Q18646,Q18646),i(s(fun(list(Q18647),fun(Q18646,Q18646)),i(s(fun(fun(Q18647,fun(Q18646,Q18646)),fun(list(Q18647),fun(Q18646,Q18646))),itlist),s(fun(Q18647,fun(Q18646,Q18646)),f))),s(list(Q18647),i(s(fun(list(Q18647),list(Q18647)),i(s(fun(Q18647,fun(list(Q18647),list(Q18647))),cons),s(Q18647,h0))),s(list(Q18647),t0))))),s(Q18646,b0))) = s(Q18646,i(s(fun(Q18646,Q18646),i(s(fun(Q18647,fun(Q18646,Q18646)),f),s(Q18647,h0))),s(Q18646,i(s(fun(Q18646,Q18646),i(s(fun(list(Q18647),fun(Q18646,Q18646)),i(s(fun(fun(Q18647,fun(Q18646,Q18646)),fun(list(Q18647),fun(Q18646,Q18646))),itlist),s(fun(Q18647,fun(Q18646,Q18646)),f))),s(list(Q18647),t0))),s(Q18646,b0))))) ).

fof(aMEMu_conjunct0,axiom,
    ! [Q18672] : s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,x))),s(list(Q18672),nil))) = s(bool,f0) ).

fof(aMEMu_conjunct1,axiom,
    ! [Q18672] :
      ( p(s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,x))),s(list(Q18672),i(s(fun(list(Q18672),list(Q18672)),i(s(fun(Q18672,fun(list(Q18672),list(Q18672))),cons),s(Q18672,h0))),s(list(Q18672),t0))))))
    <=> ( s(Q18672,x) = s(Q18672,h0)
        | p(s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,x))),s(list(Q18672),t0)))) ) ) ).

fof(aALL2u_DEFu_conjunct0,axiom,
    ! [Q18705,Q18712] :
      ( p(s(bool,i(s(fun(list(Q18712),bool),i(s(fun(list(Q18705),fun(list(Q18712),bool)),i(s(fun(fun(Q18705,fun(Q18712,bool)),fun(list(Q18705),fun(list(Q18712),bool))),all2),s(fun(Q18705,fun(Q18712,bool)),p0))),s(list(Q18705),nil))),s(list(Q18712),l2))))
    <=> s(list(Q18712),l2) = s(list(Q18712),nil) ) ).

fof(aALL2u_DEFu_conjunct1,axiom,
    ! [Q18705,Q18712] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> ( p(s(bool,i(s(fun(Q18712,bool),i(s(fun(Q18705,fun(Q18712,bool)),p0),s(Q18705,h1))),s(Q18712,i(s(fun(list(Q18712),Q18712),hd),s(list(Q18712),l2))))))
          & p(s(bool,i(s(fun(list(Q18712),bool),i(s(fun(list(Q18705),fun(list(Q18712),bool)),i(s(fun(fun(Q18705,fun(Q18712,bool)),fun(list(Q18705),fun(list(Q18712),bool))),all2),s(fun(Q18705,fun(Q18712,bool)),p0))),s(list(Q18705),t1))),s(list(Q18712),i(s(fun(list(Q18712),list(Q18712)),tl),s(list(Q18712),l2)))))) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> s(list(Q18712),l2) = s(list(Q18712),nil) )
          & s(bool,i(s(fun(list(Q18712),bool),i(s(fun(list(Q18705),fun(list(Q18712),bool)),i(s(fun(fun(Q18705,fun(Q18712,bool)),fun(list(Q18705),fun(list(Q18712),bool))),all2),s(fun(Q18705,fun(Q18712,bool)),p0))),s(list(Q18705),i(s(fun(list(Q18705),list(Q18705)),i(s(fun(Q18705,fun(list(Q18705),list(Q18705))),cons),s(Q18705,h1))),s(list(Q18705),t1))))),s(list(Q18712),l2))) = s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,f0))),s(bool,V))) ) ) ).

fof(aALL2u_conjunct0,axiom,
    ! [Q18767,Q18766] : s(bool,i(s(fun(list(Q18766),bool),i(s(fun(list(Q18767),fun(list(Q18766),bool)),i(s(fun(fun(Q18767,fun(Q18766,bool)),fun(list(Q18767),fun(list(Q18766),bool))),all2),s(fun(Q18767,fun(Q18766,bool)),p0))),s(list(Q18767),nil))),s(list(Q18766),nil))) = s(bool,t) ).

fof(aALL2u_conjunct1,axiom,
    ! [Q18767,Q18766] : s(bool,i(s(fun(list(Q18766),bool),i(s(fun(list(Q18767),fun(list(Q18766),bool)),i(s(fun(fun(Q18767,fun(Q18766,bool)),fun(list(Q18767),fun(list(Q18766),bool))),all2),s(fun(Q18767,fun(Q18766,bool)),p0))),s(list(Q18767),i(s(fun(list(Q18767),list(Q18767)),i(s(fun(Q18767,fun(list(Q18767),list(Q18767))),cons),s(Q18767,h1))),s(list(Q18767),t1))))),s(list(Q18766),nil))) = s(bool,f0) ).

fof(aALL2u_conjunct2,axiom,
    ! [Q18767,Q18766] : s(bool,i(s(fun(list(Q18766),bool),i(s(fun(list(Q18767),fun(list(Q18766),bool)),i(s(fun(fun(Q18767,fun(Q18766,bool)),fun(list(Q18767),fun(list(Q18766),bool))),all2),s(fun(Q18767,fun(Q18766,bool)),p0))),s(list(Q18767),nil))),s(list(Q18766),i(s(fun(list(Q18766),list(Q18766)),i(s(fun(Q18766,fun(list(Q18766),list(Q18766))),cons),s(Q18766,h2))),s(list(Q18766),t2))))) = s(bool,f0) ).

fof(aALL2u_conjunct3,axiom,
    ! [Q18767,Q18766] :
      ( p(s(bool,i(s(fun(list(Q18766),bool),i(s(fun(list(Q18767),fun(list(Q18766),bool)),i(s(fun(fun(Q18767,fun(Q18766,bool)),fun(list(Q18767),fun(list(Q18766),bool))),all2),s(fun(Q18767,fun(Q18766,bool)),p0))),s(list(Q18767),i(s(fun(list(Q18767),list(Q18767)),i(s(fun(Q18767,fun(list(Q18767),list(Q18767))),cons),s(Q18767,h1))),s(list(Q18767),t1))))),s(list(Q18766),i(s(fun(list(Q18766),list(Q18766)),i(s(fun(Q18766,fun(list(Q18766),list(Q18766))),cons),s(Q18766,h2))),s(list(Q18766),t2))))))
    <=> ( p(s(bool,i(s(fun(Q18766,bool),i(s(fun(Q18767,fun(Q18766,bool)),p0),s(Q18767,h1))),s(Q18766,h2))))
        & p(s(bool,i(s(fun(list(Q18766),bool),i(s(fun(list(Q18767),fun(list(Q18766),bool)),i(s(fun(fun(Q18767,fun(Q18766,bool)),fun(list(Q18767),fun(list(Q18766),bool))),all2),s(fun(Q18767,fun(Q18766,bool)),p0))),s(list(Q18767),t1))),s(list(Q18766),t2)))) ) ) ).

fof(aMAP2u_DEFu_conjunct0,axiom,
    ! [Q18797,Q18804,Q18794] : s(list(Q18794),i(s(fun(list(Q18804),list(Q18794)),i(s(fun(list(Q18797),fun(list(Q18804),list(Q18794))),i(s(fun(fun(Q18797,fun(Q18804,Q18794)),fun(list(Q18797),fun(list(Q18804),list(Q18794)))),map2),s(fun(Q18797,fun(Q18804,Q18794)),f))),s(list(Q18797),nil))),s(list(Q18804),l0))) = s(list(Q18794),nil) ).

fof(aMAP2u_DEFu_conjunct1,axiom,
    ! [Q18794,Q18797,Q18804] : s(list(Q18794),i(s(fun(list(Q18804),list(Q18794)),i(s(fun(list(Q18797),fun(list(Q18804),list(Q18794))),i(s(fun(fun(Q18797,fun(Q18804,Q18794)),fun(list(Q18797),fun(list(Q18804),list(Q18794)))),map2),s(fun(Q18797,fun(Q18804,Q18794)),f))),s(list(Q18797),i(s(fun(list(Q18797),list(Q18797)),i(s(fun(Q18797,fun(list(Q18797),list(Q18797))),cons),s(Q18797,h1))),s(list(Q18797),t1))))),s(list(Q18804),l0))) = s(list(Q18794),i(s(fun(list(Q18794),list(Q18794)),i(s(fun(Q18794,fun(list(Q18794),list(Q18794))),cons),s(Q18794,i(s(fun(Q18804,Q18794),i(s(fun(Q18797,fun(Q18804,Q18794)),f),s(Q18797,h1))),s(Q18804,i(s(fun(list(Q18804),Q18804),hd),s(list(Q18804),l0))))))),s(list(Q18794),i(s(fun(list(Q18804),list(Q18794)),i(s(fun(list(Q18797),fun(list(Q18804),list(Q18794))),i(s(fun(fun(Q18797,fun(Q18804,Q18794)),fun(list(Q18797),fun(list(Q18804),list(Q18794)))),map2),s(fun(Q18797,fun(Q18804,Q18794)),f))),s(list(Q18797),t1))),s(list(Q18804),i(s(fun(list(Q18804),list(Q18804)),tl),s(list(Q18804),l0))))))) ).

fof(aMAP2u_conjunct0,axiom,
    ! [Q18839,Q18838,Q18845] : s(list(Q18845),i(s(fun(list(Q18838),list(Q18845)),i(s(fun(list(Q18839),fun(list(Q18838),list(Q18845))),i(s(fun(fun(Q18839,fun(Q18838,Q18845)),fun(list(Q18839),fun(list(Q18838),list(Q18845)))),map2),s(fun(Q18839,fun(Q18838,Q18845)),f))),s(list(Q18839),nil))),s(list(Q18838),nil))) = s(list(Q18845),nil) ).

fof(aMAP2u_conjunct1,axiom,
    ! [Q18845,Q18839,Q18838] : s(list(Q18845),i(s(fun(list(Q18838),list(Q18845)),i(s(fun(list(Q18839),fun(list(Q18838),list(Q18845))),i(s(fun(fun(Q18839,fun(Q18838,Q18845)),fun(list(Q18839),fun(list(Q18838),list(Q18845)))),map2),s(fun(Q18839,fun(Q18838,Q18845)),f))),s(list(Q18839),i(s(fun(list(Q18839),list(Q18839)),i(s(fun(Q18839,fun(list(Q18839),list(Q18839))),cons),s(Q18839,h1))),s(list(Q18839),t1))))),s(list(Q18838),i(s(fun(list(Q18838),list(Q18838)),i(s(fun(Q18838,fun(list(Q18838),list(Q18838))),cons),s(Q18838,h2))),s(list(Q18838),t2))))) = s(list(Q18845),i(s(fun(list(Q18845),list(Q18845)),i(s(fun(Q18845,fun(list(Q18845),list(Q18845))),cons),s(Q18845,i(s(fun(Q18838,Q18845),i(s(fun(Q18839,fun(Q18838,Q18845)),f),s(Q18839,h1))),s(Q18838,h2))))),s(list(Q18845),i(s(fun(list(Q18838),list(Q18845)),i(s(fun(list(Q18839),fun(list(Q18838),list(Q18845))),i(s(fun(fun(Q18839,fun(Q18838,Q18845)),fun(list(Q18839),fun(list(Q18838),list(Q18845)))),map2),s(fun(Q18839,fun(Q18838,Q18845)),f))),s(list(Q18839),t1))),s(list(Q18838),t2))))) ).

fof(aELu_conjunct0,axiom,
    ! [Q18865] : s(Q18865,i(s(fun(list(Q18865),Q18865),i(s(fun(num,fun(list(Q18865),Q18865)),el),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(list(Q18865),l0))) = s(Q18865,i(s(fun(list(Q18865),Q18865),hd),s(list(Q18865),l0))) ).

fof(aELu_conjunct1,axiom,
    ! [Q18865] : s(Q18865,i(s(fun(list(Q18865),Q18865),i(s(fun(num,fun(list(Q18865),Q18865)),el),s(num,i(s(fun(num,num),suc),s(num,n))))),s(list(Q18865),l0))) = s(Q18865,i(s(fun(list(Q18865),Q18865),i(s(fun(num,fun(list(Q18865),Q18865)),el),s(num,n))),s(list(Q18865),i(s(fun(list(Q18865),list(Q18865)),tl),s(list(Q18865),l0))))) ).

fof(aFILTERu_conjunct0,axiom,
    ! [Q18890] : s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(fun(Q18890,bool),fun(list(Q18890),list(Q18890))),filter0),s(fun(Q18890,bool),p0))),s(list(Q18890),nil))) = s(list(Q18890),nil) ).

fof(aFILTERu_conjunct1,axiom,
    ! [Q18890] : s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(fun(Q18890,bool),fun(list(Q18890),list(Q18890))),filter0),s(fun(Q18890,bool),p0))),s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(Q18890,fun(list(Q18890),list(Q18890))),cons),s(Q18890,h0))),s(list(Q18890),t0))))) = s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(list(Q18890),fun(list(Q18890),list(Q18890))),i(s(fun(bool,fun(list(Q18890),fun(list(Q18890),list(Q18890)))),cond),s(bool,i(s(fun(Q18890,bool),p0),s(Q18890,h0))))),s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(Q18890,fun(list(Q18890),list(Q18890))),cons),s(Q18890,h0))),s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(fun(Q18890,bool),fun(list(Q18890),list(Q18890))),filter0),s(fun(Q18890,bool),p0))),s(list(Q18890),t0))))))),s(list(Q18890),i(s(fun(list(Q18890),list(Q18890)),i(s(fun(fun(Q18890,bool),fun(list(Q18890),list(Q18890))),filter0),s(fun(Q18890,bool),p0))),s(list(Q18890),t0))))) ).

fof(aASSOC,axiom,
    ! [Q18919,Q18913] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(Q18919,i(s(fun(prod(Q18919,Q18913),Q18919),fst),s(prod(Q18919,Q18913),h0))) = s(Q18919,a0) )
      & s(Q18913,i(s(fun(list(prod(Q18919,Q18913)),Q18913),i(s(fun(Q18919,fun(list(prod(Q18919,Q18913)),Q18913)),assoc),s(Q18919,a0))),s(list(prod(Q18919,Q18913)),i(s(fun(list(prod(Q18919,Q18913)),list(prod(Q18919,Q18913))),i(s(fun(prod(Q18919,Q18913),fun(list(prod(Q18919,Q18913)),list(prod(Q18919,Q18913)))),cons),s(prod(Q18919,Q18913),h0))),s(list(prod(Q18919,Q18913)),t0))))) = s(Q18913,i(s(fun(Q18913,Q18913),i(s(fun(Q18913,fun(Q18913,Q18913)),i(s(fun(bool,fun(Q18913,fun(Q18913,Q18913))),cond),s(bool,V))),s(Q18913,i(s(fun(prod(Q18919,Q18913),Q18913),snd),s(prod(Q18919,Q18913),h0))))),s(Q18913,i(s(fun(list(prod(Q18919,Q18913)),Q18913),i(s(fun(Q18919,fun(list(prod(Q18919,Q18913)),Q18913)),assoc),s(Q18919,a0))),s(list(prod(Q18919,Q18913)),t0))))) ) ).

fof(aITLIST2u_DEFu_conjunct0,axiom,
    ! [Q18943,Q18951,Q18941] : s(Q18941,i(s(fun(Q18941,Q18941),i(s(fun(list(Q18951),fun(Q18941,Q18941)),i(s(fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941))),i(s(fun(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941)))),itlist2),s(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),f))),s(list(Q18943),nil))),s(list(Q18951),l2))),s(Q18941,b0))) = s(Q18941,b0) ).

fof(aITLIST2u_DEFu_conjunct1,axiom,
    ! [Q18943,Q18951,Q18941] : s(Q18941,i(s(fun(Q18941,Q18941),i(s(fun(list(Q18951),fun(Q18941,Q18941)),i(s(fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941))),i(s(fun(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941)))),itlist2),s(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),f))),s(list(Q18943),i(s(fun(list(Q18943),list(Q18943)),i(s(fun(Q18943,fun(list(Q18943),list(Q18943))),cons),s(Q18943,h1))),s(list(Q18943),t1))))),s(list(Q18951),l2))),s(Q18941,b0))) = s(Q18941,i(s(fun(Q18941,Q18941),i(s(fun(Q18951,fun(Q18941,Q18941)),i(s(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),f),s(Q18943,h1))),s(Q18951,i(s(fun(list(Q18951),Q18951),hd),s(list(Q18951),l2))))),s(Q18941,i(s(fun(Q18941,Q18941),i(s(fun(list(Q18951),fun(Q18941,Q18941)),i(s(fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941))),i(s(fun(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),fun(list(Q18943),fun(list(Q18951),fun(Q18941,Q18941)))),itlist2),s(fun(Q18943,fun(Q18951,fun(Q18941,Q18941))),f))),s(list(Q18943),t1))),s(list(Q18951),i(s(fun(list(Q18951),list(Q18951)),tl),s(list(Q18951),l2))))),s(Q18941,b0))))) ).

fof(aITLIST2u_conjunct0,axiom,
    ! [Q18985,Q18984,Q18983] : s(Q18983,i(s(fun(Q18983,Q18983),i(s(fun(list(Q18984),fun(Q18983,Q18983)),i(s(fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983))),i(s(fun(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983)))),itlist2),s(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),f))),s(list(Q18985),nil))),s(list(Q18984),nil))),s(Q18983,b0))) = s(Q18983,b0) ).

fof(aITLIST2u_conjunct1,axiom,
    ! [Q18985,Q18984,Q18983] : s(Q18983,i(s(fun(Q18983,Q18983),i(s(fun(list(Q18984),fun(Q18983,Q18983)),i(s(fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983))),i(s(fun(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983)))),itlist2),s(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),f))),s(list(Q18985),i(s(fun(list(Q18985),list(Q18985)),i(s(fun(Q18985,fun(list(Q18985),list(Q18985))),cons),s(Q18985,h1))),s(list(Q18985),t1))))),s(list(Q18984),i(s(fun(list(Q18984),list(Q18984)),i(s(fun(Q18984,fun(list(Q18984),list(Q18984))),cons),s(Q18984,h2))),s(list(Q18984),t2))))),s(Q18983,b0))) = s(Q18983,i(s(fun(Q18983,Q18983),i(s(fun(Q18984,fun(Q18983,Q18983)),i(s(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),f),s(Q18985,h1))),s(Q18984,h2))),s(Q18983,i(s(fun(Q18983,Q18983),i(s(fun(list(Q18984),fun(Q18983,Q18983)),i(s(fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983))),i(s(fun(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),fun(list(Q18985),fun(list(Q18984),fun(Q18983,Q18983)))),itlist2),s(fun(Q18985,fun(Q18984,fun(Q18983,Q18983))),f))),s(list(Q18985),t1))),s(list(Q18984),t2))),s(Q18983,b0))))) ).

fof(aZIPu_DEFu_conjunct0,axiom,
    ! [Q19015,Q19023] : s(list(prod(Q19015,Q19023)),i(s(fun(list(Q19023),list(prod(Q19015,Q19023))),i(s(fun(list(Q19015),fun(list(Q19023),list(prod(Q19015,Q19023)))),zip0),s(list(Q19015),nil))),s(list(Q19023),l2))) = s(list(prod(Q19015,Q19023)),nil) ).

fof(aZIPu_DEFu_conjunct1,axiom,
    ! [Q19015,Q19023] : s(list(prod(Q19015,Q19023)),i(s(fun(list(Q19023),list(prod(Q19015,Q19023))),i(s(fun(list(Q19015),fun(list(Q19023),list(prod(Q19015,Q19023)))),zip0),s(list(Q19015),i(s(fun(list(Q19015),list(Q19015)),i(s(fun(Q19015,fun(list(Q19015),list(Q19015))),cons),s(Q19015,h1))),s(list(Q19015),t1))))),s(list(Q19023),l2))) = s(list(prod(Q19015,Q19023)),i(s(fun(list(prod(Q19015,Q19023)),list(prod(Q19015,Q19023))),i(s(fun(prod(Q19015,Q19023),fun(list(prod(Q19015,Q19023)),list(prod(Q19015,Q19023)))),cons),s(prod(Q19015,Q19023),i(s(fun(Q19023,prod(Q19015,Q19023)),i(s(fun(Q19015,fun(Q19023,prod(Q19015,Q19023))),c_),s(Q19015,h1))),s(Q19023,i(s(fun(list(Q19023),Q19023),hd),s(list(Q19023),l2))))))),s(list(prod(Q19015,Q19023)),i(s(fun(list(Q19023),list(prod(Q19015,Q19023))),i(s(fun(list(Q19015),fun(list(Q19023),list(prod(Q19015,Q19023)))),zip0),s(list(Q19015),t1))),s(list(Q19023),i(s(fun(list(Q19023),list(Q19023)),tl),s(list(Q19023),l2))))))) ).

fof(aZIPu_conjunct0,axiom,
    ! [Q19034,Q19035] : s(list(prod(Q19034,Q19035)),i(s(fun(list(Q19035),list(prod(Q19034,Q19035))),i(s(fun(list(Q19034),fun(list(Q19035),list(prod(Q19034,Q19035)))),zip0),s(list(Q19034),nil))),s(list(Q19035),nil))) = s(list(prod(Q19034,Q19035)),nil) ).

fof(aZIPu_conjunct1,axiom,
    ! [Q19059,Q19060] : s(list(prod(Q19059,Q19060)),i(s(fun(list(Q19060),list(prod(Q19059,Q19060))),i(s(fun(list(Q19059),fun(list(Q19060),list(prod(Q19059,Q19060)))),zip0),s(list(Q19059),i(s(fun(list(Q19059),list(Q19059)),i(s(fun(Q19059,fun(list(Q19059),list(Q19059))),cons),s(Q19059,h1))),s(list(Q19059),t1))))),s(list(Q19060),i(s(fun(list(Q19060),list(Q19060)),i(s(fun(Q19060,fun(list(Q19060),list(Q19060))),cons),s(Q19060,h2))),s(list(Q19060),t2))))) = s(list(prod(Q19059,Q19060)),i(s(fun(list(prod(Q19059,Q19060)),list(prod(Q19059,Q19060))),i(s(fun(prod(Q19059,Q19060),fun(list(prod(Q19059,Q19060)),list(prod(Q19059,Q19060)))),cons),s(prod(Q19059,Q19060),i(s(fun(Q19060,prod(Q19059,Q19060)),i(s(fun(Q19059,fun(Q19060,prod(Q19059,Q19060))),c_),s(Q19059,h1))),s(Q19060,h2))))),s(list(prod(Q19059,Q19060)),i(s(fun(list(Q19060),list(prod(Q19059,Q19060))),i(s(fun(list(Q19059),fun(list(Q19060),list(prod(Q19059,Q19060)))),zip0),s(list(Q19059),t1))),s(list(Q19060),t2))))) ).

fof(aNOTu_CONSu_NIL,axiom,
    ! [A,H0,T0] : s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))) != s(list(A),nil) ).

fof(aLASTu_CLAUSESu_conjunct0,axiom,
    ! [A] : s(A,i(s(fun(list(A),A),last0),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),nil))))) = s(A,h0) ).

fof(aLASTu_CLAUSESu_conjunct1,axiom,
    ! [A] : s(A,i(s(fun(list(A),A),last0),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,k))),s(list(A),t0))))))) = s(A,i(s(fun(list(A),A),last0),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,k))),s(list(A),t0))))) ).

fof(aAPPENDu_NIL,axiom,
    ! [A,L] : s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),nil))) = s(list(A),L) ).

fof(aAPPENDu_ASSOC,axiom,
    ! [A,L,M0,N0] : s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),M0))),s(list(A),N0))))) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),M0))))),s(list(A),N0))) ).

fof(aREVERSEu_APPEND,axiom,
    ! [A,L,M0] : s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),M0))))) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),M0))))),s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),L))))) ).

fof(aREVERSEu_REVERSE,axiom,
    ! [A,L] : s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),i(s(fun(list(A),list(A)),reverse),s(list(A),L))))) = s(list(A),L) ).

fof(aCONSu_11,axiom,
    ! [A,H1,H2,T1,T2] :
      ( s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H1))),s(list(A),T1))) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H2))),s(list(A),T2)))
    <=> ( s(A,H1) = s(A,H2)
        & s(list(A),T1) = s(list(A),T2) ) ) ).

fof(alistu_CASES,axiom,
    ! [A,L] :
      ( s(list(A),L) = s(list(A),nil)
      | ? [H0,T0] : s(list(A),L) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,H0))),s(list(A),T0))) ) ).

fof(aLENGTHu_APPEND,axiom,
    ! [A,L,M0] : s(num,i(s(fun(list(A),num),length),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),M0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(list(A),num),length),s(list(A),L))))),s(num,i(s(fun(list(A),num),length),s(list(A),M0))))) ).

fof(aMAPu_APPEND,axiom,
    ! [B,A,F0,L1,L2] : s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L1))),s(list(A),L2))))) = s(list(B),i(s(fun(list(B),list(B)),i(s(fun(list(B),fun(list(B),list(B))),append),s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L1))))),s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L2))))) ).

fof(aLENGTHu_MAP,axiom,
    ! [B,A,L,F0] : s(num,i(s(fun(list(B),num),length),s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L))))) = s(num,i(s(fun(list(A),num),length),s(list(A),L))) ).

fof(aLENGTHu_EQu_NIL,axiom,
    ! [A,L] :
      ( s(num,i(s(fun(list(A),num),length),s(list(A),L))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
    <=> s(list(A),L) = s(list(A),nil) ) ).

fof(aLENGTHu_EQu_CONS,axiom,
    ! [Q19367,L,N0] :
      ( s(num,i(s(fun(list(Q19367),num),length),s(list(Q19367),L))) = s(num,i(s(fun(num,num),suc),s(num,N0)))
    <=> ? [H0,T0] :
          ( s(list(Q19367),L) = s(list(Q19367),i(s(fun(list(Q19367),list(Q19367)),i(s(fun(Q19367,fun(list(Q19367),list(Q19367))),cons),s(Q19367,H0))),s(list(Q19367),T0)))
          & s(num,i(s(fun(list(Q19367),num),length),s(list(Q19367),T0))) = s(num,N0) ) ) ).

fof(aMAPu_o,axiom,
    ! [C,B,A,F0,G0,L] : s(list(C),i(s(fun(list(A),list(C)),i(s(fun(fun(A,C),fun(list(A),list(C))),map0),s(fun(A,C),i(s(fun(fun(A,B),fun(A,C)),i(s(fun(fun(B,C),fun(fun(A,B),fun(A,C))),o),s(fun(B,C),G0))),s(fun(A,B),F0))))),s(list(A),L))) = s(list(C),i(s(fun(list(B),list(C)),i(s(fun(fun(B,C),fun(list(B),list(C))),map0),s(fun(B,C),G0))),s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L))))) ).

fof(aMAPu_EQ,axiom,
    ! [Q19442,Q19431,U_0] :
      ( ! [F0,G0,X] :
          ( p(s(bool,i(s(fun(Q19431,bool),i(s(fun(fun(Q19431,Q19442),fun(Q19431,bool)),i(s(fun(fun(Q19431,Q19442),fun(fun(Q19431,Q19442),fun(Q19431,bool))),U_0),s(fun(Q19431,Q19442),F0))),s(fun(Q19431,Q19442),G0))),s(Q19431,X))))
        <=> s(Q19442,i(s(fun(Q19431,Q19442),F0),s(Q19431,X))) = s(Q19442,i(s(fun(Q19431,Q19442),G0),s(Q19431,X))) )
     => ! [F0,G0,L] :
          ( p(s(bool,i(s(fun(list(Q19431),bool),i(s(fun(fun(Q19431,bool),fun(list(Q19431),bool)),all0),s(fun(Q19431,bool),i(s(fun(fun(Q19431,Q19442),fun(Q19431,bool)),i(s(fun(fun(Q19431,Q19442),fun(fun(Q19431,Q19442),fun(Q19431,bool))),U_0),s(fun(Q19431,Q19442),F0))),s(fun(Q19431,Q19442),G0))))),s(list(Q19431),L))))
         => s(list(Q19442),i(s(fun(list(Q19431),list(Q19442)),i(s(fun(fun(Q19431,Q19442),fun(list(Q19431),list(Q19442))),map0),s(fun(Q19431,Q19442),F0))),s(list(Q19431),L))) = s(list(Q19442),i(s(fun(list(Q19431),list(Q19442)),i(s(fun(fun(Q19431,Q19442),fun(list(Q19431),list(Q19442))),map0),s(fun(Q19431,Q19442),G0))),s(list(Q19431),L))) ) ) ).

fof(aALLu_IMP,axiom,
    ! [Q19472,P0,Q0,L] :
      ( ( ! [X] :
            ( ( p(s(bool,i(s(fun(list(Q19472),bool),i(s(fun(Q19472,fun(list(Q19472),bool)),mem),s(Q19472,X))),s(list(Q19472),L))))
              & p(s(bool,i(s(fun(Q19472,bool),P0),s(Q19472,X)))) )
           => p(s(bool,i(s(fun(Q19472,bool),Q0),s(Q19472,X)))) )
        & p(s(bool,i(s(fun(list(Q19472),bool),i(s(fun(fun(Q19472,bool),fun(list(Q19472),bool)),all0),s(fun(Q19472,bool),P0))),s(list(Q19472),L)))) )
     => p(s(bool,i(s(fun(list(Q19472),bool),i(s(fun(fun(Q19472,bool),fun(list(Q19472),bool)),all0),s(fun(Q19472,bool),Q0))),s(list(Q19472),L)))) ) ).

fof(aNOTu_EX,axiom,
    ! [Q19500,U_0] :
      ( ! [P0,X] :
          ( p(s(bool,i(s(fun(Q19500,bool),i(s(fun(fun(Q19500,bool),fun(Q19500,bool)),U_0),s(fun(Q19500,bool),P0))),s(Q19500,X))))
        <=> ~ p(s(bool,i(s(fun(Q19500,bool),P0),s(Q19500,X)))) )
     => ! [P0,L] :
          ( ~ p(s(bool,i(s(fun(list(Q19500),bool),i(s(fun(fun(Q19500,bool),fun(list(Q19500),bool)),ex0),s(fun(Q19500,bool),P0))),s(list(Q19500),L))))
        <=> p(s(bool,i(s(fun(list(Q19500),bool),i(s(fun(fun(Q19500,bool),fun(list(Q19500),bool)),all0),s(fun(Q19500,bool),i(s(fun(fun(Q19500,bool),fun(Q19500,bool)),U_0),s(fun(Q19500,bool),P0))))),s(list(Q19500),L)))) ) ) ).

fof(aNOTu_ALL,axiom,
    ! [Q19522,U_0] :
      ( ! [P0,X] :
          ( p(s(bool,i(s(fun(Q19522,bool),i(s(fun(fun(Q19522,bool),fun(Q19522,bool)),U_0),s(fun(Q19522,bool),P0))),s(Q19522,X))))
        <=> ~ p(s(bool,i(s(fun(Q19522,bool),P0),s(Q19522,X)))) )
     => ! [P0,L] :
          ( ~ p(s(bool,i(s(fun(list(Q19522),bool),i(s(fun(fun(Q19522,bool),fun(list(Q19522),bool)),all0),s(fun(Q19522,bool),P0))),s(list(Q19522),L))))
        <=> p(s(bool,i(s(fun(list(Q19522),bool),i(s(fun(fun(Q19522,bool),fun(list(Q19522),bool)),ex0),s(fun(Q19522,bool),i(s(fun(fun(Q19522,bool),fun(Q19522,bool)),U_0),s(fun(Q19522,bool),P0))))),s(list(Q19522),L)))) ) ) ).

fof(aALLu_MAP,axiom,
    ! [Q19544,Q19543,P0,F0,L] : s(bool,i(s(fun(list(Q19544),bool),i(s(fun(fun(Q19544,bool),fun(list(Q19544),bool)),all0),s(fun(Q19544,bool),P0))),s(list(Q19544),i(s(fun(list(Q19543),list(Q19544)),i(s(fun(fun(Q19543,Q19544),fun(list(Q19543),list(Q19544))),map0),s(fun(Q19543,Q19544),F0))),s(list(Q19543),L))))) = s(bool,i(s(fun(list(Q19543),bool),i(s(fun(fun(Q19543,bool),fun(list(Q19543),bool)),all0),s(fun(Q19543,bool),i(s(fun(fun(Q19543,Q19544),fun(Q19543,bool)),i(s(fun(fun(Q19544,bool),fun(fun(Q19543,Q19544),fun(Q19543,bool))),o),s(fun(Q19544,bool),P0))),s(fun(Q19543,Q19544),F0))))),s(list(Q19543),L))) ).

fof(aALLu_T,axiom,
    ! [Q19562,U_0] :
      ( ! [X] : s(bool,i(s(fun(Q19562,bool),U_0),s(Q19562,X))) = s(bool,t)
     => ! [L] : p(s(bool,i(s(fun(list(Q19562),bool),i(s(fun(fun(Q19562,bool),fun(list(Q19562),bool)),all0),s(fun(Q19562,bool),U_0))),s(list(Q19562),L)))) ) ).

fof(aMAPu_EQu_ALL2,axiom,
    ! [Q19598,Q19587,U_1] :
      ( ! [X,Y] :
          ( p(s(bool,i(s(fun(Q19587,bool),i(s(fun(Q19587,fun(Q19587,bool)),U_1),s(Q19587,X))),s(Q19587,Y))))
        <=> s(Q19598,i(s(fun(Q19587,Q19598),f),s(Q19587,X))) = s(Q19598,i(s(fun(Q19587,Q19598),f),s(Q19587,Y))) )
     => ! [U_0] :
          ( ! [X] : s(fun(Q19587,bool),i(s(fun(Q19587,fun(Q19587,bool)),U_0),s(Q19587,X))) = s(fun(Q19587,bool),i(s(fun(Q19587,fun(Q19587,bool)),U_1),s(Q19587,X)))
         => ! [L,M0] :
              ( p(s(bool,i(s(fun(list(Q19587),bool),i(s(fun(list(Q19587),fun(list(Q19587),bool)),i(s(fun(fun(Q19587,fun(Q19587,bool)),fun(list(Q19587),fun(list(Q19587),bool))),all2),s(fun(Q19587,fun(Q19587,bool)),U_0))),s(list(Q19587),L))),s(list(Q19587),M0))))
             => s(list(Q19598),i(s(fun(list(Q19587),list(Q19598)),i(s(fun(fun(Q19587,Q19598),fun(list(Q19587),list(Q19598))),map0),s(fun(Q19587,Q19598),f))),s(list(Q19587),L))) = s(list(Q19598),i(s(fun(list(Q19587),list(Q19598)),i(s(fun(fun(Q19587,Q19598),fun(list(Q19587),list(Q19598))),map0),s(fun(Q19587,Q19598),f))),s(list(Q19587),M0))) ) ) ) ).

fof(aALL2u_MAP,axiom,
    ! [Q19629,Q19630,U_0] :
      ( ! [P0,F0,A5] : s(bool,i(s(fun(Q19630,bool),i(s(fun(fun(Q19630,Q19629),fun(Q19630,bool)),i(s(fun(fun(Q19629,fun(Q19630,bool)),fun(fun(Q19630,Q19629),fun(Q19630,bool))),U_0),s(fun(Q19629,fun(Q19630,bool)),P0))),s(fun(Q19630,Q19629),F0))),s(Q19630,A5))) = s(bool,i(s(fun(Q19630,bool),i(s(fun(Q19629,fun(Q19630,bool)),P0),s(Q19629,i(s(fun(Q19630,Q19629),F0),s(Q19630,A5))))),s(Q19630,A5)))
     => ! [P0,F0,L] : s(bool,i(s(fun(list(Q19630),bool),i(s(fun(list(Q19629),fun(list(Q19630),bool)),i(s(fun(fun(Q19629,fun(Q19630,bool)),fun(list(Q19629),fun(list(Q19630),bool))),all2),s(fun(Q19629,fun(Q19630,bool)),P0))),s(list(Q19629),i(s(fun(list(Q19630),list(Q19629)),i(s(fun(fun(Q19630,Q19629),fun(list(Q19630),list(Q19629))),map0),s(fun(Q19630,Q19629),F0))),s(list(Q19630),L))))),s(list(Q19630),L))) = s(bool,i(s(fun(list(Q19630),bool),i(s(fun(fun(Q19630,bool),fun(list(Q19630),bool)),all0),s(fun(Q19630,bool),i(s(fun(fun(Q19630,Q19629),fun(Q19630,bool)),i(s(fun(fun(Q19629,fun(Q19630,bool)),fun(fun(Q19630,Q19629),fun(Q19630,bool))),U_0),s(fun(Q19629,fun(Q19630,bool)),P0))),s(fun(Q19630,Q19629),F0))))),s(list(Q19630),L))) ) ).

fof(aMAPu_EQu_DEGEN,axiom,
    ! [Q19647,U_0] :
      ( ! [F0,X] :
          ( p(s(bool,i(s(fun(Q19647,bool),i(s(fun(fun(Q19647,Q19647),fun(Q19647,bool)),U_0),s(fun(Q19647,Q19647),F0))),s(Q19647,X))))
        <=> s(Q19647,i(s(fun(Q19647,Q19647),F0),s(Q19647,X))) = s(Q19647,X) )
     => ! [L,F0] :
          ( p(s(bool,i(s(fun(list(Q19647),bool),i(s(fun(fun(Q19647,bool),fun(list(Q19647),bool)),all0),s(fun(Q19647,bool),i(s(fun(fun(Q19647,Q19647),fun(Q19647,bool)),U_0),s(fun(Q19647,Q19647),F0))))),s(list(Q19647),L))))
         => s(list(Q19647),i(s(fun(list(Q19647),list(Q19647)),i(s(fun(fun(Q19647,Q19647),fun(list(Q19647),list(Q19647))),map0),s(fun(Q19647,Q19647),F0))),s(list(Q19647),L))) = s(list(Q19647),L) ) ) ).

fof(aALL2u_ANDu_RIGHT,axiom,
    ! [Q19690,Q19689,U_1] :
      ( ! [P0,Q0,X,Y] :
          ( p(s(bool,i(s(fun(Q19689,bool),i(s(fun(Q19690,fun(Q19689,bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool))),i(s(fun(fun(Q19690,bool),fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool)))),U_1),s(fun(Q19690,bool),P0))),s(fun(Q19690,fun(Q19689,bool)),Q0))),s(Q19690,X))),s(Q19689,Y))))
        <=> ( p(s(bool,i(s(fun(Q19690,bool),P0),s(Q19690,X))))
            & p(s(bool,i(s(fun(Q19689,bool),i(s(fun(Q19690,fun(Q19689,bool)),Q0),s(Q19690,X))),s(Q19689,Y)))) ) )
     => ! [U_0] :
          ( ! [P0,Q0,X] : s(fun(Q19689,bool),i(s(fun(Q19690,fun(Q19689,bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool))),i(s(fun(fun(Q19690,bool),fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool)))),U_0),s(fun(Q19690,bool),P0))),s(fun(Q19690,fun(Q19689,bool)),Q0))),s(Q19690,X))) = s(fun(Q19689,bool),i(s(fun(Q19690,fun(Q19689,bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool))),i(s(fun(fun(Q19690,bool),fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool)))),U_1),s(fun(Q19690,bool),P0))),s(fun(Q19690,fun(Q19689,bool)),Q0))),s(Q19690,X)))
         => ! [L,M0,P0,Q0] :
              ( p(s(bool,i(s(fun(list(Q19689),bool),i(s(fun(list(Q19690),fun(list(Q19689),bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(list(Q19690),fun(list(Q19689),bool))),all2),s(fun(Q19690,fun(Q19689,bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool))),i(s(fun(fun(Q19690,bool),fun(fun(Q19690,fun(Q19689,bool)),fun(Q19690,fun(Q19689,bool)))),U_0),s(fun(Q19690,bool),P0))),s(fun(Q19690,fun(Q19689,bool)),Q0))))),s(list(Q19690),L))),s(list(Q19689),M0))))
            <=> ( p(s(bool,i(s(fun(list(Q19690),bool),i(s(fun(fun(Q19690,bool),fun(list(Q19690),bool)),all0),s(fun(Q19690,bool),P0))),s(list(Q19690),L))))
                & p(s(bool,i(s(fun(list(Q19689),bool),i(s(fun(list(Q19690),fun(list(Q19689),bool)),i(s(fun(fun(Q19690,fun(Q19689,bool)),fun(list(Q19690),fun(list(Q19689),bool))),all2),s(fun(Q19690,fun(Q19689,bool)),Q0))),s(list(Q19690),L))),s(list(Q19689),M0)))) ) ) ) ) ).

fof(aITLISTu_APPEND,axiom,
    ! [Q19728,Q19718,F0,A5,L1,L2] : s(Q19718,i(s(fun(Q19718,Q19718),i(s(fun(list(Q19728),fun(Q19718,Q19718)),i(s(fun(fun(Q19728,fun(Q19718,Q19718)),fun(list(Q19728),fun(Q19718,Q19718))),itlist),s(fun(Q19728,fun(Q19718,Q19718)),F0))),s(list(Q19728),i(s(fun(list(Q19728),list(Q19728)),i(s(fun(list(Q19728),fun(list(Q19728),list(Q19728))),append),s(list(Q19728),L1))),s(list(Q19728),L2))))),s(Q19718,A5))) = s(Q19718,i(s(fun(Q19718,Q19718),i(s(fun(list(Q19728),fun(Q19718,Q19718)),i(s(fun(fun(Q19728,fun(Q19718,Q19718)),fun(list(Q19728),fun(Q19718,Q19718))),itlist),s(fun(Q19728,fun(Q19718,Q19718)),F0))),s(list(Q19728),L1))),s(Q19718,i(s(fun(Q19718,Q19718),i(s(fun(list(Q19728),fun(Q19718,Q19718)),i(s(fun(fun(Q19728,fun(Q19718,Q19718)),fun(list(Q19728),fun(Q19718,Q19718))),itlist),s(fun(Q19728,fun(Q19718,Q19718)),F0))),s(list(Q19728),L2))),s(Q19718,A5))))) ).

fof(aITLISTu_EXTRA,axiom,
    ! [Q19765,Q19764,L] : s(Q19764,i(s(fun(Q19764,Q19764),i(s(fun(list(Q19765),fun(Q19764,Q19764)),i(s(fun(fun(Q19765,fun(Q19764,Q19764)),fun(list(Q19765),fun(Q19764,Q19764))),itlist),s(fun(Q19765,fun(Q19764,Q19764)),f))),s(list(Q19765),i(s(fun(list(Q19765),list(Q19765)),i(s(fun(list(Q19765),fun(list(Q19765),list(Q19765))),append),s(list(Q19765),L))),s(list(Q19765),i(s(fun(list(Q19765),list(Q19765)),i(s(fun(Q19765,fun(list(Q19765),list(Q19765))),cons),s(Q19765,a0))),s(list(Q19765),nil))))))),s(Q19764,b0))) = s(Q19764,i(s(fun(Q19764,Q19764),i(s(fun(list(Q19765),fun(Q19764,Q19764)),i(s(fun(fun(Q19765,fun(Q19764,Q19764)),fun(list(Q19765),fun(Q19764,Q19764))),itlist),s(fun(Q19765,fun(Q19764,Q19764)),f))),s(list(Q19765),L))),s(Q19764,i(s(fun(Q19764,Q19764),i(s(fun(Q19765,fun(Q19764,Q19764)),f),s(Q19765,a0))),s(Q19764,b0))))) ).

fof(aALLu_MP,axiom,
    ! [Q19791,U_0] :
      ( ! [P0,Q0,X] :
          ( p(s(bool,i(s(fun(Q19791,bool),i(s(fun(fun(Q19791,bool),fun(Q19791,bool)),i(s(fun(fun(Q19791,bool),fun(fun(Q19791,bool),fun(Q19791,bool))),U_0),s(fun(Q19791,bool),P0))),s(fun(Q19791,bool),Q0))),s(Q19791,X))))
        <=> ( p(s(bool,i(s(fun(Q19791,bool),P0),s(Q19791,X))))
           => p(s(bool,i(s(fun(Q19791,bool),Q0),s(Q19791,X)))) ) )
     => ! [P0,Q0,L] :
          ( ( p(s(bool,i(s(fun(list(Q19791),bool),i(s(fun(fun(Q19791,bool),fun(list(Q19791),bool)),all0),s(fun(Q19791,bool),i(s(fun(fun(Q19791,bool),fun(Q19791,bool)),i(s(fun(fun(Q19791,bool),fun(fun(Q19791,bool),fun(Q19791,bool))),U_0),s(fun(Q19791,bool),P0))),s(fun(Q19791,bool),Q0))))),s(list(Q19791),L))))
            & p(s(bool,i(s(fun(list(Q19791),bool),i(s(fun(fun(Q19791,bool),fun(list(Q19791),bool)),all0),s(fun(Q19791,bool),P0))),s(list(Q19791),L)))) )
         => p(s(bool,i(s(fun(list(Q19791),bool),i(s(fun(fun(Q19791,bool),fun(list(Q19791),bool)),all0),s(fun(Q19791,bool),Q0))),s(list(Q19791),L)))) ) ) ).

fof(aANDu_ALL,axiom,
    ! [Q19821,U_0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(Q19821,bool),U_0),s(Q19821,X))))
        <=> ( p(s(bool,i(s(fun(Q19821,bool),p0),s(Q19821,X))))
            & p(s(bool,i(s(fun(Q19821,bool),q0),s(Q19821,X)))) ) )
     => ! [L] :
          ( ( p(s(bool,i(s(fun(list(Q19821),bool),i(s(fun(fun(Q19821,bool),fun(list(Q19821),bool)),all0),s(fun(Q19821,bool),p0))),s(list(Q19821),L))))
            & p(s(bool,i(s(fun(list(Q19821),bool),i(s(fun(fun(Q19821,bool),fun(list(Q19821),bool)),all0),s(fun(Q19821,bool),q0))),s(list(Q19821),L)))) )
        <=> p(s(bool,i(s(fun(list(Q19821),bool),i(s(fun(fun(Q19821,bool),fun(list(Q19821),bool)),all0),s(fun(Q19821,bool),U_0))),s(list(Q19821),L)))) ) ) ).

fof(aEXu_IMP,axiom,
    ! [Q19851,P0,Q0,L] :
      ( ( ! [X] :
            ( ( p(s(bool,i(s(fun(list(Q19851),bool),i(s(fun(Q19851,fun(list(Q19851),bool)),mem),s(Q19851,X))),s(list(Q19851),L))))
              & p(s(bool,i(s(fun(Q19851,bool),P0),s(Q19851,X)))) )
           => p(s(bool,i(s(fun(Q19851,bool),Q0),s(Q19851,X)))) )
        & p(s(bool,i(s(fun(list(Q19851),bool),i(s(fun(fun(Q19851,bool),fun(list(Q19851),bool)),ex0),s(fun(Q19851,bool),P0))),s(list(Q19851),L)))) )
     => p(s(bool,i(s(fun(list(Q19851),bool),i(s(fun(fun(Q19851,bool),fun(list(Q19851),bool)),ex0),s(fun(Q19851,bool),Q0))),s(list(Q19851),L)))) ) ).

fof(aALLu_MEM,axiom,
    ! [Q19878,P0,L] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(list(Q19878),bool),i(s(fun(Q19878,fun(list(Q19878),bool)),mem),s(Q19878,X))),s(list(Q19878),L))))
         => p(s(bool,i(s(fun(Q19878,bool),P0),s(Q19878,X)))) )
    <=> p(s(bool,i(s(fun(list(Q19878),bool),i(s(fun(fun(Q19878,bool),fun(list(Q19878),bool)),all0),s(fun(Q19878,bool),P0))),s(list(Q19878),L)))) ) ).

fof(aLENGTHu_REPLICATE,axiom,
    ! [Q19896,N0,X] : s(num,i(s(fun(list(Q19896),num),length),s(list(Q19896),i(s(fun(Q19896,list(Q19896)),i(s(fun(num,fun(Q19896,list(Q19896))),replicate),s(num,N0))),s(Q19896,X))))) = s(num,N0) ).

fof(aEXu_MAP,axiom,
    ! [Q19920,Q19919,P0,F0,L] : s(bool,i(s(fun(list(Q19920),bool),i(s(fun(fun(Q19920,bool),fun(list(Q19920),bool)),ex0),s(fun(Q19920,bool),P0))),s(list(Q19920),i(s(fun(list(Q19919),list(Q19920)),i(s(fun(fun(Q19919,Q19920),fun(list(Q19919),list(Q19920))),map0),s(fun(Q19919,Q19920),F0))),s(list(Q19919),L))))) = s(bool,i(s(fun(list(Q19919),bool),i(s(fun(fun(Q19919,bool),fun(list(Q19919),bool)),ex0),s(fun(Q19919,bool),i(s(fun(fun(Q19919,Q19920),fun(Q19919,bool)),i(s(fun(fun(Q19920,bool),fun(fun(Q19919,Q19920),fun(Q19919,bool))),o),s(fun(Q19920,bool),P0))),s(fun(Q19919,Q19920),F0))))),s(list(Q19919),L))) ).

fof(aEXISTSu_EX,axiom,
    ! [Q19958,Q19957,U_0] :
      ( ! [P0,S0] :
          ( p(s(bool,i(s(fun(Q19957,bool),i(s(fun(fun(Q19958,fun(Q19957,bool)),fun(Q19957,bool)),U_0),s(fun(Q19958,fun(Q19957,bool)),P0))),s(Q19957,S0))))
        <=> ? [X] : p(s(bool,i(s(fun(Q19957,bool),i(s(fun(Q19958,fun(Q19957,bool)),P0),s(Q19958,X))),s(Q19957,S0)))) )
     => ! [P0,L] :
          ( ? [X] : p(s(bool,i(s(fun(list(Q19957),bool),i(s(fun(fun(Q19957,bool),fun(list(Q19957),bool)),ex0),s(fun(Q19957,bool),i(s(fun(Q19958,fun(Q19957,bool)),P0),s(Q19958,X))))),s(list(Q19957),L))))
        <=> p(s(bool,i(s(fun(list(Q19957),bool),i(s(fun(fun(Q19957,bool),fun(list(Q19957),bool)),ex0),s(fun(Q19957,bool),i(s(fun(fun(Q19958,fun(Q19957,bool)),fun(Q19957,bool)),U_0),s(fun(Q19958,fun(Q19957,bool)),P0))))),s(list(Q19957),L)))) ) ) ).

fof(aFORALLu_ALL,axiom,
    ! [Q19988,Q19987,U_0] :
      ( ! [P0,S0] :
          ( p(s(bool,i(s(fun(Q19987,bool),i(s(fun(fun(Q19988,fun(Q19987,bool)),fun(Q19987,bool)),U_0),s(fun(Q19988,fun(Q19987,bool)),P0))),s(Q19987,S0))))
        <=> ! [X] : p(s(bool,i(s(fun(Q19987,bool),i(s(fun(Q19988,fun(Q19987,bool)),P0),s(Q19988,X))),s(Q19987,S0)))) )
     => ! [P0,L] :
          ( ! [X] : p(s(bool,i(s(fun(list(Q19987),bool),i(s(fun(fun(Q19987,bool),fun(list(Q19987),bool)),all0),s(fun(Q19987,bool),i(s(fun(Q19988,fun(Q19987,bool)),P0),s(Q19988,X))))),s(list(Q19987),L))))
        <=> p(s(bool,i(s(fun(list(Q19987),bool),i(s(fun(fun(Q19987,bool),fun(list(Q19987),bool)),all0),s(fun(Q19987,bool),i(s(fun(fun(Q19988,fun(Q19987,bool)),fun(Q19987,bool)),U_0),s(fun(Q19988,fun(Q19987,bool)),P0))))),s(list(Q19987),L)))) ) ) ).

fof(aMEMu_APPEND,axiom,
    ! [Q20016,X,L1,L2] :
      ( p(s(bool,i(s(fun(list(Q20016),bool),i(s(fun(Q20016,fun(list(Q20016),bool)),mem),s(Q20016,X))),s(list(Q20016),i(s(fun(list(Q20016),list(Q20016)),i(s(fun(list(Q20016),fun(list(Q20016),list(Q20016))),append),s(list(Q20016),L1))),s(list(Q20016),L2))))))
    <=> ( p(s(bool,i(s(fun(list(Q20016),bool),i(s(fun(Q20016,fun(list(Q20016),bool)),mem),s(Q20016,X))),s(list(Q20016),L1))))
        | p(s(bool,i(s(fun(list(Q20016),bool),i(s(fun(Q20016,fun(list(Q20016),bool)),mem),s(Q20016,X))),s(list(Q20016),L2)))) ) ) ).

fof(aMEMu_MAP,axiom,
    ! [Q20049,Q20052,F0,Y,L] :
      ( p(s(bool,i(s(fun(list(Q20049),bool),i(s(fun(Q20049,fun(list(Q20049),bool)),mem),s(Q20049,Y))),s(list(Q20049),i(s(fun(list(Q20052),list(Q20049)),i(s(fun(fun(Q20052,Q20049),fun(list(Q20052),list(Q20049))),map0),s(fun(Q20052,Q20049),F0))),s(list(Q20052),L))))))
    <=> ? [X] :
          ( p(s(bool,i(s(fun(list(Q20052),bool),i(s(fun(Q20052,fun(list(Q20052),bool)),mem),s(Q20052,X))),s(list(Q20052),L))))
          & s(Q20049,Y) = s(Q20049,i(s(fun(Q20052,Q20049),F0),s(Q20052,X))) ) ) ).

fof(aFILTERu_APPEND,axiom,
    ! [Q20083,P0,L1,L2] : s(list(Q20083),i(s(fun(list(Q20083),list(Q20083)),i(s(fun(fun(Q20083,bool),fun(list(Q20083),list(Q20083))),filter0),s(fun(Q20083,bool),P0))),s(list(Q20083),i(s(fun(list(Q20083),list(Q20083)),i(s(fun(list(Q20083),fun(list(Q20083),list(Q20083))),append),s(list(Q20083),L1))),s(list(Q20083),L2))))) = s(list(Q20083),i(s(fun(list(Q20083),list(Q20083)),i(s(fun(list(Q20083),fun(list(Q20083),list(Q20083))),append),s(list(Q20083),i(s(fun(list(Q20083),list(Q20083)),i(s(fun(fun(Q20083,bool),fun(list(Q20083),list(Q20083))),filter0),s(fun(Q20083,bool),P0))),s(list(Q20083),L1))))),s(list(Q20083),i(s(fun(list(Q20083),list(Q20083)),i(s(fun(fun(Q20083,bool),fun(list(Q20083),list(Q20083))),filter0),s(fun(Q20083,bool),P0))),s(list(Q20083),L2))))) ).

fof(aFILTERu_MAP,axiom,
    ! [Q20110,Q20117,P0,F0,L] : s(list(Q20110),i(s(fun(list(Q20110),list(Q20110)),i(s(fun(fun(Q20110,bool),fun(list(Q20110),list(Q20110))),filter0),s(fun(Q20110,bool),P0))),s(list(Q20110),i(s(fun(list(Q20117),list(Q20110)),i(s(fun(fun(Q20117,Q20110),fun(list(Q20117),list(Q20110))),map0),s(fun(Q20117,Q20110),F0))),s(list(Q20117),L))))) = s(list(Q20110),i(s(fun(list(Q20117),list(Q20110)),i(s(fun(fun(Q20117,Q20110),fun(list(Q20117),list(Q20110))),map0),s(fun(Q20117,Q20110),F0))),s(list(Q20117),i(s(fun(list(Q20117),list(Q20117)),i(s(fun(fun(Q20117,bool),fun(list(Q20117),list(Q20117))),filter0),s(fun(Q20117,bool),i(s(fun(fun(Q20117,Q20110),fun(Q20117,bool)),i(s(fun(fun(Q20110,bool),fun(fun(Q20117,Q20110),fun(Q20117,bool))),o),s(fun(Q20110,bool),P0))),s(fun(Q20117,Q20110),F0))))),s(list(Q20117),L))))) ).

fof(aMEMu_FILTER,axiom,
    ! [Q20144,P0,L,X] :
      ( p(s(bool,i(s(fun(list(Q20144),bool),i(s(fun(Q20144,fun(list(Q20144),bool)),mem),s(Q20144,X))),s(list(Q20144),i(s(fun(list(Q20144),list(Q20144)),i(s(fun(fun(Q20144,bool),fun(list(Q20144),list(Q20144))),filter0),s(fun(Q20144,bool),P0))),s(list(Q20144),L))))))
    <=> ( p(s(bool,i(s(fun(Q20144,bool),P0),s(Q20144,X))))
        & p(s(bool,i(s(fun(list(Q20144),bool),i(s(fun(Q20144,fun(list(Q20144),bool)),mem),s(Q20144,X))),s(list(Q20144),L)))) ) ) ).

fof(aEXu_MEM,axiom,
    ! [Q20165,P0,L] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(Q20165,bool),P0),s(Q20165,X))))
          & p(s(bool,i(s(fun(list(Q20165),bool),i(s(fun(Q20165,fun(list(Q20165),bool)),mem),s(Q20165,X))),s(list(Q20165),L)))) )
    <=> p(s(bool,i(s(fun(list(Q20165),bool),i(s(fun(fun(Q20165,bool),fun(list(Q20165),bool)),ex0),s(fun(Q20165,bool),P0))),s(list(Q20165),L)))) ) ).

fof(aMAPu_FSTu_ZIP,axiom,
    ! [Q20187,Q20185,L1,L2] :
      ( s(num,i(s(fun(list(Q20185),num),length),s(list(Q20185),L1))) = s(num,i(s(fun(list(Q20187),num),length),s(list(Q20187),L2)))
     => s(list(Q20185),i(s(fun(list(prod(Q20185,Q20187)),list(Q20185)),i(s(fun(fun(prod(Q20185,Q20187),Q20185),fun(list(prod(Q20185,Q20187)),list(Q20185))),map0),s(fun(prod(Q20185,Q20187),Q20185),fst))),s(list(prod(Q20185,Q20187)),i(s(fun(list(Q20187),list(prod(Q20185,Q20187))),i(s(fun(list(Q20185),fun(list(Q20187),list(prod(Q20185,Q20187)))),zip0),s(list(Q20185),L1))),s(list(Q20187),L2))))) = s(list(Q20185),L1) ) ).

fof(aMAPu_SNDu_ZIP,axiom,
    ! [Q20216,Q20218,L1,L2] :
      ( s(num,i(s(fun(list(Q20216),num),length),s(list(Q20216),L1))) = s(num,i(s(fun(list(Q20218),num),length),s(list(Q20218),L2)))
     => s(list(Q20218),i(s(fun(list(prod(Q20216,Q20218)),list(Q20218)),i(s(fun(fun(prod(Q20216,Q20218),Q20218),fun(list(prod(Q20216,Q20218)),list(Q20218))),map0),s(fun(prod(Q20216,Q20218),Q20218),snd))),s(list(prod(Q20216,Q20218)),i(s(fun(list(Q20218),list(prod(Q20216,Q20218))),i(s(fun(list(Q20216),fun(list(Q20218),list(prod(Q20216,Q20218)))),zip0),s(list(Q20216),L1))),s(list(Q20218),L2))))) = s(list(Q20218),L2) ) ).

fof(aMEMu_ASSOC,axiom,
    ! [Q20262,Q20246,L,X] : s(bool,i(s(fun(list(prod(Q20262,Q20246)),bool),i(s(fun(prod(Q20262,Q20246),fun(list(prod(Q20262,Q20246)),bool)),mem),s(prod(Q20262,Q20246),i(s(fun(Q20246,prod(Q20262,Q20246)),i(s(fun(Q20262,fun(Q20246,prod(Q20262,Q20246))),c_),s(Q20262,X))),s(Q20246,i(s(fun(list(prod(Q20262,Q20246)),Q20246),i(s(fun(Q20262,fun(list(prod(Q20262,Q20246)),Q20246)),assoc),s(Q20262,X))),s(list(prod(Q20262,Q20246)),L))))))),s(list(prod(Q20262,Q20246)),L))) = s(bool,i(s(fun(list(Q20262),bool),i(s(fun(Q20262,fun(list(Q20262),bool)),mem),s(Q20262,X))),s(list(Q20262),i(s(fun(list(prod(Q20262,Q20246)),list(Q20262)),i(s(fun(fun(prod(Q20262,Q20246),Q20262),fun(list(prod(Q20262,Q20246)),list(Q20262))),map0),s(fun(prod(Q20262,Q20246),Q20262),fst))),s(list(prod(Q20262,Q20246)),L))))) ).

fof(aALLu_APPEND,axiom,
    ! [Q20283,P0,L1,L2] :
      ( p(s(bool,i(s(fun(list(Q20283),bool),i(s(fun(fun(Q20283,bool),fun(list(Q20283),bool)),all0),s(fun(Q20283,bool),P0))),s(list(Q20283),i(s(fun(list(Q20283),list(Q20283)),i(s(fun(list(Q20283),fun(list(Q20283),list(Q20283))),append),s(list(Q20283),L1))),s(list(Q20283),L2))))))
    <=> ( p(s(bool,i(s(fun(list(Q20283),bool),i(s(fun(fun(Q20283,bool),fun(list(Q20283),bool)),all0),s(fun(Q20283,bool),P0))),s(list(Q20283),L1))))
        & p(s(bool,i(s(fun(list(Q20283),bool),i(s(fun(fun(Q20283,bool),fun(list(Q20283),bool)),all0),s(fun(Q20283,bool),P0))),s(list(Q20283),L2)))) ) ) ).

fof(aMEMu_EL,axiom,
    ! [Q20306,L,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,i(s(fun(list(Q20306),num),length),s(list(Q20306),L))))))
     => p(s(bool,i(s(fun(list(Q20306),bool),i(s(fun(Q20306,fun(list(Q20306),bool)),mem),s(Q20306,i(s(fun(list(Q20306),Q20306),i(s(fun(num,fun(list(Q20306),Q20306)),el),s(num,N0))),s(list(Q20306),L))))),s(list(Q20306),L)))) ) ).

fof(aMEMu_EXISTSu_EL,axiom,
    ! [Q20354,L,X] :
      ( p(s(bool,i(s(fun(list(Q20354),bool),i(s(fun(Q20354,fun(list(Q20354),bool)),mem),s(Q20354,X))),s(list(Q20354),L))))
    <=> ? [I0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,I0))),s(num,i(s(fun(list(Q20354),num),length),s(list(Q20354),L))))))
          & s(Q20354,X) = s(Q20354,i(s(fun(list(Q20354),Q20354),i(s(fun(num,fun(list(Q20354),Q20354)),el),s(num,I0))),s(list(Q20354),L))) ) ) ).

fof(aALLu_EL,axiom,
    ! [Q20380,P0,L] :
      ( ! [I0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,I0))),s(num,i(s(fun(list(Q20380),num),length),s(list(Q20380),L))))))
         => p(s(bool,i(s(fun(Q20380,bool),P0),s(Q20380,i(s(fun(list(Q20380),Q20380),i(s(fun(num,fun(list(Q20380),Q20380)),el),s(num,I0))),s(list(Q20380),L)))))) )
    <=> p(s(bool,i(s(fun(list(Q20380),bool),i(s(fun(fun(Q20380,bool),fun(list(Q20380),bool)),all0),s(fun(Q20380,bool),P0))),s(list(Q20380),L)))) ) ).

fof(aALL2u_MAP2,axiom,
    ! [Q20423,Q20422,Q20424,Q20425,U_1] :
      ( ! [X,Y] : s(bool,i(s(fun(Q20425,bool),i(s(fun(Q20424,fun(Q20425,bool)),U_1),s(Q20424,X))),s(Q20425,Y))) = s(bool,i(s(fun(Q20422,bool),i(s(fun(Q20423,fun(Q20422,bool)),p0),s(Q20423,i(s(fun(Q20424,Q20423),f),s(Q20424,X))))),s(Q20422,i(s(fun(Q20425,Q20422),g),s(Q20425,Y)))))
     => ! [U_0] :
          ( ! [X] : s(fun(Q20425,bool),i(s(fun(Q20424,fun(Q20425,bool)),U_0),s(Q20424,X))) = s(fun(Q20425,bool),i(s(fun(Q20424,fun(Q20425,bool)),U_1),s(Q20424,X)))
         => ! [L,M0] : s(bool,i(s(fun(list(Q20422),bool),i(s(fun(list(Q20423),fun(list(Q20422),bool)),i(s(fun(fun(Q20423,fun(Q20422,bool)),fun(list(Q20423),fun(list(Q20422),bool))),all2),s(fun(Q20423,fun(Q20422,bool)),p0))),s(list(Q20423),i(s(fun(list(Q20424),list(Q20423)),i(s(fun(fun(Q20424,Q20423),fun(list(Q20424),list(Q20423))),map0),s(fun(Q20424,Q20423),f))),s(list(Q20424),L))))),s(list(Q20422),i(s(fun(list(Q20425),list(Q20422)),i(s(fun(fun(Q20425,Q20422),fun(list(Q20425),list(Q20422))),map0),s(fun(Q20425,Q20422),g))),s(list(Q20425),M0))))) = s(bool,i(s(fun(list(Q20425),bool),i(s(fun(list(Q20424),fun(list(Q20425),bool)),i(s(fun(fun(Q20424,fun(Q20425,bool)),fun(list(Q20424),fun(list(Q20425),bool))),all2),s(fun(Q20424,fun(Q20425,bool)),U_0))),s(list(Q20424),L))),s(list(Q20425),M0))) ) ) ).

fof(aANDu_ALL2,axiom,
    ! [Q20471,Q20470,U_1] :
      ( ! [P0,Q0,X,Y] :
          ( p(s(bool,i(s(fun(Q20470,bool),i(s(fun(Q20471,fun(Q20470,bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool))),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool)))),U_1),s(fun(Q20471,fun(Q20470,bool)),P0))),s(fun(Q20471,fun(Q20470,bool)),Q0))),s(Q20471,X))),s(Q20470,Y))))
        <=> ( p(s(bool,i(s(fun(Q20470,bool),i(s(fun(Q20471,fun(Q20470,bool)),P0),s(Q20471,X))),s(Q20470,Y))))
            & p(s(bool,i(s(fun(Q20470,bool),i(s(fun(Q20471,fun(Q20470,bool)),Q0),s(Q20471,X))),s(Q20470,Y)))) ) )
     => ! [U_0] :
          ( ! [P0,Q0,X] : s(fun(Q20470,bool),i(s(fun(Q20471,fun(Q20470,bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool))),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool)))),U_0),s(fun(Q20471,fun(Q20470,bool)),P0))),s(fun(Q20471,fun(Q20470,bool)),Q0))),s(Q20471,X))) = s(fun(Q20470,bool),i(s(fun(Q20471,fun(Q20470,bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool))),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool)))),U_1),s(fun(Q20471,fun(Q20470,bool)),P0))),s(fun(Q20471,fun(Q20470,bool)),Q0))),s(Q20471,X)))
         => ! [P0,Q0,L,M0] :
              ( ( p(s(bool,i(s(fun(list(Q20470),bool),i(s(fun(list(Q20471),fun(list(Q20470),bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(list(Q20471),fun(list(Q20470),bool))),all2),s(fun(Q20471,fun(Q20470,bool)),P0))),s(list(Q20471),L))),s(list(Q20470),M0))))
                & p(s(bool,i(s(fun(list(Q20470),bool),i(s(fun(list(Q20471),fun(list(Q20470),bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(list(Q20471),fun(list(Q20470),bool))),all2),s(fun(Q20471,fun(Q20470,bool)),Q0))),s(list(Q20471),L))),s(list(Q20470),M0)))) )
            <=> p(s(bool,i(s(fun(list(Q20470),bool),i(s(fun(list(Q20471),fun(list(Q20470),bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(list(Q20471),fun(list(Q20470),bool))),all2),s(fun(Q20471,fun(Q20470,bool)),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool))),i(s(fun(fun(Q20471,fun(Q20470,bool)),fun(fun(Q20471,fun(Q20470,bool)),fun(Q20471,fun(Q20470,bool)))),U_0),s(fun(Q20471,fun(Q20470,bool)),P0))),s(fun(Q20471,fun(Q20470,bool)),Q0))))),s(list(Q20471),L))),s(list(Q20470),M0)))) ) ) ) ).

fof(aALL2u_ALL,axiom,
    ! [Q20493,U_0] :
      ( ! [P0,X] : s(bool,i(s(fun(Q20493,bool),i(s(fun(fun(Q20493,fun(Q20493,bool)),fun(Q20493,bool)),U_0),s(fun(Q20493,fun(Q20493,bool)),P0))),s(Q20493,X))) = s(bool,i(s(fun(Q20493,bool),i(s(fun(Q20493,fun(Q20493,bool)),P0),s(Q20493,X))),s(Q20493,X)))
     => ! [P0,L] : s(bool,i(s(fun(list(Q20493),bool),i(s(fun(list(Q20493),fun(list(Q20493),bool)),i(s(fun(fun(Q20493,fun(Q20493,bool)),fun(list(Q20493),fun(list(Q20493),bool))),all2),s(fun(Q20493,fun(Q20493,bool)),P0))),s(list(Q20493),L))),s(list(Q20493),L))) = s(bool,i(s(fun(list(Q20493),bool),i(s(fun(fun(Q20493,bool),fun(list(Q20493),bool)),all0),s(fun(Q20493,bool),i(s(fun(fun(Q20493,fun(Q20493,bool)),fun(Q20493,bool)),U_0),s(fun(Q20493,fun(Q20493,bool)),P0))))),s(list(Q20493),L))) ) ).

fof(aAPPENDu_EQu_NIL,axiom,
    ! [Q20522,L,M0] :
      ( s(list(Q20522),i(s(fun(list(Q20522),list(Q20522)),i(s(fun(list(Q20522),fun(list(Q20522),list(Q20522))),append),s(list(Q20522),L))),s(list(Q20522),M0))) = s(list(Q20522),nil)
    <=> ( s(list(Q20522),L) = s(list(Q20522),nil)
        & s(list(Q20522),M0) = s(list(Q20522),nil) ) ) ).

fof(aLENGTHu_MAP2,axiom,
    ! [Q20555,Q20542,Q20544,F0,L,M0] :
      ( s(num,i(s(fun(list(Q20542),num),length),s(list(Q20542),L))) = s(num,i(s(fun(list(Q20544),num),length),s(list(Q20544),M0)))
     => s(num,i(s(fun(list(Q20555),num),length),s(list(Q20555),i(s(fun(list(Q20544),list(Q20555)),i(s(fun(list(Q20542),fun(list(Q20544),list(Q20555))),i(s(fun(fun(Q20542,fun(Q20544,Q20555)),fun(list(Q20542),fun(list(Q20544),list(Q20555)))),map2),s(fun(Q20542,fun(Q20544,Q20555)),F0))),s(list(Q20542),L))),s(list(Q20544),M0))))) = s(num,i(s(fun(list(Q20544),num),length),s(list(Q20544),M0))) ) ).

fof(aMAPu_EQu_NIL,axiom,
    ! [Q20576,Q20580,F0,L] :
      ( s(list(Q20576),i(s(fun(list(Q20580),list(Q20576)),i(s(fun(fun(Q20580,Q20576),fun(list(Q20580),list(Q20576))),map0),s(fun(Q20580,Q20576),F0))),s(list(Q20580),L))) = s(list(Q20576),nil)
    <=> s(list(Q20580),L) = s(list(Q20580),nil) ) ).

fof(aINJECTIVEu_MAP,axiom,
    ! [B,A,F0] :
      ( ! [L,M0] :
          ( s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L))) = s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),M0)))
         => s(list(A),L) = s(list(A),M0) )
    <=> ! [X,Y] :
          ( s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y)))
         => s(A,X) = s(A,Y) ) ) ).

fof(aSURJECTIVEu_MAP,axiom,
    ! [A,B,F0] :
      ( ! [M0] :
        ? [L] : s(list(B),i(s(fun(list(A),list(B)),i(s(fun(fun(A,B),fun(list(A),list(B))),map0),s(fun(A,B),F0))),s(list(A),L))) = s(list(B),M0)
    <=> ! [Y] :
        ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) ).

fof(aMAPu_ID,axiom,
    ! [Q20694,U_0] :
      ( ! [X] : s(Q20694,i(s(fun(Q20694,Q20694),U_0),s(Q20694,X))) = s(Q20694,X)
     => ! [L] : s(list(Q20694),i(s(fun(list(Q20694),list(Q20694)),i(s(fun(fun(Q20694,Q20694),fun(list(Q20694),list(Q20694))),map0),s(fun(Q20694,Q20694),U_0))),s(list(Q20694),L))) = s(list(Q20694),L) ) ).

fof(aMAPu_I,axiom,
    ! [Q20703] : s(fun(list(Q20703),list(Q20703)),i(s(fun(fun(Q20703,Q20703),fun(list(Q20703),list(Q20703))),map0),s(fun(Q20703,Q20703),i1))) = s(fun(list(Q20703),list(Q20703)),i1) ).

fof(aAPPENDu_BUTLASTu_LAST,axiom,
    ! [Q20730,L] :
      ( s(list(Q20730),L) != s(list(Q20730),nil)
     => s(list(Q20730),i(s(fun(list(Q20730),list(Q20730)),i(s(fun(list(Q20730),fun(list(Q20730),list(Q20730))),append),s(list(Q20730),i(s(fun(list(Q20730),list(Q20730)),butlast),s(list(Q20730),L))))),s(list(Q20730),i(s(fun(list(Q20730),list(Q20730)),i(s(fun(Q20730,fun(list(Q20730),list(Q20730))),cons),s(Q20730,i(s(fun(list(Q20730),Q20730),last0),s(list(Q20730),L))))),s(list(Q20730),nil))))) = s(list(Q20730),L) ) ).

fof(aLASTu_APPEND,axiom,
    ! [Q20755,P0,Q0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(list(Q20755),Q0) = s(list(Q20755),nil) )
      & s(Q20755,i(s(fun(list(Q20755),Q20755),last0),s(list(Q20755),i(s(fun(list(Q20755),list(Q20755)),i(s(fun(list(Q20755),fun(list(Q20755),list(Q20755))),append),s(list(Q20755),P0))),s(list(Q20755),Q0))))) = s(Q20755,i(s(fun(Q20755,Q20755),i(s(fun(Q20755,fun(Q20755,Q20755)),i(s(fun(bool,fun(Q20755,fun(Q20755,Q20755))),cond),s(bool,V))),s(Q20755,i(s(fun(list(Q20755),Q20755),last0),s(list(Q20755),P0))))),s(Q20755,i(s(fun(list(Q20755),Q20755),last0),s(list(Q20755),Q0))))) ) ).

fof(aLENGTHu_TL,axiom,
    ! [Q20771,L] :
      ( s(list(Q20771),L) != s(list(Q20771),nil)
     => s(num,i(s(fun(list(Q20771),num),length),s(list(Q20771),i(s(fun(list(Q20771),list(Q20771)),tl),s(list(Q20771),L))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(list(Q20771),num),length),s(list(Q20771),L))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aELu_APPEND,axiom,
    ! [Q20804,K0,L,M0] : s(Q20804,i(s(fun(list(Q20804),Q20804),i(s(fun(num,fun(list(Q20804),Q20804)),el),s(num,K0))),s(list(Q20804),i(s(fun(list(Q20804),list(Q20804)),i(s(fun(list(Q20804),fun(list(Q20804),list(Q20804))),append),s(list(Q20804),L))),s(list(Q20804),M0))))) = s(Q20804,i(s(fun(Q20804,Q20804),i(s(fun(Q20804,fun(Q20804,Q20804)),i(s(fun(bool,fun(Q20804,fun(Q20804,Q20804))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,K0))),s(num,i(s(fun(list(Q20804),num),length),s(list(Q20804),L))))))),s(Q20804,i(s(fun(list(Q20804),Q20804),i(s(fun(num,fun(list(Q20804),Q20804)),el),s(num,K0))),s(list(Q20804),L))))),s(Q20804,i(s(fun(list(Q20804),Q20804),i(s(fun(num,fun(list(Q20804),Q20804)),el),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,K0))),s(num,i(s(fun(list(Q20804),num),length),s(list(Q20804),L))))))),s(list(Q20804),M0))))) ).

fof(aELu_TL,axiom,
    ! [Q20835,N0] : s(Q20835,i(s(fun(list(Q20835),Q20835),i(s(fun(num,fun(list(Q20835),Q20835)),el),s(num,N0))),s(list(Q20835),i(s(fun(list(Q20835),list(Q20835)),tl),s(list(Q20835),l0))))) = s(Q20835,i(s(fun(list(Q20835),Q20835),i(s(fun(num,fun(list(Q20835),Q20835)),el),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(list(Q20835),l0))) ).

fof(aELu_CONS,axiom,
    ! [Q20861,N0,H0,T0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
      & s(Q20861,i(s(fun(list(Q20861),Q20861),i(s(fun(num,fun(list(Q20861),Q20861)),el),s(num,N0))),s(list(Q20861),i(s(fun(list(Q20861),list(Q20861)),i(s(fun(Q20861,fun(list(Q20861),list(Q20861))),cons),s(Q20861,H0))),s(list(Q20861),T0))))) = s(Q20861,i(s(fun(Q20861,Q20861),i(s(fun(Q20861,fun(Q20861,Q20861)),i(s(fun(bool,fun(Q20861,fun(Q20861,Q20861))),cond),s(bool,V))),s(Q20861,H0))),s(Q20861,i(s(fun(list(Q20861),Q20861),i(s(fun(num,fun(list(Q20861),Q20861)),el),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(list(Q20861),T0))))) ) ).

fof(aLASTu_EL,axiom,
    ! [Q20886,L] :
      ( s(list(Q20886),L) != s(list(Q20886),nil)
     => s(Q20886,i(s(fun(list(Q20886),Q20886),last0),s(list(Q20886),L))) = s(Q20886,i(s(fun(list(Q20886),Q20886),i(s(fun(num,fun(list(Q20886),Q20886)),el),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(list(Q20886),num),length),s(list(Q20886),L))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(list(Q20886),L))) ) ).

fof(aHDu_APPEND,axiom,
    ! [A,L,M0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(list(A),L) = s(list(A),nil) )
      & s(A,i(s(fun(list(A),A),hd),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L))),s(list(A),M0))))) = s(A,i(s(fun(A,A),i(s(fun(A,fun(A,A)),i(s(fun(bool,fun(A,fun(A,A))),cond),s(bool,V))),s(A,i(s(fun(list(A),A),hd),s(list(A),M0))))),s(A,i(s(fun(list(A),A),hd),s(list(A),L))))) ) ).

fof(aCONSu_HDu_TL,axiom,
    ! [Q20949,L] :
      ( s(list(Q20949),L) != s(list(Q20949),nil)
     => s(list(Q20949),L) = s(list(Q20949),i(s(fun(list(Q20949),list(Q20949)),i(s(fun(Q20949,fun(list(Q20949),list(Q20949))),cons),s(Q20949,i(s(fun(list(Q20949),Q20949),hd),s(list(Q20949),L))))),s(list(Q20949),i(s(fun(list(Q20949),list(Q20949)),tl),s(list(Q20949),L))))) ) ).

fof(aELu_MAP,axiom,
    ! [Q20978,Q20979,F0,N0,L] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,i(s(fun(list(Q20979),num),length),s(list(Q20979),L))))))
     => s(Q20978,i(s(fun(list(Q20978),Q20978),i(s(fun(num,fun(list(Q20978),Q20978)),el),s(num,N0))),s(list(Q20978),i(s(fun(list(Q20979),list(Q20978)),i(s(fun(fun(Q20979,Q20978),fun(list(Q20979),list(Q20978))),map0),s(fun(Q20979,Q20978),F0))),s(list(Q20979),L))))) = s(Q20978,i(s(fun(Q20979,Q20978),F0),s(Q20979,i(s(fun(list(Q20979),Q20979),i(s(fun(num,fun(list(Q20979),Q20979)),el),s(num,N0))),s(list(Q20979),L))))) ) ).

fof(aMAPu_REVERSE,axiom,
    ! [Q21004,Q21006,F0,L] : s(list(Q21004),i(s(fun(list(Q21004),list(Q21004)),reverse),s(list(Q21004),i(s(fun(list(Q21006),list(Q21004)),i(s(fun(fun(Q21006,Q21004),fun(list(Q21006),list(Q21004))),map0),s(fun(Q21006,Q21004),F0))),s(list(Q21006),L))))) = s(list(Q21004),i(s(fun(list(Q21006),list(Q21004)),i(s(fun(fun(Q21006,Q21004),fun(list(Q21006),list(Q21004))),map0),s(fun(Q21006,Q21004),F0))),s(list(Q21006),i(s(fun(list(Q21006),list(Q21006)),reverse),s(list(Q21006),L))))) ).

fof(aALLu_FILTER,axiom,
    ! [A,U_0] :
      ( ! [Q0,P0,X] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),Q0))),s(fun(A,bool),P0))),s(A,X))))
        <=> ( p(s(bool,i(s(fun(A,bool),Q0),s(A,X))))
           => p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) )
     => ! [P0,Q0,L] : s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,bool),fun(list(A),bool)),all0),s(fun(A,bool),P0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(fun(A,bool),fun(list(A),list(A))),filter0),s(fun(A,bool),Q0))),s(list(A),L))))) = s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,bool),fun(list(A),bool)),all0),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),Q0))),s(fun(A,bool),P0))))),s(list(A),L))) ) ).

fof(aAPPENDu_SING,axiom,
    ! [Q21057,H0,T0] : s(list(Q21057),i(s(fun(list(Q21057),list(Q21057)),i(s(fun(list(Q21057),fun(list(Q21057),list(Q21057))),append),s(list(Q21057),i(s(fun(list(Q21057),list(Q21057)),i(s(fun(Q21057,fun(list(Q21057),list(Q21057))),cons),s(Q21057,H0))),s(list(Q21057),nil))))),s(list(Q21057),T0))) = s(list(Q21057),i(s(fun(list(Q21057),list(Q21057)),i(s(fun(Q21057,fun(list(Q21057),list(Q21057))),cons),s(Q21057,H0))),s(list(Q21057),T0))) ).

fof(aSeq2o_MEM,axiom,
    ! [Q18672,H0,X,T0] :
      ( s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,X))),s(list(Q18672),nil))) = s(bool,f0)
      & ( p(s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,X))),s(list(Q18672),i(s(fun(list(Q18672),list(Q18672)),i(s(fun(Q18672,fun(list(Q18672),list(Q18672))),cons),s(Q18672,H0))),s(list(Q18672),T0))))))
      <=> ( s(Q18672,X) = s(Q18672,H0)
          | p(s(bool,i(s(fun(list(Q18672),bool),i(s(fun(Q18672,fun(list(Q18672),bool)),mem),s(Q18672,X))),s(list(Q18672),T0)))) ) ) ) ).

fof(aMEMu_APPENDu_DECOMPOSEu_LEFT,axiom,
    ! [A,X,L] :
      ( p(s(bool,i(s(fun(list(A),bool),i(s(fun(A,fun(list(A),bool)),mem),s(A,X))),s(list(A),L))))
    <=> ? [L1,L2] :
          ( ~ p(s(bool,i(s(fun(list(A),bool),i(s(fun(A,fun(list(A),bool)),mem),s(A,X))),s(list(A),L1))))
          & s(list(A),L) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L1))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,X))),s(list(A),L2))))) ) ) ).

fof(aMEMu_APPENDu_DECOMPOSE,axiom,
    ! [A,X,L] :
      ( p(s(bool,i(s(fun(list(A),bool),i(s(fun(A,fun(list(A),bool)),mem),s(A,X))),s(list(A),L))))
    <=> ? [L1,L2] : s(list(A),L) = s(list(A),i(s(fun(list(A),list(A)),i(s(fun(list(A),fun(list(A),list(A))),append),s(list(A),L1))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,X))),s(list(A),L2))))) ) ).

fof(aMONOu_ALL,axiom,
    ! [A] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(A,bool),p0),s(A,X))))
         => p(s(bool,i(s(fun(A,bool),q0),s(A,X)))) )
     => ( p(s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,bool),fun(list(A),bool)),all0),s(fun(A,bool),p0))),s(list(A),l0))))
       => p(s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,bool),fun(list(A),bool)),all0),s(fun(A,bool),q0))),s(list(A),l0)))) ) ) ).

fof(aMONOu_ALL2,axiom,
    ! [A,B] :
      ( ! [X,Y] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),p0),s(A,X))),s(B,Y))))
         => p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),q0),s(A,X))),s(B,Y)))) )
     => ( p(s(bool,i(s(fun(list(B),bool),i(s(fun(list(A),fun(list(B),bool)),i(s(fun(fun(A,fun(B,bool)),fun(list(A),fun(list(B),bool))),all2),s(fun(A,fun(B,bool)),p0))),s(list(A),l0))),s(list(B),li_0))))
       => p(s(bool,i(s(fun(list(B),bool),i(s(fun(list(A),fun(list(B),bool)),i(s(fun(fun(A,fun(B,bool)),fun(list(A),fun(list(B),bool))),all2),s(fun(A,fun(B,bool)),q0))),s(list(A),l0))),s(list(B),li_0)))) ) ) ).

fof(acharu_INDUCT,axiom,
    ! [P0] :
      ( ! [A01,A10,A20,A30,A40,A5,A6,A7] : p(s(bool,i(s(fun(char,bool),P0),s(char,i(s(fun(bool,char),i(s(fun(bool,fun(bool,char)),i(s(fun(bool,fun(bool,fun(bool,char))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,char)))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char)))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char))))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char)))))))),ascii),s(bool,A01))),s(bool,A10))),s(bool,A20))),s(bool,A30))),s(bool,A40))),s(bool,A5))),s(bool,A6))),s(bool,A7))))))
     => ! [X] : p(s(bool,i(s(fun(char,bool),P0),s(char,X)))) ) ).

fof(acharu_RECURSION,axiom,
    ! [Z,F0] :
    ? [FN] :
    ! [A01,A10,A20,A30,A40,A5,A6,A7] : s(Z,i(s(fun(char,Z),FN),s(char,i(s(fun(bool,char),i(s(fun(bool,fun(bool,char)),i(s(fun(bool,fun(bool,fun(bool,char))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,char)))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char)))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char))))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,char)))))))),ascii),s(bool,A01))),s(bool,A10))),s(bool,A20))),s(bool,A30))),s(bool,A40))),s(bool,A5))),s(bool,A6))),s(bool,A7))))) = s(Z,i(s(fun(bool,Z),i(s(fun(bool,fun(bool,Z)),i(s(fun(bool,fun(bool,fun(bool,Z))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,Z)))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,Z))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,Z)))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,Z))))))),i(s(fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,fun(bool,Z)))))))),F0),s(bool,A01))),s(bool,A10))),s(bool,A20))),s(bool,A30))),s(bool,A40))),s(bool,A5))),s(bool,A6))),s(bool,A7))) ).

fof(aDISTu_LZERO,axiom,
    ! [N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,N0))))) = s(num,N0) ).

fof(aDISTu_RZERO,axiom,
    ! [N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(num,N0) ).

fof(aDISTu_LADD,axiom,
    ! [M0,P0,N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))))) = s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,P0))))) ).

fof(aDISTu_RADD,axiom,
    ! [M0,P0,N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))))) = s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0))))) ).

fof(aDISTu_LADDu_0,axiom,
    ! [M0,N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,M0))))) = s(num,N0) ).

fof(aDISTu_RADDu_0,axiom,
    ! [M0,N0] : s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))) = s(num,N0) ).

fof(aDISTu_LMUL,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,P0))))))) = s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))))) ).

fof(aDISTu_RMUL,axiom,
    ! [M0,N0,P0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0))))))),s(num,P0))) = s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,P0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,P0))))))) ).

fof(aDISTu_ELIMu_THM,axiom,
    ( p(s(bool,i(s(fun(num,bool),p0),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,x))),s(num,y))))))))
  <=> ! [D0] :
        ( ( s(num,x) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,y))),s(num,D0)))
         => p(s(bool,i(s(fun(num,bool),p0),s(num,D0)))) )
        & ( s(num,y) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,x))),s(num,D0)))
         => p(s(bool,i(s(fun(num,bool),p0),s(num,D0)))) ) ) ) ).

fof(aDISTu_LEu_CASES,axiom,
    ! [M0,N0,P0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0))))))),s(num,P0))))
    <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,P0))))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,P0)))))) ) ) ).

fof(aDISTu_ADDBOUND,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))) ).

fof(aDISTu_ADD2u_REV,axiom,
    ! [M0,N0,P0,Q0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,P0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0))))))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,Q0)))))))))) ).

fof(aDISTu_ADD2,axiom,
    ! [M0,N0,P0,Q0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,Q0))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,P0))))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,Q0)))))))))) ).

fof(aDISTu_TRIANGLESu_LE,axiom,
    ! [M0,N0,P0,Q0,R0,S0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0))))))),s(num,R0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,P0))),s(num,Q0))))))),s(num,S0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,P0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,N0))),s(num,Q0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,R0))),s(num,S0)))))))) ) ).

fof(aBOUNDSu_LINEAR,axiom,
    ! [A5,B0,C0] :
      ( ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,N0))))),s(num,C0))))))
    <=> p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,A5))),s(num,B0)))) ) ).

fof(aBOUNDSu_LINEARu_0,axiom,
    ! [A5,B0] :
      ( ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0))))
    <=> s(num,A5) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ).

fof(aBOUNDSu_DIVIDED,axiom,
    ! [P0] :
      ( ? [B0] :
        ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),P0),s(num,N0))))),s(num,B0))))
    <=> ? [A5,B0] :
        ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),P0),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0)))))) ) ).

fof(aBOUNDSu_NOTZERO,axiom,
    ! [P0,A5,B0] :
      ( ( s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),P0),s(num,i(s(fun(num,num),numeral),s(num,u_0))))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),P0),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))),s(num,B0)))))) )
     => ? [B0] :
        ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),P0),s(num,M0))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ) ).

fof(aBOUNDSu_IGNORE,axiom,
    ! [P0,Q0] :
      ( ? [B0] :
        ! [I0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),P0),s(num,I0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),Q0),s(num,I0))))),s(num,B0))))))
    <=> ? [B0,N0] :
        ! [I0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,I0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),P0),s(num,I0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),Q0),s(num,I0))))),s(num,B0)))))) ) ) ).

fof(aisu_nadd,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(fun(num,num),bool),isu_nadd),s(fun(num,num),X))))
    <=> ? [B0] :
        ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),X),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),X),s(num,M0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ) ).

fof(aisu_naddu_0,axiom,
    ! [U_0] :
      ( ! [N0] : s(num,i(s(fun(num,num),U_0),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(fun(num,num),bool),isu_nadd),s(fun(num,num),U_0)))) ) ).

fof(anaddu_abs,axiom,
    s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,a0))))) = s(nadd,a0) ).

fof(anaddu_rep,axiom,
    ( p(s(bool,i(s(fun(fun(num,num),bool),isu_nadd),s(fun(num,num),r0))))
  <=> s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),r0))))) = s(fun(num,num),r0) ) ).

fof(aNADDu_CAUCHY,axiom,
    ! [X] :
    ? [B0] :
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ).

fof(aNADDu_BOUND,axiom,
    ! [X] :
    ? [A5,B0] :
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0)))))) ).

fof(aNADDu_MULTIPLICATIVE,axiom,
    ! [X] :
    ? [B0] :
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,M0))))),s(num,B0)))))) ).

fof(aNADDu_ADDITIVE,axiom,
    ! [X] :
    ? [B0] :
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))))))))),s(num,B0)))) ).

fof(aNADDu_SUC,axiom,
    ! [X] :
    ? [B0] :
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),suc),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))))))),s(num,B0)))) ).

fof(aNADDu_DISTu_LEMMA,axiom,
    ! [X] :
    ? [B0] :
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,N0)))))) ).

fof(aNADDu_DIST,axiom,
    ! [X] :
    ? [B0] :
    ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,M0))),s(num,N0)))))))))) ).

fof(aNADDu_ALTMUL,axiom,
    ! [X,Y] :
    ? [A5,B0] :
    ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0)))))) ).

fof(anaddu_eq,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y))))
    <=> ? [B0] :
        ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0))))))))),s(num,B0)))) ) ).

fof(aNADDu_EQu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,X)))) ).

fof(aNADDu_EQu_SYM,axiom,
    ! [X,Y] : s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y))) = s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,X))) ).

fof(aNADDu_EQu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,Z0)))) )
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Z0)))) ) ).

fof(anaddu_ofu_num,axiom,
    ! [U_0] :
      ( ! [K0,N0] : s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),U_0),s(num,K0))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,K0))),s(num,N0)))
     => ! [K0] : s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,K0))) = s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),i(s(fun(num,fun(num,num)),U_0),s(num,K0))))) ) ).

fof(aNADDu_OFu_NUM,axiom,
    ! [K0,X] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,K0))))),s(num,X))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,K0))),s(num,X))) ).

fof(aNADDu_OFu_NUMu_WELLDEF,axiom,
    ! [M0,N0] :
      ( s(num,M0) = s(num,N0)
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,M0))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0)))))) ) ).

fof(aNADDu_OFu_NUMu_EQ,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,M0))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))))
    <=> s(num,M0) = s(num,N0) ) ).

fof(anaddu_le,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
    <=> ? [B0] :
        ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0))))),s(num,B0)))))) ) ).

fof(aNADDu_LEu_WELLDEFu_LEMMA,axiom,
    ! [X,XI_,Y,YI_] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,XI_))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,YI_))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y)))) )
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,XI_))),s(nadd,YI_)))) ) ).

fof(aNADDu_LEu_WELLDEF,axiom,
    ! [X,XI_,Y,YI_] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,XI_))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,YI_)))) )
     => s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))) = s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,XI_))),s(nadd,YI_))) ) ).

fof(aNADDu_LEu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,X)))) ).

fof(aNADDu_LEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,Y))),s(nadd,Z0)))) )
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Z0)))) ) ).

fof(aNADDu_LEu_ANTISYM,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,Y))),s(nadd,X)))) )
    <=> p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y)))) ) ).

fof(aNADDu_LEu_TOTALu_LEMMA,axiom,
    ! [X,Y] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
     => ! [B0] :
        ? [N0] :
          ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0))))),s(num,B0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0)))))) ) ) ).

fof(aNADDu_LEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
      | p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,Y))),s(nadd,X)))) ) ).

fof(aNADDu_ARCH,axiom,
    ! [X] :
    ? [N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0)))))) ).

fof(aNADDu_OFu_NUMu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,M0))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(anaddu_add,axiom,
    ! [U_0] :
      ( ! [X,Y,N0] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),i(s(fun(nadd,fun(nadd,fun(num,num))),U_0),s(nadd,X))),s(nadd,Y))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0)))))
     => ! [X,Y] : s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))) = s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),i(s(fun(nadd,fun(num,num)),i(s(fun(nadd,fun(nadd,fun(num,num))),U_0),s(nadd,X))),s(nadd,Y))))) ) ).

fof(aNADDu_ADD,axiom,
    ! [X,Y,X0] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(num,X0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,X0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,X0))))) ).

fof(aNADDu_ADDu_WELLDEF,axiom,
    ! [X,XI_,Y,YI_] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,XI_))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,YI_)))) )
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,XI_))),s(nadd,YI_)))))) ) ).

fof(aNADDu_ADDu_SYM,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,Y))),s(nadd,X)))))) ).

fof(aNADDu_ADDu_ASSOC,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,Y))),s(nadd,Z0))))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,Z0)))))) ).

fof(aNADDu_ADDu_LID,axiom,
    ! [X] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(nadd,X))))),s(nadd,X)))) ).

fof(aNADDu_ADDu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Z0))))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,Z0)))) ) ).

fof(aNADDu_LEu_ADD,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y)))))) ).

fof(aNADDu_LEu_EXISTS,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
     => ? [D0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,D0)))))) ) ).

fof(aNADDu_OFu_NUMu_ADD,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,M0))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ).

fof(anaddu_mul,axiom,
    ! [U_0] :
      ( ! [X,Y,N0] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),i(s(fun(nadd,fun(nadd,fun(num,num))),U_0),s(nadd,X))),s(nadd,Y))),s(num,N0))) = s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,N0)))))
     => ! [X,Y] : s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))) = s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),i(s(fun(nadd,fun(num,num)),i(s(fun(nadd,fun(nadd,fun(num,num))),U_0),s(nadd,X))),s(nadd,Y))))) ) ).

fof(aNADDu_MUL,axiom,
    ! [X,Y,X0] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(num,X0))) = s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,Y))),s(num,X0))))) ).

fof(aNADDu_MULu_SYM,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,Y))),s(nadd,X)))))) ).

fof(aNADDu_MULu_ASSOC,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,Y))),s(nadd,Z0))))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,Z0)))))) ).

fof(aNADDu_MULu_LID,axiom,
    ! [X] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(nadd,X))))),s(nadd,X)))) ).

fof(aNADDu_LDISTRIB,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,Y))),s(nadd,Z0))))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Z0)))))))) ).

fof(aNADDu_MULu_WELLDEFu_LEMMA,axiom,
    ! [X,Y,YI_] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,YI_))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,YI_)))))) ) ).

fof(aNADDu_MULu_WELLDEF,axiom,
    ! [X,XI_,Y,YI_] :
      ( ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,XI_))))
        & p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,Y))),s(nadd,YI_)))) )
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,XI_))),s(nadd,YI_)))))) ) ).

fof(aNADDu_OFu_NUMu_MUL,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,M0))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))))) ).

fof(aNADDu_LEu_0,axiom,
    ! [X] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(nadd,X)))) ).

fof(aNADDu_EQu_IMPu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y)))) ) ).

fof(aNADDu_LEu_LMUL,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,Y))),s(nadd,Z0))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Z0)))))) ) ).

fof(aNADDu_LEu_RMUL,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Z0))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,Y))),s(nadd,Z0)))))) ) ).

fof(aNADDu_LEu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Z0))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,Y))),s(nadd,Z0))))) = s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))) ).

fof(aNADDu_LEu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Z0))))) = s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,Y))),s(nadd,Z0))) ).

fof(aNADDu_RDISTRIB,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,Z0))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Z0))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,Y))),s(nadd,Z0)))))))) ).

fof(aNADDu_ARCHu_MULT,axiom,
    ! [X,K0] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,K0))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))),s(nadd,X)))))) ) ).

fof(aNADDu_ARCHu_ZERO,axiom,
    ! [X,K0] :
      ( ! [N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))),s(nadd,X))))),s(nadd,K0))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ).

fof(aNADDu_ARCHu_LEMMA,axiom,
    ! [X,Y,Z0] :
      ( ! [N0] : p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))),s(nadd,X))))),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,N0))))),s(nadd,Y))))),s(nadd,Z0))))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y)))) ) ).

fof(aNADDu_COMPLETE,axiom,
    ! [P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(nadd,bool),P0),s(nadd,X))))
        & ? [M0] :
          ! [X] :
            ( p(s(bool,i(s(fun(nadd,bool),P0),s(nadd,X))))
           => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,M0)))) ) )
     => ? [M0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(nadd,bool),P0),s(nadd,X))))
             => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,M0)))) )
          & ! [MI_] :
              ( ! [X] :
                  ( p(s(bool,i(s(fun(nadd,bool),P0),s(nadd,X))))
                 => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,MI_)))) )
             => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,M0))),s(nadd,MI_)))) ) ) ) ).

fof(aNADDu_UBOUND,axiom,
    ! [X] :
    ? [B0,N0] :
    ! [N1] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,N1)))))) ) ).

fof(aNADDu_NONZERO,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [N0] :
        ! [N1] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1))))
         => s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aNADDu_LBOUND,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [A5,N0] :
        ! [N1] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1)))))))) ) ) ).

fof(anaddu_rinv,axiom,
    ! [X,X0] : s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,X0))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),div),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,X0))),s(num,X0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,X0))))) ).

fof(aNADDu_MULu_LINVu_LEMMA0,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [A5,B0] :
        ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N0))))),s(num,B0)))))) ) ).

fof(aNADDu_MULu_LINVu_LEMMA1,axiom,
    ! [X,N0] :
      ( s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,N0))))))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N0)))))) ) ).

fof(aNADDu_MULu_LINVu_LEMMA2,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [N0] :
        ! [N1] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,N1))))))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1)))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA3,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [N0] :
        ! [M0,N1] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,N1))))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1)))))))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA4,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [N0] :
        ! [M0,N1] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N1))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N1)))))))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA5,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [B0,N0] :
        ! [M0,N1] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,M0))))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N1))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N1)))))))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA6,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [B0,N0] :
        ! [M0,N1] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N1))))),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N1))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N1)))))))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA7,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [B0,N0] :
        ! [M0,N1] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,N1)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N1)))))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA7a,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ! [N0] :
        ? [A5,B0] :
        ! [M0,N1] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N1))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N1))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,A5))),s(num,N1))))),s(num,B0)))))) ) ) ).

fof(aNADDu_MULu_LINVu_LEMMA8,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => ? [B0] :
        ! [M0,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(prod(num,num),num),dist),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,N0))),s(num,i(s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))),s(num,M0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,B0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ) ).

fof(anaddu_inv,axiom,
    ! [X] : s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,X))) = s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),i(s(fun(bool,fun(nadd,fun(nadd,nadd))),cond),s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(nadd,i(s(fun(fun(num,num),nadd),mku_nadd),s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))))))) ).

fof(aNADDu_INV,axiom,
    ! [U_0] :
      ( ! [N0] : s(num,i(s(fun(num,num),U_0),s(num,N0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
     => ! [X] : s(fun(num,num),i(s(fun(nadd,fun(num,num)),destu_nadd),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,X))))) = s(fun(num,num),i(s(fun(fun(num,num),fun(num,num)),i(s(fun(fun(num,num),fun(fun(num,num),fun(num,num))),i(s(fun(bool,fun(fun(num,num),fun(fun(num,num),fun(num,num)))),cond),s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(fun(num,num),U_0))),s(fun(num,num),i(s(fun(nadd,fun(num,num)),naddu_rinv),s(nadd,X))))) ) ).

fof(aNADDu_MULu_LINV,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,X))))),s(nadd,X))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aNADDu_INVu_0,axiom,
    p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ).

fof(aNADDu_INVu_WELLDEF,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,X))),s(nadd,Y))))
     => p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,X))))),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,Y)))))) ) ).

fof(ahrealu_ofu_num,axiom,
    ! [U_0] :
      ( ! [U] : s(bool,i(s(fun(nadd,bool),U_0),s(nadd,U))) = s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,m))))),s(nadd,U)))
     => s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,m))) = s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),U_0))) ) ).

fof(ahrealu_ofu_numu_th,axiom,
    s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(num,nadd),naddu_ofu_num),s(num,m))))))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,m))) ).

fof(ahrealu_add,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(nadd,bool),U_0),s(nadd,U))))
        <=> ? [X,Y] :
              ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,X))),s(nadd,Y))))),s(nadd,U))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,x))),s(nadd,X))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,y))),s(nadd,Y)))) ) )
     => s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,x))),s(hreal,y))) = s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),U_0))) ) ).

fof(ahrealu_addu_th,axiom,
    s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_add),s(nadd,x))),s(nadd,y))))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,x))))))),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,y))))))) ).

fof(ahrealu_mul,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(nadd,bool),U_0),s(nadd,U))))
        <=> ? [X,Y] :
              ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,X))),s(nadd,Y))))),s(nadd,U))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,x))),s(nadd,X))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,y))),s(nadd,Y)))) ) )
     => s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,x))),s(hreal,y))) = s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),U_0))) ) ).

fof(ahrealu_mulu_th,axiom,
    s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),i(s(fun(nadd,fun(nadd,nadd)),naddu_mul),s(nadd,x))),s(nadd,y))))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,x))))))),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,y))))))) ).

fof(ahrealu_le,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(bool,bool),U_0),s(bool,U))))
        <=> ? [X,Y] :
              ( s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,X))),s(nadd,Y))) = s(bool,U)
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,x))),s(nadd,X))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,y))),s(nadd,Y)))) ) )
     => s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,x))),s(hreal,y))) = s(bool,i(s(fun(fun(bool,bool),bool),h_),s(fun(bool,bool),U_0))) ) ).

fof(ahrealu_leu_th,axiom,
    s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_le),s(nadd,x))),s(nadd,y))) = s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,x))))))),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,y))))))) ).

fof(ahrealu_inv,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(nadd,bool),U_0),s(nadd,U))))
        <=> ? [X] :
              ( p(s(bool,i(s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,X))))),s(nadd,U))))
              & p(s(bool,i(s(fun(nadd,bool),i(s(fun(hreal,fun(nadd,bool)),destu_hreal),s(hreal,x))),s(nadd,X)))) ) )
     => s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,x))) = s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),U_0))) ) ).

fof(ahrealu_invu_th,axiom,
    s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,i(s(fun(nadd,nadd),naddu_inv),s(nadd,x))))))) = s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,i(s(fun(fun(nadd,bool),hreal),mku_hreal),s(fun(nadd,bool),i(s(fun(nadd,fun(nadd,bool)),naddu_eq),s(nadd,x))))))) ).

fof(aHREALu_COMPLETE,axiom,
    ! [P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(hreal,bool),P0),s(hreal,X))))
        & ? [M0] :
          ! [X] :
            ( p(s(bool,i(s(fun(hreal,bool),P0),s(hreal,X))))
           => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,M0)))) ) )
     => ? [M0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(hreal,bool),P0),s(hreal,X))))
             => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,M0)))) )
          & ! [MI_] :
              ( ! [X] :
                  ( p(s(bool,i(s(fun(hreal,bool),P0),s(hreal,X))))
                 => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,MI_)))) )
             => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,M0))),s(hreal,MI_)))) ) ) ) ).

fof(aHREALu_OFu_NUMu_EQ,axiom,
    ! [M0,N0] :
      ( s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,M0))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aHREALu_OFu_NUMu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,M0))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aHREALu_OFu_NUMu_ADD,axiom,
    ! [M0,N0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,M0))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0))))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aHREALu_OFu_NUMu_MUL,axiom,
    ! [M0,N0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,M0))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0))))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aHREALu_LEu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,X)))) ).

fof(aHREALu_LEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Y))))
        & p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,Y))),s(hreal,Z0)))) )
     => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Z0)))) ) ).

fof(aHREALu_LEu_ANTISYM,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Y))))
        & p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,Y))),s(hreal,X)))) )
    <=> s(hreal,X) = s(hreal,Y) ) ).

fof(aHREALu_LEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Y))))
      | p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,Y))),s(hreal,X)))) ) ).

fof(aHREALu_LEu_ADD,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,Y)))))) ).

fof(aHREALu_LEu_EXISTS,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Y))))
     => ? [D0] : s(hreal,Y) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,D0))) ) ).

fof(aHREALu_ARCH,axiom,
    ! [X] :
    ? [N0] : p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0)))))) ).

fof(aHREALu_ADDu_SYM,axiom,
    ! [X,Y] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,Y))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,Y))),s(hreal,X))) ).

fof(aHREALu_ADDu_ASSOC,axiom,
    ! [X,Y,Z0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,Y))),s(hreal,Z0))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,Y))))),s(hreal,Z0))) ).

fof(aHREALu_ADDu_LID,axiom,
    ! [X] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(hreal,X))) = s(hreal,X) ).

fof(aHREALu_ADDu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,Y))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X))),s(hreal,Z0)))
     => s(hreal,Y) = s(hreal,Z0) ) ).

fof(aHREALu_MULu_SYM,axiom,
    ! [X,Y] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,Y))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,Y))),s(hreal,X))) ).

fof(aHREALu_MULu_ASSOC,axiom,
    ! [X,Y,Z0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,Y))),s(hreal,Z0))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,Y))))),s(hreal,Z0))) ).

fof(aHREALu_MULu_LID,axiom,
    ! [X] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(hreal,X))) = s(hreal,X) ).

fof(aHREALu_ADDu_LDISTRIB,axiom,
    ! [X,Y,Z0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,Y))),s(hreal,Z0))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,Y))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X))),s(hreal,Z0))))) ).

fof(aHREALu_MULu_LINV,axiom,
    ! [X] :
      ( s(hreal,X) != s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,X))))),s(hreal,X))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aHREALu_INVu_0,axiom,
    s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aHREALu_LEu_EXISTSu_DEF,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,M0))),s(hreal,N0))))
    <=> ? [D0] : s(hreal,N0) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,D0))) ) ).

fof(aHREALu_EQu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,N0))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,P0)))
    <=> s(hreal,N0) = s(hreal,P0) ) ).

fof(aHREALu_EQu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] :
      ( s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,P0))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,N0))),s(hreal,P0)))
    <=> s(hreal,M0) = s(hreal,N0) ) ).

fof(aHREALu_LEu_ADDu_LCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,N0))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,P0))))) = s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,N0))),s(hreal,P0))) ).

fof(aHREALu_LEu_ADDu_RCANCEL,axiom,
    ! [M0,N0,P0] : s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,P0))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,N0))),s(hreal,P0))))) = s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,M0))),s(hreal,N0))) ).

fof(aHREALu_ADDu_RID,axiom,
    ! [N0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,N0))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(hreal,N0) ).

fof(aHREALu_ADDu_RDISTRIB,axiom,
    ! [M0,N0,P0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,M0))),s(hreal,N0))))),s(hreal,P0))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,M0))),s(hreal,P0))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,N0))),s(hreal,P0))))) ).

fof(aHREALu_MULu_LZERO,axiom,
    ! [M0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(hreal,M0))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aHREALu_MULu_RZERO,axiom,
    ! [M0] : s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,M0))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aHREALu_ADDu_ACu_conjunct0,axiom,
    s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,m))),s(hreal,n))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,n))),s(hreal,m))) ).

fof(aHREALu_ADDu_ACu_conjunct1,axiom,
    s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,m))),s(hreal,n))))),s(hreal,p1))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,m))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,n))),s(hreal,p1))))) ).

fof(aHREALu_ADDu_ACu_conjunct2,axiom,
    s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,m))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,n))),s(hreal,p1))))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,n))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,m))),s(hreal,p1))))) ).

fof(aHREALu_LEu_ADD2,axiom,
    ! [A5,B0,C0,D0] :
      ( ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,A5))),s(hreal,B0))))
        & p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,C0))),s(hreal,D0)))) )
     => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,A5))),s(hreal,C0))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,B0))),s(hreal,D0)))))) ) ).

fof(aHREALu_LEu_MULu_RCANCELu_IMP,axiom,
    ! [A5,B0,C0] :
      ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,A5))),s(hreal,B0))))
     => p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,A5))),s(hreal,C0))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,B0))),s(hreal,C0)))))) ) ).

fof(atrealu_ofu_num,axiom,
    ! [N0] : s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0))) = s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,N0))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(atrealu_neg,axiom,
    ! [Y,X] : s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X))),s(hreal,Y))))) = s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,Y))),s(hreal,X))) ).

fof(atrealu_add,axiom,
    ! [X1,X2,Y1,Y2] : s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X1))),s(hreal,Y1))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X2))),s(hreal,Y2))))) = s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X1))),s(hreal,X2))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,Y1))),s(hreal,Y2))))) ).

fof(atrealu_mul,axiom,
    ! [X1,Y2,Y1,X2] : s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X1))),s(hreal,Y1))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X2))),s(hreal,Y2))))) = s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X1))),s(hreal,X2))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,Y1))),s(hreal,Y2))))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,X1))),s(hreal,Y2))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_mul),s(hreal,Y1))),s(hreal,X2))))))) ).

fof(atrealu_le,axiom,
    ! [X1,Y2,X2,Y1] : s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X1))),s(hreal,Y1))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X2))),s(hreal,Y2))))) = s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X1))),s(hreal,Y2))))),s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X2))),s(hreal,Y1))))) ).

fof(atrealu_inv,axiom,
    ! [U_0] :
      ( ! [X,Y,D0] :
          ( p(s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),i(s(fun(hreal,fun(hreal,fun(hreal,bool))),U_0),s(hreal,X))),s(hreal,Y))),s(hreal,D0))))
        <=> s(hreal,X) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,Y))),s(hreal,D0))) )
     => ! [Y,X] :
        ? [V] :
          ( ( p(s(bool,V))
          <=> s(hreal,X) = s(hreal,Y) )
          & s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X))),s(hreal,Y))))) = s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),i(s(fun(bool,fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal)))),cond),s(bool,V))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),i(s(fun(bool,fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal)))),cond),s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,Y))),s(hreal,X))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,i(s(fun(fun(hreal,bool),hreal),h_),s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),i(s(fun(hreal,fun(hreal,fun(hreal,bool))),U_0),s(hreal,X))),s(hreal,Y))))))))),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,i(s(fun(num,hreal),hrealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(hreal,i(s(fun(hreal,hreal),hrealu_inv),s(hreal,i(s(fun(fun(hreal,bool),hreal),h_),s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),i(s(fun(hreal,fun(hreal,fun(hreal,bool))),U_0),s(hreal,Y))),s(hreal,X))))))))))))) ) ) ).

fof(atrealu_eq,axiom,
    ! [X1,Y2,X2,Y1] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X1))),s(hreal,Y1))))),s(prod(hreal,hreal),i(s(fun(hreal,prod(hreal,hreal)),i(s(fun(hreal,fun(hreal,prod(hreal,hreal))),c_),s(hreal,X2))),s(hreal,Y2))))))
    <=> s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X1))),s(hreal,Y2))) = s(hreal,i(s(fun(hreal,hreal),i(s(fun(hreal,fun(hreal,hreal)),hrealu_add),s(hreal,X2))),s(hreal,Y1))) ) ).

fof(aTREALu_EQu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),X)))) ).

fof(aTREALu_EQu_SYM,axiom,
    ! [X,Y] : s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))) = s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X))) ).

fof(aTREALu_EQu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0)))) )
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Z0)))) ) ).

fof(aTREALu_EQu_AP,axiom,
    ! [X,Y] :
      ( s(prod(hreal,hreal),X) = s(prod(hreal,hreal),Y)
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y)))) ) ).

fof(aTREALu_OFu_NUMu_EQ,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,M0))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0))))))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aTREALu_OFu_NUMu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,M0))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aTREALu_OFu_NUMu_ADD,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,M0))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0))))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))))) ).

fof(aTREALu_OFu_NUMu_MUL,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,M0))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0))))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))))) ).

fof(aTREALu_ADDu_SYMu_EQ,axiom,
    ! [X,Y] : s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))) = s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X))) ).

fof(aTREALu_MULu_SYMu_EQ,axiom,
    ! [X,Y] : s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))) = s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X))) ).

fof(aTREALu_ADDu_SYM,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X)))))) ).

fof(aTREALu_ADDu_ASSOC,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0))))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),Z0)))))) ).

fof(aTREALu_ADDu_LID,axiom,
    ! [X] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),X)))) ).

fof(aTREALu_ADDu_LINV,axiom,
    ! [X] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ).

fof(aTREALu_MULu_SYM,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X)))))) ).

fof(aTREALu_MULu_ASSOC,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0))))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),Z0)))))) ).

fof(aTREALu_MULu_LID,axiom,
    ! [X] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),X)))) ).

fof(aTREALu_ADDu_LDISTRIB,axiom,
    ! [X,Y,Z0] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0))))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Z0)))))))) ).

fof(aTREALu_LEu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),X)))) ).

fof(aTREALu_LEu_ANTISYM,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X)))) )
    <=> p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y)))) ) ).

fof(aTREALu_LEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0)))) )
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Z0)))) ) ).

fof(aTREALu_LEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
      | p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),X)))) ) ).

fof(aTREALu_LEu_LADDu_IMP,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),Y))),s(prod(hreal,hreal),Z0))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Z0)))))) ) ).

fof(aTREALu_LEu_MUL,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(prod(hreal,hreal),X))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(prod(hreal,hreal),Y)))) )
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y)))))) ) ).

fof(aTREALu_INVu_0,axiom,
    p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ).

fof(aTREALu_MULu_LINV,axiom,
    ! [X] :
      ( ~ p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aTREALu_OFu_NUMu_WELLDEF,axiom,
    ! [M0,N0] :
      ( s(num,M0) = s(num,N0)
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,M0))))),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,N0)))))) ) ).

fof(aTREALu_NEGu_WELLDEF,axiom,
    ! [X1,X2] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),X1))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),X2)))))) ) ).

fof(aTREALu_ADDu_WELLDEFR,axiom,
    ! [X1,X2,Y] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X2))),s(prod(hreal,hreal),Y)))))) ) ).

fof(aTREALu_ADDu_WELLDEF,axiom,
    ! [X1,X2,Y1,Y2] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),Y1))),s(prod(hreal,hreal),Y2)))) )
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X2))),s(prod(hreal,hreal),Y2)))))) ) ).

fof(aTREALu_MULu_WELLDEFR,axiom,
    ! [X1,X2,Y] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X2))),s(prod(hreal,hreal),Y)))))) ) ).

fof(aTREALu_MULu_WELLDEF,axiom,
    ! [X1,X2,Y1,Y2] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),Y1))),s(prod(hreal,hreal),Y2)))) )
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X2))),s(prod(hreal,hreal),Y2)))))) ) ).

fof(aTREALu_EQu_IMPu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y)))) ) ).

fof(aTREALu_LEu_WELLDEF,axiom,
    ! [X1,X2,Y1,Y2] :
      ( ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),X2))))
        & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),Y1))),s(prod(hreal,hreal),Y2)))) )
     => s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))) = s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X2))),s(prod(hreal,hreal),Y2))) ) ).

fof(aTREALu_INVu_WELLDEF,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),X))),s(prod(hreal,hreal),Y))))
     => p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),Y)))))) ) ).

fof(arealu_ofu_num,axiom,
    ! [U_0] :
      ( ! [U] : s(bool,i(s(fun(prod(hreal,hreal),bool),U_0),s(prod(hreal,hreal),U))) = s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,m))))),s(prod(hreal,hreal),U)))
     => s(real,i(s(fun(num,real),realu_ofu_num),s(num,m))) = s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),U_0))) ) ).

fof(arealu_ofu_numu_th,axiom,
    s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(num,prod(hreal,hreal)),trealu_ofu_num),s(num,m))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,m))) ).

fof(arealu_neg,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),U_0),s(prod(hreal,hreal),U))))
        <=> ? [X1] :
              ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),X1))))),s(prod(hreal,hreal),U))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,x1))),s(prod(hreal,hreal),X1)))) ) )
     => s(real,i(s(fun(real,real),realu_neg),s(real,x1))) = s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),U_0))) ) ).

fof(arealu_negu_th,axiom,
    s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_neg),s(prod(hreal,hreal),x1))))))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),x1))))))) ).

fof(arealu_add,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),U_0),s(prod(hreal,hreal),U))))
        <=> ? [X1,Y1] :
              ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))))),s(prod(hreal,hreal),U))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,x1))),s(prod(hreal,hreal),X1))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,y1))),s(prod(hreal,hreal),Y1)))) ) )
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,x1))),s(real,y1))) = s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),U_0))) ) ).

fof(arealu_addu_th,axiom,
    s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_add),s(prod(hreal,hreal),x1))),s(prod(hreal,hreal),y1))))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),x1))))))),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),y1))))))) ).

fof(arealu_mul,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),U_0),s(prod(hreal,hreal),U))))
        <=> ? [X1,Y1] :
              ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))))),s(prod(hreal,hreal),U))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,x1))),s(prod(hreal,hreal),X1))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,y1))),s(prod(hreal,hreal),Y1)))) ) )
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y1))) = s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),U_0))) ) ).

fof(arealu_mulu_th,axiom,
    s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),prod(hreal,hreal))),trealu_mul),s(prod(hreal,hreal),x1))),s(prod(hreal,hreal),y1))))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),x1))))))),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),y1))))))) ).

fof(arealu_le,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(bool,bool),U_0),s(bool,U))))
        <=> ? [X1,Y1] :
              ( s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),X1))),s(prod(hreal,hreal),Y1))) = s(bool,U)
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,x1))),s(prod(hreal,hreal),X1))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,y1))),s(prod(hreal,hreal),Y1)))) ) )
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,x1))),s(real,y1))) = s(bool,i(s(fun(fun(bool,bool),bool),h_),s(fun(bool,bool),U_0))) ) ).

fof(arealu_leu_th,axiom,
    s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_le),s(prod(hreal,hreal),x1))),s(prod(hreal,hreal),y1))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),x1))))))),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),y1))))))) ).

fof(arealu_inv,axiom,
    ! [U_0] :
      ( ! [U] :
          ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),U_0),s(prod(hreal,hreal),U))))
        <=> ? [X] :
              ( p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),X))))),s(prod(hreal,hreal),U))))
              & p(s(bool,i(s(fun(prod(hreal,hreal),bool),i(s(fun(real,fun(prod(hreal,hreal),bool)),destu_real),s(real,x))),s(prod(hreal,hreal),X)))) ) )
     => s(real,i(s(fun(real,real),realu_inv),s(real,x))) = s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),U_0))) ) ).

fof(arealu_invu_th,axiom,
    s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),i(s(fun(prod(hreal,hreal),prod(hreal,hreal)),trealu_inv),s(prod(hreal,hreal),x))))))) = s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(fun(prod(hreal,hreal),bool),real),mku_real),s(fun(prod(hreal,hreal),bool),i(s(fun(prod(hreal,hreal),fun(prod(hreal,hreal),bool)),trealu_eq),s(prod(hreal,hreal),x))))))) ).

fof(aREALu_ADDu_SYM,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,X))) ).

fof(aREALu_ADDu_ASSOC,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,Z0))) ).

fof(aREALu_ADDu_LID,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) = s(real,X) ).

fof(aREALu_ADDu_LINV,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_MULu_SYM,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,X))) ).

fof(aREALu_MULu_ASSOC,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,Z0))) ).

fof(aREALu_MULu_LID,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))) = s(real,X) ).

fof(aREALu_ADDu_LDISTRIB,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))) ).

fof(aREALu_LEu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,X)))) ).

fof(aREALu_LEu_ANTISYM,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) )
    <=> s(real,X) = s(real,Y) ) ).

fof(aREALu_LEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Z0)))) ) ).

fof(aREALu_LEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LEu_LADDu_IMP,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LEu_MUL,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_INVu_0,axiom,
    s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_MULu_LINV,axiom,
    ! [X] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aREALu_OFu_NUMu_EQ,axiom,
    ! [M0,N0] :
      ( s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aREALu_OFu_NUMu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aREALu_OFu_NUMu_ADD,axiom,
    ! [M0,N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aREALu_OFu_NUMu_MUL,axiom,
    ! [M0,N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(arealu_sub,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) ).

fof(arealu_lt,axiom,
    ! [Y,X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
    <=> ~ p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) ) ).

fof(arealu_ge,axiom,
    ! [Y,X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_ge),s(real,X))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X))) ).

fof(arealu_gt,axiom,
    ! [Y,X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_gt),s(real,X))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X))) ).

fof(arealu_abs,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) ).

fof(aREALu_POLYu_CLAUSESu_conjunct9,axiom,
    ! [X,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) ).

fof(aREALu_POLYu_CLAUSESu_conjunct8,axiom,
    ! [X] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(arealu_powu_conjunct0,axiom,
    s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,x))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(arealu_powu_conjunct1,axiom,
    ! [N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,x))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,x))),s(num,N0))))) ).

fof(arealu_div,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))) ).

fof(arealu_max,axiom,
    ! [N0,M0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,M0))),s(real,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,M0))),s(real,N0))))),s(real,N0))),s(real,M0))) ).

fof(arealu_min,axiom,
    ! [M0,N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,M0))),s(real,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,M0))),s(real,N0))))),s(real,M0))),s(real,N0))) ).

fof(aREALu_HREALu_LEMMA1,axiom,
    ? [R0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        <=> ? [Y] : s(real,X) = s(real,i(s(fun(hreal,real),R0),s(hreal,Y))) )
      & ! [Y,Z0] : s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,Y))),s(hreal,Z0))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(hreal,real),R0),s(hreal,Y))))),s(real,i(s(fun(hreal,real),R0),s(hreal,Z0))))) ) ).

fof(aREALu_HREALu_LEMMA2,axiom,
    ? [H0,R0] :
      ( ! [X] : s(hreal,i(s(fun(real,hreal),H0),s(real,i(s(fun(hreal,real),R0),s(hreal,X))))) = s(hreal,X)
      & ! [X] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
         => s(real,i(s(fun(hreal,real),R0),s(hreal,i(s(fun(real,hreal),H0),s(real,X))))) = s(real,X) )
      & ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(hreal,real),R0),s(hreal,X))))))
      & ! [X,Y] : s(bool,i(s(fun(hreal,bool),i(s(fun(hreal,fun(hreal,bool)),hrealu_le),s(hreal,X))),s(hreal,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(hreal,real),R0),s(hreal,X))))),s(real,i(s(fun(hreal,real),R0),s(hreal,Y))))) ) ).

fof(aREALu_COMPLETEu_SOMEPOS,axiom,
    ! [P0] :
      ( ( ? [X] :
            ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
            & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X)))) )
        & ? [M0] :
          ! [X] :
            ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,M0)))) ) )
     => ? [M0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,M0)))) )
          & ! [MI_] :
              ( ! [X] :
                  ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
                 => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,MI_)))) )
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,M0))),s(real,MI_)))) ) ) ) ).

fof(aREALu_ADDu_RID,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,X) ).

fof(aREALu_ADDu_RINV,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_COMPLETE,axiom,
    ! [P0] :
      ( ( ? [X] : p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
        & ? [M0] :
          ! [X] :
            ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,M0)))) ) )
     => ? [M0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,M0)))) )
          & ! [MI_] :
              ( ! [X] :
                  ( p(s(bool,i(s(fun(real,bool),P0),s(real,X))))
                 => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,MI_)))) )
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,M0))),s(real,MI_)))) ) ) ) ).

fof(aREALu_ADDu_ACu_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,m))),s(real,n))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,n))),s(real,m))) ).

fof(aREALu_ADDu_ACu_conjunct1,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,m))),s(real,n))))),s(real,p1))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,m))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,n))),s(real,p1))))) ).

fof(aREALu_ADDu_ACu_conjunct2,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,m))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,n))),s(real,p1))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,n))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,m))),s(real,p1))))) ).

fof(aREALu_EQu_ADDu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))
    <=> s(real,Y) = s(real,Z0) ) ).

fof(aREALu_EQu_ADDu_RCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0)))
    <=> s(real,X) = s(real,Y) ) ).

fof(aREALu_MULu_RZERO,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_MULu_LZERO,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_NEGNEG,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(real,X) ).

fof(aREALu_MULu_RNEG,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) ).

fof(aREALu_MULu_LNEG,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,Y))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) ).

fof(aREALu_NEGu_ADD,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) ).

fof(aREALu_NEGu_0,axiom,
    s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_LEu_LNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) ).

fof(aREALu_LEu_NEG2,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X))) ).

fof(aREALu_LEu_RNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aREALu_OFu_NUMu_POW,axiom,
    ! [X,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),realu_ofu_num),s(num,X))))),s(num,N0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))) ).

fof(aREALu_POWu_NEG,axiom,
    ! [X,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(num,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(num,bool),even),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))))) ).

fof(aREALu_ABSu_NUM,axiom,
    ! [N0] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))) ).

fof(aREALu_ABSu_NEG,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(real,i(s(fun(real,real),realu_abs),s(real,X))) ).

fof(aREALu_LTEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LETu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LTu_IMPu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_LTEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0)))) ) ).

fof(aREALu_LETu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0)))) ) ).

fof(aREALu_LTu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0)))) ) ).

fof(aREALu_LEu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_LTEu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_SUBu_LE,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X))) ).

fof(aREALu_NEGu_SUB,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))) ).

fof(aREALu_LEu_LT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        | s(real,X) = s(real,Y) ) ) ).

fof(aREALu_SUBu_LT,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X))) ).

fof(aREALu_NOTu_LT,axiom,
    ! [X,Y] :
      ( ~ p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_SUBu_0,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,Y) ) ).

fof(aREALu_LTu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & s(real,X) != s(real,Y) ) ) ).

fof(aREALu_LTu_REFL,axiom,
    ! [X] : ~ p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,X)))) ).

fof(aREALu_LTEu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_LETu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_LTu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_ENTIRE,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(real,Y) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aREALu_LEu_NEGTOTAL,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_neg),s(real,X)))))) ) ).

fof(aREALu_LEu_SQUARE,axiom,
    ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,X)))))) ).

fof(aREALu_MULu_RID,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,X) ).

fof(aREALu_POWu_2,axiom,
    ! [X] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,X))) ).

fof(aREALu_NEGu_MINUS1,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_neg),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,X))) ).

fof(aREALu_POLYu_NEGu_CLAUSESu_conjunct1,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,Y))))) ).

fof(aREALu_POS,axiom,
    ! [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))))) ).

fof(aREALu_OFu_NUMu_LT,axiom,
    ! [M0,N0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aREALu_OFu_NUMu_GE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_ge),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,M0))),s(num,N0))) ).

fof(aREALu_OFu_NUMu_GT,axiom,
    ! [M0,N0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_gt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,M0))),s(num,N0))) ).

fof(aREALu_OFu_NUMu_MAX,axiom,
    ! [M0,N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),max),s(num,M0))),s(num,N0))))) ).

fof(aREALu_OFu_NUMu_MIN,axiom,
    ! [M0,N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),min),s(num,M0))),s(num,N0))))) ).

fof(aREALu_OFu_NUMu_SUC,axiom,
    ! [N0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),suc),s(num,N0))))) ).

fof(aREALu_OFu_NUMu_SUB,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,M0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,M0))))) ) ).

fof(aREALu_MULu_ACu_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,m))),s(real,n))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,n))),s(real,m))) ).

fof(aREALu_MULu_ACu_conjunct1,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,m))),s(real,n))))),s(real,p1))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,m))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,n))),s(real,p1))))) ).

fof(aREALu_MULu_ACu_conjunct2,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,m))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,n))),s(real,p1))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,n))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,m))),s(real,p1))))) ).

fof(aREALu_ADDu_RDISTRIB,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,Z0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) ).

fof(aREALu_LTu_LADDu_IMP,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_MUL,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_EQu_ADDu_LCANCELu_0,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,X)
    <=> s(real,Y) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_EQu_ADDu_RCANCELu_0,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,Y)
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_LNEGu_UNIQ,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,i(s(fun(real,real),realu_neg),s(real,Y))) ) ).

fof(aREALu_RNEGu_UNIQ,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,Y) = s(real,i(s(fun(real,real),realu_neg),s(real,X))) ) ).

fof(aREALu_NEGu_LMUL,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,Y))) ).

fof(aREALu_NEGu_RMUL,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) ).

fof(aREALu_NEGu_MUL2,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) ).

fof(aREALu_LTu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0))) ).

fof(aREALu_LTu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))) ).

fof(aREALu_LTu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LTu_GT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
     => ~ p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_NOTu_EQ,axiom,
    ! [X,Y] :
      ( s(real,X) != s(real,Y)
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ) ).

fof(aREALu_NOTu_LE,axiom,
    ! [X,Y] :
      ( ~ p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LETu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_NEGu_LT0,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_NEGu_GT0,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aREALu_NEGu_LE0,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_NEGu_GE0,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aREALu_LTu_TOTAL,axiom,
    ! [X,Y] :
      ( s(real,X) = s(real,Y)
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X)))) ) ).

fof(aREALu_LTu_NEGTOTAL,axiom,
    ! [X] :
      ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_neg),s(real,X)))))) ) ).

fof(aREALu_LEu_01,axiom,
    p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ).

fof(aREALu_LTu_01,axiom,
    p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ).

fof(aREALu_LEu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0))) ).

fof(aREALu_LEu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))) ).

fof(aREALu_LTu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LEu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_LNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) ).

fof(aREALu_LTu_RNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aREALu_LTu_ADDNEG,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Z0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,Z0))))),s(real,X))) ).

fof(aREALu_LTu_ADDNEG2,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))))),s(real,Z0))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Z0))),s(real,Y))))) ).

fof(aREALu_LTu_ADD1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))))) ) ).

fof(aREALu_SUBu_ADD,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))),s(real,Y))) = s(real,X) ).

fof(aREALu_SUBu_ADD2,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(real,X) ).

fof(aREALu_SUBu_REFL,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_LEu_DOUBLE,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_LEu_NEGL,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,X))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_LEu_NEGR,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aREALu_NEGu_EQu_0,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_neg),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_ADDu_SUB,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,X))) = s(real,Y) ).

fof(aREALu_NEGu_EQ,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),realu_neg),s(real,X))) = s(real,Y)
    <=> s(real,X) = s(real,i(s(fun(real,real),realu_neg),s(real,Y))) ) ).

fof(aREALu_LTu_IMPu_NE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
     => s(real,X) != s(real,Y) ) ).

fof(aREALu_LEu_ADDR,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))) ).

fof(aREALu_LEu_ADDL,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_LTu_ADDR,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))) ).

fof(aREALu_LTu_ADDL,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_SUBu_SUB,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))),s(real,X))) = s(real,i(s(fun(real,real),realu_neg),s(real,Y))) ).

fof(aREALu_LTu_ADDu_SUB,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,Z0))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Z0))),s(real,Y))))) ).

fof(aREALu_LTu_SUBu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))),s(real,Z0))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Z0))),s(real,Y))))) ).

fof(aREALu_LTu_SUBu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))),s(real,Y))) ).

fof(aREALu_LEu_SUBu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))))),s(real,Y))) ).

fof(aREALu_LEu_SUBu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))),s(real,Z0))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Z0))),s(real,Y))))) ).

fof(aREALu_LTu_NEG2,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,X))) ).

fof(aREALu_ADD2u_SUB2,axiom,
    ! [A5,B0,C0,D0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,A5))),s(real,B0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,C0))),s(real,D0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,A5))),s(real,C0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,B0))),s(real,D0))))) ).

fof(aREALu_SUBu_LZERO,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) = s(real,i(s(fun(real,real),realu_neg),s(real,X))) ).

fof(aREALu_SUBu_RZERO,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,X) ).

fof(aREALu_LETu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTEu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_SUBu_LNEG,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,Y))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) ).

fof(aREALu_SUBu_RNEG,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))) ).

fof(aREALu_SUBu_NEG2,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))) ).

fof(aREALu_SUBu_TRIANGLE,axiom,
    ! [A5,B0,C0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,A5))),s(real,B0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,B0))),s(real,C0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,A5))),s(real,C0))) ).

fof(aREALu_EQu_SUBu_LADD,axiom,
    ! [X,Y,Z0] :
      ( s(real,X) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,Z0)))
    <=> s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Z0))) = s(real,Y) ) ).

fof(aREALu_EQu_SUBu_RADD,axiom,
    ! [X,Y,Z0] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))) = s(real,Z0)
    <=> s(real,X) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,Z0))),s(real,Y))) ) ).

fof(aREALu_SUBu_SUB2,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(real,Y) ).

fof(aREALu_ADDu_SUB2,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),realu_neg),s(real,Y))) ).

fof(aREALu_EQu_IMPu_LE,axiom,
    ! [X,Y] :
      ( s(real,X) = s(real,Y)
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_POSu_NZ,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_DIFFSQ,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,X))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Y))))) ).

fof(aREALu_EQu_NEG2,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),realu_neg),s(real,X))) = s(real,i(s(fun(real,real),realu_neg),s(real,Y)))
    <=> s(real,X) = s(real,Y) ) ).

fof(aREALu_SUBu_LDISTRIB,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))) ).

fof(aREALu_SUBu_RDISTRIB,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))),s(real,Z0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) ).

fof(aREALu_ABSu_ZERO,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_ABSu_0,axiom,
    s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_ABSu_1,axiom,
    s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aREALu_ABSu_TRIANGLE,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,Y))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y)))))))) ).

fof(aREALu_ABSu_TRIANGLEu_LE,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))))))),s(real,Z0))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))),s(real,Z0)))) ) ).

fof(aREALu_ABSu_TRIANGLEu_LT,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))))))),s(real,Z0))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))),s(real,Z0)))) ) ).

fof(aREALu_ABSu_POS,axiom,
    ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_abs),s(real,X)))))) ).

fof(aREALu_ABSu_SUB,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))) ).

fof(aREALu_ABSu_NZ,axiom,
    ! [X] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_abs),s(real,X)))))) ) ).

fof(aREALu_ABSu_ABS,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),realu_abs),s(real,X))))) = s(real,i(s(fun(real,real),realu_abs),s(real,X))) ).

fof(aREALu_ABSu_LE,axiom,
    ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),realu_abs),s(real,X)))))) ).

fof(aREALu_ABSu_REFL,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,X)
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X)))) ) ).

fof(aREALu_ABSu_BETWEEN,axiom,
    ! [X,Y,D0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,D0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,D0))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,D0)))))) )
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))))),s(real,D0)))) ) ).

fof(aREALu_ABSu_BOUND,axiom,
    ! [X,Y,D0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))))),s(real,D0))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,D0)))))) ) ).

fof(aREALu_ABSu_STILLNZ,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))))
     => s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_ABSu_CASES,axiom,
    ! [X] :
      ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_abs),s(real,X)))))) ) ).

fof(aREALu_ABSu_BETWEEN1,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Z0))),s(real,X)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) ) ).

fof(aREALu_ABSu_SIGN2,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ).

fof(aREALu_ABSu_CIRCLE,axiom,
    ! [X,Y,H0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,H0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))),s(real,i(s(fun(real,real),realu_abs),s(real,X))))))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,H0))))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y)))))) ) ).

fof(aREALu_SUBu_ABS,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y)))))))) ).

fof(aREALu_ABSu_SUBu_ABS,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y)))))))) ).

fof(aREALu_ABSu_BETWEEN2,axiom,
    ! [X0,X,Y0,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X0))),s(real,Y0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,X0))))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y0))),s(real,X0))))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,Y0))))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y0))),s(real,X0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_ABSu_BOUNDS,axiom,
    ! [X,K0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,K0))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,K0))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,K0)))) ) ) ).

fof(aREALu_BOUNDSu_LE,axiom,
    ! [X,K0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_neg),s(real,K0))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,K0)))) )
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,K0)))) ) ).

fof(aREALu_BOUNDSu_LT,axiom,
    ! [X,K0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_neg),s(real,K0))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,K0)))) )
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,K0)))) ) ).

fof(aREALu_MINu_MAX,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))))) ).

fof(aREALu_MAXu_MIN,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(real,real),realu_neg),s(real,X))))),s(real,i(s(fun(real,real),realu_neg),s(real,Y))))))) ).

fof(aREALu_MAXu_MAX,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_MINu_MIN,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))),s(real,X))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))),s(real,Y)))) ) ).

fof(aREALu_MAXu_SYM,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,Y))),s(real,X))) ).

fof(aREALu_MINu_SYM,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,Y))),s(real,X))) ).

fof(aREALu_LEu_MAX,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,X))))
        | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,Y)))) ) ) ).

fof(aREALu_LEu_MIN,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Z0))),s(real,Y)))) ) ) ).

fof(aREALu_LTu_MAX,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,X))))
        | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,Y)))) ) ) ).

fof(aREALu_LTu_MIN,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Z0))),s(real,Y)))) ) ) ).

fof(aREALu_MAXu_LE,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))),s(real,Z0))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Z0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) ) ) ).

fof(aREALu_MINu_LE,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))),s(real,Z0))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Z0))))
        | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) ) ) ).

fof(aREALu_MAXu_LT,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))),s(real,Z0))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) ) ) ).

fof(aREALu_MINu_LT,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))),s(real,Z0))))
    <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Z0))))
        | p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) ) ) ).

fof(aREALu_MAXu_ASSOC,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,Y))))),s(real,Z0))) ).

fof(aREALu_MINu_ASSOC,axiom,
    ! [X,Y,Z0] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,Y))),s(real,Z0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,Y))))),s(real,Z0))) ).

fof(aREALu_MAXu_ACIu_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,y))),s(real,x))) ).

fof(aREALu_MAXu_ACIu_conjunct1,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,y))))),s(real,z))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,y))),s(real,z))))) ).

fof(aREALu_MAXu_ACIu_conjunct2,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,y))),s(real,z))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,z))))) ).

fof(aREALu_MAXu_ACIu_conjunct3,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,x))) = s(real,x) ).

fof(aREALu_MAXu_ACIu_conjunct4,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,x))),s(real,y))) ).

fof(aREALu_MINu_ACIu_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,y))),s(real,x))) ).

fof(aREALu_MINu_ACIu_conjunct1,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,y))))),s(real,z))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,y))),s(real,z))))) ).

fof(aREALu_MINu_ACIu_conjunct2,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,y))),s(real,z))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,z))))) ).

fof(aREALu_MINu_ACIu_conjunct3,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,x))) = s(real,x) ).

fof(aREALu_MINu_ACIu_conjunct4,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,x))),s(real,y))) ).

fof(aREALu_ABSu_MUL,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))) ).

fof(aREALu_POWu_LE,axiom,
    ! [X,N0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LT,axiom,
    ! [X,N0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_ABSu_POW,axiom,
    ! [X,N0] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(num,N0))) ).

fof(aREALu_LEu_LMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LEu_RMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_LMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_RMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0)))))) ) ).

fof(aREALu_EQu_MULu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(real,Y) = s(real,Z0) ) ) ).

fof(aREALu_EQu_MULu_RCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0)))
    <=> ( s(real,X) = s(real,Y)
        | s(real,Z0) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aREALu_MULu_LINVu_UNIQ,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
     => s(real,i(s(fun(real,real),realu_inv),s(real,Y))) = s(real,X) ) ).

fof(aREALu_MULu_RINVu_UNIQ,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
     => s(real,i(s(fun(real,real),realu_inv),s(real,X))) = s(real,Y) ) ).

fof(aREALu_INVu_INV,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(real,X) ).

fof(aREALu_EQu_INV2,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),realu_inv),s(real,X))) = s(real,i(s(fun(real,real),realu_inv),s(real,Y)))
    <=> s(real,X) = s(real,Y) ) ).

fof(aREALu_INVu_EQu_0,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_inv),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_LTu_INV,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_LTu_INVu_EQ,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_INVu_NEG,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) ).

fof(aREALu_LEu_INVu_EQ,axiom,
    ! [X] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ).

fof(aREALu_LEu_INV,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_MULu_RINV,axiom,
    ! [X] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aREALu_INVu_1,axiom,
    s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aREALu_INVu_EQu_1,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_inv),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aREALu_DIVu_1,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,X) ).

fof(aREALu_DIVu_REFL,axiom,
    ! [X] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aREALu_DIVu_RMUL,axiom,
    ! [X,Y] :
      ( s(real,Y) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))),s(real,Y))) = s(real,X) ) ).

fof(aREALu_DIVu_LMUL,axiom,
    ! [X,Y] :
      ( s(real,Y) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))) = s(real,X) ) ).

fof(aREALu_ABSu_INV,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(real,real),realu_abs),s(real,X))))) ).

fof(aREALu_ABSu_DIV,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))) ).

fof(aREALu_INVu_MUL,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))) ).

fof(aREALu_INVu_DIV,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,X))) ).

fof(aREALu_POWu_MUL,axiom,
    ! [X,Y,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(num,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))))) ).

fof(aREALu_POWu_INV,axiom,
    ! [X,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(num,N0))) = s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) ).

fof(aREALu_INVu_POW,axiom,
    ! [X,N0] : s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(num,N0))) ).

fof(aREALu_POWu_DIV,axiom,
    ! [X,Y,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))),s(num,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))))) ).

fof(aREALu_DIVu_EQu_0,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(real,Y) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aREALu_POWu_ADD,axiom,
    ! [X,M0,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) ).

fof(aREALu_POWu_NZ,axiom,
    ! [X,N0] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_POWu_SUB,axiom,
    ! [X,M0,N0] :
      ( ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) )
     => s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,M0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))) ) ).

fof(aREALu_LTu_LCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) ) ).

fof(aREALu_LTu_RCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_LEu_LCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) ) ).

fof(aREALu_LEu_RCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_LEu_RMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))) ) ).

fof(aREALu_LEu_LMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,X))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))) ) ).

fof(aREALu_LTu_RMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))) ) ).

fof(aREALu_LTu_LMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,X))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))) ) ).

fof(aREALu_LEu_MULu_EQu_conjunct0,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))) ) ).

fof(aREALu_LEu_MULu_EQu_conjunct1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ) ).

fof(aREALu_LTu_MULu_EQu_conjunct0,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))) ) ).

fof(aREALu_LTu_MULu_EQu_conjunct1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))) ) ).

fof(aREALu_MULu_POSu_LT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))))
    <=> ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
        | ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ) ) ).

fof(aREALu_MULu_POSu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(real,Y) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
        | ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ) ) ).

fof(aREALu_LEu_RDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,Y))) ) ).

fof(aREALu_LEu_LDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Z0))))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) ) ).

fof(aREALu_LTu_RDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))))),s(real,Y))) ) ).

fof(aREALu_LTu_LDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Z0))))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))))) ) ).

fof(aREALu_EQu_RDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => ( s(real,X) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,Z0)))
      <=> s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))) = s(real,Y) ) ) ).

fof(aREALu_EQu_LDIVu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Z0))) = s(real,Y)
      <=> s(real,X) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))) ) ) ).

fof(aREALu_LTu_DIV2u_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))) ) ).

fof(aREALu_LEu_DIV2u_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Z0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Z0))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,Y))),s(real,Z0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))) ) ).

fof(aREALu_MULu_2,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,X))),s(real,X))) ).

fof(aREALu_POWu_EQu_0,axiom,
    ! [X,N0] :
      ( s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aREALu_LEu_MUL2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,W))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_MUL2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,W))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,W))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,Z0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,W))),s(real,Y))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0)))))) ) ).

fof(aREALu_LTu_SQUARE,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,X))))))
    <=> s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_POWu_1,axiom,
    ! [X] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(real,X) ).

fof(aREALu_POWu_ONE,axiom,
    ! [N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aREALu_LTu_INV2,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_LEu_INV2,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_LTu_LINV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))),s(real,X)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,Y)))) ) ).

fof(aREALu_LTu_RINV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(real,real),realu_inv),s(real,Y)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_LEu_LINV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))),s(real,X)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,Y)))) ) ).

fof(aREALu_LEu_RINV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(real,real),realu_inv),s(real,Y)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_INVu_LEu_1,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aREALu_INVu_1u_LE,axiom,
    ! [X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_INVu_LTu_1,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aREALu_INVu_1u_LT,axiom,
    ! [X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(real,real),realu_inv),s(real,X)))))) ) ).

fof(aREALu_SUBu_INV,axiom,
    ! [X,Y] :
      ( ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(real,Y) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) )
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),realu_inv),s(real,X))))),s(real,i(s(fun(real,real),realu_inv),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,Y))),s(real,X))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) ) ).

fof(aRealu_exto_REALu_INV2u_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aREALu_DOWN,axiom,
    ! [D0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,D0))))
     => ? [E0] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,E0))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,E0))),s(real,D0)))) ) ) ).

fof(aREALu_DOWN2,axiom,
    ! [D1,D2] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,D1))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,D2)))) )
     => ? [E0] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,E0))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,E0))),s(real,D1))))
          & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,E0))),s(real,D2)))) ) ) ).

fof(aREALu_POWu_LE2,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LEu_1,axiom,
    ! [N0,X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))))
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_1u_LE,axiom,
    ! [N0,X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aREALu_POWu_MONO,axiom,
    ! [M0,N0,X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LT2,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LTu_1,axiom,
    ! [N0,X] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_1u_LT,axiom,
    ! [N0,X] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aREALu_POWu_MONOu_LT,axiom,
    ! [M0,N0,X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,X))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_POW,axiom,
    ! [X,M0,N0] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aREALu_EQu_RCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( s(real,Z0) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Z0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Y))),s(real,Z0))) )
     => s(real,X) = s(real,Y) ) ).

fof(aREALu_EQu_LCANCELu_IMP,axiom,
    ! [X,Y,Z0] :
      ( ( s(real,Z0) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Z0))),s(real,Y))) )
     => s(real,X) = s(real,Y) ) ).

fof(aREALu_LTu_DIV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_LEu_DIV,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y)))))) ) ).

fof(aREALu_DIVu_POW2,axiom,
    ! [X,M0,N0] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,M0))))))))) ) ).

fof(aREALu_DIVu_POW2u_ALT,axiom,
    ! [X,M0,N0] :
      ( s(real,X) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,N0))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0))))))),s(real,i(s(fun(real,real),realu_inv),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,M0))))))))) ) ).

fof(aREALu_LTu_POW2,axiom,
    ! [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(num,N0)))))) ).

fof(aREALu_LEu_POW2,axiom,
    ! [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(num,N0)))))) ).

fof(aREALu_POW2u_ABS,axiom,
    ! [X] : s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ).

fof(aREALu_LEu_SQUAREu_ABS,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ).

fof(aREALu_LTu_SQUAREu_ABS,axiom,
    ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,Y))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ).

fof(aREALu_EQu_SQUAREu_ABS,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(real,real),realu_abs),s(real,Y)))
    <=> s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ) ).

fof(aREALu_LEu_POWu_2,axiom,
    ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))))) ).

fof(aREALu_SOSu_EQu_0,axiom,
    ! [X,Y] :
      ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(real,Y) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aREALu_POWu_ZERO,axiom,
    ! [N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
      & s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(num,N0))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,V))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ) ).

fof(aREALu_POWu_MONOu_INV,axiom,
    ! [M0,N0,X] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,M0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,M0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LE2u_REV,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_POWu_LT2u_REV,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_POWu_EQ,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,Y))))
        & s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))) )
     => s(real,X) = s(real,Y) ) ).

fof(aREALu_POWu_EQu_ABS,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))) )
     => s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(real,real),realu_abs),s(real,Y))) ) ).

fof(aREALu_POWu_EQu_1u_IMP,axiom,
    ! [X,N0] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) )
     => s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aREALu_POWu_EQu_1,axiom,
    ! [X,N0] :
      ( s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
    <=> ( ( s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
          & ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
           => p(s(bool,i(s(fun(num,bool),even),s(num,N0)))) ) )
        | s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aREALu_POWu_LT2u_ODD,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LE2u_ODD,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
        & p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))))) ) ).

fof(aREALu_POWu_LT2u_ODDu_EQ,axiom,
    ! [N0,X,Y] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))) ) ).

fof(aREALu_POWu_LE2u_ODDu_EQ,axiom,
    ! [N0,X,Y] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
     => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))))),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))) ) ).

fof(aREALu_POWu_EQu_ODDu_EQ,axiom,
    ! [N0,X,Y] :
      ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
     => ( s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))
      <=> s(real,X) = s(real,Y) ) ) ).

fof(aREALu_POWu_EQu_ODD,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(num,bool),odd),s(num,N0))))
        & s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0))) )
     => s(real,X) = s(real,Y) ) ).

fof(aREALu_POWu_EQu_EQ,axiom,
    ! [N0,X,Y] :
      ( s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,X))),s(num,N0))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,Y))),s(num,N0)))
    <=> ? [V] :
          ( ( p(s(bool,V))
          <=> ( s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
              | s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(real,real),realu_abs),s(real,Y))) ) )
          & ? [VI_] :
              ( ( p(s(bool,VI_))
              <=> s(real,X) = s(real,Y) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,i(s(fun(num,bool),even),s(num,N0))))),s(bool,V))),s(bool,VI_)))) ) ) ) ).

fof(aREALu_ARCHu_SIMPLE,axiom,
    ! [X] :
    ? [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))))) ).

fof(aREALu_ARCHu_LT,axiom,
    ! [X] :
    ? [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))))) ).

fof(aREALu_ARCH,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))
     => ! [Y] :
        ? [N0] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,Y))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))),s(real,X)))))) ) ).

fof(arealu_sgn,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))) ).

fof(aREALu_SGNu_0,axiom,
    s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aREALu_SGNu_NEG,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(real,real),realu_neg),s(real,X))))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(real,real),realu_sgn),s(real,X))))) ).

fof(aREALu_SGNu_ABS,axiom,
    ! [X] : s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_sgn),s(real,X))))),s(real,i(s(fun(real,real),realu_abs),s(real,X))))) = s(real,X) ).

fof(aREALu_ABSu_SGN,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),realu_sgn),s(real,X))))) = s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(real,real),realu_abs),s(real,X))))) ).

fof(aREALu_SGN,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,i(s(fun(real,real),realu_abs),s(real,X))))) ).

fof(aREALu_SGNu_MUL,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_sgn),s(real,X))))),s(real,i(s(fun(real,real),realu_sgn),s(real,Y))))) ).

fof(aREALu_SGNu_INV,axiom,
    ! [X] : s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(real,real),realu_inv),s(real,X))))) = s(real,i(s(fun(real,real),realu_sgn),s(real,X))) ).

fof(aREALu_SGNu_DIV,axiom,
    ! [X,Y] : s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,X))),s(real,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(real,real),realu_sgn),s(real,X))))),s(real,i(s(fun(real,real),realu_sgn),s(real,Y))))) ).

fof(aREALu_SGNu_EQu_conjunct0,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(real,X) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aREALu_SGNu_EQu_conjunct1,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_gt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ).

fof(aREALu_SGNu_EQu_conjunct2,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ).

fof(aREALu_SGNu_CASES,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
      | s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ) ).

fof(aREALu_WLOGu_LE,axiom,
    ( ( ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,Y))),s(real,X)))
      & ! [X,Y] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,Y))))
         => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y)))) ) )
   => ! [X,Y] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y)))) ) ).

fof(aREALu_WLOGu_LT,axiom,
    ( ( ! [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,X))))
      & ! [X,Y] : s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,Y))),s(real,X)))
      & ! [X,Y] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,Y))))
         => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y)))) ) )
   => ! [X,Y] : p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),p0),s(real,X))),s(real,Y)))) ) ).

fof(aDECIMAL,axiom,
    ! [X,Y] : s(real,i(s(fun(num,real),i(s(fun(num,fun(num,real)),decimal),s(num,X))),s(num,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,i(s(fun(num,real),realu_ofu_num),s(num,X))))),s(real,i(s(fun(num,real),realu_ofu_num),s(num,Y))))) ).

fof(aCollectu_geomo_PERu_MUL3u_conjunct0,axiom,
    s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,a0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,b0))),s(real,c))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,b0))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,a0))),s(real,c))))) ).

fof(aRATu_LEMMA1,axiom,
    ( ( s(real,y1) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      & s(real,y2) != s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) )
   => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x1))),s(real,y1))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x2))),s(real,y2))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y2))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x2))),s(real,y1))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,y1))))),s(real,i(s(fun(real,real),realu_inv),s(real,y2))))))) ) ).

fof(aRATu_LEMMA2,axiom,
    ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y1))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y2)))) )
   => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x1))),s(real,y1))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x2))),s(real,y2))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y2))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x2))),s(real,y1))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,y1))))),s(real,i(s(fun(real,real),realu_inv),s(real,y2))))))) ) ).

fof(aRATu_LEMMA3,axiom,
    ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y1))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y2)))) )
   => s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x1))),s(real,y1))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x2))),s(real,y2))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y2))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x2))),s(real,y1))))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(real,real),realu_inv),s(real,y1))))),s(real,i(s(fun(real,real),realu_inv),s(real,y2))))))) ) ).

fof(aRATu_LEMMA4,axiom,
    ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y1))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y2)))) )
   => s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x1))),s(real,y1))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x2))),s(real,y2))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y2))))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x2))),s(real,y1))))) ) ).

fof(aRATu_LEMMA5,axiom,
    ( ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y1))))
      & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(num,real),realu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(real,y2)))) )
   => ( s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x1))),s(real,y1))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_div),s(real,x2))),s(real,y2)))
    <=> s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x1))),s(real,y2))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,x2))),s(real,y1))) ) ) ).

fof(ainteger,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(real,bool),integer),s(real,X))))
    <=> ? [N0] : s(real,i(s(fun(real,real),realu_abs),s(real,X))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))) ) ).

fof(aisu_int,axiom,
    ( p(s(bool,i(s(fun(real,bool),integer),s(real,x))))
  <=> ? [N0] :
        ( s(real,x) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))
        | s(real,x) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) ) ) ).

fof(aintu_abstr,axiom,
    s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(int,real),realu_ofu_int),s(int,a0))))) = s(int,a0) ).

fof(aintu_rep,axiom,
    ( p(s(bool,i(s(fun(real,bool),integer),s(real,r0))))
  <=> s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(real,int),intu_ofu_real),s(real,r0))))) = s(real,r0) ) ).

fof(aintu_tybiju_conjunct1,axiom,
    ! [R0] :
      ( p(s(bool,i(s(fun(real,bool),integer),s(real,R0))))
    <=> s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(real,int),intu_ofu_real),s(real,R0))))) = s(real,R0) ) ).

fof(aintu_tybiju_conjunct0,axiom,
    ! [A5] : s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(int,real),realu_ofu_int),s(int,A5))))) = s(int,A5) ).

fof(adestu_intu_rep,axiom,
    ! [I0] :
    ? [N0] :
      ( s(real,i(s(fun(int,real),realu_ofu_int),s(int,I0))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0)))
      | s(real,i(s(fun(int,real),realu_ofu_int),s(int,I0))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) ) ).

fof(aintu_eq,axiom,
    ! [X,Y] :
      ( s(int,X) = s(int,Y)
    <=> s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))) = s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))) ) ).

fof(aintu_le,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_lt,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_ge,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_ge),s(int,X))),s(int,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_ge),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_gt,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_gt),s(int,X))),s(int,Y))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_gt),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_ofu_num,axiom,
    ! [N0] : s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))))) ).

fof(aintu_ofu_numu_th,axiom,
    ! [N0] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(real,i(s(fun(num,real),realu_ofu_num),s(num,N0))) ).

fof(aintu_neg,axiom,
    ! [I0] : s(int,i(s(fun(int,int),intu_neg),s(int,I0))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(int,real),realu_ofu_int),s(int,I0))))))) ).

fof(aintu_negu_th,axiom,
    ! [X] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(real,i(s(fun(real,real),realu_neg),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))) ).

fof(aintu_add,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))))) ).

fof(aintu_addu_th,axiom,
    ! [X,Y] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_add),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_sub,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))))) ).

fof(aintu_subu_th,axiom,
    ! [X,Y] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_mul,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))))) ).

fof(aintu_mulu_th,axiom,
    ! [X,Y] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_abs,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))))) ).

fof(aintu_absu_th,axiom,
    ! [X] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),intu_abs),s(int,X))))) = s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))) ).

fof(aintu_sgn,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))))) ).

fof(aintu_sgnu_th,axiom,
    ! [X] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),intu_sgn),s(int,X))))) = s(real,i(s(fun(real,real),realu_sgn),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))) ).

fof(aintu_max,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))))) ).

fof(aintu_maxu_th,axiom,
    ! [X,Y] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_min,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))))) ).

fof(aintu_minu_th,axiom,
    ! [X,Y] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,Y))))) ).

fof(aintu_pow,axiom,
    ! [X,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))) = s(int,i(s(fun(real,int),intu_ofu_real),s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(num,N0))))) ).

fof(aintu_powu_th,axiom,
    ! [X,N0] : s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))) = s(real,i(s(fun(num,real),i(s(fun(real,fun(num,real)),realu_pow),s(real,i(s(fun(int,real),realu_ofu_int),s(int,X))))),s(num,N0))) ).

fof(aINTu_IMAGE,axiom,
    ! [X] :
      ( ? [N0] : s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0)))
      | ? [N0] : s(int,X) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) ) ).

fof(aINTu_LTu_DISCRETE,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,Y))) ).

fof(aINTu_GTu_DISCRETE,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_gt),s(int,X))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_ge),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ).

fof(aINTu_ABSu_0,axiom,
    s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_ABSu_1,axiom,
    s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aINTu_ABSu_ABS,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),intu_abs),s(int,X))))) = s(int,i(s(fun(int,int),intu_abs),s(int,X))) ).

fof(aINTu_ABSu_BETWEEN,axiom,
    ! [X,Y,D0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,D0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,D0))))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,D0)))))) )
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,X))))))),s(int,D0)))) ) ).

fof(aINTu_ABSu_BETWEEN1,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,X))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Z0))),s(int,X)))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) ) ).

fof(aINTu_ABSu_BETWEEN2,axiom,
    ! [X0,X,Y0,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X0))),s(int,Y0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,X0))))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y0))),s(int,X0))))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,Y0))))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y0))),s(int,X0)))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y)))) ) ).

fof(aINTu_ABSu_BOUND,axiom,
    ! [X,Y,D0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))))),s(int,D0))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,D0)))))) ) ).

fof(aINTu_ABSu_CASES,axiom,
    ! [X] :
      ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ) ).

fof(aINTu_ABSu_CIRCLE,axiom,
    ! [X,Y,H0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,H0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))),s(int,i(s(fun(int,int),intu_abs),s(int,X))))))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,H0))))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y)))))) ) ).

fof(aINTu_ABSu_LE,axiom,
    ! [X] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ).

fof(aINTu_ABSu_MUL,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))) ).

fof(aINTu_ABSu_NEG,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(int,i(s(fun(int,int),intu_abs),s(int,X))) ).

fof(aINTu_ABSu_NUM,axiom,
    ! [N0] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))) ).

fof(aINTu_ABSu_NZ,axiom,
    ! [X] :
      ( s(int,X) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ) ).

fof(aINTu_ABSu_POS,axiom,
    ! [X] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ).

fof(aINTu_ABSu_POW,axiom,
    ! [X,N0] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(num,N0))) ).

fof(aINTu_ABSu_REFL,axiom,
    ! [X] :
      ( s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,X)
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X)))) ) ).

fof(aINTu_ABSu_SGN,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),intu_sgn),s(int,X))))) = s(int,i(s(fun(int,int),intu_sgn),s(int,i(s(fun(int,int),intu_abs),s(int,X))))) ).

fof(aINTu_ABSu_SIGN,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))))),s(int,Y))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X)))) ) ).

fof(aINTu_ABSu_SIGN2,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ).

fof(aINTu_ABSu_STILLNZ,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))))
     => s(int,X) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_ABSu_SUB,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,X))))) ).

fof(aINTu_ABSu_SUBu_ABS,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))))))),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y)))))))) ).

fof(aINTu_ABSu_TRIANGLE,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y)))))))) ).

fof(aINTu_ABSu_ZERO,axiom,
    ! [X] :
      ( s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_ADD2u_SUB2,axiom,
    ! [A5,B0,C0,D0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,A5))),s(int,B0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,C0))),s(int,D0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,A5))),s(int,C0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,B0))),s(int,D0))))) ).

fof(aINTu_ADDu_ACu_conjunct0,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,m))),s(int,n))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,n))),s(int,m))) ).

fof(aINTu_ADDu_ACu_conjunct1,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,m))),s(int,n))))),s(int,p1))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,m))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,n))),s(int,p1))))) ).

fof(aINTu_ADDu_ACu_conjunct2,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,m))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,n))),s(int,p1))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,n))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,m))),s(int,p1))))) ).

fof(aINTu_ADDu_ASSOC,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,Z0))) ).

fof(aINTu_ADDu_LDISTRIB,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))) ).

fof(aINTu_ADDu_LID,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) = s(int,X) ).

fof(aINTu_ADDu_LINV,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_ADDu_RDISTRIB,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,Z0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0))))) ).

fof(aINTu_ADDu_RID,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,X) ).

fof(aINTu_ADDu_RINV,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_ADDu_SUB,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,X))) = s(int,Y) ).

fof(aINTu_ADDu_SUB2,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),intu_neg),s(int,Y))) ).

fof(aINTu_ADDu_SYM,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,X))) ).

fof(aINTu_BOUNDSu_LE,axiom,
    ! [X,K0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_neg),s(int,K0))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,K0)))) )
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,K0)))) ) ).

fof(aINTu_BOUNDSu_LT,axiom,
    ! [X,K0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_neg),s(int,K0))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,K0)))) )
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,K0)))) ) ).

fof(aINTu_DIFFSQ,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Y))))) ).

fof(aINTu_ENTIRE,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(int,Y) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aINTu_EQu_ADDu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))
    <=> s(int,Y) = s(int,Z0) ) ).

fof(aINTu_EQu_ADDu_LCANCELu_0,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,X)
    <=> s(int,Y) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_EQu_ADDu_RCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0)))
    <=> s(int,X) = s(int,Y) ) ).

fof(aINTu_EQu_ADDu_RCANCELu_0,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,Y)
    <=> s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_EQu_IMPu_LE,axiom,
    ! [X,Y] :
      ( s(int,X) = s(int,Y)
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y)))) ) ).

fof(aINTu_EQu_MULu_LCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0)))
    <=> ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(int,Y) = s(int,Z0) ) ) ).

fof(aINTu_EQu_MULu_RCANCEL,axiom,
    ! [X,Y,Z0] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0)))
    <=> ( s(int,X) = s(int,Y)
        | s(int,Z0) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aINTu_EQu_NEG2,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),intu_neg),s(int,X))) = s(int,i(s(fun(int,int),intu_neg),s(int,Y)))
    <=> s(int,X) = s(int,Y) ) ).

fof(aINTu_EQu_SQUAREu_ABS,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(int,int),intu_abs),s(int,Y)))
    <=> s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ) ).

fof(aINTu_EQu_SUBu_LADD,axiom,
    ! [X,Y,Z0] :
      ( s(int,X) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,Z0)))
    <=> s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))) = s(int,Y) ) ).

fof(aINTu_EQu_SUBu_RADD,axiom,
    ! [X,Y,Z0] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))) = s(int,Z0)
    <=> s(int,X) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Z0))),s(int,Y))) ) ).

fof(aINTu_LETu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LETu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,W))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,W))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LETu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LETu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LETu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0)))) ) ).

fof(aINTu_LEu_01,axiom,
    p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ).

fof(aINTu_LEu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LEu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,W))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,W))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LEu_ADDL,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_LEu_ADDR,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))) ).

fof(aINTu_LEu_ANTISYM,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) )
    <=> s(int,X) = s(int,Y) ) ).

fof(aINTu_LEu_DOUBLE,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,X))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_LEu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0))) ).

fof(aINTu_LEu_LADDu_IMP,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LEu_LMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LEu_LNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) ).

fof(aINTu_LEu_LT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        | s(int,X) = s(int,Y) ) ) ).

fof(aINTu_LEu_MAX,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,X))))
        | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,Y)))) ) ) ).

fof(aINTu_LEu_MIN,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Z0))),s(int,Y)))) ) ) ).

fof(aINTu_LEu_MUL,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LEu_MULu_EQu_conjunct1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ) ).

fof(aINTu_LEu_MULu_EQu_conjunct0,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))) ) ).

fof(aINTu_LEu_NEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X))) ).

fof(aINTu_LEu_NEGL,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,X))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_LEu_NEGR,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aINTu_LEu_NEGTOTAL,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_neg),s(int,X)))))) ) ).

fof(aINTu_LEu_POW2,axiom,
    ! [N0] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(num,N0)))))) ).

fof(aINTu_LEu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))) ).

fof(aINTu_LEu_REFL,axiom,
    ! [X] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,X)))) ).

fof(aINTu_LEu_RMUL,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0)))))) ) ).

fof(aINTu_LEu_RNEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aINTu_LEu_SQUARE,axiom,
    ! [X] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,X)))))) ).

fof(aINTu_LEu_SQUAREu_ABS,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ).

fof(aINTu_LEu_SUBu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))),s(int,Y))) ).

fof(aINTu_LEu_SUBu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))),s(int,Z0))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Z0))),s(int,Y))))) ).

fof(aINTu_LEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Z0)))) ) ).

fof(aINTu_LNEGu_UNIQ,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,X) = s(int,i(s(fun(int,int),intu_neg),s(int,Y))) ) ).

fof(aINTu_LTEu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LTEu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,W))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,W))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LTEu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LTEu_TOTAL,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LTEu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0)))) ) ).

fof(aINTu_LTu_01,axiom,
    p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ).

fof(aINTu_LTu_ADD,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LTu_ADD1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))))) ) ).

fof(aINTu_LTu_ADD2,axiom,
    ! [W,X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,W))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,W))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0)))))) ) ).

fof(aINTu_LTu_ADDL,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_LTu_ADDNEG,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Z0))))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0))))),s(int,X))) ).

fof(aINTu_LTu_ADDNEG2,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))))),s(int,Z0))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Z0))),s(int,Y))))) ).

fof(aINTu_LTu_ADDR,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))) ).

fof(aINTu_LTu_ADDu_SUB,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,Z0))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Z0))),s(int,Y))))) ).

fof(aINTu_LTu_ANTISYM,axiom,
    ! [X,Y] :
      ~ ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LTu_GT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
     => ~ p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LTu_IMPu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y)))) ) ).

fof(aINTu_LTu_IMPu_NE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
     => s(int,X) != s(int,Y) ) ).

fof(aINTu_LTu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0))) ).

fof(aINTu_LTu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & s(int,X) != s(int,Y) ) ) ).

fof(aINTu_LTu_LMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Z0))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Z0))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Z0))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))) ) ).

fof(aINTu_LTu_MAX,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,X))))
        | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,Y)))) ) ) ).

fof(aINTu_LTu_MIN,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Z0))),s(int,Y)))) ) ) ).

fof(aINTu_LTu_MUL,axiom,
    ! [X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_LTu_MULu_EQu_conjunct1,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ) ).

fof(aINTu_LTu_MULu_EQu_conjunct0,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))) ) ).

fof(aINTu_LTu_NEG,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X))) ).

fof(aINTu_LTu_NEGTOTAL,axiom,
    ! [X] :
      ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_neg),s(int,X)))))) ) ).

fof(aINTu_LTu_POW2,axiom,
    ! [N0] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(num,N0)))))) ).

fof(aINTu_LTu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))) ).

fof(aINTu_LTu_REFL,axiom,
    ! [X] : ~ p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,X)))) ).

fof(aINTu_LTu_RMULu_EQ,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Z0))))
     => s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))) ) ).

fof(aINTu_LTu_SQUAREu_ABS,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) ).

fof(aINTu_LTu_SUBu_LADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,Z0))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Z0))))),s(int,Y))) ).

fof(aINTu_LTu_SUBu_RADD,axiom,
    ! [X,Y,Z0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))),s(int,Z0))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Z0))),s(int,Y))))) ).

fof(aINTu_LTu_TOTAL,axiom,
    ! [X,Y] :
      ( s(int,X) = s(int,Y)
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
      | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_LTu_TRANS,axiom,
    ! [X,Y,Z0] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0)))) ) ).

fof(aINTu_MAXu_ACIu_conjunct0,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,y))),s(int,x))) ).

fof(aINTu_MAXu_ACIu_conjunct1,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,y))))),s(int,z))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,y))),s(int,z))))) ).

fof(aINTu_MAXu_ACIu_conjunct2,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,y))),s(int,z))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,z))))) ).

fof(aINTu_MAXu_ACIu_conjunct3,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,x))) = s(int,x) ).

fof(aINTu_MAXu_ACIu_conjunct4,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,x))),s(int,y))) ).

fof(aINTu_MAXu_ASSOC,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))),s(int,Z0))) ).

fof(aINTu_MAXu_LE,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))),s(int,Z0))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Z0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) ) ) ).

fof(aINTu_MAXu_LT,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))),s(int,Z0))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) ) ) ).

fof(aINTu_MAXu_MAX,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y)))))) ) ).

fof(aINTu_MAXu_MIN,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))))) ).

fof(aINTu_MAXu_SYM,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,Y))),s(int,X))) ).

fof(aINTu_MINu_ACIu_conjunct0,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,y))),s(int,x))) ).

fof(aINTu_MINu_ACIu_conjunct1,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,y))))),s(int,z))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,y))),s(int,z))))) ).

fof(aINTu_MINu_ACIu_conjunct2,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,y))),s(int,z))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,z))))) ).

fof(aINTu_MINu_ACIu_conjunct3,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,x))) = s(int,x) ).

fof(aINTu_MINu_ACIu_conjunct4,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,x))),s(int,y))) ).

fof(aINTu_MINu_ASSOC,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))),s(int,Z0))) ).

fof(aINTu_MINu_LE,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))),s(int,Z0))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Z0))))
        | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,Z0)))) ) ) ).

fof(aINTu_MINu_LT,axiom,
    ! [X,Y,Z0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))),s(int,Z0))))
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Z0))))
        | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,Z0)))) ) ) ).

fof(aINTu_MINu_MAX,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))))) ).

fof(aINTu_MINu_MIN,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))),s(int,X))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))))),s(int,Y)))) ) ).

fof(aINTu_MINu_SYM,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,Y))),s(int,X))) ).

fof(aINTu_MULu_ACu_conjunct0,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,m))),s(int,n))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,n))),s(int,m))) ).

fof(aINTu_MULu_ACu_conjunct1,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,m))),s(int,n))))),s(int,p1))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,m))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,n))),s(int,p1))))) ).

fof(aINTu_MULu_ACu_conjunct2,axiom,
    s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,m))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,n))),s(int,p1))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,n))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,m))),s(int,p1))))) ).

fof(aINTu_MULu_ASSOC,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))),s(int,Z0))) ).

fof(aINTu_MULu_LID,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,X))) = s(int,X) ).

fof(aINTu_MULu_LNEG,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,Y))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) ).

fof(aINTu_MULu_LZERO,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_MULu_POSu_LE,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))))
    <=> ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | s(int,Y) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        | ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
          & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
        | ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
          & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ) ) ).

fof(aINTu_MULu_POSu_LT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))))
    <=> ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
          & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y)))) )
        | ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
          & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))) ) ) ) ).

fof(aINTu_MULu_RID,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,X) ).

fof(aINTu_MULu_RNEG,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) ).

fof(aINTu_MULu_RZERO,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_MULu_SYM,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,X))) ).

fof(aINTu_NEGu_NEG,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(int,X) ).

fof(aINTu_NEGu_0,axiom,
    s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_NEGu_ADD,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) ).

fof(aINTu_NEGu_EQ,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),intu_neg),s(int,X))) = s(int,Y)
    <=> s(int,X) = s(int,i(s(fun(int,int),intu_neg),s(int,Y))) ) ).

fof(aINTu_NEGu_EQu_0,axiom,
    ! [X] :
      ( s(int,i(s(fun(int,int),intu_neg),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_NEGu_GE0,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aINTu_NEGu_GT0,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ).

fof(aINTu_NEGu_LE0,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_NEGu_LMUL,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,Y))) ).

fof(aINTu_NEGu_LT0,axiom,
    ! [X] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) ).

fof(aINTu_NEGu_MINUS1,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_neg),s(int,X))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,X))) ).

fof(aINTu_NEGu_MUL2,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))) ).

fof(aINTu_NEGu_RMUL,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) ).

fof(aINTu_NEGu_SUB,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,X))) ).

fof(aINTu_NOTu_EQ,axiom,
    ! [X,Y] :
      ( s(int,X) != s(int,Y)
    <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
        | p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ) ).

fof(aINTu_NOTu_LE,axiom,
    ! [X,Y] :
      ( ~ p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_NOTu_LT,axiom,
    ! [X,Y] :
      ( ~ p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
    <=> p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_OFu_NUMu_ADD,axiom,
    ! [M0,N0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) ).

fof(aINTu_OFu_NUMu_EQ,axiom,
    ! [M0,N0] :
      ( s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0)))
    <=> s(num,M0) = s(num,N0) ) ).

fof(aINTu_OFu_NUMu_GE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_ge),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_a_),s(num,M0))),s(num,N0))) ).

fof(aINTu_OFu_NUMu_GT,axiom,
    ! [M0,N0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_gt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),g_),s(num,M0))),s(num,N0))) ).

fof(aINTu_OFu_NUMu_LE,axiom,
    ! [M0,N0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))) ).

fof(aINTu_OFu_NUMu_LT,axiom,
    ! [M0,N0] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))) ).

fof(aINTu_OFu_NUMu_MAX,axiom,
    ! [M0,N0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),max),s(num,M0))),s(num,N0))))) ).

fof(aINTu_OFu_NUMu_MIN,axiom,
    ! [M0,N0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),min),s(num,M0))),s(num,N0))))) ).

fof(aINTu_OFu_NUMu_MUL,axiom,
    ! [M0,N0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aINTu_OFu_NUMu_POW,axiom,
    ! [X,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),intu_ofu_num),s(num,X))))),s(num,N0))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,X))),s(num,N0))))) ).

fof(aINTu_OFu_NUMu_SUB,axiom,
    ! [M0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))
     => s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,M0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,N0))),s(num,M0))))) ) ).

fof(aINTu_OFu_NUMu_SUC,axiom,
    ! [N0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),suc),s(num,N0))))) ).

fof(aINTu_POS,axiom,
    ! [N0] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0)))))) ).

fof(aINTu_POSu_NZ,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => s(int,X) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_POW2u_ABS,axiom,
    ! [X] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ).

fof(aINTu_POWu_1,axiom,
    ! [X] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) = s(int,X) ).

fof(aINTu_POWu_1u_LE,axiom,
    ! [N0,X] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aINTu_POWu_1u_LT,axiom,
    ! [N0,X] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aINTu_POWu_2,axiom,
    ! [X] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,X))) ).

fof(aINTu_POWu_ADD,axiom,
    ! [X,M0,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,M0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))) ).

fof(aINTu_POWu_EQ,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
        & s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0))) )
     => s(int,X) = s(int,Y) ) ).

fof(aINTu_POWu_EQu_0,axiom,
    ! [X,N0] :
      ( s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0))) ) ) ).

fof(aINTu_POWu_EQu_ABS,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0))) )
     => s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(int,int),intu_abs),s(int,Y))) ) ).

fof(aINTu_POWu_LE,axiom,
    ! [X,N0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LE2,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LE2u_ODD,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))
        & p(s(bool,i(s(fun(num,bool),odd),s(num,N0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LE2u_REV,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0)))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y)))) ) ).

fof(aINTu_POWu_LEu_1,axiom,
    ! [N0,X] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,X))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LT,axiom,
    ! [X,N0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LT2,axiom,
    ! [N0,X,Y] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0)))))) ) ).

fof(aINTu_POWu_LT2u_REV,axiom,
    ! [N0,X,Y] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0)))))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y)))) ) ).

fof(aINTu_POWu_LTu_1,axiom,
    ! [N0,X] :
      ( ( s(num,N0) != s(num,i(s(fun(num,num),numeral),s(num,u_0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,X)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_MONO,axiom,
    ! [M0,N0,X] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,X))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,M0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_MONOu_LT,axiom,
    ! [M0,N0,X] :
      ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,X))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,M0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0)))))) ) ).

fof(aINTu_POWu_MUL,axiom,
    ! [X,Y,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))),s(num,N0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,N0))))) ).

fof(aINTu_POWu_NEG,axiom,
    ! [X,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(num,N0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(num,bool),even),s(num,N0))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))),s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))))))) ).

fof(aINTu_POWu_NZ,axiom,
    ! [X,N0] :
      ( s(int,X) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,N0))) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_POWu_ONE,axiom,
    ! [N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aINTu_POWu_POW,axiom,
    ! [X,M0,N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,M0))))),s(num,N0))) = s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0))))) ).

fof(aINTu_POWu_ZERO,axiom,
    ! [N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(num,N0) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) )
      & s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(num,N0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,V))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) ) ).

fof(aINTu_RNEGu_UNIQ,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,Y) = s(int,i(s(fun(int,int),intu_neg),s(int,X))) ) ).

fof(aINTu_SGN,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))),s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))) ).

fof(aINTu_SGNu_0,axiom,
    s(int,i(s(fun(int,int),intu_sgn),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_SGNu_ABS,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_sgn),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,X))))) = s(int,X) ).

fof(aINTu_SGNu_CASES,axiom,
    ! [X] :
      ( s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
      | s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
      | s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))) ) ).

fof(aINTu_SGNu_EQu_conjunct0,axiom,
    ! [X] :
      ( s(int,i(s(fun(int,int),intu_sgn),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ).

fof(aINTu_SGNu_EQu_conjunct1,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_gt),s(real,X))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))))) ) ).

fof(aINTu_SGNu_EQu_conjunct2,axiom,
    ! [X] :
      ( s(real,i(s(fun(real,real),realu_sgn),s(real,X))) = s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))))
    <=> p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,i(s(fun(int,real),realu_ofu_int),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))))))) ) ).

fof(aINTu_SGNu_MUL,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),intu_sgn),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),intu_sgn),s(int,X))))),s(int,i(s(fun(int,int),intu_sgn),s(int,Y))))) ).

fof(aINTu_SGNu_NEG,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_sgn),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),intu_sgn),s(int,X))))) ).

fof(aINTu_SOSu_EQu_0,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,X))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,Y))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> ( s(int,X) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
        & s(int,Y) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aINTu_SUBu_0,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
    <=> s(int,X) = s(int,Y) ) ).

fof(aINTu_SUBu_ABS,axiom,
    ! [X,Y] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),intu_abs),s(int,X))))),s(int,i(s(fun(int,int),intu_abs),s(int,Y))))))),s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y)))))))) ).

fof(aINTu_SUBu_ADD,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))),s(int,Y))) = s(int,X) ).

fof(aINTu_SUBu_ADD2,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,Y))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(int,X) ).

fof(aINTu_SUBu_LDISTRIB,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,Z0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))) ).

fof(aINTu_SUBu_LE,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X))) ).

fof(aINTu_SUBu_LNEG,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,Y))) = s(int,i(s(fun(int,int),intu_neg),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))))) ).

fof(aINTu_SUBu_LT,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X))) ).

fof(aINTu_SUBu_LZERO,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))) = s(int,i(s(fun(int,int),intu_neg),s(int,X))) ).

fof(aINTu_SUBu_NEG2,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),intu_neg),s(int,X))))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,Y))),s(int,X))) ).

fof(aINTu_SUBu_RDISTRIB,axiom,
    ! [X,Y,Z0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))),s(int,Z0))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Z0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Y))),s(int,Z0))))) ).

fof(aINTu_SUBu_REFL,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ).

fof(aINTu_SUBu_RNEG,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,Y))) ).

fof(aINTu_SUBu_RZERO,axiom,
    ! [X] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))) = s(int,X) ).

fof(aINTu_SUBu_SUB,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))),s(int,X))) = s(int,i(s(fun(int,int),intu_neg),s(int,Y))) ).

fof(aINTu_SUBu_SUB2,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) = s(int,Y) ).

fof(aINTu_SUBu_TRIANGLE,axiom,
    ! [A5,B0,C0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,A5))),s(int,B0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,B0))),s(int,C0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,A5))),s(int,C0))) ).

fof(aINTu_FORALLu_POS,axiom,
    ! [P0] :
      ( ! [N0] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))))
    <=> ! [I0] :
          ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,I0))))
         => p(s(bool,i(s(fun(int,bool),P0),s(int,I0)))) ) ) ).

fof(aINTu_EXISTSu_POS,axiom,
    ! [P0] :
      ( ? [N0] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))))
    <=> ? [I0] :
          ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,I0))))
          & p(s(bool,i(s(fun(int,bool),P0),s(int,I0)))) ) ) ).

fof(aINTu_FORALLu_ABS,axiom,
    ! [P0] :
      ( ! [N0] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))))
    <=> ! [X] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ) ).

fof(aINTu_EXISTSu_ABS,axiom,
    ! [P0] :
      ( ? [N0] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))))
    <=> ? [X] : p(s(bool,i(s(fun(int,bool),P0),s(int,i(s(fun(int,int),intu_abs),s(int,X)))))) ) ).

fof(aINTu_ABSu_MULu_1,axiom,
    ! [X,Y] :
      ( s(int,i(s(fun(int,int),intu_abs),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,X))),s(int,Y))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
    <=> ( s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))
        & s(int,i(s(fun(int,int),intu_abs),s(int,Y))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ) ).

fof(aINTu_WOP,axiom,
    ( ? [X] :
        ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),p0),s(int,X)))) )
  <=> ? [X] :
        ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
        & p(s(bool,i(s(fun(int,bool),p0),s(int,X))))
        & ! [Y] :
            ( ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,Y))))
              & p(s(bool,i(s(fun(int,bool),p0),s(int,Y)))) )
           => p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y)))) ) ) ) ).

fof(aINTu_POWu_conjunct0,axiom,
    s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,x))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aINTu_POWu_conjunct1,axiom,
    ! [N0] : s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,x))),s(num,i(s(fun(num,num),suc),s(num,N0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,x))),s(int,i(s(fun(num,int),i(s(fun(int,fun(num,int)),intu_pow),s(int,x))),s(num,N0))))) ).

fof(aINTu_ABS,axiom,
    ! [X] : s(int,i(s(fun(int,int),intu_abs),s(int,X))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,X))))) ).

fof(aINTu_GE,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_ge),s(int,X))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X))) ).

fof(aINTu_GT,axiom,
    ! [X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_gt),s(int,X))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,Y))),s(int,X))) ).

fof(aINTu_LT,axiom,
    ! [X,Y] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,Y))))
    <=> ~ p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,Y))),s(int,X)))) ) ).

fof(aINTu_SUB,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,X))),s(int,i(s(fun(int,int),intu_neg),s(int,Y))))) ).

fof(aINTu_MAX,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_max),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))),s(int,Y))),s(int,X))) ).

fof(aINTu_MIN,axiom,
    ! [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_min),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),i(s(fun(bool,fun(int,fun(int,int))),cond),s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,X))),s(int,Y))))),s(int,X))),s(int,Y))) ).

fof(aINTu_ARCH,axiom,
    ! [X,D0] :
      ( s(int,D0) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => ? [C0] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,X))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,C0))),s(int,D0)))))) ) ).

fof(aINTu_DIVMODu_EXISTu_0,axiom,
    ! [M0,N0] :
    ? [Q0,R0,V] :
      ( ( p(s(bool,V))
      <=> ( s(int,Q0) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
          & s(int,R0) = s(int,M0) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> s(int,N0) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) )
          & ? [VI_I_] :
              ( ( p(s(bool,VI_I_))
              <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,R0))))
                  & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,R0))),s(int,i(s(fun(int,int),intu_abs),s(int,N0))))))
                  & s(int,M0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Q0))),s(int,N0))))),s(int,R0))) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ).

fof(aINTu_DIVISIONu_0,axiom,
    ! [M0,N0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),div0),s(int,M0))),s(int,N0))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
          & s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))) = s(int,M0) ) )
      & ? [VI_] :
          ( ( p(s(bool,VI_))
          <=> s(int,N0) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) )
          & ? [VI_I_] :
              ( ( p(s(bool,VI_I_))
              <=> ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))))))
                  & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))))),s(int,i(s(fun(int,int),intu_abs),s(int,N0))))))
                  & s(int,M0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),div0),s(int,M0))),s(int,N0))))),s(int,N0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))))) ) )
              & p(s(bool,i(s(fun(bool,bool),i(s(fun(bool,fun(bool,bool)),i(s(fun(bool,fun(bool,fun(bool,bool))),cond),s(bool,VI_))),s(bool,V))),s(bool,VI_I_)))) ) ) ) ).

fof(aINTu_DIVISION,axiom,
    ! [M0,N0] :
      ( s(int,N0) != s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0)))))
     => ( s(int,M0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),div0),s(int,M0))),s(int,N0))))),s(int,N0))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0)))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))))),s(int,i(s(fun(int,int),intu_abs),s(int,N0)))))) ) ) ).

fof(aINTu_DIVMODu_UNIQ,axiom,
    ! [M0,N0,Q0,R0] :
      ( ( s(int,M0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,Q0))),s(int,N0))))),s(int,R0)))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,R0))))
        & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,R0))),s(int,i(s(fun(int,int),intu_abs),s(int,N0)))))) )
     => ( s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),div0),s(int,M0))),s(int,N0))) = s(int,Q0)
        & s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),rem),s(int,M0))),s(int,N0))) = s(int,R0) ) ) ).

fof(acong,axiom,
    ! [A,REL,X,Y] : s(bool,i(s(fun(fun(A,fun(A,bool)),bool),i(s(fun(A,fun(fun(A,fun(A,bool)),bool)),i(s(fun(A,fun(A,fun(fun(A,fun(A,bool)),bool))),a_a_),s(A,X))),s(A,Y))),s(fun(A,fun(A,bool)),REL))) = s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),REL),s(A,X))),s(A,Y))) ).

fof(arealu_mod,axiom,
    ! [X,Y,N0] :
      ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),realu_mod),s(real,N0))),s(real,X))),s(real,Y))))
    <=> ? [Q0] :
          ( p(s(bool,i(s(fun(real,bool),integer),s(real,Q0))))
          & s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,Y))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_mul),s(real,Q0))),s(real,N0))) ) ) ).

fof(aintu_divides,axiom,
    ! [B0,A5] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,A5))),s(int,B0))))
    <=> ? [X] : s(int,B0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,A5))),s(int,X))) ) ).

fof(aintu_mod,axiom,
    ! [N0,X,Y] : s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),i(s(fun(int,fun(int,fun(int,bool))),intu_mod),s(int,N0))),s(int,X))),s(int,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,N0))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))))) ).

fof(aintu_congruent,axiom,
    ! [X,Y,N0] :
      ( p(s(bool,i(s(fun(fun(int,fun(int,bool)),bool),i(s(fun(int,fun(fun(int,fun(int,bool)),bool)),i(s(fun(int,fun(int,fun(fun(int,fun(int,bool)),bool))),a_a_),s(int,X))),s(int,Y))),s(fun(int,fun(int,bool)),i(s(fun(int,fun(int,fun(int,bool))),intu_mod),s(int,N0))))))
    <=> ? [D0] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_sub),s(int,X))),s(int,Y))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,N0))),s(int,D0))) ) ).

fof(aintu_coprime,axiom,
    ! [A5,B0] :
      ( p(s(bool,i(s(fun(prod(int,int),bool),intu_coprime),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,A5))),s(int,B0))))))
    <=> ? [X,Y] : s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,A5))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,B0))),s(int,Y))))) = s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(aWFu_INTu_MEASURE,axiom,
    ! [A,P0,M0] :
      ( ( ! [X] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(A,int),M0),s(A,X))))))
        & ! [X] :
            ( ! [Y] :
                ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(A,int),M0),s(A,Y))))),s(int,i(s(fun(A,int),M0),s(A,X))))))
               => p(s(bool,i(s(fun(A,bool),P0),s(A,Y)))) )
           => p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) )
     => ! [X] : p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) ).

fof(aWFu_INTu_MEASUREu_2,axiom,
    ! [A,B,P0,M0] :
      ( ( ! [X,Y] : p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(B,int),i(s(fun(A,fun(B,int)),M0),s(A,X))),s(B,Y))))))
        & ! [X,Y] :
            ( ! [XI_,YI_] :
                ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_lt),s(int,i(s(fun(B,int),i(s(fun(A,fun(B,int)),M0),s(A,XI_))),s(B,YI_))))),s(int,i(s(fun(B,int),i(s(fun(A,fun(B,int)),M0),s(A,X))),s(B,Y))))))
               => p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,XI_))),s(B,YI_)))) )
           => p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y)))) ) )
     => ! [X,Y] : p(s(bool,i(s(fun(B,bool),i(s(fun(A,fun(B,bool)),P0),s(A,X))),s(B,Y)))) ) ).

fof(aINTu_GCDu_EXISTS,axiom,
    ! [A5,B0] :
    ? [D0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,D0))),s(int,A5))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,D0))),s(int,B0))))
      & ? [X,Y] : s(int,D0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,A5))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,B0))),s(int,Y))))) ) ).

fof(aINTu_GCDu_EXISTSu_POS,axiom,
    ! [A5,B0] :
    ? [D0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,D0))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,D0))),s(int,A5))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,D0))),s(int,B0))))
      & ? [X,Y] : s(int,D0) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,A5))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,B0))),s(int,Y))))) ) ).

fof(aintu_gcd,axiom,
    ! [A5,B0] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,A5))),s(int,B0))))))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,A5))),s(int,B0))))))),s(int,A5))))
      & p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,A5))),s(int,B0))))))),s(int,B0))))
      & ? [X,Y] : s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,A5))),s(int,B0))))) = s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_add),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,A5))),s(int,X))))),s(int,i(s(fun(int,int),i(s(fun(int,fun(int,int)),intu_mul),s(int,B0))),s(int,Y))))) ) ).

fof(anumu_ofu_int,axiom,
    ! [U_0] :
      ( ! [X,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(int,fun(num,bool)),U_0),s(int,X))),s(num,N0))))
        <=> s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))) = s(int,X) )
     => ! [X] : s(num,i(s(fun(int,num),numu_ofu_int),s(int,X))) = s(num,i(s(fun(fun(num,bool),num),h_),s(fun(num,bool),i(s(fun(int,fun(num,bool)),U_0),s(int,X))))) ) ).

fof(aNUMu_OFu_INTu_OFu_NUM,axiom,
    ! [N0] : s(num,i(s(fun(int,num),numu_ofu_int),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))) = s(num,N0) ).

fof(aINTu_OFu_NUMu_OFu_INT,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
     => s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(int,num),numu_ofu_int),s(int,X))))) = s(int,X) ) ).

fof(aNUMu_OFu_INT,axiom,
    ! [X] :
      ( p(s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_le),s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))),s(int,X))))
    <=> s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(int,num),numu_ofu_int),s(int,X))))) = s(int,X) ) ).

fof(anumu_divides,axiom,
    ! [A5,B0] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),numu_divides),s(num,A5))),s(num,B0))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),intu_divides),s(int,i(s(fun(num,int),intu_ofu_num),s(num,A5))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,B0))))) ).

fof(anumu_mod,axiom,
    ! [N0,X,Y] : s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),numu_mod),s(num,N0))),s(num,X))),s(num,Y))) = s(bool,i(s(fun(int,bool),i(s(fun(int,fun(int,bool)),i(s(fun(int,fun(int,fun(int,bool))),intu_mod),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,X))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,Y))))) ).

fof(anumu_congruent,axiom,
    ! [X,Y,N0] : s(bool,i(s(fun(fun(num,fun(num,bool)),bool),i(s(fun(num,fun(fun(num,fun(num,bool)),bool)),i(s(fun(num,fun(num,fun(fun(num,fun(num,bool)),bool))),a_a_),s(num,X))),s(num,Y))),s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),numu_mod),s(num,N0))))) = s(bool,i(s(fun(fun(int,fun(int,bool)),bool),i(s(fun(int,fun(fun(int,fun(int,bool)),bool)),i(s(fun(int,fun(int,fun(fun(int,fun(int,bool)),bool))),a_a_),s(int,i(s(fun(num,int),intu_ofu_num),s(num,X))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,Y))))),s(fun(int,fun(int,bool)),i(s(fun(int,fun(int,fun(int,bool))),intu_mod),s(int,i(s(fun(num,int),intu_ofu_num),s(num,N0))))))) ).

fof(anumu_coprime,axiom,
    ! [A5,B0] : s(bool,i(s(fun(prod(num,num),bool),numu_coprime),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,A5))),s(num,B0))))) = s(bool,i(s(fun(prod(int,int),bool),intu_coprime),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,i(s(fun(num,int),intu_ofu_num),s(num,A5))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,B0))))))) ).

fof(anumu_gcd,axiom,
    ! [A5,B0] : s(num,i(s(fun(prod(num,num),num),numu_gcd),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,A5))),s(num,B0))))) = s(num,i(s(fun(int,num),numu_ofu_int),s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,i(s(fun(num,int),intu_ofu_num),s(num,A5))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,B0))))))))) ).

fof(aNUMu_GCD,axiom,
    ! [A5,B0] : s(int,i(s(fun(num,int),intu_ofu_num),s(num,i(s(fun(prod(num,num),num),numu_gcd),s(prod(num,num),i(s(fun(num,prod(num,num)),i(s(fun(num,fun(num,prod(num,num))),c_),s(num,A5))),s(num,B0))))))) = s(int,i(s(fun(prod(int,int),int),intu_gcd),s(prod(int,int),i(s(fun(int,prod(int,int)),i(s(fun(int,fun(int,prod(int,int))),c_),s(int,i(s(fun(num,int),intu_ofu_num),s(num,A5))))),s(int,i(s(fun(num,int),intu_ofu_num),s(num,B0))))))) ).

fof(aIN,axiom,
    ! [A,P0,X] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),P0))) = s(bool,i(s(fun(A,bool),P0),s(A,X))) ).

fof(aEXTENSION,axiom,
    ! [A,S0,T0] :
      ( s(fun(A,bool),S0) = s(fun(A,bool),T0)
    <=> ! [X] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))) ) ).

fof(aGSPEC,axiom,
    ! [A,P0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),P0))) = s(fun(A,bool),P0) ).

fof(aSETSPEC,axiom,
    ! [Q44069,P0,V,T0] :
      ( p(s(bool,i(s(fun(Q44069,bool),i(s(fun(bool,fun(Q44069,bool)),i(s(fun(Q44069,fun(bool,fun(Q44069,bool))),setspec),s(Q44069,V))),s(bool,P0))),s(Q44069,T0))))
    <=> ( p(s(bool,P0))
        & s(Q44069,V) = s(Q44069,T0) ) ) ).

fof(aINu_ELIMu_THMu_conjunct4,axiom,
    ! [Q44207,U_0] :
      ( ! [P0,Y] : s(bool,i(s(fun(Q44207,bool),i(s(fun(fun(Q44207,bool),fun(Q44207,bool)),U_0),s(fun(Q44207,bool),P0))),s(Q44207,Y))) = s(bool,i(s(fun(Q44207,bool),P0),s(Q44207,Y)))
     => ! [P0,X] : s(bool,i(s(fun(fun(Q44207,bool),bool),i(s(fun(Q44207,fun(fun(Q44207,bool),bool)),in),s(Q44207,X))),s(fun(Q44207,bool),i(s(fun(fun(Q44207,bool),fun(Q44207,bool)),U_0),s(fun(Q44207,bool),P0))))) = s(bool,i(s(fun(Q44207,bool),P0),s(Q44207,X))) ) ).

fof(aINu_ELIMu_THMu_conjunct3,axiom,
    ! [Q44190,U_0] :
      ( ! [P0,V] :
          ( p(s(bool,i(s(fun(Q44190,bool),i(s(fun(fun(Q44190,bool),fun(Q44190,bool)),U_0),s(fun(Q44190,bool),P0))),s(Q44190,V))))
        <=> ? [Y] : p(s(bool,i(s(fun(Q44190,bool),i(s(fun(bool,fun(Q44190,bool)),i(s(fun(Q44190,fun(bool,fun(Q44190,bool))),setspec),s(Q44190,V))),s(bool,i(s(fun(Q44190,bool),P0),s(Q44190,Y))))),s(Q44190,Y)))) )
     => ! [P0,X] : s(bool,i(s(fun(Q44190,bool),i(s(fun(fun(Q44190,bool),fun(Q44190,bool)),gspec),s(fun(Q44190,bool),i(s(fun(fun(Q44190,bool),fun(Q44190,bool)),U_0),s(fun(Q44190,bool),P0))))),s(Q44190,X))) = s(bool,i(s(fun(Q44190,bool),P0),s(Q44190,X))) ) ).

fof(aINu_ELIMu_THMu_conjunct2,axiom,
    ! [Q44161,U_2] :
      ( ! [P0,X,T0] :
          ( p(s(bool,i(s(fun(Q44161,bool),i(s(fun(Q44161,fun(Q44161,bool)),i(s(fun(bool,fun(Q44161,fun(Q44161,bool))),U_2),s(bool,P0))),s(Q44161,X))),s(Q44161,T0))))
        <=> ( p(s(bool,P0))
            & s(Q44161,X) = s(Q44161,T0) ) )
     => ! [U_1] :
          ( ! [X,P0] : s(fun(Q44161,bool),i(s(fun(bool,fun(Q44161,bool)),i(s(fun(Q44161,fun(bool,fun(Q44161,bool))),U_1),s(Q44161,X))),s(bool,P0))) = s(fun(Q44161,bool),i(s(fun(Q44161,fun(Q44161,bool)),i(s(fun(bool,fun(Q44161,fun(Q44161,bool))),U_2),s(bool,P0))),s(Q44161,X)))
         => ! [U_0] :
              ( ! [P0,V] : s(bool,i(s(fun(Q44161,bool),i(s(fun(fun(fun(bool,fun(Q44161,bool)),bool),fun(Q44161,bool)),U_0),s(fun(fun(bool,fun(Q44161,bool)),bool),P0))),s(Q44161,V))) = s(bool,i(s(fun(fun(bool,fun(Q44161,bool)),bool),P0),s(fun(bool,fun(Q44161,bool)),i(s(fun(Q44161,fun(bool,fun(Q44161,bool))),setspec),s(Q44161,V)))))
             => ! [P0,X] : s(bool,i(s(fun(Q44161,bool),i(s(fun(fun(Q44161,bool),fun(Q44161,bool)),gspec),s(fun(Q44161,bool),i(s(fun(fun(fun(bool,fun(Q44161,bool)),bool),fun(Q44161,bool)),U_0),s(fun(fun(bool,fun(Q44161,bool)),bool),P0))))),s(Q44161,X))) = s(bool,i(s(fun(fun(bool,fun(Q44161,bool)),bool),P0),s(fun(bool,fun(Q44161,bool)),i(s(fun(Q44161,fun(bool,fun(Q44161,bool))),U_1),s(Q44161,X))))) ) ) ) ).

fof(aINu_ELIMu_THMu_conjunct1,axiom,
    ! [Q44133,U_0] :
      ( ! [P0,V] :
          ( p(s(bool,i(s(fun(Q44133,bool),i(s(fun(fun(Q44133,bool),fun(Q44133,bool)),U_0),s(fun(Q44133,bool),P0))),s(Q44133,V))))
        <=> ? [Y] : p(s(bool,i(s(fun(Q44133,bool),i(s(fun(bool,fun(Q44133,bool)),i(s(fun(Q44133,fun(bool,fun(Q44133,bool))),setspec),s(Q44133,V))),s(bool,i(s(fun(Q44133,bool),P0),s(Q44133,Y))))),s(Q44133,Y)))) )
     => ! [P0,X] : s(bool,i(s(fun(fun(Q44133,bool),bool),i(s(fun(Q44133,fun(fun(Q44133,bool),bool)),in),s(Q44133,X))),s(fun(Q44133,bool),i(s(fun(fun(Q44133,bool),fun(Q44133,bool)),gspec),s(fun(Q44133,bool),i(s(fun(fun(Q44133,bool),fun(Q44133,bool)),U_0),s(fun(Q44133,bool),P0))))))) = s(bool,i(s(fun(Q44133,bool),P0),s(Q44133,X))) ) ).

fof(aINu_ELIMu_THMu_conjunct0,axiom,
    ! [Q44102,U_2] :
      ( ! [P0,X,T0] :
          ( p(s(bool,i(s(fun(Q44102,bool),i(s(fun(Q44102,fun(Q44102,bool)),i(s(fun(bool,fun(Q44102,fun(Q44102,bool))),U_2),s(bool,P0))),s(Q44102,X))),s(Q44102,T0))))
        <=> ( p(s(bool,P0))
            & s(Q44102,X) = s(Q44102,T0) ) )
     => ! [U_1] :
          ( ! [X,P0] : s(fun(Q44102,bool),i(s(fun(bool,fun(Q44102,bool)),i(s(fun(Q44102,fun(bool,fun(Q44102,bool))),U_1),s(Q44102,X))),s(bool,P0))) = s(fun(Q44102,bool),i(s(fun(Q44102,fun(Q44102,bool)),i(s(fun(bool,fun(Q44102,fun(Q44102,bool))),U_2),s(bool,P0))),s(Q44102,X)))
         => ! [U_0] :
              ( ! [P0,V] : s(bool,i(s(fun(Q44102,bool),i(s(fun(fun(fun(bool,fun(Q44102,bool)),bool),fun(Q44102,bool)),U_0),s(fun(fun(bool,fun(Q44102,bool)),bool),P0))),s(Q44102,V))) = s(bool,i(s(fun(fun(bool,fun(Q44102,bool)),bool),P0),s(fun(bool,fun(Q44102,bool)),i(s(fun(Q44102,fun(bool,fun(Q44102,bool))),setspec),s(Q44102,V)))))
             => ! [P0,X] : s(bool,i(s(fun(fun(Q44102,bool),bool),i(s(fun(Q44102,fun(fun(Q44102,bool),bool)),in),s(Q44102,X))),s(fun(Q44102,bool),i(s(fun(fun(Q44102,bool),fun(Q44102,bool)),gspec),s(fun(Q44102,bool),i(s(fun(fun(fun(bool,fun(Q44102,bool)),bool),fun(Q44102,bool)),U_0),s(fun(fun(bool,fun(Q44102,bool)),bool),P0))))))) = s(bool,i(s(fun(fun(bool,fun(Q44102,bool)),bool),P0),s(fun(bool,fun(Q44102,bool)),i(s(fun(Q44102,fun(bool,fun(Q44102,bool))),U_1),s(Q44102,X))))) ) ) ) ).

fof(aEMPTY,axiom,
    ! [A,X] : s(bool,i(s(fun(A,bool),empty),s(A,X))) = s(bool,f0) ).

fof(aINSERTu_DEF,axiom,
    ! [A,S0,X,XI_] :
      ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))),s(A,XI_))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,XI_))),s(fun(A,bool),S0))))
        | s(A,XI_) = s(A,X) ) ) ).

fof(aUNIV,axiom,
    ! [A,X] : s(bool,i(s(fun(A,bool),univ),s(A,X))) = s(bool,t) ).

fof(aUNION,axiom,
    ! [A,U_0] :
      ( ! [S0,T0,GENR_PVARR_0] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))),s(A,GENR_PVARR_0))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  | p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_0))),s(bool,V))),s(A,X)))) ) )
     => ! [S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) ) ).

fof(aUNIONS,axiom,
    ! [A,U_0] :
      ( ! [S0,GENR_PVARR_1] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),U_0),s(fun(fun(A,bool),bool),S0))),s(A,GENR_PVARR_1))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ? [U] :
                    ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),i(s(fun(fun(A,bool),fun(fun(fun(A,bool),bool),bool)),in),s(fun(A,bool),U))),s(fun(fun(A,bool),bool),S0))))
                    & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),U)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_1))),s(bool,V))),s(A,X)))) ) )
     => ! [S0] : s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),unions),s(fun(fun(A,bool),bool),S0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),U_0),s(fun(fun(A,bool),bool),S0))))) ) ).

fof(aINTER,axiom,
    ! [A,U_0] :
      ( ! [S0,T0,GENR_PVARR_2] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))),s(A,GENR_PVARR_2))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_2))),s(bool,V))),s(A,X)))) ) )
     => ! [S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) ) ).

fof(aINTERS,axiom,
    ! [A,U_0] :
      ( ! [S0,GENR_PVARR_3] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),U_0),s(fun(fun(A,bool),bool),S0))),s(A,GENR_PVARR_3))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ! [U] :
                    ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),i(s(fun(fun(A,bool),fun(fun(fun(A,bool),bool),bool)),in),s(fun(A,bool),U))),s(fun(fun(A,bool),bool),S0))))
                   => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),U)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_3))),s(bool,V))),s(A,X)))) ) )
     => ! [S0] : s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),inters),s(fun(fun(A,bool),bool),S0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),U_0),s(fun(fun(A,bool),bool),S0))))) ) ).

fof(aDIFF,axiom,
    ! [A,U_0] :
      ( ! [S0,T0,GENR_PVARR_4] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))),s(A,GENR_PVARR_4))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_4))),s(bool,V))),s(A,X)))) ) )
     => ! [S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) ) ).

fof(aINSERT,axiom,
    ! [A,U_0] :
      ( ! [GENR_PVARR_5] :
          ( p(s(bool,i(s(fun(A,bool),U_0),s(A,GENR_PVARR_5))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),s0))))
                  | s(A,Y) = s(A,x) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_5))),s(bool,V))),s(A,Y)))) ) )
     => s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,x))),s(fun(A,bool),s0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),U_0))) ) ).

fof(aDELETE,axiom,
    ! [A,U_0] :
      ( ! [S0,X,GENR_PVARR_6] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),U_0),s(fun(A,bool),S0))),s(A,X))),s(A,GENR_PVARR_6))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                  & s(A,Y) != s(A,X) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_6))),s(bool,V))),s(A,Y)))) ) )
     => ! [S0,X] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),U_0),s(fun(A,bool),S0))),s(A,X))))) ) ).

fof(aSUBSET,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ! [X] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aPSUBSET,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & s(fun(A,bool),S0) != s(fun(A,bool),T0) ) ) ).

fof(aDISJOINT,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),empty) ) ).

fof(aSING,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),sing),s(fun(A,bool),S0))))
    <=> ? [X] : s(fun(A,bool),S0) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),empty))) ) ).

fof(aFINITEu_RULESu_conjunct0,axiom,
    ! [A] : p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),empty)))) ).

fof(aFINITEu_RULESu_conjunct1,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0)))))) ) ).

fof(aFINITEu_CASES,axiom,
    ! [A,A5] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),A5))))
    <=> ( s(fun(A,bool),A5) = s(fun(A,bool),empty)
        | ? [X,S0] :
            ( s(fun(A,bool),A5) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0)))
            & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0)))) ) ) ) ).

fof(aFINITEu_INDUCT,axiom,
    ! [A,FINITEI_] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),FINITEI_),s(fun(A,bool),empty))))
        & ! [X,S0] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),FINITEI_),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(fun(A,bool),bool),FINITEI_),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0)))))) ) )
     => ! [A5] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),A5))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),FINITEI_),s(fun(A,bool),A5)))) ) ) ).

fof(aINFINITE,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),infinite),s(fun(A,bool),S0))))
    <=> ~ p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0)))) ) ).

fof(aIMAGE,axiom,
    ! [A,B,U_0] :
      ( ! [S0,F0,GENR_PVARR_7] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(fun(A,B),fun(B,bool)),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(B,GENR_PVARR_7))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ? [X] :
                    ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                    & s(B,Y) = s(B,i(s(fun(A,B),F0),s(A,X))) ) )
              & p(s(bool,i(s(fun(B,bool),i(s(fun(bool,fun(B,bool)),i(s(fun(B,fun(bool,fun(B,bool))),setspec),s(B,GENR_PVARR_7))),s(bool,V))),s(B,Y)))) ) )
     => ! [S0,F0] : s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),i(s(fun(fun(B,bool),fun(B,bool)),gspec),s(fun(B,bool),i(s(fun(fun(A,B),fun(B,bool)),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))))) ) ).

fof(aINJ,axiom,
    ! [B,A,T0,S0,F0] :
      ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(fun(B,bool),bool))),inj),s(fun(A,B),F0))),s(fun(A,bool),S0))),s(fun(B,bool),T0))))
    <=> ( ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) )
        & ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) ) ) ) ).

fof(aSURJ,axiom,
    ! [A,B,T0,S0,F0] :
      ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(fun(B,bool),bool))),surj),s(fun(A,B),F0))),s(fun(A,bool),S0))),s(fun(B,bool),T0))))
    <=> ( ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) )
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,X))),s(fun(B,bool),T0))))
           => ? [Y] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                & s(B,i(s(fun(A,B),F0),s(A,Y))) = s(B,X) ) ) ) ) ).

fof(aBIJ,axiom,
    ! [A,B,F0,S0,T0] :
      ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(fun(B,bool),bool))),bij),s(fun(A,B),F0))),s(fun(A,bool),S0))),s(fun(B,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(fun(B,bool),bool))),inj),s(fun(A,B),F0))),s(fun(A,bool),S0))),s(fun(B,bool),T0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(fun(B,bool),bool))),surj),s(fun(A,B),F0))),s(fun(A,bool),S0))),s(fun(B,bool),T0)))) ) ) ).

fof(aCHOICE,axiom,
    ! [A,U_0] :
      ( ! [S0,X] : s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),U_0),s(fun(A,bool),S0))),s(A,X))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))
     => ! [S0] : s(A,i(s(fun(fun(A,bool),A),choice0),s(fun(A,bool),S0))) = s(A,i(s(fun(fun(A,bool),A),h_),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),U_0),s(fun(A,bool),S0))))) ) ).

fof(aREST,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),rest),s(fun(A,bool),S0))) = s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,i(s(fun(fun(A,bool),A),choice0),s(fun(A,bool),S0))))) ).

fof(aNOTu_INu_EMPTY,axiom,
    ! [A,X] : ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),empty)))) ).

fof(aINu_UNIV,axiom,
    ! [A,X] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),univ)))) ).

fof(aINu_UNION,axiom,
    ! [A,S0,T0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        | p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINu_UNIONS,axiom,
    ! [A,S0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),unions),s(fun(fun(A,bool),bool),S0))))))
    <=> ? [T0] :
          ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),i(s(fun(fun(A,bool),fun(fun(fun(A,bool),bool),bool)),in),s(fun(A,bool),T0))),s(fun(fun(A,bool),bool),S0))))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINu_INTER,axiom,
    ! [A,S0,T0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINu_INTERS,axiom,
    ! [A,S0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),inters),s(fun(fun(A,bool),bool),S0))))))
    <=> ! [T0] :
          ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),i(s(fun(fun(A,bool),fun(fun(fun(A,bool),bool),bool)),in),s(fun(A,bool),T0))),s(fun(fun(A,bool),bool),S0))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINu_DIFF,axiom,
    ! [A,S0,T0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINu_INSERT,axiom,
    ! [A,X,Y,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,Y))),s(fun(A,bool),S0))))))
    <=> ( s(A,X) = s(A,Y)
        | p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))) ) ) ).

fof(aINu_DELETE,axiom,
    ! [A,S0,X,Y] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,Y))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        & s(A,X) != s(A,Y) ) ) ).

fof(aINu_SING,axiom,
    ! [A,X,Y] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,Y))),s(fun(A,bool),empty))))))
    <=> s(A,X) = s(A,Y) ) ).

fof(aINu_IMAGE,axiom,
    ! [B,A,Y,S0,F0] :
      ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))))
    <=> ? [X] :
          ( s(B,Y) = s(B,i(s(fun(A,B),F0),s(A,X)))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))) ) ) ).

fof(aINu_REST,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),rest),s(fun(A,bool),S0))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        & s(A,X) != s(A,i(s(fun(fun(A,bool),A),choice0),s(fun(A,bool),S0))) ) ) ).

fof(aFORALLu_INu_INSERT,axiom,
    ! [Q45021,P0,A5,S0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q45021,bool),bool),i(s(fun(Q45021,fun(fun(Q45021,bool),bool)),in),s(Q45021,X))),s(fun(Q45021,bool),i(s(fun(fun(Q45021,bool),fun(Q45021,bool)),i(s(fun(Q45021,fun(fun(Q45021,bool),fun(Q45021,bool))),insert),s(Q45021,A5))),s(fun(Q45021,bool),S0))))))
         => p(s(bool,i(s(fun(Q45021,bool),P0),s(Q45021,X)))) )
    <=> ( p(s(bool,i(s(fun(Q45021,bool),P0),s(Q45021,A5))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(Q45021,bool),bool),i(s(fun(Q45021,fun(fun(Q45021,bool),bool)),in),s(Q45021,X))),s(fun(Q45021,bool),S0))))
           => p(s(bool,i(s(fun(Q45021,bool),P0),s(Q45021,X)))) ) ) ) ).

fof(aEXISTSu_INu_INSERT,axiom,
    ! [Q45062,P0,A5,S0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(fun(Q45062,bool),bool),i(s(fun(Q45062,fun(fun(Q45062,bool),bool)),in),s(Q45062,X))),s(fun(Q45062,bool),i(s(fun(fun(Q45062,bool),fun(Q45062,bool)),i(s(fun(Q45062,fun(fun(Q45062,bool),fun(Q45062,bool))),insert),s(Q45062,A5))),s(fun(Q45062,bool),S0))))))
          & p(s(bool,i(s(fun(Q45062,bool),P0),s(Q45062,X)))) )
    <=> ( p(s(bool,i(s(fun(Q45062,bool),P0),s(Q45062,A5))))
        | ? [X] :
            ( p(s(bool,i(s(fun(fun(Q45062,bool),bool),i(s(fun(Q45062,fun(fun(Q45062,bool),bool)),in),s(Q45062,X))),s(fun(Q45062,bool),S0))))
            & p(s(bool,i(s(fun(Q45062,bool),P0),s(Q45062,X)))) ) ) ) ).

fof(aCHOICEu_DEF,axiom,
    ! [A,S0] :
      ( s(fun(A,bool),S0) != s(fun(A,bool),empty)
     => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(fun(A,bool),A),choice0),s(fun(A,bool),S0))))),s(fun(A,bool),S0)))) ) ).

fof(aNOTu_EQUALu_SETS,axiom,
    ! [A,S0,T0] :
      ( s(fun(A,bool),S0) != s(fun(A,bool),T0)
    <=> ? [X] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))
        <=> ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))) ) ) ).

fof(aMEMBERu_NOTu_EMPTY,axiom,
    ! [A,S0] :
      ( ? [X] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
    <=> s(fun(A,bool),S0) != s(fun(A,bool),empty) ) ).

fof(aUNIVu_NOTu_EMPTY,axiom,
    ! [A] : s(fun(A,bool),univ) != s(fun(A,bool),empty) ).

fof(aEMPTYu_NOTu_UNIV,axiom,
    ! [A] : s(fun(A,bool),empty) != s(fun(A,bool),univ) ).

fof(aEQu_UNIV,axiom,
    ! [A] :
      ( ! [X] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),s0))))
    <=> s(fun(A,bool),s0) = s(fun(A,bool),univ) ) ).

fof(aSUBSETu_TRANS,axiom,
    ! [A,S0,T0,U] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),U)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),U)))) ) ).

fof(aSUBSETu_REFL,axiom,
    ! [A,S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),S0)))) ).

fof(aSUBSETu_ANTISYM,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0)))) )
     => s(fun(A,bool),S0) = s(fun(A,bool),T0) ) ).

fof(aSUBSETu_ANTISYMu_EQ,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0)))) )
    <=> s(fun(A,bool),S0) = s(fun(A,bool),T0) ) ).

fof(aEMPTYu_SUBSET,axiom,
    ! [A,S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),empty))),s(fun(A,bool),S0)))) ).

fof(aSUBSETu_EMPTY,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),empty))))
    <=> s(fun(A,bool),S0) = s(fun(A,bool),empty) ) ).

fof(aSUBSETu_UNIV,axiom,
    ! [A,S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),univ)))) ).

fof(aUNIVu_SUBSET,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),univ))),s(fun(A,bool),S0))))
    <=> s(fun(A,bool),S0) = s(fun(A,bool),univ) ) ).

fof(aSINGu_SUBSET,axiom,
    ! [Q45300,S0,X] : s(bool,i(s(fun(fun(Q45300,bool),bool),i(s(fun(fun(Q45300,bool),fun(fun(Q45300,bool),bool)),subset),s(fun(Q45300,bool),i(s(fun(fun(Q45300,bool),fun(Q45300,bool)),i(s(fun(Q45300,fun(fun(Q45300,bool),fun(Q45300,bool))),insert),s(Q45300,X))),s(fun(Q45300,bool),empty))))),s(fun(Q45300,bool),S0))) = s(bool,i(s(fun(fun(Q45300,bool),bool),i(s(fun(Q45300,fun(fun(Q45300,bool),bool)),in),s(Q45300,X))),s(fun(Q45300,bool),S0))) ).

fof(aPSUBSETu_TRANS,axiom,
    ! [A,S0,T0,U] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),T0))),s(fun(A,bool),U)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),U)))) ) ).

fof(aPSUBSETu_SUBSETu_TRANS,axiom,
    ! [A,S0,T0,U] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),U)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),U)))) ) ).

fof(aSUBSETu_PSUBSETu_TRANS,axiom,
    ! [A,S0,T0,U] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),T0))),s(fun(A,bool),U)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),U)))) ) ).

fof(aPSUBSETu_IRREFL,axiom,
    ! [A,S0] : ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),S0)))) ).

fof(aNOTu_PSUBSETu_EMPTY,axiom,
    ! [A,S0] : ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),empty)))) ).

fof(aNOTu_UNIVu_PSUBSET,axiom,
    ! [A,S0] : ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),univ))),s(fun(A,bool),S0)))) ).

fof(aPSUBSETu_UNIV,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),univ))))
    <=> ? [X] : ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))) ) ).

fof(aPSUBSETu_ALT,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & ? [A5] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,A5))),s(fun(A,bool),T0))))
            & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,A5))),s(fun(A,bool),S0)))) ) ) ) ).

fof(aUNIONu_ASSOC,axiom,
    ! [A,S0,T0,U] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),U))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),T0))),s(fun(A,bool),U))))) ).

fof(aUNIONu_IDEMPOT,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),S0))) = s(fun(A,bool),S0) ).

fof(aUNIONu_COMM,axiom,
    ! [A,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),T0))),s(fun(A,bool),S0))) ).

fof(aSUBSETu_UNIONu_conjunct0,axiom,
    ! [A,S0,T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0)))))) ).

fof(aSUBSETu_UNIONu_conjunct1,axiom,
    ! [A,S0,T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),T0))),s(fun(A,bool),S0)))))) ).

fof(aSUBSETu_UNIONu_ABSORPTION,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),T0) ) ).

fof(aUNIONu_EMPTYu_conjunct0,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),empty))),s(fun(A,bool),S0))) = s(fun(A,bool),S0) ).

fof(aUNIONu_EMPTYu_conjunct1,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),empty))) = s(fun(A,bool),S0) ).

fof(aUNIONu_UNIVu_conjunct0,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),univ))),s(fun(A,bool),S0))) = s(fun(A,bool),univ) ).

fof(aUNIONu_UNIVu_conjunct1,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),univ))) = s(fun(A,bool),univ) ).

fof(aEMPTYu_UNION,axiom,
    ! [A,S0,T0] :
      ( s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),empty)
    <=> ( s(fun(A,bool),S0) = s(fun(A,bool),empty)
        & s(fun(A,bool),T0) = s(fun(A,bool),empty) ) ) ).

fof(aUNIONu_SUBSET,axiom,
    ! [Q45668,S0,T0,U] :
      ( p(s(bool,i(s(fun(fun(Q45668,bool),bool),i(s(fun(fun(Q45668,bool),fun(fun(Q45668,bool),bool)),subset),s(fun(Q45668,bool),i(s(fun(fun(Q45668,bool),fun(Q45668,bool)),i(s(fun(fun(Q45668,bool),fun(fun(Q45668,bool),fun(Q45668,bool))),union),s(fun(Q45668,bool),S0))),s(fun(Q45668,bool),T0))))),s(fun(Q45668,bool),U))))
    <=> ( p(s(bool,i(s(fun(fun(Q45668,bool),bool),i(s(fun(fun(Q45668,bool),fun(fun(Q45668,bool),bool)),subset),s(fun(Q45668,bool),S0))),s(fun(Q45668,bool),U))))
        & p(s(bool,i(s(fun(fun(Q45668,bool),bool),i(s(fun(fun(Q45668,bool),fun(fun(Q45668,bool),bool)),subset),s(fun(Q45668,bool),T0))),s(fun(Q45668,bool),U)))) ) ) ).

fof(aINTERu_ASSOC,axiom,
    ! [A,S0,T0,U] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),U))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),T0))),s(fun(A,bool),U))))) ).

fof(aINTERu_IDEMPOT,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),S0))) = s(fun(A,bool),S0) ).

fof(aINTERu_COMM,axiom,
    ! [A,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),T0))),s(fun(A,bool),S0))) ).

fof(aINTERu_SUBSETu_conjunct0,axiom,
    ! [A,S0,T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),S0)))) ).

fof(aINTERu_SUBSETu_conjunct1,axiom,
    ! [A,S0,T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),T0))),s(fun(A,bool),S0))))),s(fun(A,bool),S0)))) ).

fof(aSUBSETu_INTERu_ABSORPTION,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),S0) ) ).

fof(aINTERu_EMPTYu_conjunct0,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),empty))),s(fun(A,bool),S0))) = s(fun(A,bool),empty) ).

fof(aINTERu_EMPTYu_conjunct1,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),empty))) = s(fun(A,bool),empty) ).

fof(aINTERu_UNIVu_conjunct0,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),univ))),s(fun(A,bool),S0))) = s(fun(A,bool),S0) ).

fof(aINTERu_UNIVu_conjunct1,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),univ))) = s(fun(A,bool),S0) ).

fof(aSUBSETu_INTER,axiom,
    ! [Q45857,S0,T0,U] :
      ( p(s(bool,i(s(fun(fun(Q45857,bool),bool),i(s(fun(fun(Q45857,bool),fun(fun(Q45857,bool),bool)),subset),s(fun(Q45857,bool),S0))),s(fun(Q45857,bool),i(s(fun(fun(Q45857,bool),fun(Q45857,bool)),i(s(fun(fun(Q45857,bool),fun(fun(Q45857,bool),fun(Q45857,bool))),inter),s(fun(Q45857,bool),T0))),s(fun(Q45857,bool),U))))))
    <=> ( p(s(bool,i(s(fun(fun(Q45857,bool),bool),i(s(fun(fun(Q45857,bool),fun(fun(Q45857,bool),bool)),subset),s(fun(Q45857,bool),S0))),s(fun(Q45857,bool),T0))))
        & p(s(bool,i(s(fun(fun(Q45857,bool),bool),i(s(fun(fun(Q45857,bool),fun(fun(Q45857,bool),bool)),subset),s(fun(Q45857,bool),S0))),s(fun(Q45857,bool),U)))) ) ) ).

fof(aUNIONu_OVERu_INTER,axiom,
    ! [A,S0,T0,U] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),T0))),s(fun(A,bool),U))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),U))))) ).

fof(aINTERu_OVERu_UNION,axiom,
    ! [A,S0,T0,U] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),T0))),s(fun(A,bool),U))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),U))))) ).

fof(aINu_DISJOINT,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ~ ? [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aDISJOINTu_SYM,axiom,
    ! [A,S0,T0] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),T0))),s(fun(A,bool),S0))) ).

fof(aDISJOINTu_EMPTY,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),empty))),s(fun(A,bool),S0))))
      & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),empty)))) ) ).

fof(aDISJOINTu_EMPTYu_REFL,axiom,
    ! [A,S0] :
      ( s(fun(A,bool),S0) = s(fun(A,bool),empty)
    <=> p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),S0)))) ) ).

fof(aDISJOINTu_UNION,axiom,
    ! [A,S0,T0,U] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),U))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),U))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),T0))),s(fun(A,bool),U)))) ) ) ).

fof(aDIFFu_EMPTY,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),empty))) = s(fun(A,bool),S0) ).

fof(aEMPTYu_DIFF,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),empty))),s(fun(A,bool),S0))) = s(fun(A,bool),empty) ).

fof(aDIFFu_UNIV,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),univ))) = s(fun(A,bool),empty) ).

fof(aDIFFu_DIFF,axiom,
    ! [A,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))) ).

fof(aDIFFu_EQu_EMPTY,axiom,
    ! [A,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),S0))) = s(fun(A,bool),empty) ).

fof(aSUBSETu_DIFF,axiom,
    ! [Q46115,S0,T0] : p(s(bool,i(s(fun(fun(Q46115,bool),bool),i(s(fun(fun(Q46115,bool),fun(fun(Q46115,bool),bool)),subset),s(fun(Q46115,bool),i(s(fun(fun(Q46115,bool),fun(Q46115,bool)),i(s(fun(fun(Q46115,bool),fun(fun(Q46115,bool),fun(Q46115,bool))),diff),s(fun(Q46115,bool),S0))),s(fun(Q46115,bool),T0))))),s(fun(Q46115,bool),S0)))) ).

fof(aCOMPONENT,axiom,
    ! [A,X,S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0)))))) ).

fof(aDECOMPOSITION,axiom,
    ! [A,S0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
    <=> ? [T0] :
          ( s(fun(A,bool),S0) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),T0)))
          & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aSETu_CASES,axiom,
    ! [A,S0] :
      ( s(fun(A,bool),S0) = s(fun(A,bool),empty)
      | ? [X,T0] :
          ( s(fun(A,bool),S0) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),T0)))
          & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aABSORPTION,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
    <=> s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))) = s(fun(A,bool),S0) ) ).

fof(aINSERTu_INSERT,axiom,
    ! [A,X,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))) ).

fof(aINSERTu_COMM,axiom,
    ! [A,X,Y,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,Y))),s(fun(A,bool),S0))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,Y))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))) ).

fof(aINSERTu_UNIV,axiom,
    ! [A,X] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),univ))) = s(fun(A,bool),univ) ).

fof(aNOTu_INSERTu_EMPTY,axiom,
    ! [A,X,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))) != s(fun(A,bool),empty) ).

fof(aNOTu_EMPTYu_INSERT,axiom,
    ! [A,X,S0] : s(fun(A,bool),empty) != s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))) ).

fof(aINSERTu_UNION,axiom,
    ! [A,X,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),i(s(fun(bool,fun(fun(A,bool),fun(fun(A,bool),fun(A,bool)))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))) ).

fof(aINSERTu_UNIONu_EQ,axiom,
    ! [A,X,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) ).

fof(aINSERTu_INTER,axiom,
    ! [A,X,S0,T0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),i(s(fun(bool,fun(fun(A,bool),fun(fun(A,bool),fun(A,bool)))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) ).

fof(aDISJOINTu_INSERT,axiom,
    ! [A,X,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0)))) ) ) ).

fof(aINSERTu_SUBSET,axiom,
    ! [A,X,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0)))) ) ) ).

fof(aSUBSETu_INSERT,axiom,
    ! [A,X,S0] :
      ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
     => ! [T0] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),T0))))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))) ) ).

fof(aINSERTu_DIFF,axiom,
    ! [A,S0,T0,X] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),i(s(fun(bool,fun(fun(A,bool),fun(fun(A,bool),fun(A,bool)))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))) ).

fof(aINSERTu_ACu_conjunct0,axiom,
    ! [Q46571] : s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,x))),s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,y))),s(fun(Q46571,bool),s0))))) = s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,y))),s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,x))),s(fun(Q46571,bool),s0))))) ).

fof(aINSERTu_ACu_conjunct1,axiom,
    ! [Q46571] : s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,x))),s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,x))),s(fun(Q46571,bool),s0))))) = s(fun(Q46571,bool),i(s(fun(fun(Q46571,bool),fun(Q46571,bool)),i(s(fun(Q46571,fun(fun(Q46571,bool),fun(Q46571,bool))),insert),s(Q46571,x))),s(fun(Q46571,bool),s0))) ).

fof(aINTERu_ACIu_conjunct0,axiom,
    ! [Q46638] : s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),q))) = s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),q))),s(fun(Q46638,bool),p1))) ).

fof(aINTERu_ACIu_conjunct1,axiom,
    ! [Q46638] : s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),q))))),s(fun(Q46638,bool),r0))) = s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),q))),s(fun(Q46638,bool),r0))))) ).

fof(aINTERu_ACIu_conjunct2,axiom,
    ! [Q46638] : s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),q))),s(fun(Q46638,bool),r0))))) = s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),q))),s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),r0))))) ).

fof(aINTERu_ACIu_conjunct3,axiom,
    ! [Q46638] : s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),p1))) = s(fun(Q46638,bool),p1) ).

fof(aINTERu_ACIu_conjunct4,axiom,
    ! [Q46638] : s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),q))))) = s(fun(Q46638,bool),i(s(fun(fun(Q46638,bool),fun(Q46638,bool)),i(s(fun(fun(Q46638,bool),fun(fun(Q46638,bool),fun(Q46638,bool))),inter),s(fun(Q46638,bool),p1))),s(fun(Q46638,bool),q))) ).

fof(aUNIONu_ACIu_conjunct0,axiom,
    ! [Q46704] : s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),q))) = s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),q))),s(fun(Q46704,bool),p1))) ).

fof(aUNIONu_ACIu_conjunct1,axiom,
    ! [Q46704] : s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),q))))),s(fun(Q46704,bool),r0))) = s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),q))),s(fun(Q46704,bool),r0))))) ).

fof(aUNIONu_ACIu_conjunct2,axiom,
    ! [Q46704] : s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),q))),s(fun(Q46704,bool),r0))))) = s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),q))),s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),r0))))) ).

fof(aUNIONu_ACIu_conjunct3,axiom,
    ! [Q46704] : s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),p1))) = s(fun(Q46704,bool),p1) ).

fof(aUNIONu_ACIu_conjunct4,axiom,
    ! [Q46704] : s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),q))))) = s(fun(Q46704,bool),i(s(fun(fun(Q46704,bool),fun(Q46704,bool)),i(s(fun(fun(Q46704,bool),fun(fun(Q46704,bool),fun(Q46704,bool))),union),s(fun(Q46704,bool),p1))),s(fun(Q46704,bool),q))) ).

fof(aDELETEu_NONu_ELEMENT,axiom,
    ! [A,X,S0] :
      ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
    <=> s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))) = s(fun(A,bool),S0) ) ).

fof(aINu_DELETEu_EQ,axiom,
    ! [A,S0,X,XI_] :
      ( s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,XI_))),s(fun(A,bool),S0)))
    <=> s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,XI_))))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,XI_))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))) ) ).

fof(aEMPTYu_DELETE,axiom,
    ! [A,X] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),empty))),s(A,X))) = s(fun(A,bool),empty) ).

fof(aDELETEu_DELETE,axiom,
    ! [A,X,S0] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(A,X))) = s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))) ).

fof(aDELETEu_COMM,axiom,
    ! [A,X,Y,S0] : s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(A,Y))) = s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,Y))))),s(A,X))) ).

fof(aDELETEu_SUBSET,axiom,
    ! [A,X,S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(fun(A,bool),S0)))) ).

fof(aSUBSETu_DELETE,axiom,
    ! [A,X,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),T0))),s(A,X))))))
    <=> ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0)))) ) ) ).

fof(aSUBSETu_INSERTu_DELETE,axiom,
    ! [A,X,S0,T0] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),T0))))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(fun(A,bool),T0))) ).

fof(aDIFFu_INSERT,axiom,
    ! [A,S0,T0,X] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),T0))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(fun(A,bool),T0))) ).

fof(aPSUBSETu_INSERTu_SUBSET,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ? [X] :
          ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(fun(A,bool),T0)))) ) ) ).

fof(aPSUBSETu_MEMBER,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
        & ? [Y] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),T0))))
            & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0)))) ) ) ) ).

fof(aDELETEu_INSERT,axiom,
    ! [A,X,Y,S0] :
    ? [V] :
      ( ( p(s(bool,V))
      <=> s(A,X) = s(A,Y) )
      & s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(A,Y))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),i(s(fun(bool,fun(fun(A,bool),fun(fun(A,bool),fun(A,bool)))),cond),s(bool,V))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,Y))))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,Y))))))) ) ).

fof(aINSERTu_DELETE,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
     => s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))) = s(fun(A,bool),S0) ) ).

fof(aDELETEu_INTER,axiom,
    ! [A,S0,T0,X] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(fun(A,bool),T0))) = s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(A,X))) ).

fof(aDISJOINTu_DELETEu_SYM,axiom,
    ! [A,S0,T0,X] : s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(fun(A,bool),T0))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),disjoint),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),T0))),s(A,X))))),s(fun(A,bool),S0))) ).

fof(aUNIONSu_0,axiom,
    ! [Q47111] : s(fun(Q47111,bool),i(s(fun(fun(fun(Q47111,bool),bool),fun(Q47111,bool)),unions),s(fun(fun(Q47111,bool),bool),empty))) = s(fun(Q47111,bool),empty) ).

fof(aUNIONSu_1,axiom,
    ! [Q47117] : s(fun(Q47117,bool),i(s(fun(fun(fun(Q47117,bool),bool),fun(Q47117,bool)),unions),s(fun(fun(Q47117,bool),bool),i(s(fun(fun(fun(Q47117,bool),bool),fun(fun(Q47117,bool),bool)),i(s(fun(fun(Q47117,bool),fun(fun(fun(Q47117,bool),bool),fun(fun(Q47117,bool),bool))),insert),s(fun(Q47117,bool),s0))),s(fun(fun(Q47117,bool),bool),empty))))) = s(fun(Q47117,bool),s0) ).

fof(aUNIONSu_2,axiom,
    ! [Q47137] : s(fun(Q47137,bool),i(s(fun(fun(fun(Q47137,bool),bool),fun(Q47137,bool)),unions),s(fun(fun(Q47137,bool),bool),i(s(fun(fun(fun(Q47137,bool),bool),fun(fun(Q47137,bool),bool)),i(s(fun(fun(Q47137,bool),fun(fun(fun(Q47137,bool),bool),fun(fun(Q47137,bool),bool))),insert),s(fun(Q47137,bool),s0))),s(fun(fun(Q47137,bool),bool),i(s(fun(fun(fun(Q47137,bool),bool),fun(fun(Q47137,bool),bool)),i(s(fun(fun(Q47137,bool),fun(fun(fun(Q47137,bool),bool),fun(fun(Q47137,bool),bool))),insert),s(fun(Q47137,bool),t0))),s(fun(fun(Q47137,bool),bool),empty))))))) = s(fun(Q47137,bool),i(s(fun(fun(Q47137,bool),fun(Q47137,bool)),i(s(fun(fun(Q47137,bool),fun(fun(Q47137,bool),fun(Q47137,bool))),union),s(fun(Q47137,bool),s0))),s(fun(Q47137,bool),t0))) ).

fof(aUNIONSu_INSERT,axiom,
    ! [Q47151] : s(fun(Q47151,bool),i(s(fun(fun(fun(Q47151,bool),bool),fun(Q47151,bool)),unions),s(fun(fun(Q47151,bool),bool),i(s(fun(fun(fun(Q47151,bool),bool),fun(fun(Q47151,bool),bool)),i(s(fun(fun(Q47151,bool),fun(fun(fun(Q47151,bool),bool),fun(fun(Q47151,bool),bool))),insert),s(fun(Q47151,bool),s0))),s(fun(fun(Q47151,bool),bool),u))))) = s(fun(Q47151,bool),i(s(fun(fun(Q47151,bool),fun(Q47151,bool)),i(s(fun(fun(Q47151,bool),fun(fun(Q47151,bool),fun(Q47151,bool))),union),s(fun(Q47151,bool),s0))),s(fun(Q47151,bool),i(s(fun(fun(fun(Q47151,bool),bool),fun(Q47151,bool)),unions),s(fun(fun(Q47151,bool),bool),u))))) ).

fof(aFORALLu_INu_UNIONS,axiom,
    ! [Q47193,P0,S0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q47193,bool),bool),i(s(fun(Q47193,fun(fun(Q47193,bool),bool)),in),s(Q47193,X))),s(fun(Q47193,bool),i(s(fun(fun(fun(Q47193,bool),bool),fun(Q47193,bool)),unions),s(fun(fun(Q47193,bool),bool),S0))))))
         => p(s(bool,i(s(fun(Q47193,bool),P0),s(Q47193,X)))) )
    <=> ! [T0,X] :
          ( ( p(s(bool,i(s(fun(fun(fun(Q47193,bool),bool),bool),i(s(fun(fun(Q47193,bool),fun(fun(fun(Q47193,bool),bool),bool)),in),s(fun(Q47193,bool),T0))),s(fun(fun(Q47193,bool),bool),S0))))
            & p(s(bool,i(s(fun(fun(Q47193,bool),bool),i(s(fun(Q47193,fun(fun(Q47193,bool),bool)),in),s(Q47193,X))),s(fun(Q47193,bool),T0)))) )
         => p(s(bool,i(s(fun(Q47193,bool),P0),s(Q47193,X)))) ) ) ).

fof(aEXISTSu_INu_UNIONS,axiom,
    ! [Q47235,P0,S0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(fun(Q47235,bool),bool),i(s(fun(Q47235,fun(fun(Q47235,bool),bool)),in),s(Q47235,X))),s(fun(Q47235,bool),i(s(fun(fun(fun(Q47235,bool),bool),fun(Q47235,bool)),unions),s(fun(fun(Q47235,bool),bool),S0))))))
          & p(s(bool,i(s(fun(Q47235,bool),P0),s(Q47235,X)))) )
    <=> ? [T0,X] :
          ( p(s(bool,i(s(fun(fun(fun(Q47235,bool),bool),bool),i(s(fun(fun(Q47235,bool),fun(fun(fun(Q47235,bool),bool),bool)),in),s(fun(Q47235,bool),T0))),s(fun(fun(Q47235,bool),bool),S0))))
          & p(s(bool,i(s(fun(fun(Q47235,bool),bool),i(s(fun(Q47235,fun(fun(Q47235,bool),bool)),in),s(Q47235,X))),s(fun(Q47235,bool),T0))))
          & p(s(bool,i(s(fun(Q47235,bool),P0),s(Q47235,X)))) ) ) ).

fof(aEMPTYu_UNIONS,axiom,
    ! [Q47261,S0] :
      ( s(fun(Q47261,bool),i(s(fun(fun(fun(Q47261,bool),bool),fun(Q47261,bool)),unions),s(fun(fun(Q47261,bool),bool),S0))) = s(fun(Q47261,bool),empty)
    <=> ! [T0] :
          ( p(s(bool,i(s(fun(fun(fun(Q47261,bool),bool),bool),i(s(fun(fun(Q47261,bool),fun(fun(fun(Q47261,bool),bool),bool)),in),s(fun(Q47261,bool),T0))),s(fun(fun(Q47261,bool),bool),S0))))
         => s(fun(Q47261,bool),T0) = s(fun(Q47261,bool),empty) ) ) ).

fof(aINTERu_UNIONSu_conjunct0,axiom,
    ! [Q47300,U_0] :
      ( ! [S0,T0,GENR_PVARR_8] :
          ( p(s(bool,i(s(fun(fun(Q47300,bool),bool),i(s(fun(fun(Q47300,bool),fun(fun(Q47300,bool),bool)),i(s(fun(fun(fun(Q47300,bool),bool),fun(fun(Q47300,bool),fun(fun(Q47300,bool),bool))),U_0),s(fun(fun(Q47300,bool),bool),S0))),s(fun(Q47300,bool),T0))),s(fun(Q47300,bool),GENR_PVARR_8))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(Q47300,bool),bool),i(s(fun(bool,fun(fun(Q47300,bool),bool)),i(s(fun(fun(Q47300,bool),fun(bool,fun(fun(Q47300,bool),bool))),setspec),s(fun(Q47300,bool),GENR_PVARR_8))),s(bool,i(s(fun(fun(fun(Q47300,bool),bool),bool),i(s(fun(fun(Q47300,bool),fun(fun(fun(Q47300,bool),bool),bool)),in),s(fun(Q47300,bool),X))),s(fun(fun(Q47300,bool),bool),S0))))),s(fun(Q47300,bool),i(s(fun(fun(Q47300,bool),fun(Q47300,bool)),i(s(fun(fun(Q47300,bool),fun(fun(Q47300,bool),fun(Q47300,bool))),inter),s(fun(Q47300,bool),X))),s(fun(Q47300,bool),T0)))))) )
     => ! [S0,T0] : s(fun(Q47300,bool),i(s(fun(fun(Q47300,bool),fun(Q47300,bool)),i(s(fun(fun(Q47300,bool),fun(fun(Q47300,bool),fun(Q47300,bool))),inter),s(fun(Q47300,bool),i(s(fun(fun(fun(Q47300,bool),bool),fun(Q47300,bool)),unions),s(fun(fun(Q47300,bool),bool),S0))))),s(fun(Q47300,bool),T0))) = s(fun(Q47300,bool),i(s(fun(fun(fun(Q47300,bool),bool),fun(Q47300,bool)),unions),s(fun(fun(Q47300,bool),bool),i(s(fun(fun(fun(Q47300,bool),bool),fun(fun(Q47300,bool),bool)),gspec),s(fun(fun(Q47300,bool),bool),i(s(fun(fun(Q47300,bool),fun(fun(Q47300,bool),bool)),i(s(fun(fun(fun(Q47300,bool),bool),fun(fun(Q47300,bool),fun(fun(Q47300,bool),bool))),U_0),s(fun(fun(Q47300,bool),bool),S0))),s(fun(Q47300,bool),T0))))))) ) ).

fof(aINTERu_UNIONSu_conjunct1,axiom,
    ! [Q47336,U_0] :
      ( ! [S0,T0,GENR_PVARR_9] :
          ( p(s(bool,i(s(fun(fun(Q47336,bool),bool),i(s(fun(fun(Q47336,bool),fun(fun(Q47336,bool),bool)),i(s(fun(fun(fun(Q47336,bool),bool),fun(fun(Q47336,bool),fun(fun(Q47336,bool),bool))),U_0),s(fun(fun(Q47336,bool),bool),S0))),s(fun(Q47336,bool),T0))),s(fun(Q47336,bool),GENR_PVARR_9))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(Q47336,bool),bool),i(s(fun(bool,fun(fun(Q47336,bool),bool)),i(s(fun(fun(Q47336,bool),fun(bool,fun(fun(Q47336,bool),bool))),setspec),s(fun(Q47336,bool),GENR_PVARR_9))),s(bool,i(s(fun(fun(fun(Q47336,bool),bool),bool),i(s(fun(fun(Q47336,bool),fun(fun(fun(Q47336,bool),bool),bool)),in),s(fun(Q47336,bool),X))),s(fun(fun(Q47336,bool),bool),S0))))),s(fun(Q47336,bool),i(s(fun(fun(Q47336,bool),fun(Q47336,bool)),i(s(fun(fun(Q47336,bool),fun(fun(Q47336,bool),fun(Q47336,bool))),inter),s(fun(Q47336,bool),T0))),s(fun(Q47336,bool),X)))))) )
     => ! [S0,T0] : s(fun(Q47336,bool),i(s(fun(fun(Q47336,bool),fun(Q47336,bool)),i(s(fun(fun(Q47336,bool),fun(fun(Q47336,bool),fun(Q47336,bool))),inter),s(fun(Q47336,bool),T0))),s(fun(Q47336,bool),i(s(fun(fun(fun(Q47336,bool),bool),fun(Q47336,bool)),unions),s(fun(fun(Q47336,bool),bool),S0))))) = s(fun(Q47336,bool),i(s(fun(fun(fun(Q47336,bool),bool),fun(Q47336,bool)),unions),s(fun(fun(Q47336,bool),bool),i(s(fun(fun(fun(Q47336,bool),bool),fun(fun(Q47336,bool),bool)),gspec),s(fun(fun(Q47336,bool),bool),i(s(fun(fun(Q47336,bool),fun(fun(Q47336,bool),bool)),i(s(fun(fun(fun(Q47336,bool),bool),fun(fun(Q47336,bool),fun(fun(Q47336,bool),bool))),U_0),s(fun(fun(Q47336,bool),bool),S0))),s(fun(Q47336,bool),T0))))))) ) ).

fof(aUNIONSu_SUBSET,axiom,
    ! [Q47352,F0,T0] :
      ( p(s(bool,i(s(fun(fun(Q47352,bool),bool),i(s(fun(fun(Q47352,bool),fun(fun(Q47352,bool),bool)),subset),s(fun(Q47352,bool),i(s(fun(fun(fun(Q47352,bool),bool),fun(Q47352,bool)),unions),s(fun(fun(Q47352,bool),bool),F0))))),s(fun(Q47352,bool),T0))))
    <=> ! [S0] :
          ( p(s(bool,i(s(fun(fun(fun(Q47352,bool),bool),bool),i(s(fun(fun(Q47352,bool),fun(fun(fun(Q47352,bool),bool),bool)),in),s(fun(Q47352,bool),S0))),s(fun(fun(Q47352,bool),bool),F0))))
         => p(s(bool,i(s(fun(fun(Q47352,bool),bool),i(s(fun(fun(Q47352,bool),fun(fun(Q47352,bool),bool)),subset),s(fun(Q47352,bool),S0))),s(fun(Q47352,bool),T0)))) ) ) ).

fof(aSUBSETu_UNIONS,axiom,
    ! [Q47385,F0,G0] :
      ( p(s(bool,i(s(fun(fun(fun(Q47385,bool),bool),bool),i(s(fun(fun(fun(Q47385,bool),bool),fun(fun(fun(Q47385,bool),bool),bool)),subset),s(fun(fun(Q47385,bool),bool),F0))),s(fun(fun(Q47385,bool),bool),G0))))
     => p(s(bool,i(s(fun(fun(Q47385,bool),bool),i(s(fun(fun(Q47385,bool),fun(fun(Q47385,bool),bool)),subset),s(fun(Q47385,bool),i(s(fun(fun(fun(Q47385,bool),bool),fun(Q47385,bool)),unions),s(fun(fun(Q47385,bool),bool),F0))))),s(fun(Q47385,bool),i(s(fun(fun(fun(Q47385,bool),bool),fun(Q47385,bool)),unions),s(fun(fun(Q47385,bool),bool),G0)))))) ) ).

fof(aUNIONSu_UNION,axiom,
    ! [Q47409,S0,T0] : s(fun(Q47409,bool),i(s(fun(fun(fun(Q47409,bool),bool),fun(Q47409,bool)),unions),s(fun(fun(Q47409,bool),bool),i(s(fun(fun(fun(Q47409,bool),bool),fun(fun(Q47409,bool),bool)),i(s(fun(fun(fun(Q47409,bool),bool),fun(fun(fun(Q47409,bool),bool),fun(fun(Q47409,bool),bool))),union),s(fun(fun(Q47409,bool),bool),S0))),s(fun(fun(Q47409,bool),bool),T0))))) = s(fun(Q47409,bool),i(s(fun(fun(Q47409,bool),fun(Q47409,bool)),i(s(fun(fun(Q47409,bool),fun(fun(Q47409,bool),fun(Q47409,bool))),union),s(fun(Q47409,bool),i(s(fun(fun(fun(Q47409,bool),bool),fun(Q47409,bool)),unions),s(fun(fun(Q47409,bool),bool),S0))))),s(fun(Q47409,bool),i(s(fun(fun(fun(Q47409,bool),bool),fun(Q47409,bool)),unions),s(fun(fun(Q47409,bool),bool),T0))))) ).

fof(aINTERSu_UNION,axiom,
    ! [Q47433,S0,T0] : s(fun(Q47433,bool),i(s(fun(fun(fun(Q47433,bool),bool),fun(Q47433,bool)),inters),s(fun(fun(Q47433,bool),bool),i(s(fun(fun(fun(Q47433,bool),bool),fun(fun(Q47433,bool),bool)),i(s(fun(fun(fun(Q47433,bool),bool),fun(fun(fun(Q47433,bool),bool),fun(fun(Q47433,bool),bool))),union),s(fun(fun(Q47433,bool),bool),S0))),s(fun(fun(Q47433,bool),bool),T0))))) = s(fun(Q47433,bool),i(s(fun(fun(Q47433,bool),fun(Q47433,bool)),i(s(fun(fun(Q47433,bool),fun(fun(Q47433,bool),fun(Q47433,bool))),inter),s(fun(Q47433,bool),i(s(fun(fun(fun(Q47433,bool),bool),fun(Q47433,bool)),inters),s(fun(fun(Q47433,bool),bool),S0))))),s(fun(Q47433,bool),i(s(fun(fun(fun(Q47433,bool),bool),fun(Q47433,bool)),inters),s(fun(fun(Q47433,bool),bool),T0))))) ).

fof(aUNIONSu_MONO,axiom,
    ! [Q47464] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(fun(Q47464,bool),bool),bool),i(s(fun(fun(Q47464,bool),fun(fun(fun(Q47464,bool),bool),bool)),in),s(fun(Q47464,bool),X))),s(fun(fun(Q47464,bool),bool),s0))))
         => ? [Y] :
              ( p(s(bool,i(s(fun(fun(fun(Q47464,bool),bool),bool),i(s(fun(fun(Q47464,bool),fun(fun(fun(Q47464,bool),bool),bool)),in),s(fun(Q47464,bool),Y))),s(fun(fun(Q47464,bool),bool),t0))))
              & p(s(bool,i(s(fun(fun(Q47464,bool),bool),i(s(fun(fun(Q47464,bool),fun(fun(Q47464,bool),bool)),subset),s(fun(Q47464,bool),X))),s(fun(Q47464,bool),Y)))) ) )
     => p(s(bool,i(s(fun(fun(Q47464,bool),bool),i(s(fun(fun(Q47464,bool),fun(fun(Q47464,bool),bool)),subset),s(fun(Q47464,bool),i(s(fun(fun(fun(Q47464,bool),bool),fun(Q47464,bool)),unions),s(fun(fun(Q47464,bool),bool),s0))))),s(fun(Q47464,bool),i(s(fun(fun(fun(Q47464,bool),bool),fun(Q47464,bool)),unions),s(fun(fun(Q47464,bool),bool),t0)))))) ) ).

fof(aUNIONSu_MONOu_IMAGE,axiom,
    ! [Q47492,Q47481] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q47481,bool),bool),i(s(fun(Q47481,fun(fun(Q47481,bool),bool)),in),s(Q47481,X))),s(fun(Q47481,bool),s0))))
         => p(s(bool,i(s(fun(fun(Q47492,bool),bool),i(s(fun(fun(Q47492,bool),fun(fun(Q47492,bool),bool)),subset),s(fun(Q47492,bool),i(s(fun(Q47481,fun(Q47492,bool)),f),s(Q47481,X))))),s(fun(Q47492,bool),i(s(fun(Q47481,fun(Q47492,bool)),g),s(Q47481,X)))))) )
     => p(s(bool,i(s(fun(fun(Q47492,bool),bool),i(s(fun(fun(Q47492,bool),fun(fun(Q47492,bool),bool)),subset),s(fun(Q47492,bool),i(s(fun(fun(fun(Q47492,bool),bool),fun(Q47492,bool)),unions),s(fun(fun(Q47492,bool),bool),i(s(fun(fun(Q47481,bool),fun(fun(Q47492,bool),bool)),i(s(fun(fun(Q47481,fun(Q47492,bool)),fun(fun(Q47481,bool),fun(fun(Q47492,bool),bool))),image),s(fun(Q47481,fun(Q47492,bool)),f))),s(fun(Q47481,bool),s0))))))),s(fun(Q47492,bool),i(s(fun(fun(fun(Q47492,bool),bool),fun(Q47492,bool)),unions),s(fun(fun(Q47492,bool),bool),i(s(fun(fun(Q47481,bool),fun(fun(Q47492,bool),bool)),i(s(fun(fun(Q47481,fun(Q47492,bool)),fun(fun(Q47481,bool),fun(fun(Q47492,bool),bool))),image),s(fun(Q47481,fun(Q47492,bool)),g))),s(fun(Q47481,bool),s0)))))))) ) ).

fof(aINTERSu_0,axiom,
    ! [A] : s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),inters),s(fun(fun(A,bool),bool),empty))) = s(fun(A,bool),univ) ).

fof(aINTERSu_1,axiom,
    ! [Q47510] : s(fun(Q47510,bool),i(s(fun(fun(fun(Q47510,bool),bool),fun(Q47510,bool)),inters),s(fun(fun(Q47510,bool),bool),i(s(fun(fun(fun(Q47510,bool),bool),fun(fun(Q47510,bool),bool)),i(s(fun(fun(Q47510,bool),fun(fun(fun(Q47510,bool),bool),fun(fun(Q47510,bool),bool))),insert),s(fun(Q47510,bool),s0))),s(fun(fun(Q47510,bool),bool),empty))))) = s(fun(Q47510,bool),s0) ).

fof(aINTERSu_2,axiom,
    ! [Q47530] : s(fun(Q47530,bool),i(s(fun(fun(fun(Q47530,bool),bool),fun(Q47530,bool)),inters),s(fun(fun(Q47530,bool),bool),i(s(fun(fun(fun(Q47530,bool),bool),fun(fun(Q47530,bool),bool)),i(s(fun(fun(Q47530,bool),fun(fun(fun(Q47530,bool),bool),fun(fun(Q47530,bool),bool))),insert),s(fun(Q47530,bool),s0))),s(fun(fun(Q47530,bool),bool),i(s(fun(fun(fun(Q47530,bool),bool),fun(fun(Q47530,bool),bool)),i(s(fun(fun(Q47530,bool),fun(fun(fun(Q47530,bool),bool),fun(fun(Q47530,bool),bool))),insert),s(fun(Q47530,bool),t0))),s(fun(fun(Q47530,bool),bool),empty))))))) = s(fun(Q47530,bool),i(s(fun(fun(Q47530,bool),fun(Q47530,bool)),i(s(fun(fun(Q47530,bool),fun(fun(Q47530,bool),fun(Q47530,bool))),inter),s(fun(Q47530,bool),s0))),s(fun(Q47530,bool),t0))) ).

fof(aINTERSu_INSERT,axiom,
    ! [Q47544] : s(fun(Q47544,bool),i(s(fun(fun(fun(Q47544,bool),bool),fun(Q47544,bool)),inters),s(fun(fun(Q47544,bool),bool),i(s(fun(fun(fun(Q47544,bool),bool),fun(fun(Q47544,bool),bool)),i(s(fun(fun(Q47544,bool),fun(fun(fun(Q47544,bool),bool),fun(fun(Q47544,bool),bool))),insert),s(fun(Q47544,bool),s0))),s(fun(fun(Q47544,bool),bool),u))))) = s(fun(Q47544,bool),i(s(fun(fun(Q47544,bool),fun(Q47544,bool)),i(s(fun(fun(Q47544,bool),fun(fun(Q47544,bool),fun(Q47544,bool))),inter),s(fun(Q47544,bool),s0))),s(fun(Q47544,bool),i(s(fun(fun(fun(Q47544,bool),bool),fun(Q47544,bool)),inters),s(fun(fun(Q47544,bool),bool),u))))) ).

fof(aSUBSETu_INTERS,axiom,
    ! [Q47560,S0,F0] :
      ( p(s(bool,i(s(fun(fun(Q47560,bool),bool),i(s(fun(fun(Q47560,bool),fun(fun(Q47560,bool),bool)),subset),s(fun(Q47560,bool),S0))),s(fun(Q47560,bool),i(s(fun(fun(fun(Q47560,bool),bool),fun(Q47560,bool)),inters),s(fun(fun(Q47560,bool),bool),F0))))))
    <=> ! [T0] :
          ( p(s(bool,i(s(fun(fun(fun(Q47560,bool),bool),bool),i(s(fun(fun(Q47560,bool),fun(fun(fun(Q47560,bool),bool),bool)),in),s(fun(Q47560,bool),T0))),s(fun(fun(Q47560,bool),bool),F0))))
         => p(s(bool,i(s(fun(fun(Q47560,bool),bool),i(s(fun(fun(Q47560,bool),fun(fun(Q47560,bool),bool)),subset),s(fun(Q47560,bool),S0))),s(fun(Q47560,bool),T0)))) ) ) ).

fof(aIMAGEu_CLAUSESu_conjunct0,axiom,
    ! [Q47598,Q47602] : s(fun(Q47602,bool),i(s(fun(fun(Q47598,bool),fun(Q47602,bool)),i(s(fun(fun(Q47598,Q47602),fun(fun(Q47598,bool),fun(Q47602,bool))),image),s(fun(Q47598,Q47602),f))),s(fun(Q47598,bool),empty))) = s(fun(Q47602,bool),empty) ).

fof(aIMAGEu_CLAUSESu_conjunct1,axiom,
    ! [Q47602,Q47598] : s(fun(Q47602,bool),i(s(fun(fun(Q47598,bool),fun(Q47602,bool)),i(s(fun(fun(Q47598,Q47602),fun(fun(Q47598,bool),fun(Q47602,bool))),image),s(fun(Q47598,Q47602),f))),s(fun(Q47598,bool),i(s(fun(fun(Q47598,bool),fun(Q47598,bool)),i(s(fun(Q47598,fun(fun(Q47598,bool),fun(Q47598,bool))),insert),s(Q47598,x))),s(fun(Q47598,bool),s0))))) = s(fun(Q47602,bool),i(s(fun(fun(Q47602,bool),fun(Q47602,bool)),i(s(fun(Q47602,fun(fun(Q47602,bool),fun(Q47602,bool))),insert),s(Q47602,i(s(fun(Q47598,Q47602),f),s(Q47598,x))))),s(fun(Q47602,bool),i(s(fun(fun(Q47598,bool),fun(Q47602,bool)),i(s(fun(fun(Q47598,Q47602),fun(fun(Q47598,bool),fun(Q47602,bool))),image),s(fun(Q47598,Q47602),f))),s(fun(Q47598,bool),s0))))) ).

fof(aIMAGEu_UNION,axiom,
    ! [Q47636,Q47625,F0,S0,T0] : s(fun(Q47636,bool),i(s(fun(fun(Q47625,bool),fun(Q47636,bool)),i(s(fun(fun(Q47625,Q47636),fun(fun(Q47625,bool),fun(Q47636,bool))),image),s(fun(Q47625,Q47636),F0))),s(fun(Q47625,bool),i(s(fun(fun(Q47625,bool),fun(Q47625,bool)),i(s(fun(fun(Q47625,bool),fun(fun(Q47625,bool),fun(Q47625,bool))),union),s(fun(Q47625,bool),S0))),s(fun(Q47625,bool),T0))))) = s(fun(Q47636,bool),i(s(fun(fun(Q47636,bool),fun(Q47636,bool)),i(s(fun(fun(Q47636,bool),fun(fun(Q47636,bool),fun(Q47636,bool))),union),s(fun(Q47636,bool),i(s(fun(fun(Q47625,bool),fun(Q47636,bool)),i(s(fun(fun(Q47625,Q47636),fun(fun(Q47625,bool),fun(Q47636,bool))),image),s(fun(Q47625,Q47636),F0))),s(fun(Q47625,bool),S0))))),s(fun(Q47636,bool),i(s(fun(fun(Q47625,bool),fun(Q47636,bool)),i(s(fun(fun(Q47625,Q47636),fun(fun(Q47625,bool),fun(Q47636,bool))),image),s(fun(Q47625,Q47636),F0))),s(fun(Q47625,bool),T0))))) ).

fof(aIMAGEu_ID,axiom,
    ! [Q47649,U_0] :
      ( ! [X] : s(Q47649,i(s(fun(Q47649,Q47649),U_0),s(Q47649,X))) = s(Q47649,X)
     => ! [S0] : s(fun(Q47649,bool),i(s(fun(fun(Q47649,bool),fun(Q47649,bool)),i(s(fun(fun(Q47649,Q47649),fun(fun(Q47649,bool),fun(Q47649,bool))),image),s(fun(Q47649,Q47649),U_0))),s(fun(Q47649,bool),S0))) = s(fun(Q47649,bool),S0) ) ).

fof(aIMAGEu_I,axiom,
    ! [Q47663,S0] : s(fun(Q47663,bool),i(s(fun(fun(Q47663,bool),fun(Q47663,bool)),i(s(fun(fun(Q47663,Q47663),fun(fun(Q47663,bool),fun(Q47663,bool))),image),s(fun(Q47663,Q47663),i1))),s(fun(Q47663,bool),S0))) = s(fun(Q47663,bool),S0) ).

fof(aIMAGEu_o,axiom,
    ! [Q47692,Q47696,Q47687,F0,G0,S0] : s(fun(Q47692,bool),i(s(fun(fun(Q47687,bool),fun(Q47692,bool)),i(s(fun(fun(Q47687,Q47692),fun(fun(Q47687,bool),fun(Q47692,bool))),image),s(fun(Q47687,Q47692),i(s(fun(fun(Q47687,Q47696),fun(Q47687,Q47692)),i(s(fun(fun(Q47696,Q47692),fun(fun(Q47687,Q47696),fun(Q47687,Q47692))),o),s(fun(Q47696,Q47692),F0))),s(fun(Q47687,Q47696),G0))))),s(fun(Q47687,bool),S0))) = s(fun(Q47692,bool),i(s(fun(fun(Q47696,bool),fun(Q47692,bool)),i(s(fun(fun(Q47696,Q47692),fun(fun(Q47696,bool),fun(Q47692,bool))),image),s(fun(Q47696,Q47692),F0))),s(fun(Q47696,bool),i(s(fun(fun(Q47687,bool),fun(Q47696,bool)),i(s(fun(fun(Q47687,Q47696),fun(fun(Q47687,bool),fun(Q47696,bool))),image),s(fun(Q47687,Q47696),G0))),s(fun(Q47687,bool),S0))))) ).

fof(aIMAGEu_SUBSET,axiom,
    ! [Q47725,Q47714,F0,S0,T0] :
      ( p(s(bool,i(s(fun(fun(Q47714,bool),bool),i(s(fun(fun(Q47714,bool),fun(fun(Q47714,bool),bool)),subset),s(fun(Q47714,bool),S0))),s(fun(Q47714,bool),T0))))
     => p(s(bool,i(s(fun(fun(Q47725,bool),bool),i(s(fun(fun(Q47725,bool),fun(fun(Q47725,bool),bool)),subset),s(fun(Q47725,bool),i(s(fun(fun(Q47714,bool),fun(Q47725,bool)),i(s(fun(fun(Q47714,Q47725),fun(fun(Q47714,bool),fun(Q47725,bool))),image),s(fun(Q47714,Q47725),F0))),s(fun(Q47714,bool),S0))))),s(fun(Q47725,bool),i(s(fun(fun(Q47714,bool),fun(Q47725,bool)),i(s(fun(fun(Q47714,Q47725),fun(fun(Q47714,bool),fun(Q47725,bool))),image),s(fun(Q47714,Q47725),F0))),s(fun(Q47714,bool),T0)))))) ) ).

fof(aIMAGEu_INTERu_INJ,axiom,
    ! [Q47779,Q47768,F0,S0,T0] :
      ( ! [X,Y] :
          ( s(Q47779,i(s(fun(Q47768,Q47779),F0),s(Q47768,X))) = s(Q47779,i(s(fun(Q47768,Q47779),F0),s(Q47768,Y)))
         => s(Q47768,X) = s(Q47768,Y) )
     => s(fun(Q47779,bool),i(s(fun(fun(Q47768,bool),fun(Q47779,bool)),i(s(fun(fun(Q47768,Q47779),fun(fun(Q47768,bool),fun(Q47779,bool))),image),s(fun(Q47768,Q47779),F0))),s(fun(Q47768,bool),i(s(fun(fun(Q47768,bool),fun(Q47768,bool)),i(s(fun(fun(Q47768,bool),fun(fun(Q47768,bool),fun(Q47768,bool))),inter),s(fun(Q47768,bool),S0))),s(fun(Q47768,bool),T0))))) = s(fun(Q47779,bool),i(s(fun(fun(Q47779,bool),fun(Q47779,bool)),i(s(fun(fun(Q47779,bool),fun(fun(Q47779,bool),fun(Q47779,bool))),inter),s(fun(Q47779,bool),i(s(fun(fun(Q47768,bool),fun(Q47779,bool)),i(s(fun(fun(Q47768,Q47779),fun(fun(Q47768,bool),fun(Q47779,bool))),image),s(fun(Q47768,Q47779),F0))),s(fun(Q47768,bool),S0))))),s(fun(Q47779,bool),i(s(fun(fun(Q47768,bool),fun(Q47779,bool)),i(s(fun(fun(Q47768,Q47779),fun(fun(Q47768,bool),fun(Q47779,bool))),image),s(fun(Q47768,Q47779),F0))),s(fun(Q47768,bool),T0))))) ) ).

fof(aIMAGEu_DIFFu_INJ,axiom,
    ! [Q47833,Q47822,F0,S0,T0] :
      ( ! [X,Y] :
          ( s(Q47833,i(s(fun(Q47822,Q47833),F0),s(Q47822,X))) = s(Q47833,i(s(fun(Q47822,Q47833),F0),s(Q47822,Y)))
         => s(Q47822,X) = s(Q47822,Y) )
     => s(fun(Q47833,bool),i(s(fun(fun(Q47822,bool),fun(Q47833,bool)),i(s(fun(fun(Q47822,Q47833),fun(fun(Q47822,bool),fun(Q47833,bool))),image),s(fun(Q47822,Q47833),F0))),s(fun(Q47822,bool),i(s(fun(fun(Q47822,bool),fun(Q47822,bool)),i(s(fun(fun(Q47822,bool),fun(fun(Q47822,bool),fun(Q47822,bool))),diff),s(fun(Q47822,bool),S0))),s(fun(Q47822,bool),T0))))) = s(fun(Q47833,bool),i(s(fun(fun(Q47833,bool),fun(Q47833,bool)),i(s(fun(fun(Q47833,bool),fun(fun(Q47833,bool),fun(Q47833,bool))),diff),s(fun(Q47833,bool),i(s(fun(fun(Q47822,bool),fun(Q47833,bool)),i(s(fun(fun(Q47822,Q47833),fun(fun(Q47822,bool),fun(Q47833,bool))),image),s(fun(Q47822,Q47833),F0))),s(fun(Q47822,bool),S0))))),s(fun(Q47833,bool),i(s(fun(fun(Q47822,bool),fun(Q47833,bool)),i(s(fun(fun(Q47822,Q47833),fun(fun(Q47822,bool),fun(Q47833,bool))),image),s(fun(Q47822,Q47833),F0))),s(fun(Q47822,bool),T0))))) ) ).

fof(aIMAGEu_DELETEu_INJ,axiom,
    ! [Q47879,Q47880,F0,S0,A5] :
      ( ! [X] :
          ( s(Q47879,i(s(fun(Q47880,Q47879),F0),s(Q47880,X))) = s(Q47879,i(s(fun(Q47880,Q47879),F0),s(Q47880,A5)))
         => s(Q47880,X) = s(Q47880,A5) )
     => s(fun(Q47879,bool),i(s(fun(fun(Q47880,bool),fun(Q47879,bool)),i(s(fun(fun(Q47880,Q47879),fun(fun(Q47880,bool),fun(Q47879,bool))),image),s(fun(Q47880,Q47879),F0))),s(fun(Q47880,bool),i(s(fun(Q47880,fun(Q47880,bool)),i(s(fun(fun(Q47880,bool),fun(Q47880,fun(Q47880,bool))),delete),s(fun(Q47880,bool),S0))),s(Q47880,A5))))) = s(fun(Q47879,bool),i(s(fun(Q47879,fun(Q47879,bool)),i(s(fun(fun(Q47879,bool),fun(Q47879,fun(Q47879,bool))),delete),s(fun(Q47879,bool),i(s(fun(fun(Q47880,bool),fun(Q47879,bool)),i(s(fun(fun(Q47880,Q47879),fun(fun(Q47880,bool),fun(Q47879,bool))),image),s(fun(Q47880,Q47879),F0))),s(fun(Q47880,bool),S0))))),s(Q47879,i(s(fun(Q47880,Q47879),F0),s(Q47880,A5))))) ) ).

fof(aIMAGEu_EQu_EMPTY,axiom,
    ! [Q47899,Q47903,F0,S0] :
      ( s(fun(Q47899,bool),i(s(fun(fun(Q47903,bool),fun(Q47899,bool)),i(s(fun(fun(Q47903,Q47899),fun(fun(Q47903,bool),fun(Q47899,bool))),image),s(fun(Q47903,Q47899),F0))),s(fun(Q47903,bool),S0))) = s(fun(Q47899,bool),empty)
    <=> s(fun(Q47903,bool),S0) = s(fun(Q47903,bool),empty) ) ).

fof(aFORALLu_INu_IMAGE,axiom,
    ! [Q47938,Q47939,F0,S0] :
      ( ! [Y] :
          ( p(s(bool,i(s(fun(fun(Q47938,bool),bool),i(s(fun(Q47938,fun(fun(Q47938,bool),bool)),in),s(Q47938,Y))),s(fun(Q47938,bool),i(s(fun(fun(Q47939,bool),fun(Q47938,bool)),i(s(fun(fun(Q47939,Q47938),fun(fun(Q47939,bool),fun(Q47938,bool))),image),s(fun(Q47939,Q47938),F0))),s(fun(Q47939,bool),S0))))))
         => p(s(bool,i(s(fun(Q47938,bool),p0),s(Q47938,Y)))) )
    <=> ! [X] :
          ( p(s(bool,i(s(fun(fun(Q47939,bool),bool),i(s(fun(Q47939,fun(fun(Q47939,bool),bool)),in),s(Q47939,X))),s(fun(Q47939,bool),S0))))
         => p(s(bool,i(s(fun(Q47938,bool),p0),s(Q47938,i(s(fun(Q47939,Q47938),F0),s(Q47939,X)))))) ) ) ).

fof(aEXISTSu_INu_IMAGE,axiom,
    ! [Q47974,Q47975,F0,S0] :
      ( ? [Y] :
          ( p(s(bool,i(s(fun(fun(Q47974,bool),bool),i(s(fun(Q47974,fun(fun(Q47974,bool),bool)),in),s(Q47974,Y))),s(fun(Q47974,bool),i(s(fun(fun(Q47975,bool),fun(Q47974,bool)),i(s(fun(fun(Q47975,Q47974),fun(fun(Q47975,bool),fun(Q47974,bool))),image),s(fun(Q47975,Q47974),F0))),s(fun(Q47975,bool),S0))))))
          & p(s(bool,i(s(fun(Q47974,bool),p0),s(Q47974,Y)))) )
    <=> ? [X] :
          ( p(s(bool,i(s(fun(fun(Q47975,bool),bool),i(s(fun(Q47975,fun(fun(Q47975,bool),bool)),in),s(Q47975,X))),s(fun(Q47975,bool),S0))))
          & p(s(bool,i(s(fun(Q47974,bool),p0),s(Q47974,i(s(fun(Q47975,Q47974),F0),s(Q47975,X)))))) ) ) ).

fof(aSUBSETu_IMAGE,axiom,
    ! [B,A,F0,S0,T0] :
      ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),S0))),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),T0))))))
    <=> ? [U] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),U))),s(fun(A,bool),T0))))
          & s(fun(B,bool),S0) = s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),U))) ) ) ).

fof(aFORALLu_SUBSETu_IMAGE,axiom,
    ! [Q48078,Q48062,P0,F0,S0] :
      ( ! [T0] :
          ( p(s(bool,i(s(fun(fun(Q48078,bool),bool),i(s(fun(fun(Q48078,bool),fun(fun(Q48078,bool),bool)),subset),s(fun(Q48078,bool),T0))),s(fun(Q48078,bool),i(s(fun(fun(Q48062,bool),fun(Q48078,bool)),i(s(fun(fun(Q48062,Q48078),fun(fun(Q48062,bool),fun(Q48078,bool))),image),s(fun(Q48062,Q48078),F0))),s(fun(Q48062,bool),S0))))))
         => p(s(bool,i(s(fun(fun(Q48078,bool),bool),P0),s(fun(Q48078,bool),T0)))) )
    <=> ! [T0] :
          ( p(s(bool,i(s(fun(fun(Q48062,bool),bool),i(s(fun(fun(Q48062,bool),fun(fun(Q48062,bool),bool)),subset),s(fun(Q48062,bool),T0))),s(fun(Q48062,bool),S0))))
         => p(s(bool,i(s(fun(fun(Q48078,bool),bool),P0),s(fun(Q48078,bool),i(s(fun(fun(Q48062,bool),fun(Q48078,bool)),i(s(fun(fun(Q48062,Q48078),fun(fun(Q48062,bool),fun(Q48078,bool))),image),s(fun(Q48062,Q48078),F0))),s(fun(Q48062,bool),T0)))))) ) ) ).

fof(aEXISTSu_SUBSETu_IMAGE,axiom,
    ! [Q48121,Q48105,P0,F0,S0] :
      ( ? [T0] :
          ( p(s(bool,i(s(fun(fun(Q48121,bool),bool),i(s(fun(fun(Q48121,bool),fun(fun(Q48121,bool),bool)),subset),s(fun(Q48121,bool),T0))),s(fun(Q48121,bool),i(s(fun(fun(Q48105,bool),fun(Q48121,bool)),i(s(fun(fun(Q48105,Q48121),fun(fun(Q48105,bool),fun(Q48121,bool))),image),s(fun(Q48105,Q48121),F0))),s(fun(Q48105,bool),S0))))))
          & p(s(bool,i(s(fun(fun(Q48121,bool),bool),P0),s(fun(Q48121,bool),T0)))) )
    <=> ? [T0] :
          ( p(s(bool,i(s(fun(fun(Q48105,bool),bool),i(s(fun(fun(Q48105,bool),fun(fun(Q48105,bool),bool)),subset),s(fun(Q48105,bool),T0))),s(fun(Q48105,bool),S0))))
          & p(s(bool,i(s(fun(fun(Q48121,bool),bool),P0),s(fun(Q48121,bool),i(s(fun(fun(Q48105,bool),fun(Q48121,bool)),i(s(fun(fun(Q48105,Q48121),fun(fun(Q48105,bool),fun(Q48121,bool))),image),s(fun(Q48105,Q48121),F0))),s(fun(Q48105,bool),T0)))))) ) ) ).

fof(aIMAGEu_CONST,axiom,
    ! [Q48147,Q48152,U_0] :
      ( ! [C0,X] : s(Q48152,i(s(fun(Q48147,Q48152),i(s(fun(Q48152,fun(Q48147,Q48152)),U_0),s(Q48152,C0))),s(Q48147,X))) = s(Q48152,C0)
     => ! [S0,C0] :
        ? [V] :
          ( ( p(s(bool,V))
          <=> s(fun(Q48147,bool),S0) = s(fun(Q48147,bool),empty) )
          & s(fun(Q48152,bool),i(s(fun(fun(Q48147,bool),fun(Q48152,bool)),i(s(fun(fun(Q48147,Q48152),fun(fun(Q48147,bool),fun(Q48152,bool))),image),s(fun(Q48147,Q48152),i(s(fun(Q48152,fun(Q48147,Q48152)),U_0),s(Q48152,C0))))),s(fun(Q48147,bool),S0))) = s(fun(Q48152,bool),i(s(fun(fun(Q48152,bool),fun(Q48152,bool)),i(s(fun(fun(Q48152,bool),fun(fun(Q48152,bool),fun(Q48152,bool))),i(s(fun(bool,fun(fun(Q48152,bool),fun(fun(Q48152,bool),fun(Q48152,bool)))),cond),s(bool,V))),s(fun(Q48152,bool),empty))),s(fun(Q48152,bool),i(s(fun(fun(Q48152,bool),fun(Q48152,bool)),i(s(fun(Q48152,fun(fun(Q48152,bool),fun(Q48152,bool))),insert),s(Q48152,C0))),s(fun(Q48152,bool),empty))))) ) ) ).

fof(aSIMPLEu_IMAGE,axiom,
    ! [Q48184,Q48180,U_0] :
      ( ! [S0,F0,GENR_PVARR_11] :
          ( p(s(bool,i(s(fun(Q48184,bool),i(s(fun(fun(Q48180,Q48184),fun(Q48184,bool)),i(s(fun(fun(Q48180,bool),fun(fun(Q48180,Q48184),fun(Q48184,bool))),U_0),s(fun(Q48180,bool),S0))),s(fun(Q48180,Q48184),F0))),s(Q48184,GENR_PVARR_11))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48184,bool),i(s(fun(bool,fun(Q48184,bool)),i(s(fun(Q48184,fun(bool,fun(Q48184,bool))),setspec),s(Q48184,GENR_PVARR_11))),s(bool,i(s(fun(fun(Q48180,bool),bool),i(s(fun(Q48180,fun(fun(Q48180,bool),bool)),in),s(Q48180,X))),s(fun(Q48180,bool),S0))))),s(Q48184,i(s(fun(Q48180,Q48184),F0),s(Q48180,X)))))) )
     => ! [F0,S0] : s(fun(Q48184,bool),i(s(fun(fun(Q48184,bool),fun(Q48184,bool)),gspec),s(fun(Q48184,bool),i(s(fun(fun(Q48180,Q48184),fun(Q48184,bool)),i(s(fun(fun(Q48180,bool),fun(fun(Q48180,Q48184),fun(Q48184,bool))),U_0),s(fun(Q48180,bool),S0))),s(fun(Q48180,Q48184),F0))))) = s(fun(Q48184,bool),i(s(fun(fun(Q48180,bool),fun(Q48184,bool)),i(s(fun(fun(Q48180,Q48184),fun(fun(Q48180,bool),fun(Q48184,bool))),image),s(fun(Q48180,Q48184),F0))),s(fun(Q48180,bool),S0))) ) ).

fof(aSIMPLEu_IMAGEu_GEN,axiom,
    ! [Q48214,Q48227,U_1] :
      ( ! [P0,GENR_PVARR_13] :
          ( p(s(bool,i(s(fun(Q48227,bool),i(s(fun(fun(Q48227,bool),fun(Q48227,bool)),U_1),s(fun(Q48227,bool),P0))),s(Q48227,GENR_PVARR_13))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48227,bool),i(s(fun(bool,fun(Q48227,bool)),i(s(fun(Q48227,fun(bool,fun(Q48227,bool))),setspec),s(Q48227,GENR_PVARR_13))),s(bool,i(s(fun(Q48227,bool),P0),s(Q48227,X))))),s(Q48227,X)))) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_12] :
              ( p(s(bool,i(s(fun(Q48214,bool),i(s(fun(fun(Q48227,Q48214),fun(Q48214,bool)),i(s(fun(fun(Q48227,bool),fun(fun(Q48227,Q48214),fun(Q48214,bool))),U_0),s(fun(Q48227,bool),P0))),s(fun(Q48227,Q48214),F0))),s(Q48214,GENR_PVARR_12))))
            <=> ? [X] : p(s(bool,i(s(fun(Q48214,bool),i(s(fun(bool,fun(Q48214,bool)),i(s(fun(Q48214,fun(bool,fun(Q48214,bool))),setspec),s(Q48214,GENR_PVARR_12))),s(bool,i(s(fun(Q48227,bool),P0),s(Q48227,X))))),s(Q48214,i(s(fun(Q48227,Q48214),F0),s(Q48227,X)))))) )
         => ! [F0,P0] : s(fun(Q48214,bool),i(s(fun(fun(Q48214,bool),fun(Q48214,bool)),gspec),s(fun(Q48214,bool),i(s(fun(fun(Q48227,Q48214),fun(Q48214,bool)),i(s(fun(fun(Q48227,bool),fun(fun(Q48227,Q48214),fun(Q48214,bool))),U_0),s(fun(Q48227,bool),P0))),s(fun(Q48227,Q48214),F0))))) = s(fun(Q48214,bool),i(s(fun(fun(Q48227,bool),fun(Q48214,bool)),i(s(fun(fun(Q48227,Q48214),fun(fun(Q48227,bool),fun(Q48214,bool))),image),s(fun(Q48227,Q48214),F0))),s(fun(Q48227,bool),i(s(fun(fun(Q48227,bool),fun(Q48227,bool)),gspec),s(fun(Q48227,bool),i(s(fun(fun(Q48227,bool),fun(Q48227,bool)),U_1),s(fun(Q48227,bool),P0))))))) ) ) ).

fof(aIMAGEu_UNIONS,axiom,
    ! [Q48254,Q48245,F0,S0] : s(fun(Q48254,bool),i(s(fun(fun(Q48245,bool),fun(Q48254,bool)),i(s(fun(fun(Q48245,Q48254),fun(fun(Q48245,bool),fun(Q48254,bool))),image),s(fun(Q48245,Q48254),F0))),s(fun(Q48245,bool),i(s(fun(fun(fun(Q48245,bool),bool),fun(Q48245,bool)),unions),s(fun(fun(Q48245,bool),bool),S0))))) = s(fun(Q48254,bool),i(s(fun(fun(fun(Q48254,bool),bool),fun(Q48254,bool)),unions),s(fun(fun(Q48254,bool),bool),i(s(fun(fun(fun(Q48245,bool),bool),fun(fun(Q48254,bool),bool)),i(s(fun(fun(fun(Q48245,bool),fun(Q48254,bool)),fun(fun(fun(Q48245,bool),bool),fun(fun(Q48254,bool),bool))),image),s(fun(fun(Q48245,bool),fun(Q48254,bool)),i(s(fun(fun(Q48245,Q48254),fun(fun(Q48245,bool),fun(Q48254,bool))),image),s(fun(Q48245,Q48254),F0))))),s(fun(fun(Q48245,bool),bool),S0))))) ).

fof(aFUNu_INu_IMAGE,axiom,
    ! [Q48280,Q48276,F0,S0,X] :
      ( p(s(bool,i(s(fun(fun(Q48276,bool),bool),i(s(fun(Q48276,fun(fun(Q48276,bool),bool)),in),s(Q48276,X))),s(fun(Q48276,bool),S0))))
     => p(s(bool,i(s(fun(fun(Q48280,bool),bool),i(s(fun(Q48280,fun(fun(Q48280,bool),bool)),in),s(Q48280,i(s(fun(Q48276,Q48280),F0),s(Q48276,X))))),s(fun(Q48280,bool),i(s(fun(fun(Q48276,bool),fun(Q48280,bool)),i(s(fun(fun(Q48276,Q48280),fun(fun(Q48276,bool),fun(Q48280,bool))),image),s(fun(Q48276,Q48280),F0))),s(fun(Q48276,bool),S0)))))) ) ).

fof(aSURJECTIVEu_IMAGEu_EQ,axiom,
    ! [Q48322,Q48318,S0,T0] :
      ( ( ! [Y] :
            ( p(s(bool,i(s(fun(fun(Q48318,bool),bool),i(s(fun(Q48318,fun(fun(Q48318,bool),bool)),in),s(Q48318,Y))),s(fun(Q48318,bool),T0))))
           => ? [X] : s(Q48318,i(s(fun(Q48322,Q48318),f),s(Q48322,X))) = s(Q48318,Y) )
        & ! [X] : s(bool,i(s(fun(fun(Q48318,bool),bool),i(s(fun(Q48318,fun(fun(Q48318,bool),bool)),in),s(Q48318,i(s(fun(Q48322,Q48318),f),s(Q48322,X))))),s(fun(Q48318,bool),T0))) = s(bool,i(s(fun(fun(Q48322,bool),bool),i(s(fun(Q48322,fun(fun(Q48322,bool),bool)),in),s(Q48322,X))),s(fun(Q48322,bool),S0))) )
     => s(fun(Q48318,bool),i(s(fun(fun(Q48322,bool),fun(Q48318,bool)),i(s(fun(fun(Q48322,Q48318),fun(fun(Q48322,bool),fun(Q48318,bool))),image),s(fun(Q48322,Q48318),f))),s(fun(Q48322,bool),S0))) = s(fun(Q48318,bool),T0) ) ).

fof(aEMPTYu_GSPEC,axiom,
    ! [Q48347,U_0] :
      ( ! [GENR_PVARR_14] :
          ( p(s(bool,i(s(fun(Q48347,bool),U_0),s(Q48347,GENR_PVARR_14))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48347,bool),i(s(fun(bool,fun(Q48347,bool)),i(s(fun(Q48347,fun(bool,fun(Q48347,bool))),setspec),s(Q48347,GENR_PVARR_14))),s(bool,f0))),s(Q48347,X)))) )
     => s(fun(Q48347,bool),i(s(fun(fun(Q48347,bool),fun(Q48347,bool)),gspec),s(fun(Q48347,bool),U_0))) = s(fun(Q48347,bool),empty) ) ).

fof(aUNIVu_GSPEC,axiom,
    ! [Q48364,U_0] :
      ( ! [GENR_PVARR_15] :
          ( p(s(bool,i(s(fun(Q48364,bool),U_0),s(Q48364,GENR_PVARR_15))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48364,bool),i(s(fun(bool,fun(Q48364,bool)),i(s(fun(Q48364,fun(bool,fun(Q48364,bool))),setspec),s(Q48364,GENR_PVARR_15))),s(bool,t))),s(Q48364,X)))) )
     => s(fun(Q48364,bool),i(s(fun(fun(Q48364,bool),fun(Q48364,bool)),gspec),s(fun(Q48364,bool),U_0))) = s(fun(Q48364,bool),univ) ) ).

fof(aSINGu_GSPECu_conjunct0,axiom,
    ! [Q48393,U_0] :
      ( ! [A5,GENR_PVARR_16] :
          ( p(s(bool,i(s(fun(Q48393,bool),i(s(fun(Q48393,fun(Q48393,bool)),U_0),s(Q48393,A5))),s(Q48393,GENR_PVARR_16))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> s(Q48393,X) = s(Q48393,A5) )
              & p(s(bool,i(s(fun(Q48393,bool),i(s(fun(bool,fun(Q48393,bool)),i(s(fun(Q48393,fun(bool,fun(Q48393,bool))),setspec),s(Q48393,GENR_PVARR_16))),s(bool,V))),s(Q48393,X)))) ) )
     => ! [A5] : s(fun(Q48393,bool),i(s(fun(fun(Q48393,bool),fun(Q48393,bool)),gspec),s(fun(Q48393,bool),i(s(fun(Q48393,fun(Q48393,bool)),U_0),s(Q48393,A5))))) = s(fun(Q48393,bool),i(s(fun(fun(Q48393,bool),fun(Q48393,bool)),i(s(fun(Q48393,fun(fun(Q48393,bool),fun(Q48393,bool))),insert),s(Q48393,A5))),s(fun(Q48393,bool),empty))) ) ).

fof(aSINGu_GSPECu_conjunct1,axiom,
    ! [Q48419,U_0] :
      ( ! [A5,GENR_PVARR_17] :
          ( p(s(bool,i(s(fun(Q48419,bool),i(s(fun(Q48419,fun(Q48419,bool)),U_0),s(Q48419,A5))),s(Q48419,GENR_PVARR_17))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> s(Q48419,A5) = s(Q48419,X) )
              & p(s(bool,i(s(fun(Q48419,bool),i(s(fun(bool,fun(Q48419,bool)),i(s(fun(Q48419,fun(bool,fun(Q48419,bool))),setspec),s(Q48419,GENR_PVARR_17))),s(bool,V))),s(Q48419,X)))) ) )
     => ! [A5] : s(fun(Q48419,bool),i(s(fun(fun(Q48419,bool),fun(Q48419,bool)),gspec),s(fun(Q48419,bool),i(s(fun(Q48419,fun(Q48419,bool)),U_0),s(Q48419,A5))))) = s(fun(Q48419,bool),i(s(fun(fun(Q48419,bool),fun(Q48419,bool)),i(s(fun(Q48419,fun(fun(Q48419,bool),fun(Q48419,bool))),insert),s(Q48419,A5))),s(fun(Q48419,bool),empty))) ) ).

fof(aINu_ELIMu_PAIRu_THM,axiom,
    ! [Q48465,Q48464,U_0] :
      ( ! [P0,GENR_PVARR_18] :
          ( p(s(bool,i(s(fun(prod(Q48465,Q48464),bool),i(s(fun(fun(Q48465,fun(Q48464,bool)),fun(prod(Q48465,Q48464),bool)),U_0),s(fun(Q48465,fun(Q48464,bool)),P0))),s(prod(Q48465,Q48464),GENR_PVARR_18))))
        <=> ? [X,Y] : p(s(bool,i(s(fun(prod(Q48465,Q48464),bool),i(s(fun(bool,fun(prod(Q48465,Q48464),bool)),i(s(fun(prod(Q48465,Q48464),fun(bool,fun(prod(Q48465,Q48464),bool))),setspec),s(prod(Q48465,Q48464),GENR_PVARR_18))),s(bool,i(s(fun(Q48464,bool),i(s(fun(Q48465,fun(Q48464,bool)),P0),s(Q48465,X))),s(Q48464,Y))))),s(prod(Q48465,Q48464),i(s(fun(Q48464,prod(Q48465,Q48464)),i(s(fun(Q48465,fun(Q48464,prod(Q48465,Q48464))),c_),s(Q48465,X))),s(Q48464,Y)))))) )
     => ! [P0,A5,B0] : s(bool,i(s(fun(fun(prod(Q48465,Q48464),bool),bool),i(s(fun(prod(Q48465,Q48464),fun(fun(prod(Q48465,Q48464),bool),bool)),in),s(prod(Q48465,Q48464),i(s(fun(Q48464,prod(Q48465,Q48464)),i(s(fun(Q48465,fun(Q48464,prod(Q48465,Q48464))),c_),s(Q48465,A5))),s(Q48464,B0))))),s(fun(prod(Q48465,Q48464),bool),i(s(fun(fun(prod(Q48465,Q48464),bool),fun(prod(Q48465,Q48464),bool)),gspec),s(fun(prod(Q48465,Q48464),bool),i(s(fun(fun(Q48465,fun(Q48464,bool)),fun(prod(Q48465,Q48464),bool)),U_0),s(fun(Q48465,fun(Q48464,bool)),P0))))))) = s(bool,i(s(fun(Q48464,bool),i(s(fun(Q48465,fun(Q48464,bool)),P0),s(Q48465,A5))),s(Q48464,B0))) ) ).

fof(aSETu_PAIRu_THM,axiom,
    ! [Q48509,Q48508,U_1] :
      ( ! [P0,GENR_PVARR_20] :
          ( p(s(bool,i(s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),U_1),s(fun(prod(Q48509,Q48508),bool),P0))),s(prod(Q48509,Q48508),GENR_PVARR_20))))
        <=> ? [A5,B0] : p(s(bool,i(s(fun(prod(Q48509,Q48508),bool),i(s(fun(bool,fun(prod(Q48509,Q48508),bool)),i(s(fun(prod(Q48509,Q48508),fun(bool,fun(prod(Q48509,Q48508),bool))),setspec),s(prod(Q48509,Q48508),GENR_PVARR_20))),s(bool,i(s(fun(prod(Q48509,Q48508),bool),P0),s(prod(Q48509,Q48508),i(s(fun(Q48508,prod(Q48509,Q48508)),i(s(fun(Q48509,fun(Q48508,prod(Q48509,Q48508))),c_),s(Q48509,A5))),s(Q48508,B0))))))),s(prod(Q48509,Q48508),i(s(fun(Q48508,prod(Q48509,Q48508)),i(s(fun(Q48509,fun(Q48508,prod(Q48509,Q48508))),c_),s(Q48509,A5))),s(Q48508,B0)))))) )
     => ! [U_0] :
          ( ! [P0,GENR_PVARR_19] :
              ( p(s(bool,i(s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),U_0),s(fun(prod(Q48509,Q48508),bool),P0))),s(prod(Q48509,Q48508),GENR_PVARR_19))))
            <=> ? [P1] : p(s(bool,i(s(fun(prod(Q48509,Q48508),bool),i(s(fun(bool,fun(prod(Q48509,Q48508),bool)),i(s(fun(prod(Q48509,Q48508),fun(bool,fun(prod(Q48509,Q48508),bool))),setspec),s(prod(Q48509,Q48508),GENR_PVARR_19))),s(bool,i(s(fun(prod(Q48509,Q48508),bool),P0),s(prod(Q48509,Q48508),P1))))),s(prod(Q48509,Q48508),P1)))) )
         => ! [P0] : s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),gspec),s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),U_0),s(fun(prod(Q48509,Q48508),bool),P0))))) = s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),gspec),s(fun(prod(Q48509,Q48508),bool),i(s(fun(fun(prod(Q48509,Q48508),bool),fun(prod(Q48509,Q48508),bool)),U_1),s(fun(prod(Q48509,Q48508),bool),P0))))) ) ) ).

fof(aFORALLu_INu_GSPECu_conjunct0,axiom,
    ! [Q48678,Q48557,U_0] :
      ( ! [P0,F0,GENR_PVARR_21] :
          ( p(s(bool,i(s(fun(Q48678,bool),i(s(fun(fun(Q48557,Q48678),fun(Q48678,bool)),i(s(fun(fun(Q48557,bool),fun(fun(Q48557,Q48678),fun(Q48678,bool))),U_0),s(fun(Q48557,bool),P0))),s(fun(Q48557,Q48678),F0))),s(Q48678,GENR_PVARR_21))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48678,bool),i(s(fun(bool,fun(Q48678,bool)),i(s(fun(Q48678,fun(bool,fun(Q48678,bool))),setspec),s(Q48678,GENR_PVARR_21))),s(bool,i(s(fun(Q48557,bool),P0),s(Q48557,X))))),s(Q48678,i(s(fun(Q48557,Q48678),F0),s(Q48557,X)))))) )
     => ! [P0,F0] :
          ( ! [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48678,bool),bool),i(s(fun(Q48678,fun(fun(Q48678,bool),bool)),in),s(Q48678,Z0))),s(fun(Q48678,bool),i(s(fun(fun(Q48678,bool),fun(Q48678,bool)),gspec),s(fun(Q48678,bool),i(s(fun(fun(Q48557,Q48678),fun(Q48678,bool)),i(s(fun(fun(Q48557,bool),fun(fun(Q48557,Q48678),fun(Q48678,bool))),U_0),s(fun(Q48557,bool),P0))),s(fun(Q48557,Q48678),F0))))))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,Z0)))) )
        <=> ! [X] :
              ( p(s(bool,i(s(fun(Q48557,bool),P0),s(Q48557,X))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,i(s(fun(Q48557,Q48678),F0),s(Q48557,X)))))) ) ) ) ).

fof(aFORALLu_INu_GSPECu_conjunct1,axiom,
    ! [Q48678,Q48614,Q48613,U_0] :
      ( ! [P0,F0,GENR_PVARR_22] :
          ( p(s(bool,i(s(fun(Q48678,bool),i(s(fun(fun(Q48614,fun(Q48613,Q48678)),fun(Q48678,bool)),i(s(fun(fun(Q48614,fun(Q48613,bool)),fun(fun(Q48614,fun(Q48613,Q48678)),fun(Q48678,bool))),U_0),s(fun(Q48614,fun(Q48613,bool)),P0))),s(fun(Q48614,fun(Q48613,Q48678)),F0))),s(Q48678,GENR_PVARR_22))))
        <=> ? [X,Y] : p(s(bool,i(s(fun(Q48678,bool),i(s(fun(bool,fun(Q48678,bool)),i(s(fun(Q48678,fun(bool,fun(Q48678,bool))),setspec),s(Q48678,GENR_PVARR_22))),s(bool,i(s(fun(Q48613,bool),i(s(fun(Q48614,fun(Q48613,bool)),P0),s(Q48614,X))),s(Q48613,Y))))),s(Q48678,i(s(fun(Q48613,Q48678),i(s(fun(Q48614,fun(Q48613,Q48678)),F0),s(Q48614,X))),s(Q48613,Y)))))) )
     => ! [P0,F0] :
          ( ! [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48678,bool),bool),i(s(fun(Q48678,fun(fun(Q48678,bool),bool)),in),s(Q48678,Z0))),s(fun(Q48678,bool),i(s(fun(fun(Q48678,bool),fun(Q48678,bool)),gspec),s(fun(Q48678,bool),i(s(fun(fun(Q48614,fun(Q48613,Q48678)),fun(Q48678,bool)),i(s(fun(fun(Q48614,fun(Q48613,bool)),fun(fun(Q48614,fun(Q48613,Q48678)),fun(Q48678,bool))),U_0),s(fun(Q48614,fun(Q48613,bool)),P0))),s(fun(Q48614,fun(Q48613,Q48678)),F0))))))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,Z0)))) )
        <=> ! [X,Y] :
              ( p(s(bool,i(s(fun(Q48613,bool),i(s(fun(Q48614,fun(Q48613,bool)),P0),s(Q48614,X))),s(Q48613,Y))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,i(s(fun(Q48613,Q48678),i(s(fun(Q48614,fun(Q48613,Q48678)),F0),s(Q48614,X))),s(Q48613,Y)))))) ) ) ) ).

fof(aFORALLu_INu_GSPECu_conjunct2,axiom,
    ! [Q48678,Q48681,Q48680,Q48679,U_0] :
      ( ! [P0,F0,GENR_PVARR_23] :
          ( p(s(bool,i(s(fun(Q48678,bool),i(s(fun(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),fun(Q48678,bool)),i(s(fun(fun(Q48681,fun(Q48680,fun(Q48679,bool))),fun(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),fun(Q48678,bool))),U_0),s(fun(Q48681,fun(Q48680,fun(Q48679,bool))),P0))),s(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),F0))),s(Q48678,GENR_PVARR_23))))
        <=> ? [W,X,Y] : p(s(bool,i(s(fun(Q48678,bool),i(s(fun(bool,fun(Q48678,bool)),i(s(fun(Q48678,fun(bool,fun(Q48678,bool))),setspec),s(Q48678,GENR_PVARR_23))),s(bool,i(s(fun(Q48679,bool),i(s(fun(Q48680,fun(Q48679,bool)),i(s(fun(Q48681,fun(Q48680,fun(Q48679,bool))),P0),s(Q48681,W))),s(Q48680,X))),s(Q48679,Y))))),s(Q48678,i(s(fun(Q48679,Q48678),i(s(fun(Q48680,fun(Q48679,Q48678)),i(s(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),F0),s(Q48681,W))),s(Q48680,X))),s(Q48679,Y)))))) )
     => ! [P0,F0] :
          ( ! [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48678,bool),bool),i(s(fun(Q48678,fun(fun(Q48678,bool),bool)),in),s(Q48678,Z0))),s(fun(Q48678,bool),i(s(fun(fun(Q48678,bool),fun(Q48678,bool)),gspec),s(fun(Q48678,bool),i(s(fun(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),fun(Q48678,bool)),i(s(fun(fun(Q48681,fun(Q48680,fun(Q48679,bool))),fun(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),fun(Q48678,bool))),U_0),s(fun(Q48681,fun(Q48680,fun(Q48679,bool))),P0))),s(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),F0))))))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,Z0)))) )
        <=> ! [W,X,Y] :
              ( p(s(bool,i(s(fun(Q48679,bool),i(s(fun(Q48680,fun(Q48679,bool)),i(s(fun(Q48681,fun(Q48680,fun(Q48679,bool))),P0),s(Q48681,W))),s(Q48680,X))),s(Q48679,Y))))
             => p(s(bool,i(s(fun(Q48678,bool),q0),s(Q48678,i(s(fun(Q48679,Q48678),i(s(fun(Q48680,fun(Q48679,Q48678)),i(s(fun(Q48681,fun(Q48680,fun(Q48679,Q48678))),F0),s(Q48681,W))),s(Q48680,X))),s(Q48679,Y)))))) ) ) ) ).

fof(aEXISTSu_INu_GSPECu_conjunct0,axiom,
    ! [Q48848,Q48727,U_0] :
      ( ! [P0,F0,GENR_PVARR_24] :
          ( p(s(bool,i(s(fun(Q48848,bool),i(s(fun(fun(Q48727,Q48848),fun(Q48848,bool)),i(s(fun(fun(Q48727,bool),fun(fun(Q48727,Q48848),fun(Q48848,bool))),U_0),s(fun(Q48727,bool),P0))),s(fun(Q48727,Q48848),F0))),s(Q48848,GENR_PVARR_24))))
        <=> ? [X] : p(s(bool,i(s(fun(Q48848,bool),i(s(fun(bool,fun(Q48848,bool)),i(s(fun(Q48848,fun(bool,fun(Q48848,bool))),setspec),s(Q48848,GENR_PVARR_24))),s(bool,i(s(fun(Q48727,bool),P0),s(Q48727,X))))),s(Q48848,i(s(fun(Q48727,Q48848),F0),s(Q48727,X)))))) )
     => ! [P0,F0] :
          ( ? [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48848,bool),bool),i(s(fun(Q48848,fun(fun(Q48848,bool),bool)),in),s(Q48848,Z0))),s(fun(Q48848,bool),i(s(fun(fun(Q48848,bool),fun(Q48848,bool)),gspec),s(fun(Q48848,bool),i(s(fun(fun(Q48727,Q48848),fun(Q48848,bool)),i(s(fun(fun(Q48727,bool),fun(fun(Q48727,Q48848),fun(Q48848,bool))),U_0),s(fun(Q48727,bool),P0))),s(fun(Q48727,Q48848),F0))))))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,Z0)))) )
        <=> ? [X] :
              ( p(s(bool,i(s(fun(Q48727,bool),P0),s(Q48727,X))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,i(s(fun(Q48727,Q48848),F0),s(Q48727,X)))))) ) ) ) ).

fof(aEXISTSu_INu_GSPECu_conjunct1,axiom,
    ! [Q48848,Q48784,Q48783,U_0] :
      ( ! [P0,F0,GENR_PVARR_25] :
          ( p(s(bool,i(s(fun(Q48848,bool),i(s(fun(fun(Q48784,fun(Q48783,Q48848)),fun(Q48848,bool)),i(s(fun(fun(Q48784,fun(Q48783,bool)),fun(fun(Q48784,fun(Q48783,Q48848)),fun(Q48848,bool))),U_0),s(fun(Q48784,fun(Q48783,bool)),P0))),s(fun(Q48784,fun(Q48783,Q48848)),F0))),s(Q48848,GENR_PVARR_25))))
        <=> ? [X,Y] : p(s(bool,i(s(fun(Q48848,bool),i(s(fun(bool,fun(Q48848,bool)),i(s(fun(Q48848,fun(bool,fun(Q48848,bool))),setspec),s(Q48848,GENR_PVARR_25))),s(bool,i(s(fun(Q48783,bool),i(s(fun(Q48784,fun(Q48783,bool)),P0),s(Q48784,X))),s(Q48783,Y))))),s(Q48848,i(s(fun(Q48783,Q48848),i(s(fun(Q48784,fun(Q48783,Q48848)),F0),s(Q48784,X))),s(Q48783,Y)))))) )
     => ! [P0,F0] :
          ( ? [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48848,bool),bool),i(s(fun(Q48848,fun(fun(Q48848,bool),bool)),in),s(Q48848,Z0))),s(fun(Q48848,bool),i(s(fun(fun(Q48848,bool),fun(Q48848,bool)),gspec),s(fun(Q48848,bool),i(s(fun(fun(Q48784,fun(Q48783,Q48848)),fun(Q48848,bool)),i(s(fun(fun(Q48784,fun(Q48783,bool)),fun(fun(Q48784,fun(Q48783,Q48848)),fun(Q48848,bool))),U_0),s(fun(Q48784,fun(Q48783,bool)),P0))),s(fun(Q48784,fun(Q48783,Q48848)),F0))))))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,Z0)))) )
        <=> ? [X,Y] :
              ( p(s(bool,i(s(fun(Q48783,bool),i(s(fun(Q48784,fun(Q48783,bool)),P0),s(Q48784,X))),s(Q48783,Y))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,i(s(fun(Q48783,Q48848),i(s(fun(Q48784,fun(Q48783,Q48848)),F0),s(Q48784,X))),s(Q48783,Y)))))) ) ) ) ).

fof(aEXISTSu_INu_GSPECu_conjunct2,axiom,
    ! [Q48848,Q48851,Q48850,Q48849,U_0] :
      ( ! [P0,F0,GENR_PVARR_26] :
          ( p(s(bool,i(s(fun(Q48848,bool),i(s(fun(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),fun(Q48848,bool)),i(s(fun(fun(Q48851,fun(Q48850,fun(Q48849,bool))),fun(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),fun(Q48848,bool))),U_0),s(fun(Q48851,fun(Q48850,fun(Q48849,bool))),P0))),s(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),F0))),s(Q48848,GENR_PVARR_26))))
        <=> ? [W,X,Y] : p(s(bool,i(s(fun(Q48848,bool),i(s(fun(bool,fun(Q48848,bool)),i(s(fun(Q48848,fun(bool,fun(Q48848,bool))),setspec),s(Q48848,GENR_PVARR_26))),s(bool,i(s(fun(Q48849,bool),i(s(fun(Q48850,fun(Q48849,bool)),i(s(fun(Q48851,fun(Q48850,fun(Q48849,bool))),P0),s(Q48851,W))),s(Q48850,X))),s(Q48849,Y))))),s(Q48848,i(s(fun(Q48849,Q48848),i(s(fun(Q48850,fun(Q48849,Q48848)),i(s(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),F0),s(Q48851,W))),s(Q48850,X))),s(Q48849,Y)))))) )
     => ! [P0,F0] :
          ( ? [Z0] :
              ( p(s(bool,i(s(fun(fun(Q48848,bool),bool),i(s(fun(Q48848,fun(fun(Q48848,bool),bool)),in),s(Q48848,Z0))),s(fun(Q48848,bool),i(s(fun(fun(Q48848,bool),fun(Q48848,bool)),gspec),s(fun(Q48848,bool),i(s(fun(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),fun(Q48848,bool)),i(s(fun(fun(Q48851,fun(Q48850,fun(Q48849,bool))),fun(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),fun(Q48848,bool))),U_0),s(fun(Q48851,fun(Q48850,fun(Q48849,bool))),P0))),s(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),F0))))))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,Z0)))) )
        <=> ? [W,X,Y] :
              ( p(s(bool,i(s(fun(Q48849,bool),i(s(fun(Q48850,fun(Q48849,bool)),i(s(fun(Q48851,fun(Q48850,fun(Q48849,bool))),P0),s(Q48851,W))),s(Q48850,X))),s(Q48849,Y))))
              & p(s(bool,i(s(fun(Q48848,bool),q0),s(Q48848,i(s(fun(Q48849,Q48848),i(s(fun(Q48850,fun(Q48849,Q48848)),i(s(fun(Q48851,fun(Q48850,fun(Q48849,Q48848))),F0),s(Q48851,W))),s(Q48850,X))),s(Q48849,Y)))))) ) ) ) ).

fof(aSETu_PROVEu_CASES,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),empty))))
        & ! [A5,S0] :
            ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,A5))),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,A5))),s(fun(A,bool),S0)))))) ) )
     => ! [S0] : p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),S0)))) ) ).

fof(aUNIONSu_IMAGE,axiom,
    ! [Q48928,Q48912,U_0] :
      ( ! [S0,F0,GENR_PVARR_27] :
          ( p(s(bool,i(s(fun(Q48912,bool),i(s(fun(fun(Q48928,fun(Q48912,bool)),fun(Q48912,bool)),i(s(fun(fun(Q48928,bool),fun(fun(Q48928,fun(Q48912,bool)),fun(Q48912,bool))),U_0),s(fun(Q48928,bool),S0))),s(fun(Q48928,fun(Q48912,bool)),F0))),s(Q48912,GENR_PVARR_27))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ? [X] :
                    ( p(s(bool,i(s(fun(fun(Q48928,bool),bool),i(s(fun(Q48928,fun(fun(Q48928,bool),bool)),in),s(Q48928,X))),s(fun(Q48928,bool),S0))))
                    & p(s(bool,i(s(fun(fun(Q48912,bool),bool),i(s(fun(Q48912,fun(fun(Q48912,bool),bool)),in),s(Q48912,Y))),s(fun(Q48912,bool),i(s(fun(Q48928,fun(Q48912,bool)),F0),s(Q48928,X)))))) ) )
              & p(s(bool,i(s(fun(Q48912,bool),i(s(fun(bool,fun(Q48912,bool)),i(s(fun(Q48912,fun(bool,fun(Q48912,bool))),setspec),s(Q48912,GENR_PVARR_27))),s(bool,V))),s(Q48912,Y)))) ) )
     => ! [F0,S0] : s(fun(Q48912,bool),i(s(fun(fun(fun(Q48912,bool),bool),fun(Q48912,bool)),unions),s(fun(fun(Q48912,bool),bool),i(s(fun(fun(Q48928,bool),fun(fun(Q48912,bool),bool)),i(s(fun(fun(Q48928,fun(Q48912,bool)),fun(fun(Q48928,bool),fun(fun(Q48912,bool),bool))),image),s(fun(Q48928,fun(Q48912,bool)),F0))),s(fun(Q48928,bool),S0))))) = s(fun(Q48912,bool),i(s(fun(fun(Q48912,bool),fun(Q48912,bool)),gspec),s(fun(Q48912,bool),i(s(fun(fun(Q48928,fun(Q48912,bool)),fun(Q48912,bool)),i(s(fun(fun(Q48928,bool),fun(fun(Q48928,fun(Q48912,bool)),fun(Q48912,bool))),U_0),s(fun(Q48928,bool),S0))),s(fun(Q48928,fun(Q48912,bool)),F0))))) ) ).

fof(aINTERSu_IMAGE,axiom,
    ! [Q48971,Q48955,U_0] :
      ( ! [S0,F0,GENR_PVARR_28] :
          ( p(s(bool,i(s(fun(Q48955,bool),i(s(fun(fun(Q48971,fun(Q48955,bool)),fun(Q48955,bool)),i(s(fun(fun(Q48971,bool),fun(fun(Q48971,fun(Q48955,bool)),fun(Q48955,bool))),U_0),s(fun(Q48971,bool),S0))),s(fun(Q48971,fun(Q48955,bool)),F0))),s(Q48955,GENR_PVARR_28))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ! [X] :
                    ( p(s(bool,i(s(fun(fun(Q48971,bool),bool),i(s(fun(Q48971,fun(fun(Q48971,bool),bool)),in),s(Q48971,X))),s(fun(Q48971,bool),S0))))
                   => p(s(bool,i(s(fun(fun(Q48955,bool),bool),i(s(fun(Q48955,fun(fun(Q48955,bool),bool)),in),s(Q48955,Y))),s(fun(Q48955,bool),i(s(fun(Q48971,fun(Q48955,bool)),F0),s(Q48971,X)))))) ) )
              & p(s(bool,i(s(fun(Q48955,bool),i(s(fun(bool,fun(Q48955,bool)),i(s(fun(Q48955,fun(bool,fun(Q48955,bool))),setspec),s(Q48955,GENR_PVARR_28))),s(bool,V))),s(Q48955,Y)))) ) )
     => ! [F0,S0] : s(fun(Q48955,bool),i(s(fun(fun(fun(Q48955,bool),bool),fun(Q48955,bool)),inters),s(fun(fun(Q48955,bool),bool),i(s(fun(fun(Q48971,bool),fun(fun(Q48955,bool),bool)),i(s(fun(fun(Q48971,fun(Q48955,bool)),fun(fun(Q48971,bool),fun(fun(Q48955,bool),bool))),image),s(fun(Q48971,fun(Q48955,bool)),F0))),s(fun(Q48971,bool),S0))))) = s(fun(Q48955,bool),i(s(fun(fun(Q48955,bool),fun(Q48955,bool)),gspec),s(fun(Q48955,bool),i(s(fun(fun(Q48971,fun(Q48955,bool)),fun(Q48955,bool)),i(s(fun(fun(Q48971,bool),fun(fun(Q48971,fun(Q48955,bool)),fun(Q48955,bool))),U_0),s(fun(Q48971,bool),S0))),s(fun(Q48971,fun(Q48955,bool)),F0))))) ) ).

fof(aUNIONSu_GSPECu_conjunct2,axiom,
    ! [Q49162,Q49161,Q49160,Q49136,U_1] :
      ( ! [P0,F0,GENR_PVARR_34] :
          ( p(s(bool,i(s(fun(Q49136,bool),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(Q49136,bool)),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,bool))),fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(Q49136,bool))),U_1),s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0))),s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0))),s(Q49136,GENR_PVARR_34))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ? [X,Y,Z0] :
                    ( p(s(bool,i(s(fun(Q49160,bool),i(s(fun(Q49161,fun(Q49160,bool)),i(s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0),s(Q49162,X))),s(Q49161,Y))),s(Q49160,Z0))))
                    & p(s(bool,i(s(fun(fun(Q49136,bool),bool),i(s(fun(Q49136,fun(fun(Q49136,bool),bool)),in),s(Q49136,A5))),s(fun(Q49136,bool),i(s(fun(Q49160,fun(Q49136,bool)),i(s(fun(Q49161,fun(Q49160,fun(Q49136,bool))),i(s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0),s(Q49162,X))),s(Q49161,Y))),s(Q49160,Z0)))))) ) )
              & p(s(bool,i(s(fun(Q49136,bool),i(s(fun(bool,fun(Q49136,bool)),i(s(fun(Q49136,fun(bool,fun(Q49136,bool))),setspec),s(Q49136,GENR_PVARR_34))),s(bool,V))),s(Q49136,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_33] :
              ( p(s(bool,i(s(fun(fun(Q49136,bool),bool),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(fun(Q49136,bool),bool)),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,bool))),fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(fun(Q49136,bool),bool))),U_0),s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0))),s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0))),s(fun(Q49136,bool),GENR_PVARR_33))))
            <=> ? [X,Y,Z0] : p(s(bool,i(s(fun(fun(Q49136,bool),bool),i(s(fun(bool,fun(fun(Q49136,bool),bool)),i(s(fun(fun(Q49136,bool),fun(bool,fun(fun(Q49136,bool),bool))),setspec),s(fun(Q49136,bool),GENR_PVARR_33))),s(bool,i(s(fun(Q49160,bool),i(s(fun(Q49161,fun(Q49160,bool)),i(s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0),s(Q49162,X))),s(Q49161,Y))),s(Q49160,Z0))))),s(fun(Q49136,bool),i(s(fun(Q49160,fun(Q49136,bool)),i(s(fun(Q49161,fun(Q49160,fun(Q49136,bool))),i(s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0),s(Q49162,X))),s(Q49161,Y))),s(Q49160,Z0)))))) )
         => ! [P0,F0] : s(fun(Q49136,bool),i(s(fun(fun(fun(Q49136,bool),bool),fun(Q49136,bool)),unions),s(fun(fun(Q49136,bool),bool),i(s(fun(fun(fun(Q49136,bool),bool),fun(fun(Q49136,bool),bool)),gspec),s(fun(fun(Q49136,bool),bool),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(fun(Q49136,bool),bool)),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,bool))),fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(fun(Q49136,bool),bool))),U_0),s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0))),s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0))))))) = s(fun(Q49136,bool),i(s(fun(fun(Q49136,bool),fun(Q49136,bool)),gspec),s(fun(Q49136,bool),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(Q49136,bool)),i(s(fun(fun(Q49162,fun(Q49161,fun(Q49160,bool))),fun(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),fun(Q49136,bool))),U_1),s(fun(Q49162,fun(Q49161,fun(Q49160,bool))),P0))),s(fun(Q49162,fun(Q49161,fun(Q49160,fun(Q49136,bool)))),F0))))) ) ) ).

fof(aUNIONSu_GSPECu_conjunct1,axiom,
    ! [Q49088,Q49087,Q49068,U_1] :
      ( ! [P0,F0,GENR_PVARR_32] :
          ( p(s(bool,i(s(fun(Q49068,bool),i(s(fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(Q49068,bool)),i(s(fun(fun(Q49088,fun(Q49087,bool)),fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(Q49068,bool))),U_1),s(fun(Q49088,fun(Q49087,bool)),P0))),s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0))),s(Q49068,GENR_PVARR_32))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ? [X,Y] :
                    ( p(s(bool,i(s(fun(Q49087,bool),i(s(fun(Q49088,fun(Q49087,bool)),P0),s(Q49088,X))),s(Q49087,Y))))
                    & p(s(bool,i(s(fun(fun(Q49068,bool),bool),i(s(fun(Q49068,fun(fun(Q49068,bool),bool)),in),s(Q49068,A5))),s(fun(Q49068,bool),i(s(fun(Q49087,fun(Q49068,bool)),i(s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0),s(Q49088,X))),s(Q49087,Y)))))) ) )
              & p(s(bool,i(s(fun(Q49068,bool),i(s(fun(bool,fun(Q49068,bool)),i(s(fun(Q49068,fun(bool,fun(Q49068,bool))),setspec),s(Q49068,GENR_PVARR_32))),s(bool,V))),s(Q49068,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_31] :
              ( p(s(bool,i(s(fun(fun(Q49068,bool),bool),i(s(fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(fun(Q49068,bool),bool)),i(s(fun(fun(Q49088,fun(Q49087,bool)),fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(fun(Q49068,bool),bool))),U_0),s(fun(Q49088,fun(Q49087,bool)),P0))),s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0))),s(fun(Q49068,bool),GENR_PVARR_31))))
            <=> ? [X,Y] : p(s(bool,i(s(fun(fun(Q49068,bool),bool),i(s(fun(bool,fun(fun(Q49068,bool),bool)),i(s(fun(fun(Q49068,bool),fun(bool,fun(fun(Q49068,bool),bool))),setspec),s(fun(Q49068,bool),GENR_PVARR_31))),s(bool,i(s(fun(Q49087,bool),i(s(fun(Q49088,fun(Q49087,bool)),P0),s(Q49088,X))),s(Q49087,Y))))),s(fun(Q49068,bool),i(s(fun(Q49087,fun(Q49068,bool)),i(s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0),s(Q49088,X))),s(Q49087,Y)))))) )
         => ! [P0,F0] : s(fun(Q49068,bool),i(s(fun(fun(fun(Q49068,bool),bool),fun(Q49068,bool)),unions),s(fun(fun(Q49068,bool),bool),i(s(fun(fun(fun(Q49068,bool),bool),fun(fun(Q49068,bool),bool)),gspec),s(fun(fun(Q49068,bool),bool),i(s(fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(fun(Q49068,bool),bool)),i(s(fun(fun(Q49088,fun(Q49087,bool)),fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(fun(Q49068,bool),bool))),U_0),s(fun(Q49088,fun(Q49087,bool)),P0))),s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0))))))) = s(fun(Q49068,bool),i(s(fun(fun(Q49068,bool),fun(Q49068,bool)),gspec),s(fun(Q49068,bool),i(s(fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(Q49068,bool)),i(s(fun(fun(Q49088,fun(Q49087,bool)),fun(fun(Q49088,fun(Q49087,fun(Q49068,bool))),fun(Q49068,bool))),U_1),s(fun(Q49088,fun(Q49087,bool)),P0))),s(fun(Q49088,fun(Q49087,fun(Q49068,bool))),F0))))) ) ) ).

fof(aUNIONSu_GSPECu_conjunct0,axiom,
    ! [Q49024,Q49010,U_1] :
      ( ! [P0,F0,GENR_PVARR_30] :
          ( p(s(bool,i(s(fun(Q49010,bool),i(s(fun(fun(Q49024,fun(Q49010,bool)),fun(Q49010,bool)),i(s(fun(fun(Q49024,bool),fun(fun(Q49024,fun(Q49010,bool)),fun(Q49010,bool))),U_1),s(fun(Q49024,bool),P0))),s(fun(Q49024,fun(Q49010,bool)),F0))),s(Q49010,GENR_PVARR_30))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ? [X] :
                    ( p(s(bool,i(s(fun(Q49024,bool),P0),s(Q49024,X))))
                    & p(s(bool,i(s(fun(fun(Q49010,bool),bool),i(s(fun(Q49010,fun(fun(Q49010,bool),bool)),in),s(Q49010,A5))),s(fun(Q49010,bool),i(s(fun(Q49024,fun(Q49010,bool)),F0),s(Q49024,X)))))) ) )
              & p(s(bool,i(s(fun(Q49010,bool),i(s(fun(bool,fun(Q49010,bool)),i(s(fun(Q49010,fun(bool,fun(Q49010,bool))),setspec),s(Q49010,GENR_PVARR_30))),s(bool,V))),s(Q49010,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_29] :
              ( p(s(bool,i(s(fun(fun(Q49010,bool),bool),i(s(fun(fun(Q49024,fun(Q49010,bool)),fun(fun(Q49010,bool),bool)),i(s(fun(fun(Q49024,bool),fun(fun(Q49024,fun(Q49010,bool)),fun(fun(Q49010,bool),bool))),U_0),s(fun(Q49024,bool),P0))),s(fun(Q49024,fun(Q49010,bool)),F0))),s(fun(Q49010,bool),GENR_PVARR_29))))
            <=> ? [X] : p(s(bool,i(s(fun(fun(Q49010,bool),bool),i(s(fun(bool,fun(fun(Q49010,bool),bool)),i(s(fun(fun(Q49010,bool),fun(bool,fun(fun(Q49010,bool),bool))),setspec),s(fun(Q49010,bool),GENR_PVARR_29))),s(bool,i(s(fun(Q49024,bool),P0),s(Q49024,X))))),s(fun(Q49010,bool),i(s(fun(Q49024,fun(Q49010,bool)),F0),s(Q49024,X)))))) )
         => ! [P0,F0] : s(fun(Q49010,bool),i(s(fun(fun(fun(Q49010,bool),bool),fun(Q49010,bool)),unions),s(fun(fun(Q49010,bool),bool),i(s(fun(fun(fun(Q49010,bool),bool),fun(fun(Q49010,bool),bool)),gspec),s(fun(fun(Q49010,bool),bool),i(s(fun(fun(Q49024,fun(Q49010,bool)),fun(fun(Q49010,bool),bool)),i(s(fun(fun(Q49024,bool),fun(fun(Q49024,fun(Q49010,bool)),fun(fun(Q49010,bool),bool))),U_0),s(fun(Q49024,bool),P0))),s(fun(Q49024,fun(Q49010,bool)),F0))))))) = s(fun(Q49010,bool),i(s(fun(fun(Q49010,bool),fun(Q49010,bool)),gspec),s(fun(Q49010,bool),i(s(fun(fun(Q49024,fun(Q49010,bool)),fun(Q49010,bool)),i(s(fun(fun(Q49024,bool),fun(fun(Q49024,fun(Q49010,bool)),fun(Q49010,bool))),U_1),s(fun(Q49024,bool),P0))),s(fun(Q49024,fun(Q49010,bool)),F0))))) ) ) ).

fof(aINTERSu_GSPECu_conjunct2,axiom,
    ! [Q49353,Q49352,Q49351,Q49327,U_1] :
      ( ! [P0,F0,GENR_PVARR_40] :
          ( p(s(bool,i(s(fun(Q49327,bool),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(Q49327,bool)),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,bool))),fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(Q49327,bool))),U_1),s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0))),s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0))),s(Q49327,GENR_PVARR_40))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ! [X,Y,Z0] :
                    ( p(s(bool,i(s(fun(Q49351,bool),i(s(fun(Q49352,fun(Q49351,bool)),i(s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0),s(Q49353,X))),s(Q49352,Y))),s(Q49351,Z0))))
                   => p(s(bool,i(s(fun(fun(Q49327,bool),bool),i(s(fun(Q49327,fun(fun(Q49327,bool),bool)),in),s(Q49327,A5))),s(fun(Q49327,bool),i(s(fun(Q49351,fun(Q49327,bool)),i(s(fun(Q49352,fun(Q49351,fun(Q49327,bool))),i(s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0),s(Q49353,X))),s(Q49352,Y))),s(Q49351,Z0)))))) ) )
              & p(s(bool,i(s(fun(Q49327,bool),i(s(fun(bool,fun(Q49327,bool)),i(s(fun(Q49327,fun(bool,fun(Q49327,bool))),setspec),s(Q49327,GENR_PVARR_40))),s(bool,V))),s(Q49327,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_39] :
              ( p(s(bool,i(s(fun(fun(Q49327,bool),bool),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(fun(Q49327,bool),bool)),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,bool))),fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(fun(Q49327,bool),bool))),U_0),s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0))),s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0))),s(fun(Q49327,bool),GENR_PVARR_39))))
            <=> ? [X,Y,Z0] : p(s(bool,i(s(fun(fun(Q49327,bool),bool),i(s(fun(bool,fun(fun(Q49327,bool),bool)),i(s(fun(fun(Q49327,bool),fun(bool,fun(fun(Q49327,bool),bool))),setspec),s(fun(Q49327,bool),GENR_PVARR_39))),s(bool,i(s(fun(Q49351,bool),i(s(fun(Q49352,fun(Q49351,bool)),i(s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0),s(Q49353,X))),s(Q49352,Y))),s(Q49351,Z0))))),s(fun(Q49327,bool),i(s(fun(Q49351,fun(Q49327,bool)),i(s(fun(Q49352,fun(Q49351,fun(Q49327,bool))),i(s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0),s(Q49353,X))),s(Q49352,Y))),s(Q49351,Z0)))))) )
         => ! [P0,F0] : s(fun(Q49327,bool),i(s(fun(fun(fun(Q49327,bool),bool),fun(Q49327,bool)),inters),s(fun(fun(Q49327,bool),bool),i(s(fun(fun(fun(Q49327,bool),bool),fun(fun(Q49327,bool),bool)),gspec),s(fun(fun(Q49327,bool),bool),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(fun(Q49327,bool),bool)),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,bool))),fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(fun(Q49327,bool),bool))),U_0),s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0))),s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0))))))) = s(fun(Q49327,bool),i(s(fun(fun(Q49327,bool),fun(Q49327,bool)),gspec),s(fun(Q49327,bool),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(Q49327,bool)),i(s(fun(fun(Q49353,fun(Q49352,fun(Q49351,bool))),fun(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),fun(Q49327,bool))),U_1),s(fun(Q49353,fun(Q49352,fun(Q49351,bool))),P0))),s(fun(Q49353,fun(Q49352,fun(Q49351,fun(Q49327,bool)))),F0))))) ) ) ).

fof(aINTERSu_GSPECu_conjunct1,axiom,
    ! [Q49279,Q49278,Q49259,U_1] :
      ( ! [P0,F0,GENR_PVARR_38] :
          ( p(s(bool,i(s(fun(Q49259,bool),i(s(fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(Q49259,bool)),i(s(fun(fun(Q49279,fun(Q49278,bool)),fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(Q49259,bool))),U_1),s(fun(Q49279,fun(Q49278,bool)),P0))),s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0))),s(Q49259,GENR_PVARR_38))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ! [X,Y] :
                    ( p(s(bool,i(s(fun(Q49278,bool),i(s(fun(Q49279,fun(Q49278,bool)),P0),s(Q49279,X))),s(Q49278,Y))))
                   => p(s(bool,i(s(fun(fun(Q49259,bool),bool),i(s(fun(Q49259,fun(fun(Q49259,bool),bool)),in),s(Q49259,A5))),s(fun(Q49259,bool),i(s(fun(Q49278,fun(Q49259,bool)),i(s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0),s(Q49279,X))),s(Q49278,Y)))))) ) )
              & p(s(bool,i(s(fun(Q49259,bool),i(s(fun(bool,fun(Q49259,bool)),i(s(fun(Q49259,fun(bool,fun(Q49259,bool))),setspec),s(Q49259,GENR_PVARR_38))),s(bool,V))),s(Q49259,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_37] :
              ( p(s(bool,i(s(fun(fun(Q49259,bool),bool),i(s(fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(fun(Q49259,bool),bool)),i(s(fun(fun(Q49279,fun(Q49278,bool)),fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(fun(Q49259,bool),bool))),U_0),s(fun(Q49279,fun(Q49278,bool)),P0))),s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0))),s(fun(Q49259,bool),GENR_PVARR_37))))
            <=> ? [X,Y] : p(s(bool,i(s(fun(fun(Q49259,bool),bool),i(s(fun(bool,fun(fun(Q49259,bool),bool)),i(s(fun(fun(Q49259,bool),fun(bool,fun(fun(Q49259,bool),bool))),setspec),s(fun(Q49259,bool),GENR_PVARR_37))),s(bool,i(s(fun(Q49278,bool),i(s(fun(Q49279,fun(Q49278,bool)),P0),s(Q49279,X))),s(Q49278,Y))))),s(fun(Q49259,bool),i(s(fun(Q49278,fun(Q49259,bool)),i(s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0),s(Q49279,X))),s(Q49278,Y)))))) )
         => ! [P0,F0] : s(fun(Q49259,bool),i(s(fun(fun(fun(Q49259,bool),bool),fun(Q49259,bool)),inters),s(fun(fun(Q49259,bool),bool),i(s(fun(fun(fun(Q49259,bool),bool),fun(fun(Q49259,bool),bool)),gspec),s(fun(fun(Q49259,bool),bool),i(s(fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(fun(Q49259,bool),bool)),i(s(fun(fun(Q49279,fun(Q49278,bool)),fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(fun(Q49259,bool),bool))),U_0),s(fun(Q49279,fun(Q49278,bool)),P0))),s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0))))))) = s(fun(Q49259,bool),i(s(fun(fun(Q49259,bool),fun(Q49259,bool)),gspec),s(fun(Q49259,bool),i(s(fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(Q49259,bool)),i(s(fun(fun(Q49279,fun(Q49278,bool)),fun(fun(Q49279,fun(Q49278,fun(Q49259,bool))),fun(Q49259,bool))),U_1),s(fun(Q49279,fun(Q49278,bool)),P0))),s(fun(Q49279,fun(Q49278,fun(Q49259,bool))),F0))))) ) ) ).

fof(aINTERSu_GSPECu_conjunct0,axiom,
    ! [Q49215,Q49201,U_1] :
      ( ! [P0,F0,GENR_PVARR_36] :
          ( p(s(bool,i(s(fun(Q49201,bool),i(s(fun(fun(Q49215,fun(Q49201,bool)),fun(Q49201,bool)),i(s(fun(fun(Q49215,bool),fun(fun(Q49215,fun(Q49201,bool)),fun(Q49201,bool))),U_1),s(fun(Q49215,bool),P0))),s(fun(Q49215,fun(Q49201,bool)),F0))),s(Q49201,GENR_PVARR_36))))
        <=> ? [A5,V] :
              ( ( p(s(bool,V))
              <=> ! [X] :
                    ( p(s(bool,i(s(fun(Q49215,bool),P0),s(Q49215,X))))
                   => p(s(bool,i(s(fun(fun(Q49201,bool),bool),i(s(fun(Q49201,fun(fun(Q49201,bool),bool)),in),s(Q49201,A5))),s(fun(Q49201,bool),i(s(fun(Q49215,fun(Q49201,bool)),F0),s(Q49215,X)))))) ) )
              & p(s(bool,i(s(fun(Q49201,bool),i(s(fun(bool,fun(Q49201,bool)),i(s(fun(Q49201,fun(bool,fun(Q49201,bool))),setspec),s(Q49201,GENR_PVARR_36))),s(bool,V))),s(Q49201,A5)))) ) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_35] :
              ( p(s(bool,i(s(fun(fun(Q49201,bool),bool),i(s(fun(fun(Q49215,fun(Q49201,bool)),fun(fun(Q49201,bool),bool)),i(s(fun(fun(Q49215,bool),fun(fun(Q49215,fun(Q49201,bool)),fun(fun(Q49201,bool),bool))),U_0),s(fun(Q49215,bool),P0))),s(fun(Q49215,fun(Q49201,bool)),F0))),s(fun(Q49201,bool),GENR_PVARR_35))))
            <=> ? [X] : p(s(bool,i(s(fun(fun(Q49201,bool),bool),i(s(fun(bool,fun(fun(Q49201,bool),bool)),i(s(fun(fun(Q49201,bool),fun(bool,fun(fun(Q49201,bool),bool))),setspec),s(fun(Q49201,bool),GENR_PVARR_35))),s(bool,i(s(fun(Q49215,bool),P0),s(Q49215,X))))),s(fun(Q49201,bool),i(s(fun(Q49215,fun(Q49201,bool)),F0),s(Q49215,X)))))) )
         => ! [P0,F0] : s(fun(Q49201,bool),i(s(fun(fun(fun(Q49201,bool),bool),fun(Q49201,bool)),inters),s(fun(fun(Q49201,bool),bool),i(s(fun(fun(fun(Q49201,bool),bool),fun(fun(Q49201,bool),bool)),gspec),s(fun(fun(Q49201,bool),bool),i(s(fun(fun(Q49215,fun(Q49201,bool)),fun(fun(Q49201,bool),bool)),i(s(fun(fun(Q49215,bool),fun(fun(Q49215,fun(Q49201,bool)),fun(fun(Q49201,bool),bool))),U_0),s(fun(Q49215,bool),P0))),s(fun(Q49215,fun(Q49201,bool)),F0))))))) = s(fun(Q49201,bool),i(s(fun(fun(Q49201,bool),fun(Q49201,bool)),gspec),s(fun(Q49201,bool),i(s(fun(fun(Q49215,fun(Q49201,bool)),fun(Q49201,bool)),i(s(fun(fun(Q49215,bool),fun(fun(Q49215,fun(Q49201,bool)),fun(Q49201,bool))),U_1),s(fun(Q49215,bool),P0))),s(fun(Q49215,fun(Q49201,bool)),F0))))) ) ) ).

fof(aDIFFu_INTERS,axiom,
    ! [Q49390,U_0] :
      ( ! [S0,U,GENR_PVARR_41] :
          ( p(s(bool,i(s(fun(fun(Q49390,bool),bool),i(s(fun(fun(Q49390,bool),fun(fun(Q49390,bool),bool)),i(s(fun(fun(fun(Q49390,bool),bool),fun(fun(Q49390,bool),fun(fun(Q49390,bool),bool))),U_0),s(fun(fun(Q49390,bool),bool),S0))),s(fun(Q49390,bool),U))),s(fun(Q49390,bool),GENR_PVARR_41))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(Q49390,bool),bool),i(s(fun(bool,fun(fun(Q49390,bool),bool)),i(s(fun(fun(Q49390,bool),fun(bool,fun(fun(Q49390,bool),bool))),setspec),s(fun(Q49390,bool),GENR_PVARR_41))),s(bool,i(s(fun(fun(fun(Q49390,bool),bool),bool),i(s(fun(fun(Q49390,bool),fun(fun(fun(Q49390,bool),bool),bool)),in),s(fun(Q49390,bool),T0))),s(fun(fun(Q49390,bool),bool),S0))))),s(fun(Q49390,bool),i(s(fun(fun(Q49390,bool),fun(Q49390,bool)),i(s(fun(fun(Q49390,bool),fun(fun(Q49390,bool),fun(Q49390,bool))),diff),s(fun(Q49390,bool),U))),s(fun(Q49390,bool),T0)))))) )
     => ! [U,S0] : s(fun(Q49390,bool),i(s(fun(fun(Q49390,bool),fun(Q49390,bool)),i(s(fun(fun(Q49390,bool),fun(fun(Q49390,bool),fun(Q49390,bool))),diff),s(fun(Q49390,bool),U))),s(fun(Q49390,bool),i(s(fun(fun(fun(Q49390,bool),bool),fun(Q49390,bool)),inters),s(fun(fun(Q49390,bool),bool),S0))))) = s(fun(Q49390,bool),i(s(fun(fun(fun(Q49390,bool),bool),fun(Q49390,bool)),unions),s(fun(fun(Q49390,bool),bool),i(s(fun(fun(fun(Q49390,bool),bool),fun(fun(Q49390,bool),bool)),gspec),s(fun(fun(Q49390,bool),bool),i(s(fun(fun(Q49390,bool),fun(fun(Q49390,bool),bool)),i(s(fun(fun(fun(Q49390,bool),bool),fun(fun(Q49390,bool),fun(fun(Q49390,bool),bool))),U_0),s(fun(fun(Q49390,bool),bool),S0))),s(fun(Q49390,bool),U))))))) ) ).

fof(aINTERSu_UNIONS,axiom,
    ! [Q49425,U_0] :
      ( ! [S0,GENR_PVARR_42] :
          ( p(s(bool,i(s(fun(fun(Q49425,bool),bool),i(s(fun(fun(fun(Q49425,bool),bool),fun(fun(Q49425,bool),bool)),U_0),s(fun(fun(Q49425,bool),bool),S0))),s(fun(Q49425,bool),GENR_PVARR_42))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(Q49425,bool),bool),i(s(fun(bool,fun(fun(Q49425,bool),bool)),i(s(fun(fun(Q49425,bool),fun(bool,fun(fun(Q49425,bool),bool))),setspec),s(fun(Q49425,bool),GENR_PVARR_42))),s(bool,i(s(fun(fun(fun(Q49425,bool),bool),bool),i(s(fun(fun(Q49425,bool),fun(fun(fun(Q49425,bool),bool),bool)),in),s(fun(Q49425,bool),T0))),s(fun(fun(Q49425,bool),bool),S0))))),s(fun(Q49425,bool),i(s(fun(fun(Q49425,bool),fun(Q49425,bool)),i(s(fun(fun(Q49425,bool),fun(fun(Q49425,bool),fun(Q49425,bool))),diff),s(fun(Q49425,bool),univ))),s(fun(Q49425,bool),T0)))))) )
     => ! [S0] : s(fun(Q49425,bool),i(s(fun(fun(fun(Q49425,bool),bool),fun(Q49425,bool)),inters),s(fun(fun(Q49425,bool),bool),S0))) = s(fun(Q49425,bool),i(s(fun(fun(Q49425,bool),fun(Q49425,bool)),i(s(fun(fun(Q49425,bool),fun(fun(Q49425,bool),fun(Q49425,bool))),diff),s(fun(Q49425,bool),univ))),s(fun(Q49425,bool),i(s(fun(fun(fun(Q49425,bool),bool),fun(Q49425,bool)),unions),s(fun(fun(Q49425,bool),bool),i(s(fun(fun(fun(Q49425,bool),bool),fun(fun(Q49425,bool),bool)),gspec),s(fun(fun(Q49425,bool),bool),i(s(fun(fun(fun(Q49425,bool),bool),fun(fun(Q49425,bool),bool)),U_0),s(fun(fun(Q49425,bool),bool),S0))))))))) ) ).

fof(aUNIONSu_INTERS,axiom,
    ! [Q49460,U_0] :
      ( ! [S0,GENR_PVARR_43] :
          ( p(s(bool,i(s(fun(fun(Q49460,bool),bool),i(s(fun(fun(fun(Q49460,bool),bool),fun(fun(Q49460,bool),bool)),U_0),s(fun(fun(Q49460,bool),bool),S0))),s(fun(Q49460,bool),GENR_PVARR_43))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(Q49460,bool),bool),i(s(fun(bool,fun(fun(Q49460,bool),bool)),i(s(fun(fun(Q49460,bool),fun(bool,fun(fun(Q49460,bool),bool))),setspec),s(fun(Q49460,bool),GENR_PVARR_43))),s(bool,i(s(fun(fun(fun(Q49460,bool),bool),bool),i(s(fun(fun(Q49460,bool),fun(fun(fun(Q49460,bool),bool),bool)),in),s(fun(Q49460,bool),T0))),s(fun(fun(Q49460,bool),bool),S0))))),s(fun(Q49460,bool),i(s(fun(fun(Q49460,bool),fun(Q49460,bool)),i(s(fun(fun(Q49460,bool),fun(fun(Q49460,bool),fun(Q49460,bool))),diff),s(fun(Q49460,bool),univ))),s(fun(Q49460,bool),T0)))))) )
     => ! [S0] : s(fun(Q49460,bool),i(s(fun(fun(fun(Q49460,bool),bool),fun(Q49460,bool)),unions),s(fun(fun(Q49460,bool),bool),S0))) = s(fun(Q49460,bool),i(s(fun(fun(Q49460,bool),fun(Q49460,bool)),i(s(fun(fun(Q49460,bool),fun(fun(Q49460,bool),fun(Q49460,bool))),diff),s(fun(Q49460,bool),univ))),s(fun(Q49460,bool),i(s(fun(fun(fun(Q49460,bool),bool),fun(Q49460,bool)),inters),s(fun(fun(Q49460,bool),bool),i(s(fun(fun(fun(Q49460,bool),bool),fun(fun(Q49460,bool),bool)),gspec),s(fun(fun(Q49460,bool),bool),i(s(fun(fun(fun(Q49460,bool),bool),fun(fun(Q49460,bool),bool)),U_0),s(fun(fun(Q49460,bool),bool),S0))))))))) ) ).

fof(aUNIONSu_DIFF,axiom,
    ! [Q49497,U_0] :
      ( ! [S0,T0,GENR_PVARR_44] :
          ( p(s(bool,i(s(fun(fun(Q49497,bool),bool),i(s(fun(fun(Q49497,bool),fun(fun(Q49497,bool),bool)),i(s(fun(fun(fun(Q49497,bool),bool),fun(fun(Q49497,bool),fun(fun(Q49497,bool),bool))),U_0),s(fun(fun(Q49497,bool),bool),S0))),s(fun(Q49497,bool),T0))),s(fun(Q49497,bool),GENR_PVARR_44))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(Q49497,bool),bool),i(s(fun(bool,fun(fun(Q49497,bool),bool)),i(s(fun(fun(Q49497,bool),fun(bool,fun(fun(Q49497,bool),bool))),setspec),s(fun(Q49497,bool),GENR_PVARR_44))),s(bool,i(s(fun(fun(fun(Q49497,bool),bool),bool),i(s(fun(fun(Q49497,bool),fun(fun(fun(Q49497,bool),bool),bool)),in),s(fun(Q49497,bool),X))),s(fun(fun(Q49497,bool),bool),S0))))),s(fun(Q49497,bool),i(s(fun(fun(Q49497,bool),fun(Q49497,bool)),i(s(fun(fun(Q49497,bool),fun(fun(Q49497,bool),fun(Q49497,bool))),diff),s(fun(Q49497,bool),X))),s(fun(Q49497,bool),T0)))))) )
     => ! [S0,T0] : s(fun(Q49497,bool),i(s(fun(fun(Q49497,bool),fun(Q49497,bool)),i(s(fun(fun(Q49497,bool),fun(fun(Q49497,bool),fun(Q49497,bool))),diff),s(fun(Q49497,bool),i(s(fun(fun(fun(Q49497,bool),bool),fun(Q49497,bool)),unions),s(fun(fun(Q49497,bool),bool),S0))))),s(fun(Q49497,bool),T0))) = s(fun(Q49497,bool),i(s(fun(fun(fun(Q49497,bool),bool),fun(Q49497,bool)),unions),s(fun(fun(Q49497,bool),bool),i(s(fun(fun(fun(Q49497,bool),bool),fun(fun(Q49497,bool),bool)),gspec),s(fun(fun(Q49497,bool),bool),i(s(fun(fun(Q49497,bool),fun(fun(Q49497,bool),bool)),i(s(fun(fun(fun(Q49497,bool),bool),fun(fun(Q49497,bool),fun(fun(Q49497,bool),bool))),U_0),s(fun(fun(Q49497,bool),bool),S0))),s(fun(Q49497,bool),T0))))))) ) ).

fof(aDIFFu_UNIONS,axiom,
    ! [Q49537,U_0] :
      ( ! [S0,U,GENR_PVARR_45] :
          ( p(s(bool,i(s(fun(fun(Q49537,bool),bool),i(s(fun(fun(Q49537,bool),fun(fun(Q49537,bool),bool)),i(s(fun(fun(fun(Q49537,bool),bool),fun(fun(Q49537,bool),fun(fun(Q49537,bool),bool))),U_0),s(fun(fun(Q49537,bool),bool),S0))),s(fun(Q49537,bool),U))),s(fun(Q49537,bool),GENR_PVARR_45))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(Q49537,bool),bool),i(s(fun(bool,fun(fun(Q49537,bool),bool)),i(s(fun(fun(Q49537,bool),fun(bool,fun(fun(Q49537,bool),bool))),setspec),s(fun(Q49537,bool),GENR_PVARR_45))),s(bool,i(s(fun(fun(fun(Q49537,bool),bool),bool),i(s(fun(fun(Q49537,bool),fun(fun(fun(Q49537,bool),bool),bool)),in),s(fun(Q49537,bool),T0))),s(fun(fun(Q49537,bool),bool),S0))))),s(fun(Q49537,bool),i(s(fun(fun(Q49537,bool),fun(Q49537,bool)),i(s(fun(fun(Q49537,bool),fun(fun(Q49537,bool),fun(Q49537,bool))),diff),s(fun(Q49537,bool),U))),s(fun(Q49537,bool),T0)))))) )
     => ! [U,S0] : s(fun(Q49537,bool),i(s(fun(fun(Q49537,bool),fun(Q49537,bool)),i(s(fun(fun(Q49537,bool),fun(fun(Q49537,bool),fun(Q49537,bool))),diff),s(fun(Q49537,bool),U))),s(fun(Q49537,bool),i(s(fun(fun(fun(Q49537,bool),bool),fun(Q49537,bool)),unions),s(fun(fun(Q49537,bool),bool),S0))))) = s(fun(Q49537,bool),i(s(fun(fun(Q49537,bool),fun(Q49537,bool)),i(s(fun(fun(Q49537,bool),fun(fun(Q49537,bool),fun(Q49537,bool))),inter),s(fun(Q49537,bool),U))),s(fun(Q49537,bool),i(s(fun(fun(fun(Q49537,bool),bool),fun(Q49537,bool)),inters),s(fun(fun(Q49537,bool),bool),i(s(fun(fun(fun(Q49537,bool),bool),fun(fun(Q49537,bool),bool)),gspec),s(fun(fun(Q49537,bool),bool),i(s(fun(fun(Q49537,bool),fun(fun(Q49537,bool),bool)),i(s(fun(fun(fun(Q49537,bool),bool),fun(fun(Q49537,bool),fun(fun(Q49537,bool),bool))),U_0),s(fun(fun(Q49537,bool),bool),S0))),s(fun(Q49537,bool),U))))))))) ) ).

fof(aDIFFu_UNIONSu_NONEMPTY,axiom,
    ! [Q49581,U_0] :
      ( ! [S0,U,GENR_PVARR_46] :
          ( p(s(bool,i(s(fun(fun(Q49581,bool),bool),i(s(fun(fun(Q49581,bool),fun(fun(Q49581,bool),bool)),i(s(fun(fun(fun(Q49581,bool),bool),fun(fun(Q49581,bool),fun(fun(Q49581,bool),bool))),U_0),s(fun(fun(Q49581,bool),bool),S0))),s(fun(Q49581,bool),U))),s(fun(Q49581,bool),GENR_PVARR_46))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(Q49581,bool),bool),i(s(fun(bool,fun(fun(Q49581,bool),bool)),i(s(fun(fun(Q49581,bool),fun(bool,fun(fun(Q49581,bool),bool))),setspec),s(fun(Q49581,bool),GENR_PVARR_46))),s(bool,i(s(fun(fun(fun(Q49581,bool),bool),bool),i(s(fun(fun(Q49581,bool),fun(fun(fun(Q49581,bool),bool),bool)),in),s(fun(Q49581,bool),T0))),s(fun(fun(Q49581,bool),bool),S0))))),s(fun(Q49581,bool),i(s(fun(fun(Q49581,bool),fun(Q49581,bool)),i(s(fun(fun(Q49581,bool),fun(fun(Q49581,bool),fun(Q49581,bool))),diff),s(fun(Q49581,bool),U))),s(fun(Q49581,bool),T0)))))) )
     => ! [U,S0] :
          ( s(fun(fun(Q49581,bool),bool),S0) != s(fun(fun(Q49581,bool),bool),empty)
         => s(fun(Q49581,bool),i(s(fun(fun(Q49581,bool),fun(Q49581,bool)),i(s(fun(fun(Q49581,bool),fun(fun(Q49581,bool),fun(Q49581,bool))),diff),s(fun(Q49581,bool),U))),s(fun(Q49581,bool),i(s(fun(fun(fun(Q49581,bool),bool),fun(Q49581,bool)),unions),s(fun(fun(Q49581,bool),bool),S0))))) = s(fun(Q49581,bool),i(s(fun(fun(fun(Q49581,bool),bool),fun(Q49581,bool)),inters),s(fun(fun(Q49581,bool),bool),i(s(fun(fun(fun(Q49581,bool),bool),fun(fun(Q49581,bool),bool)),gspec),s(fun(fun(Q49581,bool),bool),i(s(fun(fun(Q49581,bool),fun(fun(Q49581,bool),bool)),i(s(fun(fun(fun(Q49581,bool),bool),fun(fun(Q49581,bool),fun(fun(Q49581,bool),bool))),U_0),s(fun(fun(Q49581,bool),bool),S0))),s(fun(Q49581,bool),U))))))) ) ) ).

fof(aINTERSu_OVERu_UNIONS,axiom,
    ! [B,A,U_2] :
      ( ! [S0,G0,GENR_PVARR_50] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_2),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),G0))),s(fun(B,bool),GENR_PVARR_50))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(bool,fun(fun(B,bool),bool)),i(s(fun(fun(B,bool),fun(bool,fun(fun(B,bool),bool))),setspec),s(fun(B,bool),GENR_PVARR_50))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),G0),s(A,X)))))) )
     => ! [U_1] :
          ( ! [F0,S0,GENR_PVARR_51] :
              ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,fun(fun(B,bool),bool)),fun(fun(A,bool),fun(fun(B,bool),bool))),U_1),s(fun(A,fun(fun(B,bool),bool)),F0))),s(fun(A,bool),S0))),s(fun(B,bool),GENR_PVARR_51))))
            <=> ? [G0,V] :
                  ( ( p(s(bool,V))
                  <=> ! [X] :
                        ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                       => p(s(bool,i(s(fun(fun(fun(B,bool),bool),bool),i(s(fun(fun(B,bool),fun(fun(fun(B,bool),bool),bool)),in),s(fun(B,bool),i(s(fun(A,fun(B,bool)),G0),s(A,X))))),s(fun(fun(B,bool),bool),i(s(fun(A,fun(fun(B,bool),bool)),F0),s(A,X)))))) ) )
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(bool,fun(fun(B,bool),bool)),i(s(fun(fun(B,bool),fun(bool,fun(fun(B,bool),bool))),setspec),s(fun(B,bool),GENR_PVARR_51))),s(bool,V))),s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),inters),s(fun(fun(B,bool),bool),i(s(fun(fun(fun(B,bool),bool),fun(fun(B,bool),bool)),gspec),s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_2),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),G0)))))))))) ) )
         => ! [U_0] :
              ( ! [S0,F0,GENR_PVARR_47] :
                  ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(fun(B,bool),bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(fun(B,bool),bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(fun(B,bool),bool)),F0))),s(fun(B,bool),GENR_PVARR_47))))
                <=> ? [X] : p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(bool,fun(fun(B,bool),bool)),i(s(fun(fun(B,bool),fun(bool,fun(fun(B,bool),bool))),setspec),s(fun(B,bool),GENR_PVARR_47))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),unions),s(fun(fun(B,bool),bool),i(s(fun(A,fun(fun(B,bool),bool)),F0),s(A,X)))))))) )
             => ! [F0,S0] : s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),inters),s(fun(fun(B,bool),bool),i(s(fun(fun(fun(B,bool),bool),fun(fun(B,bool),bool)),gspec),s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(fun(B,bool),bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(fun(B,bool),bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(fun(B,bool),bool)),F0))))))) = s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),unions),s(fun(fun(B,bool),bool),i(s(fun(fun(fun(B,bool),bool),fun(fun(B,bool),bool)),gspec),s(fun(fun(B,bool),bool),i(s(fun(fun(A,bool),fun(fun(B,bool),bool)),i(s(fun(fun(A,fun(fun(B,bool),bool)),fun(fun(A,bool),fun(fun(B,bool),bool))),U_1),s(fun(A,fun(fun(B,bool),bool)),F0))),s(fun(A,bool),S0))))))) ) ) ) ).

fof(aFINITEu_INDUCTu_STRONG,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),empty))))
        & ! [X,S0] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),S0))))
              & ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0)))) )
           => p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0)))))) ) )
     => ! [S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),S0)))) ) ) ).

fof(aINJECTIVEu_ONu_ALT,axiom,
    ! [Q49786,Q49791,P0,F0] :
      ( ! [X,Y] :
          ( ( p(s(bool,i(s(fun(Q49791,bool),P0),s(Q49791,X))))
            & p(s(bool,i(s(fun(Q49791,bool),P0),s(Q49791,Y))))
            & s(Q49786,i(s(fun(Q49791,Q49786),F0),s(Q49791,X))) = s(Q49786,i(s(fun(Q49791,Q49786),F0),s(Q49791,Y))) )
         => s(Q49791,X) = s(Q49791,Y) )
    <=> ! [X,Y] :
          ( ( p(s(bool,i(s(fun(Q49791,bool),P0),s(Q49791,X))))
            & p(s(bool,i(s(fun(Q49791,bool),P0),s(Q49791,Y)))) )
         => ( s(Q49786,i(s(fun(Q49791,Q49786),F0),s(Q49791,X))) = s(Q49786,i(s(fun(Q49791,Q49786),F0),s(Q49791,Y)))
          <=> s(Q49791,X) = s(Q49791,Y) ) ) ) ).

fof(aINJECTIVEu_ALT,axiom,
    ! [Q49829,Q49834,F0] :
      ( ! [X,Y] :
          ( s(Q49829,i(s(fun(Q49834,Q49829),F0),s(Q49834,X))) = s(Q49829,i(s(fun(Q49834,Q49829),F0),s(Q49834,Y)))
         => s(Q49834,X) = s(Q49834,Y) )
    <=> ! [X,Y] :
          ( s(Q49829,i(s(fun(Q49834,Q49829),F0),s(Q49834,X))) = s(Q49829,i(s(fun(Q49834,Q49829),F0),s(Q49834,Y)))
        <=> s(Q49834,X) = s(Q49834,Y) ) ) ).

fof(aSURJECTIVEu_ONu_RIGHTu_INVERSE,axiom,
    ! [Q49892,Q49893,F0,T0] :
      ( ! [Y] :
          ( p(s(bool,i(s(fun(fun(Q49893,bool),bool),i(s(fun(Q49893,fun(fun(Q49893,bool),bool)),in),s(Q49893,Y))),s(fun(Q49893,bool),T0))))
         => ? [X] :
              ( p(s(bool,i(s(fun(fun(Q49892,bool),bool),i(s(fun(Q49892,fun(fun(Q49892,bool),bool)),in),s(Q49892,X))),s(fun(Q49892,bool),s0))))
              & s(Q49893,i(s(fun(Q49892,Q49893),F0),s(Q49892,X))) = s(Q49893,Y) ) )
    <=> ? [G0] :
        ! [Y] :
          ( p(s(bool,i(s(fun(fun(Q49893,bool),bool),i(s(fun(Q49893,fun(fun(Q49893,bool),bool)),in),s(Q49893,Y))),s(fun(Q49893,bool),T0))))
         => ( p(s(bool,i(s(fun(fun(Q49892,bool),bool),i(s(fun(Q49892,fun(fun(Q49892,bool),bool)),in),s(Q49892,i(s(fun(Q49893,Q49892),G0),s(Q49893,Y))))),s(fun(Q49892,bool),s0))))
            & s(Q49893,i(s(fun(Q49892,Q49893),F0),s(Q49892,i(s(fun(Q49893,Q49892),G0),s(Q49893,Y))))) = s(Q49893,Y) ) ) ) ).

fof(aINJECTIVEu_ONu_LEFTu_INVERSE,axiom,
    ! [Q49989,Q49986,F0,S0] :
      ( ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(Q49986,bool),bool),i(s(fun(Q49986,fun(fun(Q49986,bool),bool)),in),s(Q49986,X))),s(fun(Q49986,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q49986,bool),bool),i(s(fun(Q49986,fun(fun(Q49986,bool),bool)),in),s(Q49986,Y))),s(fun(Q49986,bool),S0))))
            & s(Q49989,i(s(fun(Q49986,Q49989),F0),s(Q49986,X))) = s(Q49989,i(s(fun(Q49986,Q49989),F0),s(Q49986,Y))) )
         => s(Q49986,X) = s(Q49986,Y) )
    <=> ? [G0] :
        ! [X] :
          ( p(s(bool,i(s(fun(fun(Q49986,bool),bool),i(s(fun(Q49986,fun(fun(Q49986,bool),bool)),in),s(Q49986,X))),s(fun(Q49986,bool),S0))))
         => s(Q49986,i(s(fun(Q49989,Q49986),G0),s(Q49989,i(s(fun(Q49986,Q49989),F0),s(Q49986,X))))) = s(Q49986,X) ) ) ).

fof(aBIJECTIVEu_ONu_LEFTu_RIGHTu_INVERSE,axiom,
    ! [Q50120,Q50121,F0,S0,T0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,X))),s(fun(Q50121,bool),S0))))
         => p(s(bool,i(s(fun(fun(Q50120,bool),bool),i(s(fun(Q50120,fun(fun(Q50120,bool),bool)),in),s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,X))))),s(fun(Q50120,bool),T0)))) )
     => ( ( ! [X,Y] :
              ( ( p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,X))),s(fun(Q50121,bool),S0))))
                & p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,Y))),s(fun(Q50121,bool),S0))))
                & s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,X))) = s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,Y))) )
             => s(Q50121,X) = s(Q50121,Y) )
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(Q50120,bool),bool),i(s(fun(Q50120,fun(fun(Q50120,bool),bool)),in),s(Q50120,Y))),s(fun(Q50120,bool),T0))))
             => ? [X] :
                  ( p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,X))),s(fun(Q50121,bool),S0))))
                  & s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,X))) = s(Q50120,Y) ) ) )
      <=> ? [G0] :
            ( ! [Y] :
                ( p(s(bool,i(s(fun(fun(Q50120,bool),bool),i(s(fun(Q50120,fun(fun(Q50120,bool),bool)),in),s(Q50120,Y))),s(fun(Q50120,bool),T0))))
               => p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,i(s(fun(Q50120,Q50121),G0),s(Q50120,Y))))),s(fun(Q50121,bool),S0)))) )
            & ! [Y] :
                ( p(s(bool,i(s(fun(fun(Q50120,bool),bool),i(s(fun(Q50120,fun(fun(Q50120,bool),bool)),in),s(Q50120,Y))),s(fun(Q50120,bool),T0))))
               => s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,i(s(fun(Q50120,Q50121),G0),s(Q50120,Y))))) = s(Q50120,Y) )
            & ! [X] :
                ( p(s(bool,i(s(fun(fun(Q50121,bool),bool),i(s(fun(Q50121,fun(fun(Q50121,bool),bool)),in),s(Q50121,X))),s(fun(Q50121,bool),S0))))
               => s(Q50121,i(s(fun(Q50120,Q50121),G0),s(Q50120,i(s(fun(Q50121,Q50120),F0),s(Q50121,X))))) = s(Q50121,X) ) ) ) ) ).

fof(aSURJECTIVEu_RIGHTu_INVERSE,axiom,
    ! [Q50148,Q50145] :
      ( ! [Y] :
        ? [X] : s(Q50145,i(s(fun(Q50148,Q50145),f),s(Q50148,X))) = s(Q50145,Y)
    <=> ? [G0] :
        ! [Y] : s(Q50145,i(s(fun(Q50148,Q50145),f),s(Q50148,i(s(fun(Q50145,Q50148),G0),s(Q50145,Y))))) = s(Q50145,Y) ) ).

fof(aINJECTIVEu_LEFTu_INVERSE,axiom,
    ! [Q50185,Q50182] :
      ( ! [X,Y] :
          ( s(Q50185,i(s(fun(Q50182,Q50185),f),s(Q50182,X))) = s(Q50185,i(s(fun(Q50182,Q50185),f),s(Q50182,Y)))
         => s(Q50182,X) = s(Q50182,Y) )
    <=> ? [G0] :
        ! [X] : s(Q50182,i(s(fun(Q50185,Q50182),G0),s(Q50185,i(s(fun(Q50182,Q50185),f),s(Q50182,X))))) = s(Q50182,X) ) ).

fof(aBIJECTIVEu_LEFTu_RIGHTu_INVERSE,axiom,
    ! [B,A,F0] :
      ( ( ! [X,Y] :
            ( s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y)))
           => s(A,X) = s(A,Y) )
        & ! [Y] :
          ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) )
    <=> ? [G0] :
          ( ! [Y] : s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,Y))))) = s(B,Y)
          & ! [X] : s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,X))))) = s(A,X) ) ) ).

fof(aFUNCTIONu_FACTORSu_LEFTu_GEN,axiom,
    ! [Q50345,Q50349,Q50350,P0,F0,G0] :
      ( ! [X,Y] :
          ( ( p(s(bool,i(s(fun(Q50350,bool),P0),s(Q50350,X))))
            & p(s(bool,i(s(fun(Q50350,bool),P0),s(Q50350,Y))))
            & s(Q50349,i(s(fun(Q50350,Q50349),G0),s(Q50350,X))) = s(Q50349,i(s(fun(Q50350,Q50349),G0),s(Q50350,Y))) )
         => s(Q50345,i(s(fun(Q50350,Q50345),F0),s(Q50350,X))) = s(Q50345,i(s(fun(Q50350,Q50345),F0),s(Q50350,Y))) )
    <=> ? [H0] :
        ! [X] :
          ( p(s(bool,i(s(fun(Q50350,bool),P0),s(Q50350,X))))
         => s(Q50345,i(s(fun(Q50350,Q50345),F0),s(Q50350,X))) = s(Q50345,i(s(fun(Q50349,Q50345),H0),s(Q50349,i(s(fun(Q50350,Q50349),G0),s(Q50350,X))))) ) ) ).

fof(aFUNCTIONu_FACTORSu_LEFT,axiom,
    ! [Q50396,Q50395,Q50375,F0,G0] :
      ( ! [X,Y] :
          ( s(Q50375,i(s(fun(Q50395,Q50375),G0),s(Q50395,X))) = s(Q50375,i(s(fun(Q50395,Q50375),G0),s(Q50395,Y)))
         => s(Q50396,i(s(fun(Q50395,Q50396),F0),s(Q50395,X))) = s(Q50396,i(s(fun(Q50395,Q50396),F0),s(Q50395,Y))) )
    <=> ? [H0] : s(fun(Q50395,Q50396),F0) = s(fun(Q50395,Q50396),i(s(fun(fun(Q50395,Q50375),fun(Q50395,Q50396)),i(s(fun(fun(Q50375,Q50396),fun(fun(Q50395,Q50375),fun(Q50395,Q50396))),o),s(fun(Q50375,Q50396),H0))),s(fun(Q50395,Q50375),G0))) ) ).

fof(aFUNCTIONu_FACTORSu_RIGHTu_GEN,axiom,
    ! [Q50439,Q50443,Q50444,P0,F0,G0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(Q50444,bool),P0),s(Q50444,X))))
         => ? [Y] : s(Q50439,i(s(fun(Q50443,Q50439),G0),s(Q50443,Y))) = s(Q50439,i(s(fun(Q50444,Q50439),F0),s(Q50444,X))) )
    <=> ? [H0] :
        ! [X] :
          ( p(s(bool,i(s(fun(Q50444,bool),P0),s(Q50444,X))))
         => s(Q50439,i(s(fun(Q50444,Q50439),F0),s(Q50444,X))) = s(Q50439,i(s(fun(Q50443,Q50439),G0),s(Q50443,i(s(fun(Q50444,Q50443),H0),s(Q50444,X))))) ) ) ).

fof(aFUNCTIONu_FACTORSu_RIGHT,axiom,
    ! [Q50480,Q50479,Q50467,F0,G0] :
      ( ! [X] :
        ? [Y] : s(Q50480,i(s(fun(Q50467,Q50480),G0),s(Q50467,Y))) = s(Q50480,i(s(fun(Q50479,Q50480),F0),s(Q50479,X)))
    <=> ? [H0] : s(fun(Q50479,Q50480),F0) = s(fun(Q50479,Q50480),i(s(fun(fun(Q50479,Q50467),fun(Q50479,Q50480)),i(s(fun(fun(Q50467,Q50480),fun(fun(Q50479,Q50467),fun(Q50479,Q50480))),o),s(fun(Q50467,Q50480),G0))),s(fun(Q50479,Q50467),H0))) ) ).

fof(aSURJECTIVEu_FORALLu_THM,axiom,
    ! [A,B,F0] :
      ( ! [Y] :
        ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y)
    <=> ! [P0] :
          ( ! [X] : p(s(bool,i(s(fun(B,bool),P0),s(B,i(s(fun(A,B),F0),s(A,X))))))
        <=> ! [Y] : p(s(bool,i(s(fun(B,bool),P0),s(B,Y)))) ) ) ).

fof(aSURJECTIVEu_EXISTSu_THM,axiom,
    ! [A,B,F0] :
      ( ! [Y] :
        ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y)
    <=> ! [P0] :
          ( ? [X] : p(s(bool,i(s(fun(B,bool),P0),s(B,i(s(fun(A,B),F0),s(A,X))))))
        <=> ? [Y] : p(s(bool,i(s(fun(B,bool),P0),s(B,Y)))) ) ) ).

fof(aSURJECTIVEu_IMAGEu_THM,axiom,
    ! [A,B,U_1] :
      ( ! [P0,GENR_PVARR_53] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(fun(B,bool),fun(B,bool)),U_1),s(fun(B,bool),P0))),s(B,GENR_PVARR_53))))
        <=> ? [X] : p(s(bool,i(s(fun(B,bool),i(s(fun(bool,fun(B,bool)),i(s(fun(B,fun(bool,fun(B,bool))),setspec),s(B,GENR_PVARR_53))),s(bool,i(s(fun(B,bool),P0),s(B,X))))),s(B,X)))) )
     => ! [U_0] :
          ( ! [P0,F0,GENR_PVARR_52] :
              ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),i(s(fun(fun(B,bool),fun(fun(A,B),fun(A,bool))),U_0),s(fun(B,bool),P0))),s(fun(A,B),F0))),s(A,GENR_PVARR_52))))
            <=> ? [X] : p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_52))),s(bool,i(s(fun(B,bool),P0),s(B,i(s(fun(A,B),F0),s(A,X))))))),s(A,X)))) )
         => ! [F0] :
              ( ! [Y] :
                ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y)
            <=> ! [P0] : s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(A,B),fun(A,bool)),i(s(fun(fun(B,bool),fun(fun(A,B),fun(A,bool))),U_0),s(fun(B,bool),P0))),s(fun(A,B),F0))))))) = s(fun(B,bool),i(s(fun(fun(B,bool),fun(B,bool)),gspec),s(fun(B,bool),i(s(fun(fun(B,bool),fun(B,bool)),U_1),s(fun(B,bool),P0))))) ) ) ) ).

fof(aIMAGEu_INJECTIVEu_IMAGEu_OFu_SUBSET,axiom,
    ! [B,A,F0,S0] :
    ? [T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))
      & s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),T0)))
      & ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),T0))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),T0))))
            & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
         => s(A,X) = s(A,Y) ) ) ).

fof(aFINITEu_EMPTY,axiom,
    ! [Q50725] : p(s(bool,i(s(fun(fun(Q50725,bool),bool),finite),s(fun(Q50725,bool),empty)))) ).

fof(aFINITEu_SUBSET,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0)))) ) ).

fof(aFINITEu_UNIONu_IMP,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0)))))) ) ).

fof(aFINITEu_UNION,axiom,
    ! [A,S0,T0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))
    <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) ) ) ).

fof(aFINITEu_INTER,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        | p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0)))))) ) ).

fof(aFINITEu_INSERT,axiom,
    ! [A,S0,X] : s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))) = s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))) ).

fof(aFINITEu_SING,axiom,
    ! [Q50925,A5] : p(s(bool,i(s(fun(fun(Q50925,bool),bool),finite),s(fun(Q50925,bool),i(s(fun(fun(Q50925,bool),fun(Q50925,bool)),i(s(fun(Q50925,fun(fun(Q50925,bool),fun(Q50925,bool))),insert),s(Q50925,A5))),s(fun(Q50925,bool),empty)))))) ).

fof(aFINITEu_DELETEu_IMP,axiom,
    ! [A,S0,X] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X)))))) ) ).

fof(aFINITEu_DELETE,axiom,
    ! [A,S0,X] : s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))) = s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))) ).

fof(aFINITEu_FINITEu_UNIONS,axiom,
    ! [Q50997,S0] :
      ( p(s(bool,i(s(fun(fun(fun(Q50997,bool),bool),bool),finite),s(fun(fun(Q50997,bool),bool),S0))))
     => ( p(s(bool,i(s(fun(fun(Q50997,bool),bool),finite),s(fun(Q50997,bool),i(s(fun(fun(fun(Q50997,bool),bool),fun(Q50997,bool)),unions),s(fun(fun(Q50997,bool),bool),S0))))))
      <=> ! [T0] :
            ( p(s(bool,i(s(fun(fun(fun(Q50997,bool),bool),bool),i(s(fun(fun(Q50997,bool),fun(fun(fun(Q50997,bool),bool),bool)),in),s(fun(Q50997,bool),T0))),s(fun(fun(Q50997,bool),bool),S0))))
           => p(s(bool,i(s(fun(fun(Q50997,bool),bool),finite),s(fun(Q50997,bool),T0)))) ) ) ) ).

fof(aFINITEu_IMAGEu_EXPAND,axiom,
    ! [A,B,U_0] :
      ( ! [S0,F0,GENR_PVARR_56] :
          ( p(s(bool,i(s(fun(B,bool),i(s(fun(fun(A,B),fun(B,bool)),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(B,GENR_PVARR_56))))
        <=> ? [Y,V] :
              ( ( p(s(bool,V))
              <=> ? [X] :
                    ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                    & s(B,Y) = s(B,i(s(fun(A,B),F0),s(A,X))) ) )
              & p(s(bool,i(s(fun(B,bool),i(s(fun(bool,fun(B,bool)),i(s(fun(B,fun(bool,fun(B,bool))),setspec),s(B,GENR_PVARR_56))),s(bool,V))),s(B,Y)))) ) )
     => ! [F0,S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),i(s(fun(fun(B,bool),fun(B,bool)),gspec),s(fun(B,bool),i(s(fun(fun(A,B),fun(B,bool)),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0)))))))) ) ) ).

fof(aFINITEu_IMAGE,axiom,
    ! [B,A,F0,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0)))))) ) ).

fof(aFINITEu_IMAGEu_INJu_GENERAL,axiom,
    ! [A,B,U_0] :
      ( ! [S0,F0,A5,GENR_PVARR_57] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(fun(B,bool),fun(A,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(fun(B,bool),A5))),s(A,GENR_PVARR_57))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),A5)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_57))),s(bool,V))),s(A,X)))) ) )
     => ! [F0,A5,S0] :
          ( ( ! [X,Y] :
                ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                  & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
               => s(A,X) = s(A,Y) )
            & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),A5)))) )
         => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(fun(B,bool),fun(A,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(fun(B,bool),A5)))))))) ) ) ).

fof(aFINITEu_FINITEu_PREIMAGEu_GENERAL,axiom,
    ! [A,B,U_1] :
      ( ! [S0,F0,T0,GENR_PVARR_61] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(fun(B,bool),fun(A,bool)))),U_1),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(fun(B,bool),T0))),s(A,GENR_PVARR_61))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_61))),s(bool,V))),s(A,X)))) ) )
     => ! [U_0] :
          ( ! [S0,F0,Y,GENR_PVARR_60] :
              ( p(s(bool,i(s(fun(A,bool),i(s(fun(B,fun(A,bool)),i(s(fun(fun(A,B),fun(B,fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,fun(A,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(B,Y))),s(A,GENR_PVARR_60))))
            <=> ? [X,V] :
                  ( ( p(s(bool,V))
                  <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                      & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) )
                  & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_60))),s(bool,V))),s(A,X)))) ) )
         => ! [F0,S0,T0] :
              ( ( p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
                & ! [Y] :
                    ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
                   => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(B,fun(A,bool)),i(s(fun(fun(A,B),fun(B,fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(B,fun(A,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(B,Y)))))))) ) )
             => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),i(s(fun(fun(A,bool),fun(fun(A,B),fun(fun(B,bool),fun(A,bool)))),U_1),s(fun(A,bool),S0))),s(fun(A,B),F0))),s(fun(B,bool),T0)))))))) ) ) ) ).

fof(aFINITEu_FINITEu_PREIMAGE,axiom,
    ! [A,B,U_1] :
      ( ! [F0,T0,GENR_PVARR_63] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),U_1),s(fun(A,B),F0))),s(fun(B,bool),T0))),s(A,GENR_PVARR_63))))
        <=> ? [X] : p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_63))),s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0))))),s(A,X)))) )
     => ! [U_0] :
          ( ! [F0,Y,GENR_PVARR_62] :
              ( p(s(bool,i(s(fun(A,bool),i(s(fun(B,fun(A,bool)),i(s(fun(fun(A,B),fun(B,fun(A,bool))),U_0),s(fun(A,B),F0))),s(B,Y))),s(A,GENR_PVARR_62))))
            <=> ? [X,V] :
                  ( ( p(s(bool,V))
                  <=> s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) )
                  & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_62))),s(bool,V))),s(A,X)))) ) )
         => ! [F0,T0] :
              ( ( p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
                & ! [Y] :
                    ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
                   => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(B,fun(A,bool)),i(s(fun(fun(A,B),fun(B,fun(A,bool))),U_0),s(fun(A,B),F0))),s(B,Y)))))))) ) )
             => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),U_1),s(fun(A,B),F0))),s(fun(B,bool),T0)))))))) ) ) ) ).

fof(aFINITEu_IMAGEu_INJu_EQ,axiom,
    ! [B,A,F0,S0] :
      ( ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
            & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
         => s(A,X) = s(A,Y) )
     => s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))) = s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))) ) ).

fof(aFINITEu_IMAGEu_INJ,axiom,
    ! [A,B,U_0] :
      ( ! [F0,A5,GENR_PVARR_64] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),U_0),s(fun(A,B),F0))),s(fun(B,bool),A5))),s(A,GENR_PVARR_64))))
        <=> ? [X] : p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_64))),s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),A5))))),s(A,X)))) )
     => ! [F0,A5] :
          ( ( ! [X,Y] :
                ( s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y)))
               => s(A,X) = s(A,Y) )
            & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),A5)))) )
         => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(B,bool),fun(A,bool)),i(s(fun(fun(A,B),fun(fun(B,bool),fun(A,bool))),U_0),s(fun(A,B),F0))),s(fun(B,bool),A5)))))))) ) ) ).

fof(aINFINITEu_IMAGEu_INJ,axiom,
    ! [B,A,F0] :
      ( ! [X,Y] :
          ( s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y)))
         => s(A,X) = s(A,Y) )
     => ! [S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),infinite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(B,bool),bool),infinite),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0)))))) ) ) ).

fof(aINFINITEu_NONEMPTY,axiom,
    ! [Q51578,S0] :
      ( p(s(bool,i(s(fun(fun(Q51578,bool),bool),infinite),s(fun(Q51578,bool),S0))))
     => s(fun(Q51578,bool),S0) != s(fun(Q51578,bool),empty) ) ).

fof(aINFINITEu_DIFFu_FINITE,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),infinite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(A,bool),bool),infinite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),diff),s(fun(A,bool),S0))),s(fun(A,bool),T0)))))) ) ).

fof(aFINITEu_SUBSETu_IMAGE,axiom,
    ! [B,A,F0,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),T0))),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0)))))) )
    <=> ? [SI_] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),SI_))))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),SI_))),s(fun(A,bool),S0))))
          & s(fun(B,bool),T0) = s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),SI_))) ) ) ).

fof(aEXISTSu_FINITEu_SUBSETu_IMAGE,axiom,
    ! [Q51738,Q51718,P0,F0,S0] :
      ( ? [T0] :
          ( p(s(bool,i(s(fun(fun(Q51738,bool),bool),finite),s(fun(Q51738,bool),T0))))
          & p(s(bool,i(s(fun(fun(Q51738,bool),bool),i(s(fun(fun(Q51738,bool),fun(fun(Q51738,bool),bool)),subset),s(fun(Q51738,bool),T0))),s(fun(Q51738,bool),i(s(fun(fun(Q51718,bool),fun(Q51738,bool)),i(s(fun(fun(Q51718,Q51738),fun(fun(Q51718,bool),fun(Q51738,bool))),image),s(fun(Q51718,Q51738),F0))),s(fun(Q51718,bool),S0))))))
          & p(s(bool,i(s(fun(fun(Q51738,bool),bool),P0),s(fun(Q51738,bool),T0)))) )
    <=> ? [T0] :
          ( p(s(bool,i(s(fun(fun(Q51718,bool),bool),finite),s(fun(Q51718,bool),T0))))
          & p(s(bool,i(s(fun(fun(Q51718,bool),bool),i(s(fun(fun(Q51718,bool),fun(fun(Q51718,bool),bool)),subset),s(fun(Q51718,bool),T0))),s(fun(Q51718,bool),S0))))
          & p(s(bool,i(s(fun(fun(Q51738,bool),bool),P0),s(fun(Q51738,bool),i(s(fun(fun(Q51718,bool),fun(Q51738,bool)),i(s(fun(fun(Q51718,Q51738),fun(fun(Q51718,bool),fun(Q51738,bool))),image),s(fun(Q51718,Q51738),F0))),s(fun(Q51718,bool),T0)))))) ) ) ).

fof(aFORALLu_FINITEu_SUBSETu_IMAGE,axiom,
    ! [Q51804,Q51784,P0,F0,S0] :
      ( ! [T0] :
          ( ( p(s(bool,i(s(fun(fun(Q51804,bool),bool),finite),s(fun(Q51804,bool),T0))))
            & p(s(bool,i(s(fun(fun(Q51804,bool),bool),i(s(fun(fun(Q51804,bool),fun(fun(Q51804,bool),bool)),subset),s(fun(Q51804,bool),T0))),s(fun(Q51804,bool),i(s(fun(fun(Q51784,bool),fun(Q51804,bool)),i(s(fun(fun(Q51784,Q51804),fun(fun(Q51784,bool),fun(Q51804,bool))),image),s(fun(Q51784,Q51804),F0))),s(fun(Q51784,bool),S0)))))) )
         => p(s(bool,i(s(fun(fun(Q51804,bool),bool),P0),s(fun(Q51804,bool),T0)))) )
    <=> ! [T0] :
          ( ( p(s(bool,i(s(fun(fun(Q51784,bool),bool),finite),s(fun(Q51784,bool),T0))))
            & p(s(bool,i(s(fun(fun(Q51784,bool),bool),i(s(fun(fun(Q51784,bool),fun(fun(Q51784,bool),bool)),subset),s(fun(Q51784,bool),T0))),s(fun(Q51784,bool),S0)))) )
         => p(s(bool,i(s(fun(fun(Q51804,bool),bool),P0),s(fun(Q51804,bool),i(s(fun(fun(Q51784,bool),fun(Q51804,bool)),i(s(fun(fun(Q51784,Q51804),fun(fun(Q51784,bool),fun(Q51804,bool))),image),s(fun(Q51784,Q51804),F0))),s(fun(Q51784,bool),T0)))))) ) ) ).

fof(aFINITEu_SUBSETu_IMAGEu_IMP,axiom,
    ! [B,A,F0,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),T0))),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0)))))) )
     => ? [SI_] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),SI_))))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),SI_))),s(fun(A,bool),S0))))
          & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),T0))),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),SI_)))))) ) ) ).

fof(aFINITEu_DIFF,axiom,
    ! [Q51863,S0,T0] :
      ( p(s(bool,i(s(fun(fun(Q51863,bool),bool),finite),s(fun(Q51863,bool),S0))))
     => p(s(bool,i(s(fun(fun(Q51863,bool),bool),finite),s(fun(Q51863,bool),i(s(fun(fun(Q51863,bool),fun(Q51863,bool)),i(s(fun(fun(Q51863,bool),fun(fun(Q51863,bool),fun(Q51863,bool))),diff),s(fun(Q51863,bool),S0))),s(fun(Q51863,bool),T0)))))) ) ).

fof(aINFINITEu_SUPERSET,axiom,
    ! [Q51883,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q51883,bool),bool),infinite),s(fun(Q51883,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q51883,bool),bool),i(s(fun(fun(Q51883,bool),fun(fun(Q51883,bool),bool)),subset),s(fun(Q51883,bool),S0))),s(fun(Q51883,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(Q51883,bool),bool),infinite),s(fun(Q51883,bool),T0)))) ) ).

fof(aFINRECu_conjunct0,axiom,
    ! [A,B] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),f))),s(B,b0))),s(fun(A,bool),s0))),s(B,a0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))
    <=> ( s(fun(A,bool),s0) = s(fun(A,bool),empty)
        & s(B,a0) = s(B,b0) ) ) ).

fof(aFINRECu_conjunct1,axiom,
    ! [A,B] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),f))),s(B,b0))),s(fun(A,bool),s0))),s(B,a0))),s(num,i(s(fun(num,num),suc),s(num,n))))))
    <=> ? [X,C0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),s0))))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),f))),s(B,b0))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),s0))),s(A,X))))),s(B,C0))),s(num,n))))
          & s(B,a0) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),f),s(A,X))),s(B,C0))) ) ) ).

fof(aFINRECu_1u_LEMMA,axiom,
    ! [Q51988,Q51987,F0,B0,S0,A5] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(Q51987,fun(num,bool)),i(s(fun(fun(Q51988,bool),fun(Q51987,fun(num,bool))),i(s(fun(Q51987,fun(fun(Q51988,bool),fun(Q51987,fun(num,bool)))),i(s(fun(fun(Q51988,fun(Q51987,Q51987)),fun(Q51987,fun(fun(Q51988,bool),fun(Q51987,fun(num,bool))))),finrec),s(fun(Q51988,fun(Q51987,Q51987)),F0))),s(Q51987,B0))),s(fun(Q51988,bool),S0))),s(Q51987,A5))),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))))
    <=> ? [X] :
          ( s(fun(Q51988,bool),S0) = s(fun(Q51988,bool),i(s(fun(fun(Q51988,bool),fun(Q51988,bool)),i(s(fun(Q51988,fun(fun(Q51988,bool),fun(Q51988,bool))),insert),s(Q51988,X))),s(fun(Q51988,bool),empty)))
          & s(Q51987,A5) = s(Q51987,i(s(fun(Q51987,Q51987),i(s(fun(Q51988,fun(Q51987,Q51987)),F0),s(Q51988,X))),s(Q51987,B0))) ) ) ).

fof(aFINRECu_SUCu_LEMMA,axiom,
    ! [A,B,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ! [N0,S0,Z0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),F0))),s(B,B0))),s(fun(A,bool),S0))),s(B,Z0))),s(num,i(s(fun(num,num),suc),s(num,N0))))))
         => ! [X] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
             => ? [W] :
                  ( p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),F0))),s(B,B0))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(B,W))),s(num,N0))))
                  & s(B,Z0) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,W))) ) ) ) ) ).

fof(aFINRECu_UNIQUEu_LEMMA,axiom,
    ! [A,B,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ! [N1,N2,S0,A10,A20] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),F0))),s(B,B0))),s(fun(A,bool),S0))),s(B,A10))),s(num,N1))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),F0))),s(B,B0))),s(fun(A,bool),S0))),s(B,A20))),s(num,N2)))) )
         => ( s(B,A10) = s(B,A20)
            & s(num,N1) = s(num,N2) ) ) ) ).

fof(aFINRECu_EXISTSu_LEMMA,axiom,
    ! [A,B,F0,B0,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => ? [A5,N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(B,fun(num,bool)),i(s(fun(fun(A,bool),fun(B,fun(num,bool))),i(s(fun(B,fun(fun(A,bool),fun(B,fun(num,bool)))),i(s(fun(fun(A,fun(B,B)),fun(B,fun(fun(A,bool),fun(B,fun(num,bool))))),finrec),s(fun(A,fun(B,B)),F0))),s(B,B0))),s(fun(A,bool),S0))),s(B,A5))),s(num,N0)))) ) ).

fof(aFINRECu_FUNu_LEMMA,axiom,
    ! [C,A,B,P0,R0] :
      ( ( ! [S0] :
            ( p(s(bool,i(s(fun(A,bool),P0),s(A,S0))))
           => ? [A5,N0] : p(s(bool,i(s(fun(C,bool),i(s(fun(B,fun(C,bool)),i(s(fun(A,fun(B,fun(C,bool))),R0),s(A,S0))),s(B,A5))),s(C,N0)))) )
        & ! [N1,N2,S0,A10,A20] :
            ( ( p(s(bool,i(s(fun(C,bool),i(s(fun(B,fun(C,bool)),i(s(fun(A,fun(B,fun(C,bool))),R0),s(A,S0))),s(B,A10))),s(C,N1))))
              & p(s(bool,i(s(fun(C,bool),i(s(fun(B,fun(C,bool)),i(s(fun(A,fun(B,fun(C,bool))),R0),s(A,S0))),s(B,A20))),s(C,N2)))) )
           => ( s(B,A10) = s(B,A20)
              & s(C,N1) = s(C,N2) ) ) )
     => ? [F0] :
        ! [S0,A5] :
          ( p(s(bool,i(s(fun(A,bool),P0),s(A,S0))))
         => ( ? [N0] : p(s(bool,i(s(fun(C,bool),i(s(fun(B,fun(C,bool)),i(s(fun(A,fun(B,fun(C,bool))),R0),s(A,S0))),s(B,A5))),s(C,N0))))
          <=> s(B,i(s(fun(A,B),F0),s(A,S0))) = s(B,A5) ) ) ) ).

fof(aFINRECu_FUN,axiom,
    ! [B,A,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ? [G0] :
          ( s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),empty))) = s(B,B0)
          & ! [S0,X] :
              ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
                & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0)))) )
             => s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),S0))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))))) ) ) ) ).

fof(aSETu_RECURSIONu_LEMMA,axiom,
    ! [B,A,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ? [G0] :
          ( s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),empty))) = s(B,B0)
          & ! [X,S0] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
             => s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),S0))))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(fun(A,bool),B),G0),s(fun(A,bool),S0))))))) ) ) ) ).

fof(aITSET,axiom,
    ! [Q52643,Q52644,U_0] :
      ( ! [B0,F0,G0] :
          ( p(s(bool,i(s(fun(fun(fun(Q52644,bool),Q52643),bool),i(s(fun(fun(Q52644,fun(Q52643,Q52643)),fun(fun(fun(Q52644,bool),Q52643),bool)),i(s(fun(Q52643,fun(fun(Q52644,fun(Q52643,Q52643)),fun(fun(fun(Q52644,bool),Q52643),bool))),U_0),s(Q52643,B0))),s(fun(Q52644,fun(Q52643,Q52643)),F0))),s(fun(fun(Q52644,bool),Q52643),G0))))
        <=> ( s(Q52643,i(s(fun(fun(Q52644,bool),Q52643),G0),s(fun(Q52644,bool),empty))) = s(Q52643,B0)
            & ! [X,S0] :
                ( p(s(bool,i(s(fun(fun(Q52644,bool),bool),finite),s(fun(Q52644,bool),S0))))
               => s(Q52643,i(s(fun(fun(Q52644,bool),Q52643),G0),s(fun(Q52644,bool),i(s(fun(fun(Q52644,bool),fun(Q52644,bool)),i(s(fun(Q52644,fun(fun(Q52644,bool),fun(Q52644,bool))),insert),s(Q52644,X))),s(fun(Q52644,bool),S0))))) = s(Q52643,i(s(fun(Q52643,Q52643),i(s(fun(Q52643,fun(Q52643,Q52643)),i(s(fun(bool,fun(Q52643,fun(Q52643,Q52643))),cond),s(bool,i(s(fun(fun(Q52644,bool),bool),i(s(fun(Q52644,fun(fun(Q52644,bool),bool)),in),s(Q52644,X))),s(fun(Q52644,bool),S0))))),s(Q52643,i(s(fun(fun(Q52644,bool),Q52643),G0),s(fun(Q52644,bool),S0))))),s(Q52643,i(s(fun(Q52643,Q52643),i(s(fun(Q52644,fun(Q52643,Q52643)),F0),s(Q52644,X))),s(Q52643,i(s(fun(fun(Q52644,bool),Q52643),G0),s(fun(Q52644,bool),S0))))))) ) ) )
     => ! [B0,F0,S0] : s(Q52643,i(s(fun(Q52643,Q52643),i(s(fun(fun(Q52644,bool),fun(Q52643,Q52643)),i(s(fun(fun(Q52644,fun(Q52643,Q52643)),fun(fun(Q52644,bool),fun(Q52643,Q52643))),itset),s(fun(Q52644,fun(Q52643,Q52643)),F0))),s(fun(Q52644,bool),S0))),s(Q52643,B0))) = s(Q52643,i(s(fun(fun(Q52644,bool),Q52643),i(s(fun(fun(fun(fun(Q52644,bool),Q52643),bool),fun(fun(Q52644,bool),Q52643)),h_),s(fun(fun(fun(Q52644,bool),Q52643),bool),i(s(fun(fun(Q52644,fun(Q52643,Q52643)),fun(fun(fun(Q52644,bool),Q52643),bool)),i(s(fun(Q52643,fun(fun(Q52644,fun(Q52643,Q52643)),fun(fun(fun(Q52644,bool),Q52643),bool))),U_0),s(Q52643,B0))),s(fun(Q52644,fun(Q52643,Q52643)),F0))))),s(fun(Q52644,bool),S0))) ) ).

fof(aFINITEu_RECURSION,axiom,
    ! [A,B,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ( s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),empty))),s(B,B0))) = s(B,B0)
        & ! [X,S0] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
           => s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))),s(B,B0))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),S0))),s(B,B0))))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),S0))),s(B,B0))))))) ) ) ) ).

fof(aFINITEu_RECURSIONu_DELETE,axiom,
    ! [A,B,F0,B0] :
      ( ! [X,Y,S0] :
          ( s(A,X) != s(A,Y)
         => s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,S0))))) = s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,Y))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,S0))))) )
     => ( s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),empty))),s(B,B0))) = s(B,B0)
        & ! [X,S0] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
           => s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),S0))),s(B,B0))) = s(B,i(s(fun(B,B),i(s(fun(B,fun(B,B)),i(s(fun(bool,fun(B,fun(B,B))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(B,i(s(fun(B,B),i(s(fun(A,fun(B,B)),F0),s(A,X))),s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(B,B0))))))),s(B,i(s(fun(B,B),i(s(fun(fun(A,bool),fun(B,B)),i(s(fun(fun(A,fun(B,B)),fun(fun(A,bool),fun(B,B))),itset),s(fun(A,fun(B,B)),F0))),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))),s(B,B0))))) ) ) ) ).

fof(aITSETu_EQ,axiom,
    ! [Q52949,Q52950,S0,F0,G0,B0] :
      ( ( p(s(bool,i(s(fun(fun(Q52949,bool),bool),finite),s(fun(Q52949,bool),S0))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(Q52949,bool),bool),i(s(fun(Q52949,fun(fun(Q52949,bool),bool)),in),s(Q52949,X))),s(fun(Q52949,bool),S0))))
           => s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),F0),s(Q52949,X))) = s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),G0),s(Q52949,X))) )
        & ! [X,Y,S1] :
            ( s(Q52949,X) != s(Q52949,Y)
           => s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),F0),s(Q52949,X))),s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),F0),s(Q52949,Y))),s(Q52950,S1))))) = s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),F0),s(Q52949,Y))),s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),F0),s(Q52949,X))),s(Q52950,S1))))) )
        & ! [X,Y,S1] :
            ( s(Q52949,X) != s(Q52949,Y)
           => s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),G0),s(Q52949,X))),s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),G0),s(Q52949,Y))),s(Q52950,S1))))) = s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),G0),s(Q52949,Y))),s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(Q52949,fun(Q52950,Q52950)),G0),s(Q52949,X))),s(Q52950,S1))))) ) )
     => s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(fun(Q52949,bool),fun(Q52950,Q52950)),i(s(fun(fun(Q52949,fun(Q52950,Q52950)),fun(fun(Q52949,bool),fun(Q52950,Q52950))),itset),s(fun(Q52949,fun(Q52950,Q52950)),F0))),s(fun(Q52949,bool),S0))),s(Q52950,B0))) = s(Q52950,i(s(fun(Q52950,Q52950),i(s(fun(fun(Q52949,bool),fun(Q52950,Q52950)),i(s(fun(fun(Q52949,fun(Q52950,Q52950)),fun(fun(Q52949,bool),fun(Q52950,Q52950))),itset),s(fun(Q52949,fun(Q52950,Q52950)),G0))),s(fun(Q52949,bool),S0))),s(Q52950,B0))) ) ).

fof(aSUBSETu_RESTRICT,axiom,
    ! [Q52983,U_0] :
      ( ! [S0,P0,GENR_PVARR_66] :
          ( p(s(bool,i(s(fun(Q52983,bool),i(s(fun(fun(Q52983,bool),fun(Q52983,bool)),i(s(fun(fun(Q52983,bool),fun(fun(Q52983,bool),fun(Q52983,bool))),U_0),s(fun(Q52983,bool),S0))),s(fun(Q52983,bool),P0))),s(Q52983,GENR_PVARR_66))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(Q52983,bool),bool),i(s(fun(Q52983,fun(fun(Q52983,bool),bool)),in),s(Q52983,X))),s(fun(Q52983,bool),S0))))
                  & p(s(bool,i(s(fun(Q52983,bool),P0),s(Q52983,X)))) ) )
              & p(s(bool,i(s(fun(Q52983,bool),i(s(fun(bool,fun(Q52983,bool)),i(s(fun(Q52983,fun(bool,fun(Q52983,bool))),setspec),s(Q52983,GENR_PVARR_66))),s(bool,V))),s(Q52983,X)))) ) )
     => ! [S0,P0] : p(s(bool,i(s(fun(fun(Q52983,bool),bool),i(s(fun(fun(Q52983,bool),fun(fun(Q52983,bool),bool)),subset),s(fun(Q52983,bool),i(s(fun(fun(Q52983,bool),fun(Q52983,bool)),gspec),s(fun(Q52983,bool),i(s(fun(fun(Q52983,bool),fun(Q52983,bool)),i(s(fun(fun(Q52983,bool),fun(fun(Q52983,bool),fun(Q52983,bool))),U_0),s(fun(Q52983,bool),S0))),s(fun(Q52983,bool),P0))))))),s(fun(Q52983,bool),S0)))) ) ).

fof(aFINITEu_RESTRICT,axiom,
    ! [A,U_0] :
      ( ! [S0,P0,GENR_PVARR_67] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),P0))),s(A,GENR_PVARR_67))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(A,bool),P0),s(A,X)))) ) )
              & p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_67))),s(bool,V))),s(A,X)))) ) )
     => ! [S0,P0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),U_0),s(fun(A,bool),S0))),s(fun(A,bool),P0)))))))) ) ) ).

fof(aCARD,axiom,
    ! [Q53037,U_1] :
      ( ! [N0] : s(num,i(s(fun(num,num),U_1),s(num,N0))) = s(num,i(s(fun(num,num),suc),s(num,N0)))
     => ! [U_0] :
          ( ! [X] : s(fun(num,num),i(s(fun(Q53037,fun(num,num)),U_0),s(Q53037,X))) = s(fun(num,num),U_1)
         => ! [S0] : s(num,i(s(fun(fun(Q53037,bool),num),card),s(fun(Q53037,bool),S0))) = s(num,i(s(fun(num,num),i(s(fun(fun(Q53037,bool),fun(num,num)),i(s(fun(fun(Q53037,fun(num,num)),fun(fun(Q53037,bool),fun(num,num))),itset),s(fun(Q53037,fun(num,num)),U_0))),s(fun(Q53037,bool),S0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))) ) ) ).

fof(aCARDu_CLAUSESu_conjunct0,axiom,
    ! [A] : s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),empty))) = s(num,i(s(fun(num,num),numeral),s(num,u_0))) ).

fof(aCARDu_CLAUSESu_conjunct1,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,X))),s(fun(A,bool),S0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(num,num),suc),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))))) ) ).

fof(aCARDu_UNION,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0))))
        & s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),inter),s(fun(A,bool),S0))),s(fun(A,bool),T0))) = s(fun(A,bool),empty) )
     => s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),T0))))) ) ).

fof(aCARDu_DELETE,axiom,
    ! [A,X,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),i(s(fun(bool,fun(num,fun(num,num))),cond),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))) ) ).

fof(aCARDu_UNIONu_EQ,axiom,
    ! [Q53282,S0,T0,U] :
      ( ( p(s(bool,i(s(fun(fun(Q53282,bool),bool),finite),s(fun(Q53282,bool),U))))
        & s(fun(Q53282,bool),i(s(fun(fun(Q53282,bool),fun(Q53282,bool)),i(s(fun(fun(Q53282,bool),fun(fun(Q53282,bool),fun(Q53282,bool))),inter),s(fun(Q53282,bool),S0))),s(fun(Q53282,bool),T0))) = s(fun(Q53282,bool),empty)
        & s(fun(Q53282,bool),i(s(fun(fun(Q53282,bool),fun(Q53282,bool)),i(s(fun(fun(Q53282,bool),fun(fun(Q53282,bool),fun(Q53282,bool))),union),s(fun(Q53282,bool),S0))),s(fun(Q53282,bool),T0))) = s(fun(Q53282,bool),U) )
     => s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(Q53282,bool),num),card),s(fun(Q53282,bool),S0))))),s(num,i(s(fun(fun(Q53282,bool),num),card),s(fun(Q53282,bool),T0))))) = s(num,i(s(fun(fun(Q53282,bool),num),card),s(fun(Q53282,bool),U))) ) ).

fof(aCARDu_DIFF,axiom,
    ! [Q53339,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q53339,bool),bool),finite),s(fun(Q53339,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q53339,bool),bool),i(s(fun(fun(Q53339,bool),fun(fun(Q53339,bool),bool)),subset),s(fun(Q53339,bool),T0))),s(fun(Q53339,bool),S0)))) )
     => s(num,i(s(fun(fun(Q53339,bool),num),card),s(fun(Q53339,bool),i(s(fun(fun(Q53339,bool),fun(Q53339,bool)),i(s(fun(fun(Q53339,bool),fun(fun(Q53339,bool),fun(Q53339,bool))),diff),s(fun(Q53339,bool),S0))),s(fun(Q53339,bool),T0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(fun(Q53339,bool),num),card),s(fun(Q53339,bool),S0))))),s(num,i(s(fun(fun(Q53339,bool),num),card),s(fun(Q53339,bool),T0))))) ) ).

fof(aCARDu_EQu_0,axiom,
    ! [Q53377,S0] :
      ( p(s(bool,i(s(fun(fun(Q53377,bool),bool),finite),s(fun(Q53377,bool),S0))))
     => ( s(num,i(s(fun(fun(Q53377,bool),num),card),s(fun(Q53377,bool),S0))) = s(num,i(s(fun(num,num),numeral),s(num,u_0)))
      <=> s(fun(Q53377,bool),S0) = s(fun(Q53377,bool),empty) ) ) ).

fof(aFINITEu_INDUCTu_DELETE,axiom,
    ! [A,P0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),empty))))
        & ! [S0] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
              & s(fun(A,bool),S0) != s(fun(A,bool),empty) )
           => ? [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                & ( p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,X))))))
                 => p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),S0)))) ) ) ) )
     => ! [S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(A,bool),bool),P0),s(fun(A,bool),S0)))) ) ) ).

fof(aHASu_SIZE,axiom,
    ! [Q53496,S0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53496,bool),fun(num,bool)),hasu_size),s(fun(Q53496,bool),S0))),s(num,N0))))
    <=> ( p(s(bool,i(s(fun(fun(Q53496,bool),bool),finite),s(fun(Q53496,bool),S0))))
        & s(num,i(s(fun(fun(Q53496,bool),num),card),s(fun(Q53496,bool),S0))) = s(num,N0) ) ) ).

fof(aHASu_SIZEu_CARD,axiom,
    ! [Q53515,S0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53515,bool),fun(num,bool)),hasu_size),s(fun(Q53515,bool),S0))),s(num,N0))))
     => s(num,i(s(fun(fun(Q53515,bool),num),card),s(fun(Q53515,bool),S0))) = s(num,N0) ) ).

fof(aHASu_SIZEu_0,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))
    <=> s(fun(A,bool),S0) = s(fun(A,bool),empty) ) ).

fof(aHASu_SIZEu_SUC,axiom,
    ! [A,S0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,i(s(fun(num,num),suc),s(num,N0))))))
    <=> ( s(fun(A,bool),S0) != s(fun(A,bool),empty)
        & ! [A5] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,A5))),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,bool),fun(A,fun(A,bool))),delete),s(fun(A,bool),S0))),s(A,A5))))),s(num,N0)))) ) ) ) ).

fof(aHASu_SIZEu_UNION,axiom,
    ! [Q53649,S0,T0,M0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53649,bool),fun(num,bool)),hasu_size),s(fun(Q53649,bool),S0))),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53649,bool),fun(num,bool)),hasu_size),s(fun(Q53649,bool),T0))),s(num,N0))))
        & p(s(bool,i(s(fun(fun(Q53649,bool),bool),i(s(fun(fun(Q53649,bool),fun(fun(Q53649,bool),bool)),disjoint),s(fun(Q53649,bool),S0))),s(fun(Q53649,bool),T0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53649,bool),fun(num,bool)),hasu_size),s(fun(Q53649,bool),i(s(fun(fun(Q53649,bool),fun(Q53649,bool)),i(s(fun(fun(Q53649,bool),fun(fun(Q53649,bool),fun(Q53649,bool))),union),s(fun(Q53649,bool),S0))),s(fun(Q53649,bool),T0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,M0))),s(num,N0)))))) ) ).

fof(aHASu_SIZEu_DIFF,axiom,
    ! [Q53685,S0,T0,M0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53685,bool),fun(num,bool)),hasu_size),s(fun(Q53685,bool),S0))),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53685,bool),fun(num,bool)),hasu_size),s(fun(Q53685,bool),T0))),s(num,N0))))
        & p(s(bool,i(s(fun(fun(Q53685,bool),bool),i(s(fun(fun(Q53685,bool),fun(fun(Q53685,bool),bool)),subset),s(fun(Q53685,bool),T0))),s(fun(Q53685,bool),S0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53685,bool),fun(num,bool)),hasu_size),s(fun(Q53685,bool),i(s(fun(fun(Q53685,bool),fun(Q53685,bool)),i(s(fun(fun(Q53685,bool),fun(fun(Q53685,bool),fun(Q53685,bool))),diff),s(fun(Q53685,bool),S0))),s(fun(Q53685,bool),T0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,M0))),s(num,N0)))))) ) ).

fof(aHASu_SIZEu_UNIONS,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_70] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))),s(fun(B,bool),GENR_PVARR_70))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(bool,fun(fun(B,bool),bool)),i(s(fun(fun(B,bool),fun(bool,fun(fun(B,bool),bool))),setspec),s(fun(B,bool),GENR_PVARR_70))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X)))))) )
     => ! [S0,T0,M0,N0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,M0))))
            & ! [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
               => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X))))),s(num,N0)))) )
            & ! [X,Y] :
                ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                  & s(A,X) != s(A,Y) )
               => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),disjoint),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X))))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,Y)))))) ) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),unions),s(fun(fun(B,bool),bool),i(s(fun(fun(fun(B,bool),bool),fun(fun(B,bool),bool)),gspec),s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))) ) ) ).

fof(aFINITEu_HASu_SIZE,axiom,
    ! [Q53889,S0] : s(bool,i(s(fun(fun(Q53889,bool),bool),finite),s(fun(Q53889,bool),S0))) = s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53889,bool),fun(num,bool)),hasu_size),s(fun(Q53889,bool),S0))),s(num,i(s(fun(fun(Q53889,bool),num),card),s(fun(Q53889,bool),S0))))) ).

fof(aHASu_SIZEu_CLAUSESu_conjunct0,axiom,
    ! [Q53951] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53951,bool),fun(num,bool)),hasu_size),s(fun(Q53951,bool),s0))),s(num,i(s(fun(num,num),numeral),s(num,u_0))))))
    <=> s(fun(Q53951,bool),s0) = s(fun(Q53951,bool),empty) ) ).

fof(aHASu_SIZEu_CLAUSESu_conjunct1,axiom,
    ! [Q53951] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53951,bool),fun(num,bool)),hasu_size),s(fun(Q53951,bool),s0))),s(num,i(s(fun(num,num),suc),s(num,n))))))
    <=> ? [A5,T0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q53951,bool),fun(num,bool)),hasu_size),s(fun(Q53951,bool),T0))),s(num,n))))
          & ~ p(s(bool,i(s(fun(fun(Q53951,bool),bool),i(s(fun(Q53951,fun(fun(Q53951,bool),bool)),in),s(Q53951,A5))),s(fun(Q53951,bool),T0))))
          & s(fun(Q53951,bool),s0) = s(fun(Q53951,bool),i(s(fun(fun(Q53951,bool),fun(Q53951,bool)),i(s(fun(Q53951,fun(fun(Q53951,bool),fun(Q53951,bool))),insert),s(Q53951,A5))),s(fun(Q53951,bool),T0))) ) ) ).

fof(aCARDu_SUBSETu_EQ,axiom,
    ! [A,A5,B0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),B0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),A5))),s(fun(A,bool),B0))))
        & s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),A5))) = s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),B0))) )
     => s(fun(A,bool),A5) = s(fun(A,bool),B0) ) ).

fof(aCARDu_SUBSET,axiom,
    ! [A,A5,B0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),A5))),s(fun(A,bool),B0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),B0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),A5))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),B0)))))) ) ).

fof(aCARDu_SUBSETu_LE,axiom,
    ! [A,A5,B0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),B0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),A5))),s(fun(A,bool),B0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),B0))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),A5)))))) )
     => s(fun(A,bool),A5) = s(fun(A,bool),B0) ) ).

fof(aSUBSETu_CARDu_EQ,axiom,
    ! [Q54262,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q54262,bool),bool),finite),s(fun(Q54262,bool),T0))))
        & p(s(bool,i(s(fun(fun(Q54262,bool),bool),i(s(fun(fun(Q54262,bool),fun(fun(Q54262,bool),bool)),subset),s(fun(Q54262,bool),S0))),s(fun(Q54262,bool),T0)))) )
     => ( s(num,i(s(fun(fun(Q54262,bool),num),card),s(fun(Q54262,bool),S0))) = s(num,i(s(fun(fun(Q54262,bool),num),card),s(fun(Q54262,bool),T0)))
      <=> s(fun(Q54262,bool),S0) = s(fun(Q54262,bool),T0) ) ) ).

fof(aCARDu_PSUBSET,axiom,
    ! [A,A5,B0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),psubset),s(fun(A,bool),A5))),s(fun(A,bool),B0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),B0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),A5))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),B0)))))) ) ).

fof(aCARDu_UNIONu_LE,axiom,
    ! [A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,bool),fun(fun(A,bool),fun(A,bool))),union),s(fun(A,bool),S0))),s(fun(A,bool),T0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),T0)))))))) ) ).

fof(aCARDu_UNIONSu_LE,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_76] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))),s(fun(B,bool),GENR_PVARR_76))))
        <=> ? [X] : p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(bool,fun(fun(B,bool),bool)),i(s(fun(fun(B,bool),fun(bool,fun(fun(B,bool),bool))),setspec),s(fun(B,bool),GENR_PVARR_76))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X)))))) )
     => ! [S0,T0,M0,N0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,M0))))
            & ! [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
               => ( p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X))))))
                  & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X))))))),s(num,N0)))) ) ) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),i(s(fun(fun(fun(B,bool),bool),fun(B,bool)),unions),s(fun(fun(B,bool),bool),i(s(fun(fun(fun(B,bool),bool),fun(fun(B,bool),bool)),gspec),s(fun(fun(B,bool),bool),i(s(fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(B,bool),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))))))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))) ) ) ).

fof(aCARDu_UNIONu_GEN,axiom,
    ! [Q54685,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q54685,bool),bool),finite),s(fun(Q54685,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q54685,bool),bool),finite),s(fun(Q54685,bool),T0)))) )
     => s(num,i(s(fun(fun(Q54685,bool),num),card),s(fun(Q54685,bool),i(s(fun(fun(Q54685,bool),fun(Q54685,bool)),i(s(fun(fun(Q54685,bool),fun(fun(Q54685,bool),fun(Q54685,bool))),union),s(fun(Q54685,bool),S0))),s(fun(Q54685,bool),T0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(Q54685,bool),num),card),s(fun(Q54685,bool),S0))))),s(num,i(s(fun(fun(Q54685,bool),num),card),s(fun(Q54685,bool),T0))))))),s(num,i(s(fun(fun(Q54685,bool),num),card),s(fun(Q54685,bool),i(s(fun(fun(Q54685,bool),fun(Q54685,bool)),i(s(fun(fun(Q54685,bool),fun(fun(Q54685,bool),fun(Q54685,bool))),inter),s(fun(Q54685,bool),S0))),s(fun(Q54685,bool),T0))))))) ) ).

fof(aCARDu_UNIONu_OVERLAPu_EQ,axiom,
    ! [Q54766,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q54766,bool),bool),finite),s(fun(Q54766,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q54766,bool),bool),finite),s(fun(Q54766,bool),T0)))) )
     => ( s(num,i(s(fun(fun(Q54766,bool),num),card),s(fun(Q54766,bool),i(s(fun(fun(Q54766,bool),fun(Q54766,bool)),i(s(fun(fun(Q54766,bool),fun(fun(Q54766,bool),fun(Q54766,bool))),union),s(fun(Q54766,bool),S0))),s(fun(Q54766,bool),T0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(Q54766,bool),num),card),s(fun(Q54766,bool),S0))))),s(num,i(s(fun(fun(Q54766,bool),num),card),s(fun(Q54766,bool),T0)))))
      <=> s(fun(Q54766,bool),i(s(fun(fun(Q54766,bool),fun(Q54766,bool)),i(s(fun(fun(Q54766,bool),fun(fun(Q54766,bool),fun(Q54766,bool))),inter),s(fun(Q54766,bool),S0))),s(fun(Q54766,bool),T0))) = s(fun(Q54766,bool),empty) ) ) ).

fof(aCARDu_UNIONu_OVERLAP,axiom,
    ! [Q54808,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q54808,bool),bool),finite),s(fun(Q54808,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q54808,bool),bool),finite),s(fun(Q54808,bool),T0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,i(s(fun(fun(Q54808,bool),num),card),s(fun(Q54808,bool),i(s(fun(fun(Q54808,bool),fun(Q54808,bool)),i(s(fun(fun(Q54808,bool),fun(fun(Q54808,bool),fun(Q54808,bool))),union),s(fun(Q54808,bool),S0))),s(fun(Q54808,bool),T0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,i(s(fun(fun(Q54808,bool),num),card),s(fun(Q54808,bool),S0))))),s(num,i(s(fun(fun(Q54808,bool),num),card),s(fun(Q54808,bool),T0)))))))) )
     => s(fun(Q54808,bool),i(s(fun(fun(Q54808,bool),fun(Q54808,bool)),i(s(fun(fun(Q54808,bool),fun(fun(Q54808,bool),fun(Q54808,bool))),inter),s(fun(Q54808,bool),S0))),s(fun(Q54808,bool),T0))) != s(fun(Q54808,bool),empty) ) ).

fof(aCARDu_IMAGEu_INJ,axiom,
    ! [B,A,F0,S0] :
      ( ( ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) )
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0)))) )
     => s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))) = s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) ) ).

fof(aHASu_SIZEu_IMAGEu_INJ,axiom,
    ! [B,A,F0,S0,N0] :
      ( ( ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) )
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))),s(num,N0)))) ) ).

fof(aCARDu_IMAGEu_LE,axiom,
    ! [B,A,F0,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0)))))) ) ).

fof(aCARDu_IMAGEu_INJu_EQ,axiom,
    ! [B,A,F0,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) )
        & ! [Y] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
           => ( ? [X] :
                  ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) )
              & ! [X,XI_] :
                  ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                    & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y)
                    & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,XI_))),s(fun(A,bool),S0))))
                    & s(B,i(s(fun(A,B),F0),s(A,XI_))) = s(B,Y) )
                 => s(A,X) = s(A,XI_) ) ) ) )
     => s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0))) = s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) ) ).

fof(aCARDu_SUBSETu_IMAGE,axiom,
    ! [Q55049,Q55042,F0,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q55042,bool),bool),finite),s(fun(Q55042,bool),T0))))
        & p(s(bool,i(s(fun(fun(Q55049,bool),bool),i(s(fun(fun(Q55049,bool),fun(fun(Q55049,bool),bool)),subset),s(fun(Q55049,bool),S0))),s(fun(Q55049,bool),i(s(fun(fun(Q55042,bool),fun(Q55049,bool)),i(s(fun(fun(Q55042,Q55049),fun(fun(Q55042,bool),fun(Q55049,bool))),image),s(fun(Q55042,Q55049),F0))),s(fun(Q55042,bool),T0)))))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(Q55049,bool),num),card),s(fun(Q55049,bool),S0))))),s(num,i(s(fun(fun(Q55042,bool),num),card),s(fun(Q55042,bool),T0)))))) ) ).

fof(aHASu_SIZEu_IMAGEu_INJu_EQ,axiom,
    ! [Q55109,Q55114,F0,S0,N0] :
      ( ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(Q55114,bool),bool),i(s(fun(Q55114,fun(fun(Q55114,bool),bool)),in),s(Q55114,X))),s(fun(Q55114,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q55114,bool),bool),i(s(fun(Q55114,fun(fun(Q55114,bool),bool)),in),s(Q55114,Y))),s(fun(Q55114,bool),S0))))
            & s(Q55109,i(s(fun(Q55114,Q55109),F0),s(Q55114,X))) = s(Q55109,i(s(fun(Q55114,Q55109),F0),s(Q55114,Y))) )
         => s(Q55114,X) = s(Q55114,Y) )
     => s(bool,i(s(fun(num,bool),i(s(fun(fun(Q55109,bool),fun(num,bool)),hasu_size),s(fun(Q55109,bool),i(s(fun(fun(Q55114,bool),fun(Q55109,bool)),i(s(fun(fun(Q55114,Q55109),fun(fun(Q55114,bool),fun(Q55109,bool))),image),s(fun(Q55114,Q55109),F0))),s(fun(Q55114,bool),S0))))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(fun(Q55114,bool),fun(num,bool)),hasu_size),s(fun(Q55114,bool),S0))),s(num,N0))) ) ).

fof(aCARDu_IMAGEu_EQu_INJ,axiom,
    ! [B,A,F0,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => ( s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))) = s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0)))
      <=> ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) ) ) ) ).

fof(aCHOOSEu_SUBSETu_STRONG,axiom,
    ! [A,N0,S0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
       => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0)))))) )
     => ? [T0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),T0))),s(num,N0)))) ) ) ).

fof(aCHOOSEu_SUBSET,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => ! [N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))))
         => ? [T0] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),T0))),s(num,N0)))) ) ) ) ).

fof(aCHOOSEu_SUBSETu_BETWEEN,axiom,
    ! [A,N0,S0,U] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),U))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,N0))))
        & ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),U))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,N0))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),U)))))) ) )
     => ? [T0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))
          & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),U))))
          & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),T0))),s(num,N0)))) ) ) ).

fof(aHASu_SIZEu_PRODUCTu_DEPENDENT,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_79] :
          ( p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(fun(A,fun(B,bool)),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))),s(prod(A,B),GENR_PVARR_79))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X)))))) ) )
              & p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(bool,fun(prod(A,B),bool)),i(s(fun(prod(A,B),fun(bool,fun(prod(A,B),bool))),setspec),s(prod(A,B),GENR_PVARR_79))),s(bool,V))),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y)))))) ) )
     => ! [S0,M0,T0,N0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,M0))))
            & ! [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
               => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X))))),s(num,N0)))) ) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(prod(A,B),bool),fun(num,bool)),hasu_size),s(fun(prod(A,B),bool),i(s(fun(fun(prod(A,B),bool),fun(prod(A,B),bool)),gspec),s(fun(prod(A,B),bool),i(s(fun(fun(A,fun(B,bool)),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))) ) ) ).

fof(aFINITEu_PRODUCTu_DEPENDENT,axiom,
    ! [A,B,C,U_0] :
      ( ! [S0,T0,F0,GENR_PVARR_84] :
          ( p(s(bool,i(s(fun(C,bool),i(s(fun(fun(A,fun(B,C)),fun(C,bool)),i(s(fun(fun(A,fun(B,bool)),fun(fun(A,fun(B,C)),fun(C,bool))),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(A,fun(B,C)),fun(C,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))),s(fun(A,fun(B,C)),F0))),s(C,GENR_PVARR_84))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X)))))) ) )
              & p(s(bool,i(s(fun(C,bool),i(s(fun(bool,fun(C,bool)),i(s(fun(C,fun(bool,fun(C,bool))),setspec),s(C,GENR_PVARR_84))),s(bool,V))),s(C,i(s(fun(B,C),i(s(fun(A,fun(B,C)),F0),s(A,X))),s(B,Y)))))) ) )
     => ! [F0,S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
            & ! [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
               => p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),i(s(fun(A,fun(B,bool)),T0),s(A,X)))))) ) )
         => p(s(bool,i(s(fun(fun(C,bool),bool),finite),s(fun(C,bool),i(s(fun(fun(C,bool),fun(C,bool)),gspec),s(fun(C,bool),i(s(fun(fun(A,fun(B,C)),fun(C,bool)),i(s(fun(fun(A,fun(B,bool)),fun(fun(A,fun(B,C)),fun(C,bool))),i(s(fun(fun(A,bool),fun(fun(A,fun(B,bool)),fun(fun(A,fun(B,C)),fun(C,bool)))),U_0),s(fun(A,bool),S0))),s(fun(A,fun(B,bool)),T0))),s(fun(A,fun(B,C)),F0)))))))) ) ) ).

fof(aFINITEu_PRODUCT,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_85] :
          ( p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0))),s(prod(A,B),GENR_PVARR_85))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0)))) ) )
              & p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(bool,fun(prod(A,B),bool)),i(s(fun(prod(A,B),fun(bool,fun(prod(A,B),bool))),setspec),s(prod(A,B),GENR_PVARR_85))),s(bool,V))),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y)))))) ) )
     => ! [S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
            & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0)))) )
         => p(s(bool,i(s(fun(fun(prod(A,B),bool),bool),finite),s(fun(prod(A,B),bool),i(s(fun(fun(prod(A,B),bool),fun(prod(A,B),bool)),gspec),s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0)))))))) ) ) ).

fof(aCARDu_PRODUCT,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_86] :
          ( p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0))),s(prod(A,B),GENR_PVARR_86))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0)))) ) )
              & p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(bool,fun(prod(A,B),bool)),i(s(fun(prod(A,B),fun(bool,fun(prod(A,B),bool))),setspec),s(prod(A,B),GENR_PVARR_86))),s(bool,V))),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y)))))) ) )
     => ! [S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
            & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0)))) )
         => s(num,i(s(fun(fun(prod(A,B),bool),num),card),s(fun(prod(A,B),bool),i(s(fun(fun(prod(A,B),bool),fun(prod(A,B),bool)),gspec),s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0))))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0))))) ) ) ).

fof(aHASu_SIZEu_PRODUCT,axiom,
    ! [A,B,U_0] :
      ( ! [S0,T0,GENR_PVARR_87] :
          ( p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0))),s(prod(A,B),GENR_PVARR_87))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0)))) ) )
              & p(s(bool,i(s(fun(prod(A,B),bool),i(s(fun(bool,fun(prod(A,B),bool)),i(s(fun(prod(A,B),fun(bool,fun(prod(A,B),bool))),setspec),s(prod(A,B),GENR_PVARR_87))),s(bool,V))),s(prod(A,B),i(s(fun(B,prod(A,B)),i(s(fun(A,fun(B,prod(A,B))),c_),s(A,X))),s(B,Y)))))) ) )
     => ! [S0,M0,T0,N0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),T0))),s(num,N0)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(prod(A,B),bool),fun(num,bool)),hasu_size),s(fun(prod(A,B),bool),i(s(fun(fun(prod(A,B),bool),fun(prod(A,B),bool)),gspec),s(fun(prod(A,B),bool),i(s(fun(fun(B,bool),fun(prod(A,B),bool)),i(s(fun(fun(A,bool),fun(fun(B,bool),fun(prod(A,B),bool))),U_0),s(fun(A,bool),S0))),s(fun(B,bool),T0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))) ) ) ).

fof(aCROSS,axiom,
    ! [Q56069,Q56068,U_0] :
      ( ! [S0,T0,GENR_PVARR_88] :
          ( p(s(bool,i(s(fun(prod(Q56069,Q56068),bool),i(s(fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool)),i(s(fun(fun(Q56069,bool),fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool))),U_0),s(fun(Q56069,bool),S0))),s(fun(Q56068,bool),T0))),s(prod(Q56069,Q56068),GENR_PVARR_88))))
        <=> ? [X,Y,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(fun(Q56069,bool),bool),i(s(fun(Q56069,fun(fun(Q56069,bool),bool)),in),s(Q56069,X))),s(fun(Q56069,bool),S0))))
                  & p(s(bool,i(s(fun(fun(Q56068,bool),bool),i(s(fun(Q56068,fun(fun(Q56068,bool),bool)),in),s(Q56068,Y))),s(fun(Q56068,bool),T0)))) ) )
              & p(s(bool,i(s(fun(prod(Q56069,Q56068),bool),i(s(fun(bool,fun(prod(Q56069,Q56068),bool)),i(s(fun(prod(Q56069,Q56068),fun(bool,fun(prod(Q56069,Q56068),bool))),setspec),s(prod(Q56069,Q56068),GENR_PVARR_88))),s(bool,V))),s(prod(Q56069,Q56068),i(s(fun(Q56068,prod(Q56069,Q56068)),i(s(fun(Q56069,fun(Q56068,prod(Q56069,Q56068))),c_),s(Q56069,X))),s(Q56068,Y)))))) ) )
     => ! [S0,T0] : s(fun(prod(Q56069,Q56068),bool),i(s(fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool)),i(s(fun(fun(Q56069,bool),fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool))),cross0),s(fun(Q56069,bool),S0))),s(fun(Q56068,bool),T0))) = s(fun(prod(Q56069,Q56068),bool),i(s(fun(fun(prod(Q56069,Q56068),bool),fun(prod(Q56069,Q56068),bool)),gspec),s(fun(prod(Q56069,Q56068),bool),i(s(fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool)),i(s(fun(fun(Q56069,bool),fun(fun(Q56068,bool),fun(prod(Q56069,Q56068),bool))),U_0),s(fun(Q56069,bool),S0))),s(fun(Q56068,bool),T0))))) ) ).

fof(aINu_CROSS,axiom,
    ! [Q56105,Q56108,X,Y,S0,T0] :
      ( p(s(bool,i(s(fun(fun(prod(Q56105,Q56108),bool),bool),i(s(fun(prod(Q56105,Q56108),fun(fun(prod(Q56105,Q56108),bool),bool)),in),s(prod(Q56105,Q56108),i(s(fun(Q56108,prod(Q56105,Q56108)),i(s(fun(Q56105,fun(Q56108,prod(Q56105,Q56108))),c_),s(Q56105,X))),s(Q56108,Y))))),s(fun(prod(Q56105,Q56108),bool),i(s(fun(fun(Q56108,bool),fun(prod(Q56105,Q56108),bool)),i(s(fun(fun(Q56105,bool),fun(fun(Q56108,bool),fun(prod(Q56105,Q56108),bool))),cross0),s(fun(Q56105,bool),S0))),s(fun(Q56108,bool),T0))))))
    <=> ( p(s(bool,i(s(fun(fun(Q56105,bool),bool),i(s(fun(Q56105,fun(fun(Q56105,bool),bool)),in),s(Q56105,X))),s(fun(Q56105,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q56108,bool),bool),i(s(fun(Q56108,fun(fun(Q56108,bool),bool)),in),s(Q56108,Y))),s(fun(Q56108,bool),T0)))) ) ) ).

fof(aHASu_SIZEu_CROSS,axiom,
    ! [Q56133,Q56136,S0,T0,M0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q56133,bool),fun(num,bool)),hasu_size),s(fun(Q56133,bool),S0))),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(Q56136,bool),fun(num,bool)),hasu_size),s(fun(Q56136,bool),T0))),s(num,N0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(prod(Q56133,Q56136),bool),fun(num,bool)),hasu_size),s(fun(prod(Q56133,Q56136),bool),i(s(fun(fun(Q56136,bool),fun(prod(Q56133,Q56136),bool)),i(s(fun(fun(Q56133,bool),fun(fun(Q56136,bool),fun(prod(Q56133,Q56136),bool))),cross0),s(fun(Q56133,bool),S0))),s(fun(Q56136,bool),T0))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,M0))),s(num,N0)))))) ) ).

fof(aFINITEu_CROSS,axiom,
    ! [Q56161,Q56163,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q56161,bool),bool),finite),s(fun(Q56161,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q56163,bool),bool),finite),s(fun(Q56163,bool),T0)))) )
     => p(s(bool,i(s(fun(fun(prod(Q56161,Q56163),bool),bool),finite),s(fun(prod(Q56161,Q56163),bool),i(s(fun(fun(Q56163,bool),fun(prod(Q56161,Q56163),bool)),i(s(fun(fun(Q56161,bool),fun(fun(Q56163,bool),fun(prod(Q56161,Q56163),bool))),cross0),s(fun(Q56161,bool),S0))),s(fun(Q56163,bool),T0)))))) ) ).

fof(aCARDu_CROSS,axiom,
    ! [Q56184,Q56186,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q56184,bool),bool),finite),s(fun(Q56184,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q56186,bool),bool),finite),s(fun(Q56186,bool),T0)))) )
     => s(num,i(s(fun(fun(prod(Q56184,Q56186),bool),num),card),s(fun(prod(Q56184,Q56186),bool),i(s(fun(fun(Q56186,bool),fun(prod(Q56184,Q56186),bool)),i(s(fun(fun(Q56184,bool),fun(fun(Q56186,bool),fun(prod(Q56184,Q56186),bool))),cross0),s(fun(Q56184,bool),S0))),s(fun(Q56186,bool),T0))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),t_),s(num,i(s(fun(fun(Q56184,bool),num),card),s(fun(Q56184,bool),S0))))),s(num,i(s(fun(fun(Q56186,bool),num),card),s(fun(Q56186,bool),T0))))) ) ).

fof(aCROSSu_EQu_EMPTY,axiom,
    ! [Q56227,Q56231,S0,T0] :
      ( s(fun(prod(Q56227,Q56231),bool),i(s(fun(fun(Q56231,bool),fun(prod(Q56227,Q56231),bool)),i(s(fun(fun(Q56227,bool),fun(fun(Q56231,bool),fun(prod(Q56227,Q56231),bool))),cross0),s(fun(Q56227,bool),S0))),s(fun(Q56231,bool),T0))) = s(fun(prod(Q56227,Q56231),bool),empty)
    <=> ( s(fun(Q56227,bool),S0) = s(fun(Q56227,bool),empty)
        | s(fun(Q56231,bool),T0) = s(fun(Q56231,bool),empty) ) ) ).

fof(aHASu_SIZEu_FUNSPACE,axiom,
    ! [A,B,U_0] :
      ( ! [T0,S0,D0,GENR_PVARR_92] :
          ( p(s(bool,i(s(fun(fun(A,B),bool),i(s(fun(B,fun(fun(A,B),bool)),i(s(fun(fun(A,bool),fun(B,fun(fun(A,B),bool))),i(s(fun(fun(B,bool),fun(fun(A,bool),fun(B,fun(fun(A,B),bool)))),U_0),s(fun(B,bool),T0))),s(fun(A,bool),S0))),s(B,D0))),s(fun(A,B),GENR_PVARR_92))))
        <=> ? [F0,V] :
              ( ( p(s(bool,V))
              <=> ( ! [X] :
                      ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                     => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) )
                  & ! [X] :
                      ( ~ p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                     => s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,D0) ) ) )
              & p(s(bool,i(s(fun(fun(A,B),bool),i(s(fun(bool,fun(fun(A,B),bool)),i(s(fun(fun(A,B),fun(bool,fun(fun(A,B),bool))),setspec),s(fun(A,B),GENR_PVARR_92))),s(bool,V))),s(fun(A,B),F0)))) ) )
     => ! [D0,N0,T0,M0,S0] :
          ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,M0))))
            & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),T0))),s(num,N0)))) )
         => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(fun(A,B),bool),fun(num,bool)),hasu_size),s(fun(fun(A,B),bool),i(s(fun(fun(fun(A,B),bool),fun(fun(A,B),bool)),gspec),s(fun(fun(A,B),bool),i(s(fun(B,fun(fun(A,B),bool)),i(s(fun(fun(A,bool),fun(B,fun(fun(A,B),bool))),i(s(fun(fun(B,bool),fun(fun(A,bool),fun(B,fun(fun(A,B),bool)))),U_0),s(fun(B,bool),T0))),s(fun(A,bool),S0))),s(B,D0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,N0))),s(num,M0)))))) ) ) ).

fof(aCARDu_FUNSPACE,axiom,
    ! [Q56534,Q56537,U_0] :
      ( ! [T0,S0,GENR_PVARR_93] :
          ( p(s(bool,i(s(fun(fun(Q56537,Q56534),bool),i(s(fun(fun(Q56537,bool),fun(fun(Q56537,Q56534),bool)),i(s(fun(fun(Q56534,bool),fun(fun(Q56537,bool),fun(fun(Q56537,Q56534),bool))),U_0),s(fun(Q56534,bool),T0))),s(fun(Q56537,bool),S0))),s(fun(Q56537,Q56534),GENR_PVARR_93))))
        <=> ? [F0,V] :
              ( ( p(s(bool,V))
              <=> ( ! [X] :
                      ( p(s(bool,i(s(fun(fun(Q56537,bool),bool),i(s(fun(Q56537,fun(fun(Q56537,bool),bool)),in),s(Q56537,X))),s(fun(Q56537,bool),S0))))
                     => p(s(bool,i(s(fun(fun(Q56534,bool),bool),i(s(fun(Q56534,fun(fun(Q56534,bool),bool)),in),s(Q56534,i(s(fun(Q56537,Q56534),F0),s(Q56537,X))))),s(fun(Q56534,bool),T0)))) )
                  & ! [X] :
                      ( ~ p(s(bool,i(s(fun(fun(Q56537,bool),bool),i(s(fun(Q56537,fun(fun(Q56537,bool),bool)),in),s(Q56537,X))),s(fun(Q56537,bool),S0))))
                     => s(Q56534,i(s(fun(Q56537,Q56534),F0),s(Q56537,X))) = s(Q56534,d) ) ) )
              & p(s(bool,i(s(fun(fun(Q56537,Q56534),bool),i(s(fun(bool,fun(fun(Q56537,Q56534),bool)),i(s(fun(fun(Q56537,Q56534),fun(bool,fun(fun(Q56537,Q56534),bool))),setspec),s(fun(Q56537,Q56534),GENR_PVARR_93))),s(bool,V))),s(fun(Q56537,Q56534),F0)))) ) )
     => ! [S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(Q56537,bool),bool),finite),s(fun(Q56537,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q56534,bool),bool),finite),s(fun(Q56534,bool),T0)))) )
         => s(num,i(s(fun(fun(fun(Q56537,Q56534),bool),num),card),s(fun(fun(Q56537,Q56534),bool),i(s(fun(fun(fun(Q56537,Q56534),bool),fun(fun(Q56537,Q56534),bool)),gspec),s(fun(fun(Q56537,Q56534),bool),i(s(fun(fun(Q56537,bool),fun(fun(Q56537,Q56534),bool)),i(s(fun(fun(Q56534,bool),fun(fun(Q56537,bool),fun(fun(Q56537,Q56534),bool))),U_0),s(fun(Q56534,bool),T0))),s(fun(Q56537,bool),S0))))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(fun(Q56534,bool),num),card),s(fun(Q56534,bool),T0))))),s(num,i(s(fun(fun(Q56537,bool),num),card),s(fun(Q56537,bool),S0))))) ) ) ).

fof(aFINITEu_FUNSPACE,axiom,
    ! [Q56600,Q56603,U_0] :
      ( ! [T0,S0,GENR_PVARR_94] :
          ( p(s(bool,i(s(fun(fun(Q56603,Q56600),bool),i(s(fun(fun(Q56603,bool),fun(fun(Q56603,Q56600),bool)),i(s(fun(fun(Q56600,bool),fun(fun(Q56603,bool),fun(fun(Q56603,Q56600),bool))),U_0),s(fun(Q56600,bool),T0))),s(fun(Q56603,bool),S0))),s(fun(Q56603,Q56600),GENR_PVARR_94))))
        <=> ? [F0,V] :
              ( ( p(s(bool,V))
              <=> ( ! [X] :
                      ( p(s(bool,i(s(fun(fun(Q56603,bool),bool),i(s(fun(Q56603,fun(fun(Q56603,bool),bool)),in),s(Q56603,X))),s(fun(Q56603,bool),S0))))
                     => p(s(bool,i(s(fun(fun(Q56600,bool),bool),i(s(fun(Q56600,fun(fun(Q56600,bool),bool)),in),s(Q56600,i(s(fun(Q56603,Q56600),F0),s(Q56603,X))))),s(fun(Q56600,bool),T0)))) )
                  & ! [X] :
                      ( ~ p(s(bool,i(s(fun(fun(Q56603,bool),bool),i(s(fun(Q56603,fun(fun(Q56603,bool),bool)),in),s(Q56603,X))),s(fun(Q56603,bool),S0))))
                     => s(Q56600,i(s(fun(Q56603,Q56600),F0),s(Q56603,X))) = s(Q56600,d) ) ) )
              & p(s(bool,i(s(fun(fun(Q56603,Q56600),bool),i(s(fun(bool,fun(fun(Q56603,Q56600),bool)),i(s(fun(fun(Q56603,Q56600),fun(bool,fun(fun(Q56603,Q56600),bool))),setspec),s(fun(Q56603,Q56600),GENR_PVARR_94))),s(bool,V))),s(fun(Q56603,Q56600),F0)))) ) )
     => ! [S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(Q56603,bool),bool),finite),s(fun(Q56603,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q56600,bool),bool),finite),s(fun(Q56600,bool),T0)))) )
         => p(s(bool,i(s(fun(fun(fun(Q56603,Q56600),bool),bool),finite),s(fun(fun(Q56603,Q56600),bool),i(s(fun(fun(fun(Q56603,Q56600),bool),fun(fun(Q56603,Q56600),bool)),gspec),s(fun(fun(Q56603,Q56600),bool),i(s(fun(fun(Q56603,bool),fun(fun(Q56603,Q56600),bool)),i(s(fun(fun(Q56600,bool),fun(fun(Q56603,bool),fun(fun(Q56603,Q56600),bool))),U_0),s(fun(Q56600,bool),T0))),s(fun(Q56603,bool),S0)))))))) ) ) ).

fof(aHASu_SIZEu_FUNSPACEu_UNIV,axiom,
    ! [A,B,M0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),univ))),s(num,M0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),univ))),s(num,N0)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(fun(A,B),bool),fun(num,bool)),hasu_size),s(fun(fun(A,B),bool),univ))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,N0))),s(num,M0)))))) ) ).

fof(aCARDu_FUNSPACEu_UNIV,axiom,
    ! [B,A] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),univ))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),univ)))) )
     => s(num,i(s(fun(fun(fun(A,B),bool),num),card),s(fun(fun(A,B),bool),univ))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),univ))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),univ))))) ) ).

fof(aFINITEu_FUNSPACEu_UNIV,axiom,
    ! [A,B] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),univ))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),univ)))) )
     => p(s(bool,i(s(fun(fun(fun(A,B),bool),bool),finite),s(fun(fun(A,B),bool),univ)))) ) ).

fof(aHASu_SIZEu_BOOL,axiom,
    p(s(bool,i(s(fun(num,bool),i(s(fun(fun(bool,bool),fun(num,bool)),hasu_size),s(fun(bool,bool),univ))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ).

fof(aCARDu_BOOL,axiom,
    s(num,i(s(fun(fun(bool,bool),num),card),s(fun(bool,bool),univ))) = s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ).

fof(aFINITEu_BOOL,axiom,
    p(s(bool,i(s(fun(fun(bool,bool),bool),finite),s(fun(bool,bool),univ)))) ).

fof(aHASu_SIZEu_POWERSET,axiom,
    ! [A,U_0] :
      ( ! [S0,GENR_PVARR_97] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0))),s(fun(A,bool),GENR_PVARR_97))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(bool,fun(fun(A,bool),bool)),i(s(fun(fun(A,bool),fun(bool,fun(fun(A,bool),bool))),setspec),s(fun(A,bool),GENR_PVARR_97))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))),s(fun(A,bool),T0)))) )
     => ! [S0,N0] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,N0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(fun(A,bool),bool),fun(num,bool)),hasu_size),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0)))))) ) ) ).

fof(aCARDu_POWERSET,axiom,
    ! [A,U_0] :
      ( ! [S0,GENR_PVARR_98] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0))),s(fun(A,bool),GENR_PVARR_98))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(bool,fun(fun(A,bool),bool)),i(s(fun(fun(A,bool),fun(bool,fun(fun(A,bool),bool))),setspec),s(fun(A,bool),GENR_PVARR_98))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))),s(fun(A,bool),T0)))) )
     => ! [S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => s(num,i(s(fun(fun(fun(A,bool),bool),num),card),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0))))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),exp0),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit0),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))) ) ) ).

fof(aFINITEu_POWERSET,axiom,
    ! [A,U_0] :
      ( ! [S0,GENR_PVARR_99] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0))),s(fun(A,bool),GENR_PVARR_99))))
        <=> ? [T0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(bool,fun(fun(A,bool),bool)),i(s(fun(fun(A,bool),fun(bool,fun(fun(A,bool),bool))),setspec),s(fun(A,bool),GENR_PVARR_99))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),S0))))),s(fun(A,bool),T0)))) )
     => ! [S0] :
          ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
         => p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),finite),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_0),s(fun(A,bool),S0)))))))) ) ) ).

fof(aFINITEu_UNIONS,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(fun(A,bool),bool),fun(A,bool)),unions),s(fun(fun(A,bool),bool),S0))))))
    <=> ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),finite),s(fun(fun(A,bool),bool),S0))))
        & ! [T0] :
            ( p(s(bool,i(s(fun(fun(fun(A,bool),bool),bool),i(s(fun(fun(A,bool),fun(fun(fun(A,bool),bool),bool)),in),s(fun(A,bool),T0))),s(fun(fun(A,bool),bool),S0))))
           => p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),T0)))) ) ) ) ).

fof(aPOWERSETu_CLAUSESu_conjunct0,axiom,
    ! [Q56919,U_0] :
      ( ! [GENR_PVARR_100] :
          ( p(s(bool,i(s(fun(fun(Q56919,bool),bool),U_0),s(fun(Q56919,bool),GENR_PVARR_100))))
        <=> ? [S0] : p(s(bool,i(s(fun(fun(Q56919,bool),bool),i(s(fun(bool,fun(fun(Q56919,bool),bool)),i(s(fun(fun(Q56919,bool),fun(bool,fun(fun(Q56919,bool),bool))),setspec),s(fun(Q56919,bool),GENR_PVARR_100))),s(bool,i(s(fun(fun(Q56919,bool),bool),i(s(fun(fun(Q56919,bool),fun(fun(Q56919,bool),bool)),subset),s(fun(Q56919,bool),S0))),s(fun(Q56919,bool),empty))))),s(fun(Q56919,bool),S0)))) )
     => s(fun(fun(Q56919,bool),bool),i(s(fun(fun(fun(Q56919,bool),bool),fun(fun(Q56919,bool),bool)),gspec),s(fun(fun(Q56919,bool),bool),U_0))) = s(fun(fun(Q56919,bool),bool),i(s(fun(fun(fun(Q56919,bool),bool),fun(fun(Q56919,bool),bool)),i(s(fun(fun(Q56919,bool),fun(fun(fun(Q56919,bool),bool),fun(fun(Q56919,bool),bool))),insert),s(fun(Q56919,bool),empty))),s(fun(fun(Q56919,bool),bool),empty))) ) ).

fof(aPOWERSETu_CLAUSESu_conjunct1,axiom,
    ! [A,U_2] :
      ( ! [A5,S0] : s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),U_2),s(A,A5))),s(fun(A,bool),S0))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,A5))),s(fun(A,bool),S0)))
     => ! [U_1] :
          ( ! [T0,GENR_PVARR_102] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_1),s(fun(A,bool),T0))),s(fun(A,bool),GENR_PVARR_102))))
            <=> ? [S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(bool,fun(fun(A,bool),bool)),i(s(fun(fun(A,bool),fun(bool,fun(fun(A,bool),bool))),setspec),s(fun(A,bool),GENR_PVARR_102))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),T0))))),s(fun(A,bool),S0)))) )
         => ! [U_0] :
              ( ! [A5,T0,GENR_PVARR_101] :
                  ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),i(s(fun(A,fun(fun(A,bool),fun(fun(A,bool),bool))),U_0),s(A,A5))),s(fun(A,bool),T0))),s(fun(A,bool),GENR_PVARR_101))))
                <=> ? [S0] : p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(bool,fun(fun(A,bool),bool)),i(s(fun(fun(A,bool),fun(bool,fun(fun(A,bool),bool))),setspec),s(fun(A,bool),GENR_PVARR_101))),s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,A5))),s(fun(A,bool),T0))))))),s(fun(A,bool),S0)))) )
             => ! [A5,T0] : s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),i(s(fun(A,fun(fun(A,bool),fun(fun(A,bool),bool))),U_0),s(A,A5))),s(fun(A,bool),T0))))) = s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),i(s(fun(fun(fun(A,bool),bool),fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool))),union),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_1),s(fun(A,bool),T0))))))),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),i(s(fun(fun(fun(A,bool),fun(A,bool)),fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool))),image),s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),U_2),s(A,A5))))),s(fun(fun(A,bool),bool),i(s(fun(fun(fun(A,bool),bool),fun(fun(A,bool),bool)),gspec),s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),U_1),s(fun(A,bool),T0))))))))) ) ) ) ).

fof(aHASu_SIZEu_NUMSEGu_LT,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_107] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_107))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_107))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),hasu_size),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))))))),s(num,N0)))) ) ).

fof(aCARDu_NUMSEGu_LT,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_108] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_108))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_108))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : s(num,i(s(fun(fun(num,bool),num),card),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))))))) = s(num,N0) ) ).

fof(aFINITEu_NUMSEGu_LT,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_109] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_109))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_109))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0)))))))) ) ).

fof(aHASu_SIZEu_NUMSEGu_LE,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_110] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_110))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_110))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : p(s(bool,i(s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),hasu_size),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))))))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) ) ).

fof(aFINITEu_NUMSEGu_LE,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_111] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_111))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_111))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0)))))))) ) ).

fof(aCARDu_NUMSEGu_LE,axiom,
    ! [U_0] :
      ( ! [N0,GENR_PVARR_112] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))),s(num,GENR_PVARR_112))))
        <=> ? [M0] : p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_112))),s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,N0))))),s(num,M0)))) )
     => ! [N0] : s(num,i(s(fun(fun(num,bool),num),card),s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),U_0),s(num,N0))))))) = s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))) ) ).

fof(anumu_FINITE,axiom,
    ! [S0] :
      ( p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),S0))))
    <=> ? [A5] :
        ! [X] :
          ( p(s(bool,i(s(fun(fun(num,bool),bool),i(s(fun(num,fun(fun(num,bool),bool)),in),s(num,X))),s(fun(num,bool),S0))))
         => p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,A5)))) ) ) ).

fof(anumu_FINITEu_AVOID,axiom,
    ! [S0] :
      ( p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),S0))))
     => ? [A5] : ~ p(s(bool,i(s(fun(fun(num,bool),bool),i(s(fun(num,fun(fun(num,bool),bool)),in),s(num,A5))),s(fun(num,bool),S0)))) ) ).

fof(aMiscu_defsu_andu_lemmaso_numu_infinite,axiom,
    ~ p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),univ)))) ).

fof(anumu_INFINITE,axiom,
    p(s(bool,i(s(fun(fun(num,bool),bool),infinite),s(fun(num,bool),univ)))) ).

fof(astringu_INFINITE,axiom,
    p(s(bool,i(s(fun(fun(list(char),bool),bool),infinite),s(fun(list(char),bool),univ)))) ).

fof(aFINITEu_REALu_INTERVALu_conjunct0,axiom,
    ! [U_0] :
      ( ! [A5,GENR_PVARR_122] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,A5))),s(real,GENR_PVARR_122))))
        <=> ? [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_122))),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,X))))),s(real,X)))) )
     => ! [A5] : ~ p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,A5)))))))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct1,axiom,
    ! [U_0] :
      ( ! [A5,GENR_PVARR_123] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,A5))),s(real,GENR_PVARR_123))))
        <=> ? [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_123))),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X))))),s(real,X)))) )
     => ! [A5] : ~ p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,A5)))))))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct2,axiom,
    ! [U_0] :
      ( ! [B0,GENR_PVARR_124] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,B0))),s(real,GENR_PVARR_124))))
        <=> ? [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_124))),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,B0))))),s(real,X)))) )
     => ! [B0] : ~ p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,B0)))))))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct3,axiom,
    ! [U_0] :
      ( ! [B0,GENR_PVARR_125] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,B0))),s(real,GENR_PVARR_125))))
        <=> ? [X] : p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_125))),s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0))))),s(real,X)))) )
     => ! [B0] : ~ p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),U_0),s(real,B0)))))))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct4,axiom,
    ! [U_0] :
      ( ! [A5,B0,GENR_PVARR_126] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))),s(real,GENR_PVARR_126))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,X))))
                  & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,B0)))) ) )
              & p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_126))),s(bool,V))),s(real,X)))) ) )
     => ! [A5,B0] : s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,A5))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct5,axiom,
    ! [U_0] :
      ( ! [A5,B0,GENR_PVARR_127] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))),s(real,GENR_PVARR_127))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X))))
                  & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,B0)))) ) )
              & p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_127))),s(bool,V))),s(real,X)))) ) )
     => ! [A5,B0] : s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,A5))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct6,axiom,
    ! [U_0] :
      ( ! [A5,B0,GENR_PVARR_128] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))),s(real,GENR_PVARR_128))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,X))))
                  & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
              & p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_128))),s(bool,V))),s(real,X)))) ) )
     => ! [A5,B0] : s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,A5))) ) ).

fof(aFINITEu_REALu_INTERVALu_conjunct7,axiom,
    ! [U_0] :
      ( ! [A5,B0,GENR_PVARR_129] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))),s(real,GENR_PVARR_129))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X))))
                  & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
              & p(s(bool,i(s(fun(real,bool),i(s(fun(bool,fun(real,bool)),i(s(fun(real,fun(bool,fun(real,bool))),setspec),s(real,GENR_PVARR_129))),s(bool,V))),s(real,X)))) ) )
     => ! [A5,B0] : s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),gspec),s(fun(real,bool),i(s(fun(real,fun(real,bool)),i(s(fun(real,fun(real,fun(real,bool))),U_0),s(real,A5))),s(real,B0))))))) = s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,A5))) ) ).

fof(arealu_INFINITE,axiom,
    p(s(bool,i(s(fun(fun(real,bool),bool),infinite),s(fun(real,bool),univ)))) ).

fof(aHASu_SIZEu_INDEX,axiom,
    ! [A,S0,N0] :
      ( p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,N0))))
     => ? [F0] :
          ( ! [M0] :
              ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
             => p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(num,A),F0),s(num,M0))))),s(fun(A,bool),S0)))) )
          & ! [X] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
             => ( ? [M0] :
                    ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
                    & s(A,i(s(fun(num,A),F0),s(num,M0))) = s(A,X) )
                & ! [M0,XI_] :
                    ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,M0))),s(num,N0))))
                      & s(A,i(s(fun(num,A),F0),s(num,M0))) = s(A,X)
                      & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_),s(num,XI_))),s(num,N0))))
                      & s(A,i(s(fun(num,A),F0),s(num,XI_))) = s(A,X) )
                   => s(num,M0) = s(num,XI_) ) ) ) ) ) ).

fof(asetu_ofu_listu_conjunct0,axiom,
    ! [A] : s(fun(A,bool),i(s(fun(list(A),fun(A,bool)),setu_ofu_list),s(list(A),nil))) = s(fun(A,bool),empty) ).

fof(asetu_ofu_listu_conjunct1,axiom,
    ! [A] : s(fun(A,bool),i(s(fun(list(A),fun(A,bool)),setu_ofu_list),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),t0))))) = s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(A,fun(fun(A,bool),fun(A,bool))),insert),s(A,h0))),s(fun(A,bool),i(s(fun(list(A),fun(A,bool)),setu_ofu_list),s(list(A),t0))))) ).

fof(alistu_ofu_set,axiom,
    ! [Q58114,U_0] :
      ( ! [S0,L] :
          ( p(s(bool,i(s(fun(list(Q58114),bool),i(s(fun(fun(Q58114,bool),fun(list(Q58114),bool)),U_0),s(fun(Q58114,bool),S0))),s(list(Q58114),L))))
        <=> ( s(fun(Q58114,bool),i(s(fun(list(Q58114),fun(Q58114,bool)),setu_ofu_list),s(list(Q58114),L))) = s(fun(Q58114,bool),S0)
            & s(num,i(s(fun(list(Q58114),num),length),s(list(Q58114),L))) = s(num,i(s(fun(fun(Q58114,bool),num),card),s(fun(Q58114,bool),S0))) ) )
     => ! [S0] : s(list(Q58114),i(s(fun(fun(Q58114,bool),list(Q58114)),listu_ofu_set),s(fun(Q58114,bool),S0))) = s(list(Q58114),i(s(fun(fun(list(Q58114),bool),list(Q58114)),h_),s(fun(list(Q58114),bool),i(s(fun(fun(Q58114,bool),fun(list(Q58114),bool)),U_0),s(fun(Q58114,bool),S0))))) ) ).

fof(aLISTu_OFu_SETu_PROPERTIES,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => ( s(fun(A,bool),i(s(fun(list(A),fun(A,bool)),setu_ofu_list),s(list(A),i(s(fun(fun(A,bool),list(A)),listu_ofu_set),s(fun(A,bool),S0))))) = s(fun(A,bool),S0)
        & s(num,i(s(fun(list(A),num),length),s(list(A),i(s(fun(fun(A,bool),list(A)),listu_ofu_set),s(fun(A,bool),S0))))) = s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) ) ) ).

fof(aSETu_OFu_LISTu_OFu_SET,axiom,
    ! [Q58163,S0] :
      ( p(s(bool,i(s(fun(fun(Q58163,bool),bool),finite),s(fun(Q58163,bool),S0))))
     => s(fun(Q58163,bool),i(s(fun(list(Q58163),fun(Q58163,bool)),setu_ofu_list),s(list(Q58163),i(s(fun(fun(Q58163,bool),list(Q58163)),listu_ofu_set),s(fun(Q58163,bool),S0))))) = s(fun(Q58163,bool),S0) ) ).

fof(aLENGTHu_LISTu_OFu_SET,axiom,
    ! [Q58179,S0] :
      ( p(s(bool,i(s(fun(fun(Q58179,bool),bool),finite),s(fun(Q58179,bool),S0))))
     => s(num,i(s(fun(list(Q58179),num),length),s(list(Q58179),i(s(fun(fun(Q58179,bool),list(Q58179)),listu_ofu_set),s(fun(Q58179,bool),S0))))) = s(num,i(s(fun(fun(Q58179,bool),num),card),s(fun(Q58179,bool),S0))) ) ).

fof(aMEMu_LISTu_OFu_SET,axiom,
    ! [A,S0] :
      ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
     => ! [X] : s(bool,i(s(fun(list(A),bool),i(s(fun(A,fun(list(A),bool)),mem),s(A,X))),s(list(A),i(s(fun(fun(A,bool),list(A)),listu_ofu_set),s(fun(A,bool),S0))))) = s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))) ) ).

fof(aFINITEu_SETu_OFu_LIST,axiom,
    ! [Q58224,L] : p(s(bool,i(s(fun(fun(Q58224,bool),bool),finite),s(fun(Q58224,bool),i(s(fun(list(Q58224),fun(Q58224,bool)),setu_ofu_list),s(list(Q58224),L)))))) ).

fof(aINu_SETu_OFu_LIST,axiom,
    ! [Q58242,X,L] : s(bool,i(s(fun(fun(Q58242,bool),bool),i(s(fun(Q58242,fun(fun(Q58242,bool),bool)),in),s(Q58242,X))),s(fun(Q58242,bool),i(s(fun(list(Q58242),fun(Q58242,bool)),setu_ofu_list),s(list(Q58242),L))))) = s(bool,i(s(fun(list(Q58242),bool),i(s(fun(Q58242,fun(list(Q58242),bool)),mem),s(Q58242,X))),s(list(Q58242),L))) ).

fof(aSETu_OFu_LISTu_APPEND,axiom,
    ! [Q58267,L1,L2] : s(fun(Q58267,bool),i(s(fun(list(Q58267),fun(Q58267,bool)),setu_ofu_list),s(list(Q58267),i(s(fun(list(Q58267),list(Q58267)),i(s(fun(list(Q58267),fun(list(Q58267),list(Q58267))),append),s(list(Q58267),L1))),s(list(Q58267),L2))))) = s(fun(Q58267,bool),i(s(fun(fun(Q58267,bool),fun(Q58267,bool)),i(s(fun(fun(Q58267,bool),fun(fun(Q58267,bool),fun(Q58267,bool))),union),s(fun(Q58267,bool),i(s(fun(list(Q58267),fun(Q58267,bool)),setu_ofu_list),s(list(Q58267),L1))))),s(fun(Q58267,bool),i(s(fun(list(Q58267),fun(Q58267,bool)),setu_ofu_list),s(list(Q58267),L2))))) ).

fof(aSETu_OFu_LISTu_MAP,axiom,
    ! [Q58289,Q58291,F0,L] : s(fun(Q58289,bool),i(s(fun(list(Q58289),fun(Q58289,bool)),setu_ofu_list),s(list(Q58289),i(s(fun(list(Q58291),list(Q58289)),i(s(fun(fun(Q58291,Q58289),fun(list(Q58291),list(Q58289))),map0),s(fun(Q58291,Q58289),F0))),s(list(Q58291),L))))) = s(fun(Q58289,bool),i(s(fun(fun(Q58291,bool),fun(Q58289,bool)),i(s(fun(fun(Q58291,Q58289),fun(fun(Q58291,bool),fun(Q58289,bool))),image),s(fun(Q58291,Q58289),F0))),s(fun(Q58291,bool),i(s(fun(list(Q58291),fun(Q58291,bool)),setu_ofu_list),s(list(Q58291),L))))) ).

fof(aSETu_OFu_LISTu_EQu_EMPTY,axiom,
    ! [Q58308,L] :
      ( s(fun(Q58308,bool),i(s(fun(list(Q58308),fun(Q58308,bool)),setu_ofu_list),s(list(Q58308),L))) = s(fun(Q58308,bool),empty)
    <=> s(list(Q58308),L) = s(list(Q58308),nil) ) ).

fof(apairwise,axiom,
    ! [Q58342,S0,R0] :
      ( p(s(bool,i(s(fun(fun(Q58342,bool),bool),i(s(fun(fun(Q58342,fun(Q58342,bool)),fun(fun(Q58342,bool),bool)),pairwise),s(fun(Q58342,fun(Q58342,bool)),R0))),s(fun(Q58342,bool),S0))))
    <=> ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(Q58342,bool),bool),i(s(fun(Q58342,fun(fun(Q58342,bool),bool)),in),s(Q58342,X))),s(fun(Q58342,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q58342,bool),bool),i(s(fun(Q58342,fun(fun(Q58342,bool),bool)),in),s(Q58342,Y))),s(fun(Q58342,bool),S0))))
            & s(Q58342,X) != s(Q58342,Y) )
         => p(s(bool,i(s(fun(Q58342,bool),i(s(fun(Q58342,fun(Q58342,bool)),R0),s(Q58342,X))),s(Q58342,Y)))) ) ) ).

fof(aPAIRWISEu_conjunct0,axiom,
    ! [A] : s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,fun(A,bool)),fun(list(A),bool)),pairwise0),s(fun(A,fun(A,bool)),r0))),s(list(A),nil))) = s(bool,t) ).

fof(aPAIRWISEu_conjunct1,axiom,
    ! [A] :
      ( p(s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,fun(A,bool)),fun(list(A),bool)),pairwise0),s(fun(A,fun(A,bool)),r0))),s(list(A),i(s(fun(list(A),list(A)),i(s(fun(A,fun(list(A),list(A))),cons),s(A,h0))),s(list(A),t0))))))
    <=> ( p(s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,bool),fun(list(A),bool)),all0),s(fun(A,bool),i(s(fun(A,fun(A,bool)),r0),s(A,h0))))),s(list(A),t0))))
        & p(s(bool,i(s(fun(list(A),bool),i(s(fun(fun(A,fun(A,bool)),fun(list(A),bool)),pairwise0),s(fun(A,fun(A,bool)),r0))),s(list(A),t0)))) ) ) ).

fof(aPAIRWISEu_EMPTY,axiom,
    ! [Q58377,R0] : s(bool,i(s(fun(fun(Q58377,bool),bool),i(s(fun(fun(Q58377,fun(Q58377,bool)),fun(fun(Q58377,bool),bool)),pairwise),s(fun(Q58377,fun(Q58377,bool)),R0))),s(fun(Q58377,bool),empty))) = s(bool,t) ).

fof(aPAIRWISEu_SING,axiom,
    ! [Q58395,R0,X] : s(bool,i(s(fun(fun(Q58395,bool),bool),i(s(fun(fun(Q58395,fun(Q58395,bool)),fun(fun(Q58395,bool),bool)),pairwise),s(fun(Q58395,fun(Q58395,bool)),R0))),s(fun(Q58395,bool),i(s(fun(fun(Q58395,bool),fun(Q58395,bool)),i(s(fun(Q58395,fun(fun(Q58395,bool),fun(Q58395,bool))),insert),s(Q58395,X))),s(fun(Q58395,bool),empty))))) = s(bool,t) ).

fof(aPAIRWISEu_MONO,axiom,
    ! [Q58415,R0,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(Q58415,bool),bool),i(s(fun(fun(Q58415,fun(Q58415,bool)),fun(fun(Q58415,bool),bool)),pairwise),s(fun(Q58415,fun(Q58415,bool)),R0))),s(fun(Q58415,bool),S0))))
        & p(s(bool,i(s(fun(fun(Q58415,bool),bool),i(s(fun(fun(Q58415,bool),fun(fun(Q58415,bool),bool)),subset),s(fun(Q58415,bool),T0))),s(fun(Q58415,bool),S0)))) )
     => p(s(bool,i(s(fun(fun(Q58415,bool),bool),i(s(fun(fun(Q58415,fun(Q58415,bool)),fun(fun(Q58415,bool),bool)),pairwise),s(fun(Q58415,fun(Q58415,bool)),R0))),s(fun(Q58415,bool),T0)))) ) ).

fof(aPAIRWISEu_INSERT,axiom,
    ! [Q58464,R0,X,S0] :
      ( p(s(bool,i(s(fun(fun(Q58464,bool),bool),i(s(fun(fun(Q58464,fun(Q58464,bool)),fun(fun(Q58464,bool),bool)),pairwise),s(fun(Q58464,fun(Q58464,bool)),R0))),s(fun(Q58464,bool),i(s(fun(fun(Q58464,bool),fun(Q58464,bool)),i(s(fun(Q58464,fun(fun(Q58464,bool),fun(Q58464,bool))),insert),s(Q58464,X))),s(fun(Q58464,bool),S0))))))
    <=> ( ! [Y] :
            ( ( p(s(bool,i(s(fun(fun(Q58464,bool),bool),i(s(fun(Q58464,fun(fun(Q58464,bool),bool)),in),s(Q58464,Y))),s(fun(Q58464,bool),S0))))
              & s(Q58464,Y) != s(Q58464,X) )
           => ( p(s(bool,i(s(fun(Q58464,bool),i(s(fun(Q58464,fun(Q58464,bool)),R0),s(Q58464,X))),s(Q58464,Y))))
              & p(s(bool,i(s(fun(Q58464,bool),i(s(fun(Q58464,fun(Q58464,bool)),R0),s(Q58464,Y))),s(Q58464,X)))) ) )
        & p(s(bool,i(s(fun(fun(Q58464,bool),bool),i(s(fun(fun(Q58464,fun(Q58464,bool)),fun(fun(Q58464,bool),bool)),pairwise),s(fun(Q58464,fun(Q58464,bool)),R0))),s(fun(Q58464,bool),S0)))) ) ) ).

fof(aPAIRWISEu_IMAGE,axiom,
    ! [Q58502,Q58505,U_1] :
      ( ! [R0,X,F0,Y] :
          ( p(s(bool,i(s(fun(Q58505,bool),i(s(fun(fun(Q58505,Q58502),fun(Q58505,bool)),i(s(fun(Q58505,fun(fun(Q58505,Q58502),fun(Q58505,bool))),i(s(fun(fun(Q58502,fun(Q58502,bool)),fun(Q58505,fun(fun(Q58505,Q58502),fun(Q58505,bool)))),U_1),s(fun(Q58502,fun(Q58502,bool)),R0))),s(Q58505,X))),s(fun(Q58505,Q58502),F0))),s(Q58505,Y))))
        <=> ( s(Q58502,i(s(fun(Q58505,Q58502),F0),s(Q58505,X))) != s(Q58502,i(s(fun(Q58505,Q58502),F0),s(Q58505,Y)))
           => p(s(bool,i(s(fun(Q58502,bool),i(s(fun(Q58502,fun(Q58502,bool)),R0),s(Q58502,i(s(fun(Q58505,Q58502),F0),s(Q58505,X))))),s(Q58502,i(s(fun(Q58505,Q58502),F0),s(Q58505,Y)))))) ) )
     => ! [U_0] :
          ( ! [R0,F0,X] : s(fun(Q58505,bool),i(s(fun(Q58505,fun(Q58505,bool)),i(s(fun(fun(Q58505,Q58502),fun(Q58505,fun(Q58505,bool))),i(s(fun(fun(Q58502,fun(Q58502,bool)),fun(fun(Q58505,Q58502),fun(Q58505,fun(Q58505,bool)))),U_0),s(fun(Q58502,fun(Q58502,bool)),R0))),s(fun(Q58505,Q58502),F0))),s(Q58505,X))) = s(fun(Q58505,bool),i(s(fun(fun(Q58505,Q58502),fun(Q58505,bool)),i(s(fun(Q58505,fun(fun(Q58505,Q58502),fun(Q58505,bool))),i(s(fun(fun(Q58502,fun(Q58502,bool)),fun(Q58505,fun(fun(Q58505,Q58502),fun(Q58505,bool)))),U_1),s(fun(Q58502,fun(Q58502,bool)),R0))),s(Q58505,X))),s(fun(Q58505,Q58502),F0)))
         => ! [R0,F0] : s(bool,i(s(fun(fun(Q58502,bool),bool),i(s(fun(fun(Q58502,fun(Q58502,bool)),fun(fun(Q58502,bool),bool)),pairwise),s(fun(Q58502,fun(Q58502,bool)),R0))),s(fun(Q58502,bool),i(s(fun(fun(Q58505,bool),fun(Q58502,bool)),i(s(fun(fun(Q58505,Q58502),fun(fun(Q58505,bool),fun(Q58502,bool))),image),s(fun(Q58505,Q58502),F0))),s(fun(Q58505,bool),s0))))) = s(bool,i(s(fun(fun(Q58505,bool),bool),i(s(fun(fun(Q58505,fun(Q58505,bool)),fun(fun(Q58505,bool),bool)),pairwise),s(fun(Q58505,fun(Q58505,bool)),i(s(fun(fun(Q58505,Q58502),fun(Q58505,fun(Q58505,bool))),i(s(fun(fun(Q58502,fun(Q58502,bool)),fun(fun(Q58505,Q58502),fun(Q58505,fun(Q58505,bool)))),U_0),s(fun(Q58502,fun(Q58502,bool)),R0))),s(fun(Q58505,Q58502),F0))))),s(fun(Q58505,bool),s0))) ) ) ).

fof(aCARDu_SETu_OFu_LISTu_LE,axiom,
    ! [Q58517,L] : p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(Q58517,bool),num),card),s(fun(Q58517,bool),i(s(fun(list(Q58517),fun(Q58517,bool)),setu_ofu_list),s(list(Q58517),L))))))),s(num,i(s(fun(list(Q58517),num),length),s(list(Q58517),L)))))) ).

fof(aHASu_SIZEu_SETu_OFu_LIST,axiom,
    ! [Q58537,U_1] :
      ( ! [X,Y] :
          ( p(s(bool,i(s(fun(Q58537,bool),i(s(fun(Q58537,fun(Q58537,bool)),U_1),s(Q58537,X))),s(Q58537,Y))))
        <=> s(Q58537,X) != s(Q58537,Y) )
     => ! [U_0] :
          ( ! [X] : s(fun(Q58537,bool),i(s(fun(Q58537,fun(Q58537,bool)),U_0),s(Q58537,X))) = s(fun(Q58537,bool),i(s(fun(Q58537,fun(Q58537,bool)),U_1),s(Q58537,X)))
         => ! [L] : s(bool,i(s(fun(num,bool),i(s(fun(fun(Q58537,bool),fun(num,bool)),hasu_size),s(fun(Q58537,bool),i(s(fun(list(Q58537),fun(Q58537,bool)),setu_ofu_list),s(list(Q58537),L))))),s(num,i(s(fun(list(Q58537),num),length),s(list(Q58537),L))))) = s(bool,i(s(fun(list(Q58537),bool),i(s(fun(fun(Q58537,fun(Q58537,bool)),fun(list(Q58537),bool)),pairwise0),s(fun(Q58537,fun(Q58537,bool)),U_0))),s(list(Q58537),L))) ) ) ).

fof(aSURJECTIVEu_IFFu_INJECTIVEu_GEN,axiom,
    ! [B,A,S0,T0,F0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) = s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0)))
        & p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))),s(fun(B,bool),T0)))) )
     => ( ! [Y] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
           => ? [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) )
      <=> ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) ) ) ) ).

fof(aSURJECTIVEu_IFFu_INJECTIVE,axiom,
    ! [A,S0,F0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),i(s(fun(fun(A,A),fun(fun(A,bool),fun(A,bool))),image),s(fun(A,A),F0))),s(fun(A,bool),S0))))),s(fun(A,bool),S0)))) )
     => ( ! [Y] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
           => ? [X] :
                ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                & s(A,i(s(fun(A,A),F0),s(A,X))) = s(A,Y) ) )
      <=> ! [X,Y] :
            ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
              & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
              & s(A,i(s(fun(A,A),F0),s(A,X))) = s(A,i(s(fun(A,A),F0),s(A,Y))) )
           => s(A,X) = s(A,Y) ) ) ) ).

fof(aIMAGEu_IMPu_INJECTIVEu_GEN,axiom,
    ! [B,A,S0,T0,F0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) = s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0)))
        & s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),T0) )
     => ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
            & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
         => s(A,X) = s(A,Y) ) ) ).

fof(aIMAGEu_IMPu_INJECTIVE,axiom,
    ! [Q58875,S0,F0] :
      ( ( p(s(bool,i(s(fun(fun(Q58875,bool),bool),finite),s(fun(Q58875,bool),S0))))
        & s(fun(Q58875,bool),i(s(fun(fun(Q58875,bool),fun(Q58875,bool)),i(s(fun(fun(Q58875,Q58875),fun(fun(Q58875,bool),fun(Q58875,bool))),image),s(fun(Q58875,Q58875),F0))),s(fun(Q58875,bool),S0))) = s(fun(Q58875,bool),S0) )
     => ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(Q58875,bool),bool),i(s(fun(Q58875,fun(fun(Q58875,bool),bool)),in),s(Q58875,X))),s(fun(Q58875,bool),S0))))
            & p(s(bool,i(s(fun(fun(Q58875,bool),bool),i(s(fun(Q58875,fun(fun(Q58875,bool),bool)),in),s(Q58875,Y))),s(fun(Q58875,bool),S0))))
            & s(Q58875,i(s(fun(Q58875,Q58875),F0),s(Q58875,X))) = s(Q58875,i(s(fun(Q58875,Q58875),F0),s(Q58875,Y))) )
         => s(Q58875,X) = s(Q58875,Y) ) ) ).

fof(aCARDu_LEu_INJ,axiom,
    ! [B,A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))))),s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0)))))) )
     => ? [F0] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))))),s(fun(B,bool),T0))))
          & ! [X,Y] :
              ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
             => s(A,X) = s(A,Y) ) ) ) ).

fof(aFORALLu_INu_CLAUSESu_conjunct0,axiom,
    ! [Q58981,P0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q58981,bool),bool),i(s(fun(Q58981,fun(fun(Q58981,bool),bool)),in),s(Q58981,X))),s(fun(Q58981,bool),empty))))
         => p(s(bool,i(s(fun(Q58981,bool),P0),s(Q58981,X)))) )
    <=> p(s(bool,t)) ) ).

fof(aFORALLu_INu_CLAUSESu_conjunct1,axiom,
    ! [Q59021,P0,A5,S0] :
      ( ! [X] :
          ( p(s(bool,i(s(fun(fun(Q59021,bool),bool),i(s(fun(Q59021,fun(fun(Q59021,bool),bool)),in),s(Q59021,X))),s(fun(Q59021,bool),i(s(fun(fun(Q59021,bool),fun(Q59021,bool)),i(s(fun(Q59021,fun(fun(Q59021,bool),fun(Q59021,bool))),insert),s(Q59021,A5))),s(fun(Q59021,bool),S0))))))
         => p(s(bool,i(s(fun(Q59021,bool),P0),s(Q59021,X)))) )
    <=> ( p(s(bool,i(s(fun(Q59021,bool),P0),s(Q59021,A5))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(Q59021,bool),bool),i(s(fun(Q59021,fun(fun(Q59021,bool),bool)),in),s(Q59021,X))),s(fun(Q59021,bool),S0))))
           => p(s(bool,i(s(fun(Q59021,bool),P0),s(Q59021,X)))) ) ) ) ).

fof(aEXISTSu_INu_CLAUSESu_conjunct0,axiom,
    ! [Q59041,P0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(fun(Q59041,bool),bool),i(s(fun(Q59041,fun(fun(Q59041,bool),bool)),in),s(Q59041,X))),s(fun(Q59041,bool),empty))))
          & p(s(bool,i(s(fun(Q59041,bool),P0),s(Q59041,X)))) )
    <=> p(s(bool,f0)) ) ).

fof(aEXISTSu_INu_CLAUSESu_conjunct1,axiom,
    ! [Q59081,P0,A5,S0] :
      ( ? [X] :
          ( p(s(bool,i(s(fun(fun(Q59081,bool),bool),i(s(fun(Q59081,fun(fun(Q59081,bool),bool)),in),s(Q59081,X))),s(fun(Q59081,bool),i(s(fun(fun(Q59081,bool),fun(Q59081,bool)),i(s(fun(Q59081,fun(fun(Q59081,bool),fun(Q59081,bool))),insert),s(Q59081,A5))),s(fun(Q59081,bool),S0))))))
          & p(s(bool,i(s(fun(Q59081,bool),P0),s(Q59081,X)))) )
    <=> ( p(s(bool,i(s(fun(Q59081,bool),P0),s(Q59081,A5))))
        | ? [X] :
            ( p(s(bool,i(s(fun(fun(Q59081,bool),bool),i(s(fun(Q59081,fun(fun(Q59081,bool),bool)),in),s(Q59081,X))),s(fun(Q59081,bool),S0))))
            & p(s(bool,i(s(fun(Q59081,bool),P0),s(Q59081,X)))) ) ) ) ).

fof(aINJECTIVEu_ONu_IMAGE,axiom,
    ! [B,A,F0,U] :
      ( ! [S0,T0] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),U))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),T0))),s(fun(A,bool),U))))
            & s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),T0))) )
         => s(fun(A,bool),S0) = s(fun(A,bool),T0) )
    <=> ! [X,Y] :
          ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),U))))
            & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),U))))
            & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
         => s(A,X) = s(A,Y) ) ) ).

fof(aINJECTIVEu_IMAGE,axiom,
    ! [B,A,F0] :
      ( ! [S0,T0] :
          ( s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),T0)))
         => s(fun(A,bool),S0) = s(fun(A,bool),T0) )
    <=> ! [X,Y] :
          ( s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y)))
         => s(A,X) = s(A,Y) ) ) ).

fof(aSURJECTIVEu_ONu_IMAGE,axiom,
    ! [A,B,F0,U,V] :
      ( ! [T0] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(fun(B,bool),fun(fun(B,bool),bool)),subset),s(fun(B,bool),T0))),s(fun(B,bool),V))))
         => ? [S0] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(fun(A,bool),fun(fun(A,bool),bool)),subset),s(fun(A,bool),S0))),s(fun(A,bool),U))))
              & s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),T0) ) )
    <=> ! [Y] :
          ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),V))))
         => ? [X] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),U))))
              & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) ) ) ).

fof(aSURJECTIVEu_IMAGE,axiom,
    ! [A,B,F0] :
      ( ! [T0] :
        ? [S0] : s(fun(B,bool),i(s(fun(fun(A,bool),fun(B,bool)),i(s(fun(fun(A,B),fun(fun(A,bool),fun(B,bool))),image),s(fun(A,B),F0))),s(fun(A,bool),S0))) = s(fun(B,bool),T0)
    <=> ! [Y] :
        ? [X] : s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) ).

fof(aCARDu_EQu_BIJECTION,axiom,
    ! [B,A,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) = s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0))) )
     => ? [F0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
             => p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0)))) )
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
             => ? [X] :
                  ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                  & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,Y) ) )
          & ! [X,Y] :
              ( ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
                & p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,Y))),s(fun(A,bool),S0))))
                & s(B,i(s(fun(A,B),F0),s(A,X))) = s(B,i(s(fun(A,B),F0),s(A,Y))) )
             => s(A,X) = s(A,Y) ) ) ) ).

fof(aCARDu_EQu_BIJECTIONS,axiom,
    ! [A,B,S0,T0] :
      ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
        & p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0))))
        & s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) = s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0))) )
     => ? [F0,G0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
             => ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0))))
                & s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,X))))) = s(A,X) ) )
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
             => ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(B,A),G0),s(B,Y))))),s(fun(A,bool),S0))))
                & s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,Y))))) = s(B,Y) ) ) ) ) ).

fof(aBIJECTIONSu_HASu_SIZE,axiom,
    ! [A,B,S0,T0,F0,G0] :
      ( ( ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0))))
              & s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,X))))) = s(A,X) ) )
        & ! [Y] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
           => ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(B,A),G0),s(B,Y))))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,Y))))) = s(B,Y) ) )
        & p(s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,n)))) )
     => p(s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),T0))),s(num,n)))) ) ).

fof(aBIJECTIONSu_HASu_SIZEu_EQ,axiom,
    ! [A,B,S0,T0,F0,G0] :
      ( ( ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0))))
              & s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,X))))) = s(A,X) ) )
        & ! [Y] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
           => ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(B,A),G0),s(B,Y))))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,Y))))) = s(B,Y) ) ) )
     => ! [N0] : s(bool,i(s(fun(num,bool),i(s(fun(fun(A,bool),fun(num,bool)),hasu_size),s(fun(A,bool),S0))),s(num,N0))) = s(bool,i(s(fun(num,bool),i(s(fun(fun(B,bool),fun(num,bool)),hasu_size),s(fun(B,bool),T0))),s(num,N0))) ) ).

fof(aBIJECTIONSu_CARDu_EQ,axiom,
    ! [A,B,S0,T0,F0,G0] :
      ( ( ( p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),S0))))
          | p(s(bool,i(s(fun(fun(B,bool),bool),finite),s(fun(B,bool),T0)))) )
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,X))),s(fun(A,bool),S0))))
           => ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,i(s(fun(A,B),F0),s(A,X))))),s(fun(B,bool),T0))))
              & s(A,i(s(fun(B,A),G0),s(B,i(s(fun(A,B),F0),s(A,X))))) = s(A,X) ) )
        & ! [Y] :
            ( p(s(bool,i(s(fun(fun(B,bool),bool),i(s(fun(B,fun(fun(B,bool),bool)),in),s(B,Y))),s(fun(B,bool),T0))))
           => ( p(s(bool,i(s(fun(fun(A,bool),bool),i(s(fun(A,fun(fun(A,bool),bool)),in),s(A,i(s(fun(B,A),G0),s(B,Y))))),s(fun(A,bool),S0))))
              & s(B,i(s(fun(A,B),F0),s(A,i(s(fun(B,A),G0),s(B,Y))))) = s(B,Y) ) ) )
     => s(num,i(s(fun(fun(A,bool),num),card),s(fun(A,bool),S0))) = s(num,i(s(fun(fun(B,bool),num),card),s(fun(B,bool),T0))) ) ).

fof(aWFu_FINITE,axiom,
    ! [A,U_0] :
      ( ! [L_L_,X,GENR_PVARR_133] :
          ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,fun(A,bool)),fun(A,fun(A,bool))),U_0),s(fun(A,fun(A,bool)),L_L_))),s(A,X))),s(A,GENR_PVARR_133))))
        <=> ? [Y] : p(s(bool,i(s(fun(A,bool),i(s(fun(bool,fun(A,bool)),i(s(fun(A,fun(bool,fun(A,bool))),setspec),s(A,GENR_PVARR_133))),s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,Y))),s(A,X))))),s(A,Y)))) )
     => ! [L_L_] :
          ( ( ! [X] : ~ p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,X))),s(A,X))))
            & ! [X,Y,Z0] :
                ( ( p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,X))),s(A,Y))))
                  & p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,Y))),s(A,Z0)))) )
               => p(s(bool,i(s(fun(A,bool),i(s(fun(A,fun(A,bool)),L_L_),s(A,X))),s(A,Z0)))) )
            & ! [X] : p(s(bool,i(s(fun(fun(A,bool),bool),finite),s(fun(A,bool),i(s(fun(fun(A,bool),fun(A,bool)),gspec),s(fun(A,bool),i(s(fun(A,fun(A,bool)),i(s(fun(fun(A,fun(A,bool)),fun(A,fun(A,bool))),U_0),s(fun(A,fun(A,bool)),L_L_))),s(A,X)))))))) )
         => p(s(bool,i(s(fun(fun(A,fun(A,bool)),bool),wf),s(fun(A,fun(A,bool)),L_L_)))) ) ) ).

fof(aleu_c,axiom,
    ! [Q59915,Q59920,T0,S0] :
      ( p(s(bool,i(s(fun(fun(Q59915,bool),bool),i(s(fun(fun(Q59920,bool),fun(fun(Q59915,bool),bool)),l_a_u_c),s(fun(Q59920,bool),S0))),s(fun(Q59915,bool),T0))))
    <=> ? [F0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(Q59920,bool),bool),i(s(fun(Q59920,fun(fun(Q59920,bool),bool)),in),s(Q59920,X))),s(fun(Q59920,bool),S0))))
             => p(s(bool,i(s(fun(fun(Q59915,bool),bool),i(s(fun(Q59915,fun(fun(Q59915,bool),bool)),in),s(Q59915,i(s(fun(Q59920,Q59915),F0),s(Q59920,X))))),s(fun(Q59915,bool),T0)))) )
          & ! [X,Y] :
              ( ( p(s(bool,i(s(fun(fun(Q59920,bool),bool),i(s(fun(Q59920,fun(fun(Q59920,bool),bool)),in),s(Q59920,X))),s(fun(Q59920,bool),S0))))
                & p(s(bool,i(s(fun(fun(Q59920,bool),bool),i(s(fun(Q59920,fun(fun(Q59920,bool),bool)),in),s(Q59920,Y))),s(fun(Q59920,bool),S0))))
                & s(Q59915,i(s(fun(Q59920,Q59915),F0),s(Q59920,X))) = s(Q59915,i(s(fun(Q59920,Q59915),F0),s(Q59920,Y))) )
             => s(Q59920,X) = s(Q59920,Y) ) ) ) ).

fof(altu_c,axiom,
    ! [Q59933,Q59932,T0,S0] :
      ( p(s(bool,i(s(fun(fun(Q59933,bool),bool),i(s(fun(fun(Q59932,bool),fun(fun(Q59933,bool),bool)),l_u_c),s(fun(Q59932,bool),S0))),s(fun(Q59933,bool),T0))))
    <=> ( p(s(bool,i(s(fun(fun(Q59933,bool),bool),i(s(fun(fun(Q59932,bool),fun(fun(Q59933,bool),bool)),l_a_u_c),s(fun(Q59932,bool),S0))),s(fun(Q59933,bool),T0))))
        & ~ p(s(bool,i(s(fun(fun(Q59932,bool),bool),i(s(fun(fun(Q59933,bool),fun(fun(Q59932,bool),bool)),l_a_u_c),s(fun(Q59933,bool),T0))),s(fun(Q59932,bool),S0)))) ) ) ).

fof(aequ_c,axiom,
    ! [Q59981,Q59984,T0,S0] :
      ( p(s(bool,i(s(fun(fun(Q59981,bool),bool),i(s(fun(fun(Q59984,bool),fun(fun(Q59981,bool),bool)),a_u_c),s(fun(Q59984,bool),S0))),s(fun(Q59981,bool),T0))))
    <=> ? [F0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(Q59984,bool),bool),i(s(fun(Q59984,fun(fun(Q59984,bool),bool)),in),s(Q59984,X))),s(fun(Q59984,bool),S0))))
             => p(s(bool,i(s(fun(fun(Q59981,bool),bool),i(s(fun(Q59981,fun(fun(Q59981,bool),bool)),in),s(Q59981,i(s(fun(Q59984,Q59981),F0),s(Q59984,X))))),s(fun(Q59981,bool),T0)))) )
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(Q59981,bool),bool),i(s(fun(Q59981,fun(fun(Q59981,bool),bool)),in),s(Q59981,Y))),s(fun(Q59981,bool),T0))))
             => ( ? [X] :
                    ( p(s(bool,i(s(fun(fun(Q59984,bool),bool),i(s(fun(Q59984,fun(fun(Q59984,bool),bool)),in),s(Q59984,X))),s(fun(Q59984,bool),S0))))
                    & s(Q59981,i(s(fun(Q59984,Q59981),F0),s(Q59984,X))) = s(Q59981,Y) )
                & ! [X,XI_] :
                    ( ( p(s(bool,i(s(fun(fun(Q59984,bool),bool),i(s(fun(Q59984,fun(fun(Q59984,bool),bool)),in),s(Q59984,X))),s(fun(Q59984,bool),S0))))
                      & s(Q59981,i(s(fun(Q59984,Q59981),F0),s(Q59984,X))) = s(Q59981,Y)
                      & p(s(bool,i(s(fun(fun(Q59984,bool),bool),i(s(fun(Q59984,fun(fun(Q59984,bool),bool)),in),s(Q59984,XI_))),s(fun(Q59984,bool),S0))))
                      & s(Q59981,i(s(fun(Q59984,Q59981),F0),s(Q59984,XI_))) = s(Q59981,Y) )
                   => s(Q59984,X) = s(Q59984,XI_) ) ) ) ) ) ).

fof(ageu_c,axiom,
    ! [Q59992,Q59993,T0,S0] : s(bool,i(s(fun(fun(Q59992,bool),bool),i(s(fun(fun(Q59993,bool),fun(fun(Q59992,bool),bool)),g_a_u_c),s(fun(Q59993,bool),S0))),s(fun(Q59992,bool),T0))) = s(bool,i(s(fun(fun(Q59993,bool),bool),i(s(fun(fun(Q59992,bool),fun(fun(Q59993,bool),bool)),l_a_u_c),s(fun(Q59992,bool),T0))),s(fun(Q59993,bool),S0))) ).

fof(agtu_c,axiom,
    ! [Q60001,Q60002,T0,S0] : s(bool,i(s(fun(fun(Q60001,bool),bool),i(s(fun(fun(Q60002,bool),fun(fun(Q60001,bool),bool)),g_u_c),s(fun(Q60002,bool),S0))),s(fun(Q60001,bool),T0))) = s(bool,i(s(fun(fun(Q60002,bool),bool),i(s(fun(fun(Q60001,bool),fun(fun(Q60002,bool),bool)),l_u_c),s(fun(Q60001,bool),T0))),s(fun(Q60002,bool),S0))) ).

fof(aLEu_C,axiom,
    ! [Q60043,Q60040,S0,T0] :
      ( p(s(bool,i(s(fun(fun(Q60043,bool),bool),i(s(fun(fun(Q60040,bool),fun(fun(Q60043,bool),bool)),l_a_u_c),s(fun(Q60040,bool),S0))),s(fun(Q60043,bool),T0))))
    <=> ? [G0] :
        ! [X] :
          ( p(s(bool,i(s(fun(fun(Q60040,bool),bool),i(s(fun(Q60040,fun(fun(Q60040,bool),bool)),in),s(Q60040,X))),s(fun(Q60040,bool),S0))))
         => ? [Y] :
              ( p(s(bool,i(s(fun(fun(Q60043,bool),bool),i(s(fun(Q60043,fun(fun(Q60043,bool),bool)),in),s(Q60043,Y))),s(fun(Q60043,bool),T0))))
              & s(Q60040,i(s(fun(Q60043,Q60040),G0),s(Q60043,Y))) = s(Q60040,X) ) ) ) ).

fof(aGEu_C,axiom,
    ! [Q60081,Q60084,S0,T0] :
      ( p(s(bool,i(s(fun(fun(Q60081,bool),bool),i(s(fun(fun(Q60084,bool),fun(fun(Q60081,bool),bool)),g_a_u_c),s(fun(Q60084,bool),S0))),s(fun(Q60081,bool),T0))))
    <=> ? [F0] :
        ! [Y] :
          ( p(s(bool,i(s(fun(fun(Q60081,bool),bool),i(s(fun(Q60081,fun(fun(Q60081,bool),bool)),in),s(Q60081,Y))),s(fun(Q60081,bool),T0))))
         => ? [X] :
              ( p(s(bool,i(s(fun(fun(Q60084,bool),bool),i(s(fun(Q60084,fun(fun(Q60084,bool),bool)),in),s(Q60084,X))),s(fun(Q60084,bool),S0))))
              & s(Q60081,Y) = s(Q60081,i(s(fun(Q60084,Q60081),F0),s(Q60084,X))) ) ) ) ).

fof(aCOUNTABLE,axiom,
    ! [Q60092,T0] : s(bool,i(s(fun(fun(Q60092,bool),bool),countable),s(fun(Q60092,bool),T0))) = s(bool,i(s(fun(fun(Q60092,bool),bool),i(s(fun(fun(num,bool),fun(fun(Q60092,bool),bool)),g_a_u_c),s(fun(num,bool),univ))),s(fun(Q60092,bool),T0))) ).

fof(asup,axiom,
    ! [U_0] :
      ( ! [S0,A5] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),U_0),s(fun(real,bool),S0))),s(real,A5))))
        <=> ( ! [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,A5)))) )
            & ! [B0] :
                ( ! [X] :
                    ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
                   => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) )
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,B0)))) ) ) )
     => ! [S0] : s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))) = s(real,i(s(fun(fun(real,bool),real),h_),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),U_0),s(fun(real,bool),S0))))) ) ).

fof(aSUPu_EQ,axiom,
    ! [S0,T0] :
      ( ! [B0] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) )
        <=> ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),T0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
     => s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))) = s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),T0))) ) ).

fof(aSUP,axiom,
    ! [S0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ? [B0] :
          ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
     => ( ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0)))))) )
        & ! [B0] :
            ( ! [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) )
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,B0)))) ) ) ) ).

fof(aSUPu_FINITEu_LEMMA,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ? [B0] :
          ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,B0))),s(fun(real,bool),S0))))
          & ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) ) ) ).

fof(aSUPu_FINITE,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(fun(real,bool),S0))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0)))))) ) ) ) ).

fof(aREALu_LEu_SUPu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))))
      <=> ? [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
            & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X)))) ) ) ) ).

fof(aREALu_SUPu_LEu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,A5))))
      <=> ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,A5)))) ) ) ) ).

fof(aREALu_LTu_SUPu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))))
      <=> ? [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
            & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,X)))) ) ) ) ).

fof(aREALu_SUPu_LTu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,A5))))
      <=> ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,A5)))) ) ) ) ).

fof(aREALu_SUPu_UNIQUE,axiom,
    ! [S0,B0] :
      ( ( ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) )
        & ! [BI_] :
            ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,BI_))),s(real,B0))))
           => ? [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
                & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,BI_))),s(real,X)))) ) ) )
     => s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))) = s(real,B0) ) ).

fof(aREALu_SUPu_LE,axiom,
    ! [B0] :
      ( ( s(fun(real,bool),s0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),s0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),s0))))),s(real,B0)))) ) ).

fof(aREALu_SUPu_LEu_SUBSET,axiom,
    ! [S0,T0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(fun(real,bool),fun(fun(real,bool),bool)),subset),s(fun(real,bool),S0))),s(fun(real,bool),T0))))
        & ? [B0] :
          ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),T0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),T0)))))) ) ).

fof(aREALu_SUPu_BOUNDS,axiom,
    ! [S0,A5,B0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X))))
              & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) ) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,B0)))) ) ) ).

fof(aREALu_ABSu_SUPu_LE,axiom,
    ! [S0,A5] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,A5)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))))),s(real,A5)))) ) ).

fof(aREALu_SUPu_ASCLOSE,axiom,
    ! [S0,L,E0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,L))))))),s(real,E0)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))),s(real,L))))))),s(real,E0)))) ) ).

fof(ainf,axiom,
    ! [U_0] :
      ( ! [S0,A5] :
          ( p(s(bool,i(s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),U_0),s(fun(real,bool),S0))),s(real,A5))))
        <=> ( ! [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X)))) )
            & ! [B0] :
                ( ! [X] :
                    ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
                   => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) )
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,A5)))) ) ) )
     => ! [S0] : s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))) = s(real,i(s(fun(fun(real,bool),real),h_),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),U_0),s(fun(real,bool),S0))))) ) ).

fof(aINFu_EQ,axiom,
    ! [S0,T0] :
      ( ! [A5] :
          ( ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X)))) )
        <=> ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),T0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X)))) ) )
     => s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))) = s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),T0))) ) ).

fof(aINF,axiom,
    ! [S0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ? [B0] :
          ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) ) )
     => ( ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,X)))) )
        & ! [B0] :
            ( ! [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
               => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) )
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0)))))) ) ) ) ).

fof(aINFu_FINITEu_LEMMA,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ? [B0] :
          ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,B0))),s(fun(real,bool),S0))))
          & ! [X] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) ) ) ) ).

fof(aINFu_FINITE,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(fun(real,bool),S0))))
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,X)))) ) ) ) ).

fof(aREALu_LEu_INFu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))))
      <=> ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X)))) ) ) ) ).

fof(aREALu_INFu_LEu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,A5))))
      <=> ? [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
            & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,A5)))) ) ) ) ).

fof(aREALu_LTu_INFu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))))
      <=> ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,A5))),s(real,X)))) ) ) ) ).

fof(aREALu_INFu_LTu_FINITE,axiom,
    ! [S0,A5] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,A5))))
      <=> ? [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
            & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,A5)))) ) ) ) ).

fof(aREALu_INFu_UNIQUE,axiom,
    ! [S0,B0] :
      ( ( ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) )
        & ! [BI_] :
            ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,B0))),s(real,BI_))))
           => ? [X] :
                ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
                & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_lt),s(real,X))),s(real,BI_)))) ) ) )
     => s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))) = s(real,B0) ) ).

fof(aREALu_LEu_INF,axiom,
    ! [B0] :
      ( ( s(fun(real,bool),s0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),s0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),s0)))))) ) ).

fof(aREALu_LEu_INFu_SUBSET,axiom,
    ! [S0,T0] :
      ( ( s(fun(real,bool),T0) != s(fun(real,bool),empty)
        & p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(fun(real,bool),fun(fun(real,bool),bool)),subset),s(fun(real,bool),T0))),s(fun(real,bool),S0))))
        & ? [B0] :
          ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,B0))),s(real,X)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),T0)))))) ) ).

fof(aREALu_INFu_BOUNDS,axiom,
    ! [S0,A5,B0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,X))))
              & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,X))),s(real,B0)))) ) ) )
     => ( p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,A5))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))))
        & p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,B0)))) ) ) ).

fof(aREALu_ABSu_INFu_LE,axiom,
    ! [S0,A5] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,A5)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))))),s(real,A5)))) ) ).

fof(aREALu_INFu_ASCLOSE,axiom,
    ! [S0,L,E0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,X))),s(real,L))))))),s(real,E0)))) ) )
     => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_sub),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))),s(real,L))))))),s(real,E0)))) ) ).

fof(aSUPu_UNIQUEu_FINITE,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))) = s(real,a0)
      <=> ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,a0))),s(fun(real,bool),S0))))
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,Y))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,Y))),s(real,a0)))) ) ) ) ) ).

fof(aINFu_UNIQUEu_FINITE,axiom,
    ! [S0] :
      ( ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
        & s(fun(real,bool),S0) != s(fun(real,bool),empty) )
     => ( s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))) = s(real,a0)
      <=> ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,a0))),s(fun(real,bool),S0))))
          & ! [Y] :
              ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,Y))),s(fun(real,bool),S0))))
             => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,a0))),s(real,Y)))) ) ) ) ) ).

fof(aSUPu_INSERTu_FINITE,axiom,
    ! [X,S0] :
      ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
     => ? [V] :
          ( ( p(s(bool,V))
          <=> s(fun(real,bool),S0) = s(fun(real,bool),empty) )
          & s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),i(s(fun(real,fun(fun(real,bool),fun(real,bool))),insert),s(real,X))),s(fun(real,bool),S0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,V))),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_max),s(real,X))),s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))))))) ) ) ).

fof(aSUPu_SING,axiom,
    ! [A5] : s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),i(s(fun(real,fun(fun(real,bool),fun(real,bool))),insert),s(real,A5))),s(fun(real,bool),empty))))) = s(real,A5) ).

fof(aINFu_INSERTu_FINITE,axiom,
    ! [X,S0] :
      ( p(s(bool,i(s(fun(fun(real,bool),bool),finite),s(fun(real,bool),S0))))
     => ? [V] :
          ( ( p(s(bool,V))
          <=> s(fun(real,bool),S0) = s(fun(real,bool),empty) )
          & s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),i(s(fun(real,fun(fun(real,bool),fun(real,bool))),insert),s(real,X))),s(fun(real,bool),S0))))) = s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),i(s(fun(bool,fun(real,fun(real,real))),cond),s(bool,V))),s(real,X))),s(real,i(s(fun(real,real),i(s(fun(real,fun(real,real)),realu_min),s(real,X))),s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0))))))) ) ) ).

fof(aINFu_SING,axiom,
    ! [A5] : s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),i(s(fun(real,fun(fun(real,bool),fun(real,bool))),insert),s(real,A5))),s(fun(real,bool),empty))))) = s(real,A5) ).

fof(aREALu_SUPu_EQu_INF,axiom,
    ! [S0] :
      ( ( s(fun(real,bool),S0) != s(fun(real,bool),empty)
        & ? [B0] :
          ! [X] :
            ( p(s(bool,i(s(fun(fun(real,bool),bool),i(s(fun(real,fun(fun(real,bool),bool)),in),s(real,X))),s(fun(real,bool),S0))))
           => p(s(bool,i(s(fun(real,bool),i(s(fun(real,fun(real,bool)),realu_le),s(real,i(s(fun(real,real),realu_abs),s(real,X))))),s(real,B0)))) ) )
     => ( s(real,i(s(fun(fun(real,bool),real),sup),s(fun(real,bool),S0))) = s(real,i(s(fun(fun(real,bool),real),inf),s(fun(real,bool),S0)))
      <=> ? [A5] : s(fun(real,bool),S0) = s(fun(real,bool),i(s(fun(fun(real,bool),fun(real,bool)),i(s(fun(real,fun(fun(real,bool),fun(real,bool))),insert),s(real,A5))),s(fun(real,bool),empty))) ) ) ).

fof(anumseg,axiom,
    ! [U_0] :
      ( ! [M0,N0,GENR_PVARR_134] :
          ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),U_0),s(num,M0))),s(num,N0))),s(num,GENR_PVARR_134))))
        <=> ? [X,V] :
              ( ( p(s(bool,V))
              <=> ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,X))))
                  & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,X))),s(num,N0)))) ) )
              & p(s(bool,i(s(fun(num,bool),i(s(fun(bool,fun(num,bool)),i(s(fun(num,fun(bool,fun(num,bool))),setspec),s(num,GENR_PVARR_134))),s(bool,V))),s(num,X)))) ) )
     => ! [M0,N0] : s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,M0))),s(num,N0))) = s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),gspec),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),U_0),s(num,M0))),s(num,N0))))) ) ).

fof(aFINITEu_NUMSEG,axiom,
    ! [M0,N0] : p(s(bool,i(s(fun(fun(num,bool),bool),finite),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,M0))),s(num,N0)))))) ).

fof(aNUMSEGu_COMBINEu_R,axiom,
    ! [M0,P0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,P0))),s(num,N0)))) )
     => s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),i(s(fun(fun(num,bool),fun(fun(num,bool),fun(num,bool))),union),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,M0))),s(num,P0))))),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,P0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))),s(num,N0))))) = s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,M0))),s(num,N0))) ) ).

fof(aNUMSEGu_COMBINEu_L,axiom,
    ! [M0,P0,N0] :
      ( ( p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,M0))),s(num,P0))))
        & p(s(bool,i(s(fun(num,bool),i(s(fun(num,fun(num,bool)),l_a_),s(num,P0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),p_),s(num,N0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0)))))))))) )
     => s(fun(num,bool),i(s(fun(fun(num,bool),fun(num,bool)),i(s(fun(fun(num,bool),fun(fun(num,bool),fun(num,bool))),union),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num,M0))),s(num,i(s(fun(num,num),i(s(fun(num,fun(num,num)),m_),s(num,P0))),s(num,i(s(fun(num,num),numeral),s(num,i(s(fun(num,num),bit1),s(num,u_0))))))))))),s(fun(num,bool),i(s(fun(num,fun(num,bool)),i(s(fun(num,fun(num,fun(num,bool))),o_o_),s(num