%------------------------------------------------------------------------------
% File     : KLE134+1 : TPTP v9.0.0. Released v4.0.0.
% Domain   : Kleene Algebra (Modal Semirings)
% Problem  : A no name lemma
% Version  : [Hoe08] axioms.
% English  :

% Refs     : [DMS04] Desharnais et al. (2004), Termination in Modal Kleene
%          : [Hoe08] Hoefner (2008), Email to G. Sutcliffe
% Source   : [Hoe08]
% Names    :

% Status   : Theorem
% Rating   : 0.97 v9.0.0, 1.00 v7.0.0, 0.93 v6.4.0, 1.00 v6.1.0, 0.97 v6.0.0, 1.00 v5.3.0, 0.96 v5.2.0, 0.95 v5.0.0, 1.00 v4.0.0
% Syntax   : Number of formulae    :   27 (  26 unt;   0 def)
%            Number of atoms       :   28 (  27 equ)
%            Maximal formula atoms :    2 (   1 avg)
%            Number of connectives :    1 (   0   ~;   0   |;   0   &)
%                                         (   1 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    4 (   3 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 2-2 aty)
%            Number of functors    :   14 (  14 usr;   2 con; 0-2 aty)
%            Number of variables   :   46 (  46   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Equational encoding
%------------------------------------------------------------------------------
%---Include axioms for modal semiring
%------------------------------------------------------------------------------
%----Additive idempotent monoid
fof(additive_commutativity,axiom,
    ! [A,B] : addition(A,B) = addition(B,A) ).

fof(additive_associativity,axiom,
    ! [C,B,A] : addition(A,addition(B,C)) = addition(addition(A,B),C) ).

fof(additive_identity,axiom,
    ! [A] : addition(A,zero) = A ).

fof(additive_idempotence,axiom,
    ! [A] : addition(A,A) = A ).

%----Multiplicative and commutative monoid
fof(multiplicative_associativity,axiom,
    ! [A,B,C] : multiplication(A,multiplication(B,C)) = multiplication(multiplication(A,B),C) ).

fof(multiplicative_right_identity,axiom,
    ! [A] : multiplication(A,one) = A ).

fof(multiplicative_left_identity,axiom,
    ! [A] : multiplication(one,A) = A ).

%----Distributivity laws
fof(right_distributivity,axiom,
    ! [A,B,C] : multiplication(A,addition(B,C)) = addition(multiplication(A,B),multiplication(A,C)) ).

fof(left_distributivity,axiom,
    ! [A,B,C] : multiplication(addition(A,B),C) = addition(multiplication(A,C),multiplication(B,C)) ).

%----Annihilation
fof(right_annihilation,axiom,
    ! [A] : multiplication(A,zero) = zero ).

fof(left_annihilation,axiom,
    ! [A] : multiplication(zero,A) = zero ).

%----Order
fof(order,axiom,
    ! [A,B] :
      ( leq(A,B)
    <=> addition(A,B) = B ) ).

%------------------------------------------------------------------------------
%---Include axioms for Boolean domain/codomain
%------------------------------------------------------------------------------
%----Boolean domain axioms (a la Desharnais & Struth)
fof(domain1,axiom,
    ! [X0] : multiplication(antidomain(X0),X0) = zero ).

fof(domain2,axiom,
    ! [X0,X1] : addition(antidomain(multiplication(X0,X1)),antidomain(multiplication(X0,antidomain(antidomain(X1))))) = antidomain(multiplication(X0,antidomain(antidomain(X1)))) ).

fof(domain3,axiom,
    ! [X0] : addition(antidomain(antidomain(X0)),antidomain(X0)) = one ).

fof(domain4,axiom,
    ! [X0] : domain(X0) = antidomain(antidomain(X0)) ).

%----Boolean codomain axioms (a la Desharnais & Struth)
fof(codomain1,axiom,
    ! [X0] : multiplication(X0,coantidomain(X0)) = zero ).

fof(codomain2,axiom,
    ! [X0,X1] : addition(coantidomain(multiplication(X0,X1)),coantidomain(multiplication(coantidomain(coantidomain(X0)),X1))) = coantidomain(multiplication(coantidomain(coantidomain(X0)),X1)) ).

fof(codomain3,axiom,
    ! [X0] : addition(coantidomain(coantidomain(X0)),coantidomain(X0)) = one ).

fof(codomain4,axiom,
    ! [X0] : codomain(X0) = coantidomain(coantidomain(X0)) ).

%------------------------------------------------------------------------------
%---Include axioms for diamond and boxes
%------------------------------------------------------------------------------
%----Standard axioms for forward/backward box and diamond
fof(complement,axiom,
    ! [X0] : c(X0) = antidomain(domain(X0)) ).

fof(domain_difference,axiom,
    ! [X0,X1] : domain_difference(X0,X1) = multiplication(domain(X0),antidomain(X1)) ).

fof(forward_diamond,axiom,
    ! [X0,X1] : forward_diamond(X0,X1) = domain(multiplication(X0,domain(X1))) ).

fof(backward_diamond,axiom,
    ! [X0,X1] : backward_diamond(X0,X1) = codomain(multiplication(codomain(X1),X0)) ).

fof(forward_box,axiom,
    ! [X0,X1] : forward_box(X0,X1) = c(forward_diamond(X0,c(X1))) ).

fof(backward_box,axiom,
    ! [X0,X1] : backward_box(X0,X1) = c(backward_diamond(X0,c(X1))) ).

%------------------------------------------------------------------------------
%------------------------------------------------------------------------------
fof(goals,conjecture,
    ! [X0,X1,X2] : addition(domain_difference(forward_diamond(X0,domain(X1)),forward_diamond(X0,domain(X2))),forward_diamond(X0,domain_difference(domain(X1),domain(X2)))) = forward_diamond(X0,domain_difference(domain(X1),domain(X2))) ).

%------------------------------------------------------------------------------
